/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.glavo.classfile.ClassBuilder;
import org.glavo.classfile.ClassElement;
import org.glavo.classfile.ClassfileTransform;
import org.glavo.classfile.CodeTransform;
import org.glavo.classfile.FieldTransform;
import org.glavo.classfile.MethodModel;
import org.glavo.classfile.MethodTransform;
import org.glavo.classfile.impl.TransformImpl;

@FunctionalInterface
public interface ClassTransform
extends ClassfileTransform<ClassTransform, ClassElement, ClassBuilder> {
    public static final ClassTransform ACCEPT_ALL = new ClassTransform(){

        @Override
        public void accept(ClassBuilder builder, ClassElement element) {
            builder.with(element);
        }
    };

    public static ClassTransform ofStateful(Supplier<ClassTransform> supplier) {
        return new TransformImpl.SupplierClassTransform(supplier);
    }

    public static ClassTransform endHandler(final Consumer<ClassBuilder> finisher) {
        return new ClassTransform(){

            @Override
            public void accept(ClassBuilder builder, ClassElement element) {
                builder.with(element);
            }

            @Override
            public void atEnd(ClassBuilder builder) {
                finisher.accept(builder);
            }
        };
    }

    public static ClassTransform dropping(Predicate<ClassElement> filter) {
        return (b, e) -> {
            if (!filter.test((ClassElement)e)) {
                b.with(e);
            }
        };
    }

    public static ClassTransform transformingMethods(Predicate<MethodModel> filter, MethodTransform xform) {
        return new TransformImpl.ClassMethodTransform(xform, filter);
    }

    public static ClassTransform transformingMethods(MethodTransform xform) {
        return ClassTransform.transformingMethods(mm -> true, xform);
    }

    public static ClassTransform transformingMethodBodies(Predicate<MethodModel> filter, CodeTransform xform) {
        return ClassTransform.transformingMethods(filter, MethodTransform.transformingCode(xform));
    }

    public static ClassTransform transformingMethodBodies(CodeTransform xform) {
        return ClassTransform.transformingMethods(MethodTransform.transformingCode(xform));
    }

    public static ClassTransform transformingFields(FieldTransform xform) {
        return new TransformImpl.ClassFieldTransform(xform, f -> true);
    }

    @Override
    default public ClassTransform andThen(ClassTransform t) {
        return new TransformImpl.ChainedClassTransform(this, t);
    }

    @Override
    default public ClassfileTransform.ResolvedTransform<ClassElement> resolve(ClassBuilder builder) {
        return new TransformImpl.ResolvedTransformImpl<ClassElement>(e -> this.accept(builder, e), () -> this.atEnd(builder), () -> this.atStart(builder));
    }
}

