/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.components;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicCallSiteDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.glavo.classfile.Annotation;
import org.glavo.classfile.AnnotationElement;
import org.glavo.classfile.AnnotationValue;
import org.glavo.classfile.Attribute;
import org.glavo.classfile.ClassBuilder;
import org.glavo.classfile.ClassElement;
import org.glavo.classfile.ClassModel;
import org.glavo.classfile.ClassSignature;
import org.glavo.classfile.ClassTransform;
import org.glavo.classfile.Classfile;
import org.glavo.classfile.CodeElement;
import org.glavo.classfile.CodeModel;
import org.glavo.classfile.CodeTransform;
import org.glavo.classfile.FieldBuilder;
import org.glavo.classfile.FieldElement;
import org.glavo.classfile.FieldModel;
import org.glavo.classfile.FieldTransform;
import org.glavo.classfile.Interfaces;
import org.glavo.classfile.MethodBuilder;
import org.glavo.classfile.MethodElement;
import org.glavo.classfile.MethodModel;
import org.glavo.classfile.MethodSignature;
import org.glavo.classfile.MethodTransform;
import org.glavo.classfile.Signature;
import org.glavo.classfile.Superclass;
import org.glavo.classfile.TypeAnnotation;
import org.glavo.classfile.attribute.AnnotationDefaultAttribute;
import org.glavo.classfile.attribute.EnclosingMethodAttribute;
import org.glavo.classfile.attribute.ExceptionsAttribute;
import org.glavo.classfile.attribute.InnerClassInfo;
import org.glavo.classfile.attribute.InnerClassesAttribute;
import org.glavo.classfile.attribute.ModuleAttribute;
import org.glavo.classfile.attribute.ModuleProvideInfo;
import org.glavo.classfile.attribute.NestHostAttribute;
import org.glavo.classfile.attribute.NestMembersAttribute;
import org.glavo.classfile.attribute.PermittedSubclassesAttribute;
import org.glavo.classfile.attribute.RecordAttribute;
import org.glavo.classfile.attribute.RecordComponentInfo;
import org.glavo.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeInvisibleParameterAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeInvisibleTypeAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeVisibleParameterAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute;
import org.glavo.classfile.attribute.SignatureAttribute;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.TemporaryConstantPool;
import org.glavo.classfile.impl.Util;
import org.glavo.classfile.instruction.ConstantInstruction;
import org.glavo.classfile.instruction.ExceptionCatch;
import org.glavo.classfile.instruction.FieldInstruction;
import org.glavo.classfile.instruction.InvokeDynamicInstruction;
import org.glavo.classfile.instruction.InvokeInstruction;
import org.glavo.classfile.instruction.LocalVariable;
import org.glavo.classfile.instruction.LocalVariableType;
import org.glavo.classfile.instruction.NewMultiArrayInstruction;
import org.glavo.classfile.instruction.NewObjectInstruction;
import org.glavo.classfile.instruction.NewReferenceArrayInstruction;
import org.glavo.classfile.instruction.TypeCheckInstruction;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClassRemapper
extends ClassTransform {
    public static ClassRemapper of(Map<ClassDesc, ClassDesc> classMap) {
        return ClassRemapper.of((ClassDesc desc) -> classMap.getOrDefault(desc, (ClassDesc)desc));
    }

    public static ClassRemapper of(Function<ClassDesc, ClassDesc> mapFunction) {
        return new ClassRemapperImpl(mapFunction);
    }

    public ClassDesc map(ClassDesc var1);

    public FieldTransform asFieldTransform();

    public MethodTransform asMethodTransform();

    public CodeTransform asCodeTransform();

    default public byte[] remapClass(ClassModel clm) {
        return Classfile.build(this.map(clm.thisClass().asSymbol()), clb -> clm.forEachElement(this.resolve((ClassBuilder)clb).consumer()));
    }

    public record ClassRemapperImpl(Function<ClassDesc, ClassDesc> mapFunction) implements ClassRemapper
    {
        @Override
        public void accept(ClassBuilder clb, ClassElement cle) {
            ClassElement classElement = cle;
            Objects.requireNonNull(classElement);
            ClassElement classElement2 = classElement;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FieldModel.class, MethodModel.class, Superclass.class, Interfaces.class, SignatureAttribute.class, InnerClassesAttribute.class, EnclosingMethodAttribute.class, RecordAttribute.class, ModuleAttribute.class, NestHostAttribute.class, NestMembersAttribute.class, PermittedSubclassesAttribute.class, RuntimeVisibleAnnotationsAttribute.class, RuntimeInvisibleAnnotationsAttribute.class, RuntimeVisibleTypeAnnotationsAttribute.class, RuntimeInvisibleTypeAnnotationsAttribute.class}, (Object)classElement2, n)) {
                case 0: {
                    FieldModel fm = (FieldModel)classElement2;
                    clb.withField(fm.fieldName().stringValue(), this.map(fm.fieldTypeSymbol()), fb -> fm.forEachElement(this.asFieldTransform().resolve((FieldBuilder)fb).consumer()));
                    break;
                }
                case 1: {
                    MethodModel mm = (MethodModel)classElement2;
                    clb.withMethod(mm.methodName().stringValue(), this.mapMethodDesc(mm.methodTypeSymbol()), mm.flags().flagsMask(), mb -> mm.forEachElement(this.asMethodTransform().resolve((MethodBuilder)mb).consumer()));
                    break;
                }
                case 2: {
                    Superclass sc = (Superclass)classElement2;
                    clb.withSuperclass(this.map(sc.superclassEntry().asSymbol()));
                    break;
                }
                case 3: {
                    Interfaces ins = (Interfaces)classElement2;
                    clb.withInterfaceSymbols(Util.mappedList(ins.interfaces(), in -> this.map(in.asSymbol())));
                    break;
                }
                case 4: {
                    SignatureAttribute sa = (SignatureAttribute)classElement2;
                    clb.with(SignatureAttribute.of(this.mapClassSignature(sa.asClassSignature())));
                    break;
                }
                case 5: {
                    InnerClassesAttribute ica = (InnerClassesAttribute)classElement2;
                    clb.with(InnerClassesAttribute.of(ica.classes().stream().map((? super T ici) -> InnerClassInfo.of(this.map(ici.innerClass().asSymbol()), ici.outerClass().map((? super T oc) -> this.map(oc.asSymbol())), ici.innerName().map(Utf8Entry::stringValue), ici.flagsMask())).toList()));
                    break;
                }
                case 6: {
                    EnclosingMethodAttribute ema = (EnclosingMethodAttribute)classElement2;
                    clb.with(EnclosingMethodAttribute.of(this.map(ema.enclosingClass().asSymbol()), ema.enclosingMethodName().map(Utf8Entry::stringValue), ema.enclosingMethodTypeSymbol().map(this::mapMethodDesc)));
                    break;
                }
                case 7: {
                    RecordAttribute ra = (RecordAttribute)classElement2;
                    clb.with(RecordAttribute.of(ra.components().stream().map(this::mapRecordComponent).toList()));
                    break;
                }
                case 8: {
                    ModuleAttribute ma = (ModuleAttribute)classElement2;
                    clb.with(ModuleAttribute.of(ma.moduleName(), ma.moduleFlagsMask(), ma.moduleVersion().orElse(null), ma.requires(), ma.exports(), ma.opens(), ma.uses().stream().map((? super T ce) -> clb.constantPool().classEntry(this.map(ce.asSymbol()))).toList(), ma.provides().stream().map((? super T mp) -> ModuleProvideInfo.of(this.map(mp.provides().asSymbol()), mp.providesWith().stream().map((? super T pw) -> this.map(pw.asSymbol())).toList())).toList()));
                    break;
                }
                case 9: {
                    NestHostAttribute nha = (NestHostAttribute)classElement2;
                    clb.with(NestHostAttribute.of(this.map(nha.nestHost().asSymbol())));
                    break;
                }
                case 10: {
                    NestMembersAttribute nma = (NestMembersAttribute)classElement2;
                    clb.with(NestMembersAttribute.ofSymbols(nma.nestMembers().stream().map((? super T nm) -> this.map(nm.asSymbol())).toList()));
                    break;
                }
                case 11: {
                    PermittedSubclassesAttribute psa = (PermittedSubclassesAttribute)classElement2;
                    clb.with(PermittedSubclassesAttribute.ofSymbols(psa.permittedSubclasses().stream().map((? super T ps) -> this.map(ps.asSymbol())).toList()));
                    break;
                }
                case 12: {
                    RuntimeVisibleAnnotationsAttribute aa = (RuntimeVisibleAnnotationsAttribute)classElement2;
                    clb.with(RuntimeVisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations())));
                    break;
                }
                case 13: {
                    RuntimeInvisibleAnnotationsAttribute aa = (RuntimeInvisibleAnnotationsAttribute)classElement2;
                    clb.with(RuntimeInvisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations())));
                    break;
                }
                case 14: {
                    RuntimeVisibleTypeAnnotationsAttribute aa = (RuntimeVisibleTypeAnnotationsAttribute)classElement2;
                    clb.with(RuntimeVisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
                    break;
                }
                case 15: {
                    RuntimeInvisibleTypeAnnotationsAttribute aa = (RuntimeInvisibleTypeAnnotationsAttribute)classElement2;
                    clb.with(RuntimeInvisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
                    break;
                }
                default: {
                    clb.with(cle);
                }
            }
        }

        @Override
        public FieldTransform asFieldTransform() {
            return (fb, fe) -> {
                FieldElement fieldElement = fe;
                Objects.requireNonNull(fieldElement);
                FieldElement selector11947$temp = fieldElement;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SignatureAttribute.class, RuntimeVisibleAnnotationsAttribute.class, RuntimeInvisibleAnnotationsAttribute.class, RuntimeVisibleTypeAnnotationsAttribute.class, RuntimeInvisibleTypeAnnotationsAttribute.class}, (Object)selector11947$temp, n)) {
                    case 0: {
                        SignatureAttribute sa = (SignatureAttribute)selector11947$temp;
                        fb.with(SignatureAttribute.of(this.mapSignature(sa.asTypeSignature())));
                        break;
                    }
                    case 1: {
                        RuntimeVisibleAnnotationsAttribute aa = (RuntimeVisibleAnnotationsAttribute)selector11947$temp;
                        fb.with(RuntimeVisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations())));
                        break;
                    }
                    case 2: {
                        RuntimeInvisibleAnnotationsAttribute aa = (RuntimeInvisibleAnnotationsAttribute)selector11947$temp;
                        fb.with(RuntimeInvisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations())));
                        break;
                    }
                    case 3: {
                        RuntimeVisibleTypeAnnotationsAttribute aa = (RuntimeVisibleTypeAnnotationsAttribute)selector11947$temp;
                        fb.with(RuntimeVisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
                        break;
                    }
                    case 4: {
                        RuntimeInvisibleTypeAnnotationsAttribute aa = (RuntimeInvisibleTypeAnnotationsAttribute)selector11947$temp;
                        fb.with(RuntimeInvisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
                        break;
                    }
                    default: {
                        fb.with(fe);
                    }
                }
            };
        }

        @Override
        public MethodTransform asMethodTransform() {
            return (mb, me) -> {
                MethodElement methodElement = me;
                Objects.requireNonNull(methodElement);
                MethodElement selector13248$temp = methodElement;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnnotationDefaultAttribute.class, CodeModel.class, ExceptionsAttribute.class, SignatureAttribute.class, RuntimeVisibleAnnotationsAttribute.class, RuntimeInvisibleAnnotationsAttribute.class, RuntimeVisibleParameterAnnotationsAttribute.class, RuntimeInvisibleParameterAnnotationsAttribute.class, RuntimeVisibleTypeAnnotationsAttribute.class, RuntimeInvisibleTypeAnnotationsAttribute.class}, (Object)selector13248$temp, n)) {
                    case 0: {
                        AnnotationDefaultAttribute ada = (AnnotationDefaultAttribute)selector13248$temp;
                        mb.with(AnnotationDefaultAttribute.of(this.mapAnnotationValue(ada.defaultValue())));
                        break;
                    }
                    case 1: {
                        CodeModel com = (CodeModel)selector13248$temp;
                        mb.transformCode(com, this.asCodeTransform());
                        break;
                    }
                    case 2: {
                        ExceptionsAttribute ea = (ExceptionsAttribute)selector13248$temp;
                        mb.with(ExceptionsAttribute.ofSymbols(ea.exceptions().stream().map((? super T ce) -> this.map(ce.asSymbol())).toList()));
                        break;
                    }
                    case 3: {
                        SignatureAttribute sa = (SignatureAttribute)selector13248$temp;
                        mb.with(SignatureAttribute.of(this.mapMethodSignature(sa.asMethodSignature())));
                        break;
                    }
                    case 4: {
                        RuntimeVisibleAnnotationsAttribute aa = (RuntimeVisibleAnnotationsAttribute)selector13248$temp;
                        mb.with(RuntimeVisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations())));
                        break;
                    }
                    case 5: {
                        RuntimeInvisibleAnnotationsAttribute aa = (RuntimeInvisibleAnnotationsAttribute)selector13248$temp;
                        mb.with(RuntimeInvisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations())));
                        break;
                    }
                    case 6: {
                        RuntimeVisibleParameterAnnotationsAttribute paa = (RuntimeVisibleParameterAnnotationsAttribute)selector13248$temp;
                        mb.with(RuntimeVisibleParameterAnnotationsAttribute.of(paa.parameterAnnotations().stream().map(this::mapAnnotations).toList()));
                        break;
                    }
                    case 7: {
                        RuntimeInvisibleParameterAnnotationsAttribute paa = (RuntimeInvisibleParameterAnnotationsAttribute)selector13248$temp;
                        mb.with(RuntimeInvisibleParameterAnnotationsAttribute.of(paa.parameterAnnotations().stream().map(this::mapAnnotations).toList()));
                        break;
                    }
                    case 8: {
                        RuntimeVisibleTypeAnnotationsAttribute aa = (RuntimeVisibleTypeAnnotationsAttribute)selector13248$temp;
                        mb.with(RuntimeVisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
                        break;
                    }
                    case 9: {
                        RuntimeInvisibleTypeAnnotationsAttribute aa = (RuntimeInvisibleTypeAnnotationsAttribute)selector13248$temp;
                        mb.with(RuntimeInvisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
                        break;
                    }
                    default: {
                        mb.with(me);
                    }
                }
            };
        }

        @Override
        public CodeTransform asCodeTransform() {
            return (cob, coe) -> {
                CodeElement codeElement = coe;
                Objects.requireNonNull(codeElement);
                CodeElement selector15718$temp = codeElement;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FieldInstruction.class, InvokeInstruction.class, InvokeDynamicInstruction.class, NewObjectInstruction.class, NewReferenceArrayInstruction.class, NewMultiArrayInstruction.class, TypeCheckInstruction.class, ExceptionCatch.class, LocalVariable.class, LocalVariableType.class, ConstantInstruction.LoadConstantInstruction.class, RuntimeVisibleTypeAnnotationsAttribute.class, RuntimeInvisibleTypeAnnotationsAttribute.class}, (Object)selector15718$temp, n)) {
                    case 0: {
                        FieldInstruction fai = (FieldInstruction)selector15718$temp;
                        cob.fieldInstruction(fai.opcode(), this.map(fai.owner().asSymbol()), fai.name().stringValue(), this.map(fai.typeSymbol()));
                        break;
                    }
                    case 1: {
                        InvokeInstruction ii = (InvokeInstruction)selector15718$temp;
                        cob.invokeInstruction(ii.opcode(), this.map(ii.owner().asSymbol()), ii.name().stringValue(), this.mapMethodDesc(ii.typeSymbol()), ii.isInterface());
                        break;
                    }
                    case 2: {
                        InvokeDynamicInstruction idi = (InvokeDynamicInstruction)selector15718$temp;
                        cob.invokeDynamicInstruction(DynamicCallSiteDesc.of(idi.bootstrapMethod(), idi.name().stringValue(), this.mapMethodDesc(idi.typeSymbol())));
                        break;
                    }
                    case 3: {
                        NewObjectInstruction c = (NewObjectInstruction)selector15718$temp;
                        cob.newObjectInstruction(this.map(c.className().asSymbol()));
                        break;
                    }
                    case 4: {
                        NewReferenceArrayInstruction c = (NewReferenceArrayInstruction)selector15718$temp;
                        cob.anewarray(this.map(c.componentType().asSymbol()));
                        break;
                    }
                    case 5: {
                        NewMultiArrayInstruction c = (NewMultiArrayInstruction)selector15718$temp;
                        cob.multianewarray(this.map(c.arrayType().asSymbol()), c.dimensions());
                        break;
                    }
                    case 6: {
                        TypeCheckInstruction c = (TypeCheckInstruction)selector15718$temp;
                        cob.typeCheckInstruction(c.opcode(), this.map(c.type().asSymbol()));
                        break;
                    }
                    case 7: {
                        ExceptionCatch c = (ExceptionCatch)selector15718$temp;
                        cob.exceptionCatch(c.tryStart(), c.tryEnd(), c.handler(), c.catchType().map((? super T d) -> TemporaryConstantPool.INSTANCE.classEntry(this.map(d.asSymbol()))));
                        break;
                    }
                    case 8: {
                        LocalVariable c = (LocalVariable)selector15718$temp;
                        cob.localVariable(c.slot(), c.name().stringValue(), this.map(c.typeSymbol()), c.startScope(), c.endScope());
                        break;
                    }
                    case 9: {
                        LocalVariableType c = (LocalVariableType)selector15718$temp;
                        cob.localVariableType(c.slot(), c.name().stringValue(), this.mapSignature(c.signatureSymbol()), c.startScope(), c.endScope());
                        break;
                    }
                    case 10: {
                        ConstantInstruction.LoadConstantInstruction ldc = (ConstantInstruction.LoadConstantInstruction)selector15718$temp;
                        cob.constantInstruction(ldc.opcode(), this.mapConstantValue(ldc.constantValue()));
                        break;
                    }
                    case 11: {
                        RuntimeVisibleTypeAnnotationsAttribute aa = (RuntimeVisibleTypeAnnotationsAttribute)selector15718$temp;
                        cob.with(RuntimeVisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
                        break;
                    }
                    case 12: {
                        RuntimeInvisibleTypeAnnotationsAttribute aa = (RuntimeInvisibleTypeAnnotationsAttribute)selector15718$temp;
                        cob.with(RuntimeInvisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
                        break;
                    }
                    default: {
                        cob.with(coe);
                    }
                }
            };
        }

        @Override
        public ClassDesc map(ClassDesc desc) {
            if (desc == null) {
                return null;
            }
            if (desc.isArray()) {
                return this.map(desc.componentType()).arrayType();
            }
            if (desc.isPrimitive()) {
                return desc;
            }
            return this.mapFunction.apply(desc);
        }

        MethodTypeDesc mapMethodDesc(MethodTypeDesc desc) {
            return MethodTypeDesc.of(this.map(desc.returnType()), (ClassDesc[])desc.parameterList().stream().map(this::map).toArray(ClassDesc[]::new));
        }

        ClassSignature mapClassSignature(ClassSignature signature) {
            return ClassSignature.of(this.mapTypeParams(signature.typeParameters()), this.mapSignature(signature.superclassSignature()), (Signature.RefTypeSig[])signature.superinterfaceSignatures().stream().map(this::mapSignature).toArray(Signature.RefTypeSig[]::new));
        }

        MethodSignature mapMethodSignature(MethodSignature signature) {
            return MethodSignature.of(this.mapTypeParams(signature.typeParameters()), signature.throwableSignatures().stream().map(this::mapSignature).toList(), this.mapSignature(signature.result()), (Signature[])signature.arguments().stream().map(this::mapSignature).toArray(Signature[]::new));
        }

        RecordComponentInfo mapRecordComponent(RecordComponentInfo component) {
            return RecordComponentInfo.of(component.name().stringValue(), this.map(component.descriptorSymbol()), component.attributes().stream().map((? super T atr) -> {
                Attribute attribute = atr;
                Objects.requireNonNull(attribute);
                Attribute selector20141$temp = attribute;
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SignatureAttribute.class, RuntimeVisibleAnnotationsAttribute.class, RuntimeInvisibleAnnotationsAttribute.class, RuntimeVisibleTypeAnnotationsAttribute.class, RuntimeInvisibleTypeAnnotationsAttribute.class}, (Object)selector20141$temp, n)) {
                    case 0 -> {
                        SignatureAttribute sa = (SignatureAttribute)selector20141$temp;
                        yield SignatureAttribute.of(this.mapSignature(sa.asTypeSignature()));
                    }
                    case 1 -> {
                        RuntimeVisibleAnnotationsAttribute aa = (RuntimeVisibleAnnotationsAttribute)selector20141$temp;
                        yield RuntimeVisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations()));
                    }
                    case 2 -> {
                        RuntimeInvisibleAnnotationsAttribute aa = (RuntimeInvisibleAnnotationsAttribute)selector20141$temp;
                        yield RuntimeInvisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations()));
                    }
                    case 3 -> {
                        RuntimeVisibleTypeAnnotationsAttribute aa = (RuntimeVisibleTypeAnnotationsAttribute)selector20141$temp;
                        yield RuntimeVisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations()));
                    }
                    case 4 -> {
                        RuntimeInvisibleTypeAnnotationsAttribute aa = (RuntimeInvisibleTypeAnnotationsAttribute)selector20141$temp;
                        yield RuntimeInvisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations()));
                    }
                    default -> atr;
                };
            }).toList());
        }

        DirectMethodHandleDesc mapDirectMethodHandle(DirectMethodHandleDesc dmhd) {
            return switch (dmhd.kind()) {
                case DirectMethodHandleDesc.Kind.GETTER, DirectMethodHandleDesc.Kind.SETTER, DirectMethodHandleDesc.Kind.STATIC_GETTER, DirectMethodHandleDesc.Kind.STATIC_SETTER -> MethodHandleDesc.ofField(dmhd.kind(), this.map(dmhd.owner()), dmhd.methodName(), this.map(ClassDesc.ofDescriptor(dmhd.lookupDescriptor())));
                default -> MethodHandleDesc.ofMethod(dmhd.kind(), this.map(dmhd.owner()), dmhd.methodName(), this.mapMethodDesc(MethodTypeDesc.ofDescriptor(dmhd.lookupDescriptor())));
            };
        }

        ConstantDesc mapConstantValue(ConstantDesc value) {
            DynamicConstantDesc<?> dynamicConstantDesc = value;
            Objects.requireNonNull(dynamicConstantDesc);
            DynamicConstantDesc<?> dynamicConstantDesc2 = dynamicConstantDesc;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassDesc.class, DynamicConstantDesc.class, DirectMethodHandleDesc.class, MethodTypeDesc.class}, (Object)dynamicConstantDesc2, n)) {
                case 0 -> {
                    ClassDesc cd = (ClassDesc)((Object)dynamicConstantDesc2);
                    yield this.map(cd);
                }
                case 1 -> {
                    DynamicConstantDesc dcd = dynamicConstantDesc2;
                    yield this.mapDynamicConstant(dcd);
                }
                case 2 -> {
                    DirectMethodHandleDesc dmhd = (DirectMethodHandleDesc)((Object)dynamicConstantDesc2);
                    yield this.mapDirectMethodHandle(dmhd);
                }
                case 3 -> {
                    MethodTypeDesc mtd = (MethodTypeDesc)((Object)dynamicConstantDesc2);
                    yield this.mapMethodDesc(mtd);
                }
                default -> value;
            };
        }

        DynamicConstantDesc<?> mapDynamicConstant(DynamicConstantDesc<?> dcd) {
            return DynamicConstantDesc.ofNamed(this.mapDirectMethodHandle(dcd.bootstrapMethod()), dcd.constantName(), this.map(dcd.constantType()), (ConstantDesc[])dcd.bootstrapArgsList().stream().map(this::mapConstantValue).toArray(ConstantDesc[]::new));
        }

        <S extends Signature> S mapSignature(S signature) {
            S s = signature;
            Objects.requireNonNull(s);
            S s2 = s;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Signature.ArrayTypeSig.class, Signature.ClassTypeSig.class}, s2, n)) {
                case 0 -> {
                    Signature.ArrayTypeSig ats = (Signature.ArrayTypeSig)s2;
                    yield Signature.ArrayTypeSig.of(this.mapSignature(ats.componentSignature()));
                }
                case 1 -> {
                    Signature.ClassTypeSig cts = (Signature.ClassTypeSig)s2;
                    yield Signature.ClassTypeSig.of((Signature.ClassTypeSig)cts.outerType().map(this::mapSignature).orElse(null), this.map(cts.classDesc()), (Signature.TypeArg[])cts.typeArgs().stream().map((? super T ta) -> Signature.TypeArg.of(ta.wildcardIndicator(), ta.boundType().map(this::mapSignature))).toArray(Signature.TypeArg[]::new));
                }
                default -> signature;
            };
        }

        List<Annotation> mapAnnotations(List<Annotation> annotations) {
            return annotations.stream().map(this::mapAnnotation).toList();
        }

        Annotation mapAnnotation(Annotation a) {
            return Annotation.of(this.map(a.classSymbol()), a.elements().stream().map((? super T el) -> AnnotationElement.of(el.name(), this.mapAnnotationValue(el.value()))).toList());
        }

        AnnotationValue mapAnnotationValue(AnnotationValue val) {
            AnnotationValue annotationValue = val;
            Objects.requireNonNull(annotationValue);
            AnnotationValue annotationValue2 = annotationValue;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnnotationValue.OfAnnotation.class, AnnotationValue.OfArray.class, AnnotationValue.OfConstant.class, AnnotationValue.OfClass.class, AnnotationValue.OfEnum.class}, (Object)annotationValue2, n)) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> {
                    AnnotationValue.OfAnnotation oa = (AnnotationValue.OfAnnotation)annotationValue2;
                    yield AnnotationValue.ofAnnotation(this.mapAnnotation(oa.annotation()));
                }
                case 1 -> {
                    AnnotationValue.OfArray oa = (AnnotationValue.OfArray)annotationValue2;
                    yield AnnotationValue.ofArray(oa.values().stream().map(this::mapAnnotationValue).toList());
                }
                case 2 -> {
                    AnnotationValue.OfConstant oc;
                    yield oc = (AnnotationValue.OfConstant)annotationValue2;
                }
                case 3 -> {
                    AnnotationValue.OfClass oc = (AnnotationValue.OfClass)annotationValue2;
                    yield AnnotationValue.ofClass(this.map(oc.classSymbol()));
                }
                case 4 -> {
                    AnnotationValue.OfEnum oe = (AnnotationValue.OfEnum)annotationValue2;
                    yield AnnotationValue.ofEnum(this.map(oe.classSymbol()), oe.constantName().stringValue());
                }
            };
        }

        List<TypeAnnotation> mapTypeAnnotations(List<TypeAnnotation> typeAnnotations) {
            return typeAnnotations.stream().map((? super T a) -> TypeAnnotation.of(a.targetInfo(), a.targetPath(), this.map(a.classSymbol()), a.elements().stream().map((? super T el) -> AnnotationElement.of(el.name(), this.mapAnnotationValue(el.value()))).toList())).toList();
        }

        List<Signature.TypeParam> mapTypeParams(List<Signature.TypeParam> typeParams) {
            return typeParams.stream().map((? super T tp) -> Signature.TypeParam.of(tp.identifier(), tp.classBound().map(this::mapSignature), (Signature.RefTypeSig[])tp.interfaceBounds().stream().map(this::mapSignature).toArray(Signature.RefTypeSig[]::new))).toList();
        }
    }
}

