/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.components;

import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import org.glavo.classfile.AccessFlag;
import org.glavo.classfile.AccessFlags;
import org.glavo.classfile.CodeBuilder;
import org.glavo.classfile.CodeElement;
import org.glavo.classfile.CodeTransform;
import org.glavo.classfile.Signature;
import org.glavo.classfile.TypeKind;
import org.glavo.classfile.instruction.IncrementInstruction;
import org.glavo.classfile.instruction.LoadInstruction;
import org.glavo.classfile.instruction.LocalVariable;
import org.glavo.classfile.instruction.LocalVariableType;
import org.glavo.classfile.instruction.StoreInstruction;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface CodeLocalsShifter
extends CodeTransform {
    public static CodeLocalsShifter of(AccessFlags methodFlags, MethodTypeDesc methodDescriptor) {
        int fixed = methodFlags.has(AccessFlag.STATIC) ? 0 : 1;
        for (ClassDesc param : methodDescriptor.parameterList()) {
            fixed += TypeKind.from(param).slotSize();
        }
        return new CodeLocalsShifterImpl(fixed);
    }

    public static final class CodeLocalsShifterImpl
    implements CodeLocalsShifter {
        private int[] locals = new int[0];
        private final int fixed;

        private CodeLocalsShifterImpl(int fixed) {
            this.fixed = fixed;
        }

        @Override
        public void accept(CodeBuilder cob, CodeElement coe) {
            CodeElement codeElement = coe;
            Objects.requireNonNull(codeElement);
            CodeElement codeElement2 = codeElement;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LoadInstruction.class, StoreInstruction.class, IncrementInstruction.class, LocalVariable.class, LocalVariableType.class}, (Object)codeElement2, n)) {
                case 0: {
                    LoadInstruction li = (LoadInstruction)codeElement2;
                    cob.loadInstruction(li.typeKind(), this.shift(cob, li.slot(), li.typeKind()));
                    break;
                }
                case 1: {
                    StoreInstruction si = (StoreInstruction)codeElement2;
                    cob.storeInstruction(si.typeKind(), this.shift(cob, si.slot(), si.typeKind()));
                    break;
                }
                case 2: {
                    IncrementInstruction ii = (IncrementInstruction)codeElement2;
                    cob.incrementInstruction(this.shift(cob, ii.slot(), TypeKind.IntType), ii.constant());
                    break;
                }
                case 3: {
                    LocalVariable lv = (LocalVariable)codeElement2;
                    cob.localVariable(this.shift(cob, lv.slot(), TypeKind.fromDescriptor(lv.type().stringValue())), lv.name(), lv.type(), lv.startScope(), lv.endScope());
                    break;
                }
                case 4: {
                    TypeKind typeKind;
                    LocalVariableType lvt = (LocalVariableType)codeElement2;
                    int n2 = lvt.slot();
                    Signature signature = lvt.signatureSymbol();
                    if (signature instanceof Signature.BaseTypeSig) {
                        Signature.BaseTypeSig bsig = (Signature.BaseTypeSig)signature;
                        typeKind = TypeKind.fromDescriptor(bsig.signatureString());
                    } else {
                        typeKind = TypeKind.ReferenceType;
                    }
                    cob.localVariableType(this.shift(cob, n2, typeKind), lvt.name(), lvt.signature(), lvt.startScope(), lvt.endScope());
                    break;
                }
                default: {
                    cob.with(coe);
                }
            }
        }

        private int shift(CodeBuilder cob, int slot, TypeKind tk) {
            if (tk == TypeKind.VoidType) {
                throw new IllegalArgumentException("Illegal local void type");
            }
            if (slot >= this.fixed) {
                int key = 2 * slot - this.fixed + tk.slotSize() - 1;
                if (key >= this.locals.length) {
                    this.locals = Arrays.copyOf(this.locals, key + 20);
                }
                if ((slot = this.locals[key] - 1) < 0) {
                    slot = cob.allocateLocal(tk);
                    this.locals[key] = slot + 1;
                    if (tk.slotSize() == 2) {
                        this.locals[key - 1] = slot + 1;
                    }
                }
            }
            return slot;
        }
    }
}

