/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.constantpool;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicCallSiteDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.Collection;
import java.util.List;
import org.glavo.classfile.BootstrapMethodEntry;
import org.glavo.classfile.BufWriter;
import org.glavo.classfile.ClassModel;
import org.glavo.classfile.Classfile;
import org.glavo.classfile.WritableElement;
import org.glavo.classfile.constantpool.AnnotationConstantValueEntry;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.ConstantDynamicEntry;
import org.glavo.classfile.constantpool.ConstantPool;
import org.glavo.classfile.constantpool.ConstantValueEntry;
import org.glavo.classfile.constantpool.DoubleEntry;
import org.glavo.classfile.constantpool.FieldRefEntry;
import org.glavo.classfile.constantpool.FloatEntry;
import org.glavo.classfile.constantpool.IntegerEntry;
import org.glavo.classfile.constantpool.InterfaceMethodRefEntry;
import org.glavo.classfile.constantpool.InvokeDynamicEntry;
import org.glavo.classfile.constantpool.LoadableConstantEntry;
import org.glavo.classfile.constantpool.LongEntry;
import org.glavo.classfile.constantpool.MemberRefEntry;
import org.glavo.classfile.constantpool.MethodHandleEntry;
import org.glavo.classfile.constantpool.MethodRefEntry;
import org.glavo.classfile.constantpool.MethodTypeEntry;
import org.glavo.classfile.constantpool.ModuleEntry;
import org.glavo.classfile.constantpool.NameAndTypeEntry;
import org.glavo.classfile.constantpool.PackageEntry;
import org.glavo.classfile.constantpool.StringEntry;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.ClassReaderImpl;
import org.glavo.classfile.impl.Options;
import org.glavo.classfile.impl.SplitConstantPool;
import org.glavo.classfile.impl.Util;
import org.glavo.classfile.java.lang.constant.ModuleDesc;
import org.glavo.classfile.java.lang.constant.PackageDesc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ConstantPoolBuilder
extends ConstantPool,
WritableElement<ConstantPool> {
    public static ConstantPoolBuilder of(ClassModel classModel) {
        ClassReaderImpl reader = (ClassReaderImpl)classModel.constantPool();
        return reader.options().cpSharing != false ? new SplitConstantPool(reader) : new SplitConstantPool(reader.options());
    }

    public static ConstantPoolBuilder of(Collection<Classfile.Option> options) {
        return new SplitConstantPool(new Options(options));
    }

    public boolean canWriteDirect(ConstantPool var1);

    public boolean writeBootstrapMethods(BufWriter var1);

    public Utf8Entry utf8Entry(String var1);

    default public Utf8Entry utf8Entry(ClassDesc desc) {
        return this.utf8Entry(desc.descriptorString());
    }

    default public Utf8Entry utf8Entry(MethodTypeDesc desc) {
        return this.utf8Entry(desc.descriptorString());
    }

    public ClassEntry classEntry(Utf8Entry var1);

    default public ClassEntry classEntry(ClassDesc classDesc) {
        return this.classEntry(this.utf8Entry(classDesc.isArray() ? classDesc.descriptorString() : Util.toInternalName(classDesc)));
    }

    public PackageEntry packageEntry(Utf8Entry var1);

    default public PackageEntry packageEntry(PackageDesc packageDesc) {
        return this.packageEntry(this.utf8Entry(packageDesc.packageInternalName()));
    }

    public ModuleEntry moduleEntry(Utf8Entry var1);

    default public ModuleEntry moduleEntry(ModuleDesc moduleDesc) {
        return this.moduleEntry(this.utf8Entry(moduleDesc.moduleName()));
    }

    public NameAndTypeEntry nameAndTypeEntry(Utf8Entry var1, Utf8Entry var2);

    default public NameAndTypeEntry nameAndTypeEntry(String name, ClassDesc type) {
        return this.nameAndTypeEntry(this.utf8Entry(name), this.utf8Entry(type.descriptorString()));
    }

    default public NameAndTypeEntry nameAndTypeEntry(String name, MethodTypeDesc type) {
        return this.nameAndTypeEntry(this.utf8Entry(name), this.utf8Entry(type.descriptorString()));
    }

    public FieldRefEntry fieldRefEntry(ClassEntry var1, NameAndTypeEntry var2);

    default public FieldRefEntry fieldRefEntry(ClassDesc owner, String name, ClassDesc type) {
        return this.fieldRefEntry(this.classEntry(owner), this.nameAndTypeEntry(name, type));
    }

    public MethodRefEntry methodRefEntry(ClassEntry var1, NameAndTypeEntry var2);

    default public MethodRefEntry methodRefEntry(ClassDesc owner, String name, MethodTypeDesc type) {
        return this.methodRefEntry(this.classEntry(owner), this.nameAndTypeEntry(name, type));
    }

    public InterfaceMethodRefEntry interfaceMethodRefEntry(ClassEntry var1, NameAndTypeEntry var2);

    default public InterfaceMethodRefEntry interfaceMethodRefEntry(ClassDesc owner, String name, MethodTypeDesc type) {
        return this.interfaceMethodRefEntry(this.classEntry(owner), this.nameAndTypeEntry(name, type));
    }

    public MethodTypeEntry methodTypeEntry(MethodTypeDesc var1);

    public MethodTypeEntry methodTypeEntry(Utf8Entry var1);

    default public MethodHandleEntry methodHandleEntry(DirectMethodHandleDesc descriptor) {
        ClassEntry owner = this.classEntry(descriptor.owner());
        NameAndTypeEntry nat = this.nameAndTypeEntry(this.utf8Entry(descriptor.methodName()), this.utf8Entry(descriptor.lookupDescriptor()));
        int n = descriptor.refKind();
        return this.methodHandleEntry(n, switch (descriptor.kind()) {
            default -> throw new IncompatibleClassChangeError();
            case DirectMethodHandleDesc.Kind.GETTER, DirectMethodHandleDesc.Kind.SETTER, DirectMethodHandleDesc.Kind.STATIC_GETTER, DirectMethodHandleDesc.Kind.STATIC_SETTER -> this.fieldRefEntry(owner, nat);
            case DirectMethodHandleDesc.Kind.INTERFACE_STATIC, DirectMethodHandleDesc.Kind.INTERFACE_VIRTUAL, DirectMethodHandleDesc.Kind.INTERFACE_SPECIAL -> this.interfaceMethodRefEntry(owner, nat);
            case DirectMethodHandleDesc.Kind.STATIC, DirectMethodHandleDesc.Kind.VIRTUAL, DirectMethodHandleDesc.Kind.SPECIAL, DirectMethodHandleDesc.Kind.CONSTRUCTOR -> this.methodRefEntry(owner, nat);
        });
    }

    public MethodHandleEntry methodHandleEntry(int var1, MemberRefEntry var2);

    default public InvokeDynamicEntry invokeDynamicEntry(DynamicCallSiteDesc dcsd) {
        return this.invokeDynamicEntry(this.bsmEntry((DirectMethodHandleDesc)dcsd.bootstrapMethod(), List.of(dcsd.bootstrapArgs())), this.nameAndTypeEntry(dcsd.invocationName(), dcsd.invocationType()));
    }

    public InvokeDynamicEntry invokeDynamicEntry(BootstrapMethodEntry var1, NameAndTypeEntry var2);

    default public ConstantDynamicEntry constantDynamicEntry(DynamicConstantDesc<?> dcd) {
        return this.constantDynamicEntry(this.bsmEntry(dcd.bootstrapMethod(), List.of(dcd.bootstrapArgs())), this.nameAndTypeEntry(dcd.constantName(), dcd.constantType()));
    }

    public ConstantDynamicEntry constantDynamicEntry(BootstrapMethodEntry var1, NameAndTypeEntry var2);

    public IntegerEntry intEntry(int var1);

    public FloatEntry floatEntry(float var1);

    public LongEntry longEntry(long var1);

    public DoubleEntry doubleEntry(double var1);

    public StringEntry stringEntry(Utf8Entry var1);

    default public StringEntry stringEntry(String value) {
        return this.stringEntry(this.utf8Entry(value));
    }

    default public ConstantValueEntry constantValueEntry(ConstantDesc c) {
        if (c instanceof Integer) {
            Integer i = (Integer)c;
            return this.intEntry(i);
        }
        if (c instanceof String) {
            String s = (String)((Object)c);
            return this.stringEntry(s);
        }
        if (c instanceof Long) {
            Long l = (Long)c;
            return this.longEntry(l);
        }
        if (c instanceof Float) {
            Float f = (Float)c;
            return this.floatEntry(f.floatValue());
        }
        if (c instanceof Double) {
            Double d = (Double)c;
            return this.doubleEntry(d);
        }
        throw new IllegalArgumentException("Illegal type: " + (c == null ? null : c.getClass()));
    }

    default public LoadableConstantEntry loadableConstantEntry(ConstantDesc c) {
        if (c instanceof Integer) {
            Integer i = (Integer)c;
            return this.intEntry(i);
        }
        if (c instanceof String) {
            String s = (String)((Object)c);
            return this.stringEntry(s);
        }
        if (c instanceof Long) {
            Long l = (Long)c;
            return this.longEntry(l);
        }
        if (c instanceof Float) {
            Float f = (Float)c;
            return this.floatEntry(f.floatValue());
        }
        if (c instanceof Double) {
            Double d = (Double)c;
            return this.doubleEntry(d);
        }
        if (c instanceof ClassDesc) {
            ClassDesc cd = (ClassDesc)c;
            return this.classEntry(cd);
        }
        if (c instanceof MethodTypeDesc) {
            MethodTypeDesc mtd = (MethodTypeDesc)c;
            return this.methodTypeEntry(mtd);
        }
        if (c instanceof DirectMethodHandleDesc) {
            DirectMethodHandleDesc dmhd = (DirectMethodHandleDesc)c;
            return this.methodHandleEntry(dmhd);
        }
        if (c instanceof DynamicConstantDesc) {
            DynamicConstantDesc dcd = (DynamicConstantDesc)c;
            return this.constantDynamicEntry(dcd);
        }
        throw new IllegalArgumentException("Illegal type: " + (c == null ? null : c.getClass()));
    }

    default public AnnotationConstantValueEntry annotationConstantValueEntry(ConstantDesc c) {
        if (c instanceof Integer) {
            Integer i = (Integer)c;
            return this.intEntry(i);
        }
        if (c instanceof String) {
            String s = (String)((Object)c);
            return this.utf8Entry(s);
        }
        if (c instanceof Long) {
            Long l = (Long)c;
            return this.longEntry(l);
        }
        if (c instanceof Float) {
            Float f = (Float)c;
            return this.floatEntry(f.floatValue());
        }
        if (c instanceof Double) {
            Double d = (Double)c;
            return this.doubleEntry(d);
        }
        if (c instanceof ClassDesc) {
            ClassDesc cd = (ClassDesc)c;
            return this.utf8Entry(cd);
        }
        if (c instanceof MethodTypeDesc) {
            MethodTypeDesc mtd = (MethodTypeDesc)c;
            return this.utf8Entry(mtd);
        }
        throw new IllegalArgumentException("Illegal type: " + (c == null ? null : c.getClass()));
    }

    default public BootstrapMethodEntry bsmEntry(DirectMethodHandleDesc methodReference, List<ConstantDesc> arguments) {
        return this.bsmEntry(this.methodHandleEntry(methodReference), arguments.stream().map(this::loadableConstantEntry).toList());
    }

    public BootstrapMethodEntry bsmEntry(MethodHandleEntry var1, List<LoadableConstantEntry> var2);
}

