/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.Optional;
import org.glavo.classfile.BufWriter;
import org.glavo.classfile.Label;
import org.glavo.classfile.PseudoInstruction;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AbstractElement;
import org.glavo.classfile.impl.BufWriterImpl;
import org.glavo.classfile.impl.DirectCodeBuilder;
import org.glavo.classfile.impl.LabelContext;
import org.glavo.classfile.instruction.CharacterRange;
import org.glavo.classfile.instruction.ExceptionCatch;
import org.glavo.classfile.instruction.LocalVariable;
import org.glavo.classfile.instruction.LocalVariableType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractPseudoInstruction
extends AbstractElement
implements PseudoInstruction {
    @Override
    public abstract void writeTo(DirectCodeBuilder var1);

    public static final class UnboundLocalVariableType
    extends AbstractLocalPseudo
    implements LocalVariableType {
        public UnboundLocalVariableType(int slot, Utf8Entry name, Utf8Entry signature, Label startScope, Label endScope) {
            super(slot, name, signature, startScope, endScope);
        }

        @Override
        public Utf8Entry signature() {
            return this.descriptor;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.addLocalVariableType(this);
        }

        public String toString() {
            return "LocalVariableType[Slot=" + this.slot() + ", name=" + this.nameString() + ", signature='" + this.signature().stringValue() + "']";
        }
    }

    public static final class UnboundLocalVariable
    extends AbstractLocalPseudo
    implements LocalVariable {
        public UnboundLocalVariable(int slot, Utf8Entry name, Utf8Entry descriptor, Label startScope, Label endScope) {
            super(slot, name, descriptor, startScope, endScope);
        }

        @Override
        public Utf8Entry type() {
            return this.descriptor;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.addLocalVariable(this);
        }

        public String toString() {
            return "LocalVariable[Slot=" + this.slot() + ", name=" + this.nameString() + ", descriptor='" + this.type().stringValue() + "']";
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static abstract class AbstractLocalPseudo
    extends AbstractPseudoInstruction {
        protected final int slot;
        protected final Utf8Entry name;
        protected final Utf8Entry descriptor;
        protected final Label startScope;
        protected final Label endScope;

        public AbstractLocalPseudo(int slot, Utf8Entry name, Utf8Entry descriptor, Label startScope, Label endScope) {
            this.slot = slot;
            this.name = name;
            this.descriptor = descriptor;
            this.startScope = startScope;
            this.endScope = endScope;
        }

        public int slot() {
            return this.slot;
        }

        public Utf8Entry name() {
            return this.name;
        }

        public String nameString() {
            return this.name.stringValue();
        }

        public Label startScope() {
            return this.startScope;
        }

        public Label endScope() {
            return this.endScope;
        }

        public boolean writeTo(BufWriter b) {
            LabelContext lc = ((BufWriterImpl)b).labelContext();
            int startBci = lc.labelToBci(this.startScope());
            int endBci = lc.labelToBci(this.endScope());
            if (startBci == -1 || endBci == -1) {
                return false;
            }
            int length = endBci - startBci;
            b.writeU2(startBci);
            b.writeU2(length);
            b.writeIndex(this.name);
            b.writeIndex(this.descriptor);
            b.writeU2(this.slot());
            return true;
        }
    }

    public static final class UnboundCharacterRange
    extends AbstractPseudoInstruction
    implements CharacterRange {
        public final Label startScope;
        public final Label endScope;
        public final int characterRangeStart;
        public final int characterRangeEnd;
        public final int flags;

        public UnboundCharacterRange(Label startScope, Label endScope, int characterRangeStart, int characterRangeEnd, int flags) {
            this.startScope = startScope;
            this.endScope = endScope;
            this.characterRangeStart = characterRangeStart;
            this.characterRangeEnd = characterRangeEnd;
            this.flags = flags;
        }

        @Override
        public Label startScope() {
            return this.startScope;
        }

        @Override
        public Label endScope() {
            return this.endScope;
        }

        @Override
        public int characterRangeStart() {
            return this.characterRangeStart;
        }

        @Override
        public int characterRangeEnd() {
            return this.characterRangeEnd;
        }

        @Override
        public int flags() {
            return this.flags;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.addCharacterRange(this);
        }
    }

    public static final class ExceptionCatchImpl
    extends AbstractPseudoInstruction
    implements ExceptionCatch {
        public final ClassEntry catchTypeEntry;
        public final Label handler;
        public final Label tryStart;
        public final Label tryEnd;

        public ExceptionCatchImpl(Label handler, Label tryStart, Label tryEnd, ClassEntry catchTypeEntry) {
            this.catchTypeEntry = catchTypeEntry;
            this.handler = handler;
            this.tryStart = tryStart;
            this.tryEnd = tryEnd;
        }

        public ExceptionCatchImpl(Label handler, Label tryStart, Label tryEnd, Optional<ClassEntry> catchTypeEntry) {
            this.catchTypeEntry = catchTypeEntry.orElse(null);
            this.handler = handler;
            this.tryStart = tryStart;
            this.tryEnd = tryEnd;
        }

        @Override
        public Label tryStart() {
            return this.tryStart;
        }

        @Override
        public Label handler() {
            return this.handler;
        }

        @Override
        public Label tryEnd() {
            return this.tryEnd;
        }

        @Override
        public Optional<ClassEntry> catchType() {
            return Optional.ofNullable(this.catchTypeEntry);
        }

        ClassEntry catchTypeEntry() {
            return this.catchTypeEntry;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.addHandler(this);
        }

        public String toString() {
            return String.format("ExceptionCatch[catchType=%s]", this.catchTypeEntry == null ? "<any>" : this.catchTypeEntry.name().stringValue());
        }
    }
}

