/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.lang.constant.ConstantDesc;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import org.glavo.classfile.Annotation;
import org.glavo.classfile.AnnotationElement;
import org.glavo.classfile.AnnotationValue;
import org.glavo.classfile.BufWriter;
import org.glavo.classfile.constantpool.DoubleEntry;
import org.glavo.classfile.constantpool.FloatEntry;
import org.glavo.classfile.constantpool.IntegerEntry;
import org.glavo.classfile.constantpool.LongEntry;
import org.glavo.classfile.constantpool.Utf8Entry;

public final class AnnotationImpl
implements Annotation {
    private final Utf8Entry className;
    private final List<AnnotationElement> elements;

    public AnnotationImpl(Utf8Entry className, List<AnnotationElement> elems) {
        this.className = className;
        this.elements = List.copyOf(elems);
    }

    @Override
    public Utf8Entry className() {
        return this.className;
    }

    @Override
    public List<AnnotationElement> elements() {
        return this.elements;
    }

    @Override
    public void writeTo(BufWriter buf) {
        buf.writeIndex(this.className());
        buf.writeList(this.elements());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Annotation[");
        sb.append(this.className().stringValue());
        List<AnnotationElement> evps = this.elements();
        if (!evps.isEmpty()) {
            sb.append(" [");
        }
        for (AnnotationElement evp : evps) {
            sb.append(evp.name().stringValue()).append("=").append(evp.value().toString()).append(", ");
        }
        if (!evps.isEmpty()) {
            sb.delete(sb.length() - 1, sb.length());
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    public record OfClassImpl(Utf8Entry className) implements AnnotationValue.OfClass
    {
        @Override
        public char tag() {
            return 'c';
        }

        @Override
        public void writeTo(BufWriter buf) {
            buf.writeU1(this.tag());
            buf.writeIndex(this.className);
        }
    }

    public record OfAnnotationImpl(Annotation annotation) implements AnnotationValue.OfAnnotation
    {
        @Override
        public char tag() {
            return '@';
        }

        @Override
        public void writeTo(BufWriter buf) {
            buf.writeU1(this.tag());
            this.annotation.writeTo(buf);
        }
    }

    public record OfEnumImpl(Utf8Entry className, Utf8Entry constantName) implements AnnotationValue.OfEnum
    {
        @Override
        public char tag() {
            return 'e';
        }

        @Override
        public void writeTo(BufWriter buf) {
            buf.writeU1(this.tag());
            buf.writeIndex(this.className);
            buf.writeIndex(this.constantName);
        }
    }

    public record OfArrayImpl(List<AnnotationValue> values) implements AnnotationValue.OfArray
    {
        public OfArrayImpl(List<AnnotationValue> values) {
            this.values = List.copyOf(values);
        }

        @Override
        public char tag() {
            return '[';
        }

        @Override
        public void writeTo(BufWriter buf) {
            buf.writeU1(this.tag());
            buf.writeList(this.values);
        }
    }

    public static final class OfBooleanImpl
    extends Record
    implements OfConstantImpl,
    AnnotationValue.OfBoolean {
        private final IntegerEntry constant;

        public OfBooleanImpl(IntegerEntry constant) {
            this.constant = constant;
        }

        @Override
        public char tag() {
            return 'Z';
        }

        @Override
        public boolean booleanValue() {
            return this.constant().intValue() == 1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OfBooleanImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OfBooleanImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OfBooleanImpl.class, "constant", "constant"}, this, o);
        }

        @Override
        public IntegerEntry constant() {
            return this.constant;
        }
    }

    public static final class OfByteImpl
    extends Record
    implements OfConstantImpl,
    AnnotationValue.OfByte {
        private final IntegerEntry constant;

        public OfByteImpl(IntegerEntry constant) {
            this.constant = constant;
        }

        @Override
        public char tag() {
            return 'B';
        }

        @Override
        public byte byteValue() {
            return (byte)this.constant().intValue();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OfByteImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OfByteImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OfByteImpl.class, "constant", "constant"}, this, o);
        }

        @Override
        public IntegerEntry constant() {
            return this.constant;
        }
    }

    public static final class OfCharacterImpl
    extends Record
    implements OfConstantImpl,
    AnnotationValue.OfCharacter {
        private final IntegerEntry constant;

        public OfCharacterImpl(IntegerEntry constant) {
            this.constant = constant;
        }

        @Override
        public char tag() {
            return 'C';
        }

        @Override
        public char charValue() {
            return (char)this.constant().intValue();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OfCharacterImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OfCharacterImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OfCharacterImpl.class, "constant", "constant"}, this, o);
        }

        @Override
        public IntegerEntry constant() {
            return this.constant;
        }
    }

    public static final class OfShortImpl
    extends Record
    implements OfConstantImpl,
    AnnotationValue.OfShort {
        private final IntegerEntry constant;

        public OfShortImpl(IntegerEntry constant) {
            this.constant = constant;
        }

        @Override
        public char tag() {
            return 'S';
        }

        @Override
        public short shortValue() {
            return (short)this.constant().intValue();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OfShortImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OfShortImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OfShortImpl.class, "constant", "constant"}, this, o);
        }

        @Override
        public IntegerEntry constant() {
            return this.constant;
        }
    }

    public static final class OfIntegerImpl
    extends Record
    implements OfConstantImpl,
    AnnotationValue.OfInteger {
        private final IntegerEntry constant;

        public OfIntegerImpl(IntegerEntry constant) {
            this.constant = constant;
        }

        @Override
        public char tag() {
            return 'I';
        }

        @Override
        public int intValue() {
            return this.constant().intValue();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OfIntegerImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OfIntegerImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OfIntegerImpl.class, "constant", "constant"}, this, o);
        }

        @Override
        public IntegerEntry constant() {
            return this.constant;
        }
    }

    public static final class OfLongImpl
    extends Record
    implements OfConstantImpl,
    AnnotationValue.OfLong {
        private final LongEntry constant;

        public OfLongImpl(LongEntry constant) {
            this.constant = constant;
        }

        @Override
        public char tag() {
            return 'J';
        }

        @Override
        public long longValue() {
            return this.constant().longValue();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OfLongImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OfLongImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OfLongImpl.class, "constant", "constant"}, this, o);
        }

        @Override
        public LongEntry constant() {
            return this.constant;
        }
    }

    public static final class OfFloatImpl
    extends Record
    implements OfConstantImpl,
    AnnotationValue.OfFloat {
        private final FloatEntry constant;

        public OfFloatImpl(FloatEntry constant) {
            this.constant = constant;
        }

        @Override
        public char tag() {
            return 'F';
        }

        @Override
        public float floatValue() {
            return this.constant().floatValue();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OfFloatImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OfFloatImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OfFloatImpl.class, "constant", "constant"}, this, o);
        }

        @Override
        public FloatEntry constant() {
            return this.constant;
        }
    }

    public static final class OfDoubleImpl
    extends Record
    implements OfConstantImpl,
    AnnotationValue.OfDouble {
        private final DoubleEntry constant;

        public OfDoubleImpl(DoubleEntry constant) {
            this.constant = constant;
        }

        @Override
        public char tag() {
            return 'D';
        }

        @Override
        public double doubleValue() {
            return this.constant().doubleValue();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OfDoubleImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OfDoubleImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OfDoubleImpl.class, "constant", "constant"}, this, o);
        }

        @Override
        public DoubleEntry constant() {
            return this.constant;
        }
    }

    public static final class OfStringImpl
    extends Record
    implements OfConstantImpl,
    AnnotationValue.OfString {
        private final Utf8Entry constant;

        public OfStringImpl(Utf8Entry constant) {
            this.constant = constant;
        }

        @Override
        public char tag() {
            return 's';
        }

        @Override
        public String stringValue() {
            return this.constant().stringValue();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OfStringImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OfStringImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OfStringImpl.class, "constant", "constant"}, this, o);
        }

        @Override
        public Utf8Entry constant() {
            return this.constant;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfConstantImpl
    extends AnnotationValue.OfConstant {
        @Override
        default public void writeTo(BufWriter buf) {
            buf.writeU1(this.tag());
            buf.writeIndex(this.constant());
        }

        @Override
        default public ConstantDesc constantValue() {
            return this.constant().constantValue();
        }
    }

    public record AnnotationElementImpl(Utf8Entry name, AnnotationValue value) implements AnnotationElement
    {
        @Override
        public void writeTo(BufWriter buf) {
            buf.writeIndex(this.name());
            this.value().writeTo(buf);
        }
    }
}

