/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.List;
import org.glavo.classfile.Annotation;
import org.glavo.classfile.AnnotationElement;
import org.glavo.classfile.AnnotationValue;
import org.glavo.classfile.ClassReader;
import org.glavo.classfile.Label;
import org.glavo.classfile.TypeAnnotation;
import org.glavo.classfile.constantpool.DoubleEntry;
import org.glavo.classfile.constantpool.FloatEntry;
import org.glavo.classfile.constantpool.IntegerEntry;
import org.glavo.classfile.constantpool.LongEntry;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AnnotationImpl;
import org.glavo.classfile.impl.LabelContext;
import org.glavo.classfile.impl.UnboundAttribute;
import org.glavo.classfile.jdk.CollectionUtils;

class AnnotationReader {
    private AnnotationReader() {
    }

    public static List<Annotation> readAnnotations(ClassReader classReader, int p) {
        int pos = p;
        int numAnnotations = classReader.readU2(pos);
        Object[] annos = new Object[numAnnotations];
        pos += 2;
        for (int i = 0; i < numAnnotations; ++i) {
            annos[i] = AnnotationReader.readAnnotation(classReader, pos);
            pos = AnnotationReader.skipAnnotation(classReader, pos);
        }
        return CollectionUtils.listFromTrustedArrayNullsAllowed(annos);
    }

    public static AnnotationValue readElementValue(ClassReader classReader, int p) {
        char tag = (char)classReader.readU1(p);
        ++p;
        return switch (tag) {
            case 'B' -> new AnnotationImpl.OfByteImpl((IntegerEntry)classReader.readEntry(p));
            case 'C' -> new AnnotationImpl.OfCharacterImpl((IntegerEntry)classReader.readEntry(p));
            case 'D' -> new AnnotationImpl.OfDoubleImpl((DoubleEntry)classReader.readEntry(p));
            case 'F' -> new AnnotationImpl.OfFloatImpl((FloatEntry)classReader.readEntry(p));
            case 'I' -> new AnnotationImpl.OfIntegerImpl((IntegerEntry)classReader.readEntry(p));
            case 'J' -> new AnnotationImpl.OfLongImpl((LongEntry)classReader.readEntry(p));
            case 'S' -> new AnnotationImpl.OfShortImpl((IntegerEntry)classReader.readEntry(p));
            case 'Z' -> new AnnotationImpl.OfBooleanImpl((IntegerEntry)classReader.readEntry(p));
            case 's' -> new AnnotationImpl.OfStringImpl(classReader.readUtf8Entry(p));
            case 'e' -> new AnnotationImpl.OfEnumImpl(classReader.readUtf8Entry(p), classReader.readUtf8Entry(p + 2));
            case 'c' -> new AnnotationImpl.OfClassImpl(classReader.readUtf8Entry(p));
            case '@' -> new AnnotationImpl.OfAnnotationImpl(AnnotationReader.readAnnotation(classReader, p));
            case '[' -> {
                int numValues = classReader.readU2(p);
                p += 2;
                Object[] values = new Object[numValues];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = AnnotationReader.readElementValue(classReader, p);
                    p = AnnotationReader.skipElementValue(classReader, p);
                }
                yield new AnnotationImpl.OfArrayImpl(CollectionUtils.listFromTrustedArrayNullsAllowed(values));
            }
            default -> throw new IllegalArgumentException("Unexpected tag '%s' in AnnotationValue, pos = %d".formatted(Character.valueOf(tag), p - 1));
        };
    }

    public static List<TypeAnnotation> readTypeAnnotations(ClassReader classReader, int p, LabelContext lc) {
        int numTypeAnnotations = classReader.readU2(p);
        p += 2;
        Object[] annotations = new Object[numTypeAnnotations];
        for (int i = 0; i < numTypeAnnotations; ++i) {
            annotations[i] = AnnotationReader.readTypeAnnotation(classReader, p, lc);
            p = AnnotationReader.skipTypeAnnotation(classReader, p);
        }
        return CollectionUtils.listFromTrustedArrayNullsAllowed(annotations);
    }

    public static List<List<Annotation>> readParameterAnnotations(ClassReader classReader, int p) {
        int cnt = classReader.readU1(p++);
        Object[] pas = new Object[cnt];
        for (int i = 0; i < cnt; ++i) {
            pas[i] = AnnotationReader.readAnnotations(classReader, p);
            p = AnnotationReader.skipAnnotations(classReader, p);
        }
        return CollectionUtils.listFromTrustedArrayNullsAllowed(pas);
    }

    private static int skipElementValue(ClassReader classReader, int p) {
        char tag = (char)classReader.readU1(p);
        ++p;
        return switch (tag) {
            case 'B', 'C', 'D', 'F', 'I', 'J', 'S', 'Z', 'c', 's' -> p + 2;
            case 'e' -> p + 4;
            case '@' -> AnnotationReader.skipAnnotation(classReader, p);
            case '[' -> {
                int numValues = classReader.readU2(p);
                p += 2;
                for (int i = 0; i < numValues; ++i) {
                    p = AnnotationReader.skipElementValue(classReader, p);
                }
                yield p;
            }
            default -> throw new IllegalArgumentException("Unexpected tag '%s' in AnnotationValue, pos = %d".formatted(Character.valueOf(tag), p - 1));
        };
    }

    private static Annotation readAnnotation(ClassReader classReader, int p) {
        Utf8Entry annotationClass = classReader.utf8EntryByIndex(classReader.readU2(p));
        List<AnnotationElement> elems = AnnotationReader.readAnnotationElementValuePairs(classReader, p += 2);
        return new AnnotationImpl(annotationClass, elems);
    }

    private static int skipAnnotations(ClassReader classReader, int p) {
        int numAnnotations = classReader.readU2(p);
        p += 2;
        for (int i = 0; i < numAnnotations; ++i) {
            p = AnnotationReader.skipAnnotation(classReader, p);
        }
        return p;
    }

    private static int skipAnnotation(ClassReader classReader, int p) {
        return AnnotationReader.skipElementValuePairs(classReader, p + 2);
    }

    private static List<AnnotationElement> readAnnotationElementValuePairs(ClassReader classReader, int p) {
        int numElementValuePairs = classReader.readU2(p);
        p += 2;
        Object[] annotationElements = new Object[numElementValuePairs];
        for (int i = 0; i < numElementValuePairs; ++i) {
            Utf8Entry elementName = classReader.readUtf8Entry(p);
            AnnotationValue value = AnnotationReader.readElementValue(classReader, p += 2);
            annotationElements[i] = new AnnotationImpl.AnnotationElementImpl(elementName, value);
            p = AnnotationReader.skipElementValue(classReader, p);
        }
        return CollectionUtils.listFromTrustedArrayNullsAllowed(annotationElements);
    }

    private static int skipElementValuePairs(ClassReader classReader, int p) {
        int numElementValuePairs = classReader.readU2(p);
        p += 2;
        for (int i = 0; i < numElementValuePairs; ++i) {
            p = AnnotationReader.skipElementValue(classReader, p + 2);
        }
        return p;
    }

    private static Label getLabel(LabelContext lc, int bciOffset, int targetType, int p) {
        if (lc == null) {
            throw new IllegalArgumentException("Unexpected targetType '%d' in TypeAnnotation outside of Code attribute, pos = %d".formatted(targetType, p - 1));
        }
        return lc.getLabel(bciOffset);
    }

    private static TypeAnnotation readTypeAnnotation(ClassReader classReader, int p, LabelContext lc) {
        int targetType = classReader.readU1(p++);
        TypeAnnotation.EmptyTarget targetInfo = switch (targetType) {
            case 0 -> TypeAnnotation.TargetInfo.ofClassTypeParameter(classReader.readU1(p));
            case 1 -> TypeAnnotation.TargetInfo.ofMethodTypeParameter(classReader.readU1(p));
            case 16 -> TypeAnnotation.TargetInfo.ofClassExtends(classReader.readU2(p));
            case 17 -> TypeAnnotation.TargetInfo.ofClassTypeParameterBound(classReader.readU1(p), classReader.readU1(p + 1));
            case 18 -> TypeAnnotation.TargetInfo.ofMethodTypeParameterBound(classReader.readU1(p), classReader.readU1(p + 1));
            case 19 -> TypeAnnotation.TargetInfo.ofField();
            case 20 -> TypeAnnotation.TargetInfo.ofMethodReturn();
            case 21 -> TypeAnnotation.TargetInfo.ofMethodReceiver();
            case 22 -> TypeAnnotation.TargetInfo.ofMethodFormalParameter(classReader.readU1(p));
            case 23 -> TypeAnnotation.TargetInfo.ofThrows(classReader.readU2(p));
            case 64 -> TypeAnnotation.TargetInfo.ofLocalVariable(AnnotationReader.readLocalVarEntries(classReader, p, lc, targetType));
            case 65 -> TypeAnnotation.TargetInfo.ofResourceVariable(AnnotationReader.readLocalVarEntries(classReader, p, lc, targetType));
            case 66 -> TypeAnnotation.TargetInfo.ofExceptionParameter(classReader.readU2(p));
            case 67 -> TypeAnnotation.TargetInfo.ofInstanceofExpr(AnnotationReader.getLabel(lc, classReader.readU2(p), targetType, p));
            case 68 -> TypeAnnotation.TargetInfo.ofNewExpr(AnnotationReader.getLabel(lc, classReader.readU2(p), targetType, p));
            case 69 -> TypeAnnotation.TargetInfo.ofConstructorReference(AnnotationReader.getLabel(lc, classReader.readU2(p), targetType, p));
            case 70 -> TypeAnnotation.TargetInfo.ofMethodReference(AnnotationReader.getLabel(lc, classReader.readU2(p), targetType, p));
            case 71 -> TypeAnnotation.TargetInfo.ofCastExpr(AnnotationReader.getLabel(lc, classReader.readU2(p), targetType, p), classReader.readU1(p + 2));
            case 72 -> TypeAnnotation.TargetInfo.ofConstructorInvocationTypeArgument(AnnotationReader.getLabel(lc, classReader.readU2(p), targetType, p), classReader.readU1(p + 2));
            case 73 -> TypeAnnotation.TargetInfo.ofMethodInvocationTypeArgument(AnnotationReader.getLabel(lc, classReader.readU2(p), targetType, p), classReader.readU1(p + 2));
            case 74 -> TypeAnnotation.TargetInfo.ofConstructorReferenceTypeArgument(AnnotationReader.getLabel(lc, classReader.readU2(p), targetType, p), classReader.readU1(p + 2));
            case 75 -> TypeAnnotation.TargetInfo.ofMethodReferenceTypeArgument(AnnotationReader.getLabel(lc, classReader.readU2(p), targetType, p), classReader.readU1(p + 2));
            default -> throw new IllegalArgumentException("Unexpected targetType '%d' in TypeAnnotation, pos = %d".formatted(targetType, p - 1));
        };
        p += targetInfo.size();
        int pathLength = classReader.readU1(p++);
        TypeAnnotation.TypePathComponent[] typePath = new TypeAnnotation.TypePathComponent[pathLength];
        for (int i = 0; i < pathLength; ++i) {
            int typePathKindTag = classReader.readU1(p++);
            int typeArgumentIndex = classReader.readU1(p++);
            typePath[i] = switch (typePathKindTag) {
                case 0 -> TypeAnnotation.TypePathComponent.ARRAY;
                case 1 -> TypeAnnotation.TypePathComponent.INNER_TYPE;
                case 2 -> TypeAnnotation.TypePathComponent.WILDCARD;
                case 3 -> new UnboundAttribute.TypePathComponentImpl(TypeAnnotation.TypePathComponent.Kind.TYPE_ARGUMENT, typeArgumentIndex);
                default -> throw new IllegalArgumentException("Unknown type annotation path component kind: " + typePathKindTag);
            };
        }
        Utf8Entry type = classReader.readUtf8Entry(p);
        return TypeAnnotation.of((TypeAnnotation.TargetInfo)targetInfo, List.of(typePath), type, AnnotationReader.readAnnotationElementValuePairs(classReader, p += 2));
    }

    private static List<TypeAnnotation.LocalVarTargetInfo> readLocalVarEntries(ClassReader classReader, int p, LabelContext lc, int targetType) {
        int tableLength = classReader.readU2(p);
        p += 2;
        Object[] entries = new Object[tableLength];
        for (int i = 0; i < tableLength; ++i) {
            int startPc = classReader.readU2(p);
            entries[i] = TypeAnnotation.LocalVarTargetInfo.of(AnnotationReader.getLabel(lc, startPc, targetType, p), AnnotationReader.getLabel(lc, startPc + classReader.readU2(p + 2), targetType, p - 2), classReader.readU2(p + 4));
            p += 6;
        }
        return CollectionUtils.listFromTrustedArrayNullsAllowed(entries);
    }

    private static int skipTypeAnnotation(ClassReader classReader, int p) {
        int targetType = classReader.readU1(p++);
        p += (switch (targetType) {
            case 19, 20, 21 -> 0;
            case 0, 1, 22 -> 1;
            case 16, 17, 18, 23, 66, 67, 68, 69, 70 -> 2;
            case 71, 72, 73, 74, 75 -> 3;
            case 64, 65 -> 2 + classReader.readU2(p) * 6;
            default -> throw new IllegalArgumentException("Unexpected targetType '%d' in TypeAnnotation, pos = %d".formatted(targetType, p - 1));
        });
        int pathLength = classReader.readU1(p++);
        p += pathLength * 2;
        p += 2;
        p = AnnotationReader.skipElementValuePairs(classReader, p);
        return p;
    }
}

