/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.glavo.classfile.AccessFlag;
import org.glavo.classfile.AccessFlags;
import org.glavo.classfile.BufWriter;
import org.glavo.classfile.ClassModel;
import org.glavo.classfile.FieldBuilder;
import org.glavo.classfile.FieldElement;
import org.glavo.classfile.FieldModel;
import org.glavo.classfile.constantpool.ConstantPoolBuilder;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AbstractUnboundModel;
import org.glavo.classfile.impl.DirectFieldBuilder;
import org.glavo.classfile.impl.SplitConstantPool;
import org.glavo.classfile.impl.TerminalFieldBuilder;

public final class BufferedFieldBuilder
implements TerminalFieldBuilder {
    private final SplitConstantPool constantPool;
    private final Utf8Entry name;
    private final Utf8Entry desc;
    private final List<FieldElement> elements = new ArrayList<FieldElement>();
    private AccessFlags flags;
    private final FieldModel original;

    public BufferedFieldBuilder(SplitConstantPool constantPool, Utf8Entry name, Utf8Entry type, FieldModel original) {
        this.constantPool = constantPool;
        this.name = name;
        this.desc = type;
        this.flags = AccessFlags.ofField(new AccessFlag[0]);
        this.original = original;
    }

    @Override
    public ConstantPoolBuilder constantPool() {
        return this.constantPool;
    }

    @Override
    public Optional<FieldModel> original() {
        return Optional.ofNullable(this.original);
    }

    @Override
    public FieldBuilder with(FieldElement element) {
        this.elements.add(element);
        if (element instanceof AccessFlags) {
            AccessFlags f;
            this.flags = f = (AccessFlags)element;
        }
        return this;
    }

    public BufferedFieldBuilder run(Consumer<? super FieldBuilder> handler) {
        handler.accept(this);
        return this;
    }

    public FieldModel toModel() {
        return new Model();
    }

    public final class Model
    extends AbstractUnboundModel<FieldElement>
    implements FieldModel {
        public Model() {
            super(BufferedFieldBuilder.this.elements);
        }

        @Override
        public Optional<ClassModel> parent() {
            FieldModel fm = BufferedFieldBuilder.this.original().orElse(null);
            return fm == null ? Optional.empty() : fm.parent();
        }

        @Override
        public AccessFlags flags() {
            return BufferedFieldBuilder.this.flags;
        }

        @Override
        public Utf8Entry fieldName() {
            return BufferedFieldBuilder.this.name;
        }

        @Override
        public Utf8Entry fieldType() {
            return BufferedFieldBuilder.this.desc;
        }

        @Override
        public void writeTo(BufWriter buf) {
            DirectFieldBuilder fb = new DirectFieldBuilder(BufferedFieldBuilder.this.constantPool, BufferedFieldBuilder.this.name, BufferedFieldBuilder.this.desc, null);
            BufferedFieldBuilder.this.elements.forEach(fb);
            fb.writeTo(buf);
        }

        public String toString() {
            return String.format("FieldModel[fieldName=%s, fieldType=%s, flags=%d]", BufferedFieldBuilder.this.name.stringValue(), BufferedFieldBuilder.this.desc.stringValue(), BufferedFieldBuilder.this.flags.flagsMask());
        }
    }
}

