/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.lang.constant.ConstantDesc;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.runtime.SwitchBootstraps;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.glavo.classfile.Annotation;
import org.glavo.classfile.AnnotationElement;
import org.glavo.classfile.AnnotationValue;
import org.glavo.classfile.Attribute;
import org.glavo.classfile.ClassModel;
import org.glavo.classfile.CodeElement;
import org.glavo.classfile.CodeModel;
import org.glavo.classfile.CompoundElement;
import org.glavo.classfile.FieldModel;
import org.glavo.classfile.Instruction;
import org.glavo.classfile.MethodModel;
import org.glavo.classfile.TypeAnnotation;
import org.glavo.classfile.attribute.AnnotationDefaultAttribute;
import org.glavo.classfile.attribute.BootstrapMethodsAttribute;
import org.glavo.classfile.attribute.CharacterRangeInfo;
import org.glavo.classfile.attribute.CharacterRangeTableAttribute;
import org.glavo.classfile.attribute.CodeAttribute;
import org.glavo.classfile.attribute.ConstantValueAttribute;
import org.glavo.classfile.attribute.EnclosingMethodAttribute;
import org.glavo.classfile.attribute.ExceptionsAttribute;
import org.glavo.classfile.attribute.InnerClassesAttribute;
import org.glavo.classfile.attribute.LineNumberInfo;
import org.glavo.classfile.attribute.LineNumberTableAttribute;
import org.glavo.classfile.attribute.LocalVariableInfo;
import org.glavo.classfile.attribute.LocalVariableTableAttribute;
import org.glavo.classfile.attribute.LocalVariableTypeInfo;
import org.glavo.classfile.attribute.LocalVariableTypeTableAttribute;
import org.glavo.classfile.attribute.MethodParameterInfo;
import org.glavo.classfile.attribute.MethodParametersAttribute;
import org.glavo.classfile.attribute.ModuleAttribute;
import org.glavo.classfile.attribute.ModuleMainClassAttribute;
import org.glavo.classfile.attribute.ModulePackagesAttribute;
import org.glavo.classfile.attribute.NestHostAttribute;
import org.glavo.classfile.attribute.NestMembersAttribute;
import org.glavo.classfile.attribute.PermittedSubclassesAttribute;
import org.glavo.classfile.attribute.RecordAttribute;
import org.glavo.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeInvisibleParameterAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeInvisibleTypeAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeVisibleParameterAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute;
import org.glavo.classfile.attribute.SignatureAttribute;
import org.glavo.classfile.attribute.SourceFileAttribute;
import org.glavo.classfile.attribute.StackMapFrameInfo;
import org.glavo.classfile.attribute.StackMapTableAttribute;
import org.glavo.classfile.components.ClassPrinter;
import org.glavo.classfile.constantpool.AnnotationConstantValueEntry;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.ConstantPool;
import org.glavo.classfile.constantpool.DynamicConstantPoolEntry;
import org.glavo.classfile.constantpool.InterfaceMethodRefEntry;
import org.glavo.classfile.constantpool.MemberRefEntry;
import org.glavo.classfile.constantpool.MethodHandleEntry;
import org.glavo.classfile.constantpool.MethodTypeEntry;
import org.glavo.classfile.constantpool.ModuleEntry;
import org.glavo.classfile.constantpool.NameAndTypeEntry;
import org.glavo.classfile.constantpool.PackageEntry;
import org.glavo.classfile.constantpool.PoolEntry;
import org.glavo.classfile.constantpool.StringEntry;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.StackMapDecoder;
import org.glavo.classfile.instruction.BranchInstruction;
import org.glavo.classfile.instruction.ConstantInstruction;
import org.glavo.classfile.instruction.FieldInstruction;
import org.glavo.classfile.instruction.IncrementInstruction;
import org.glavo.classfile.instruction.InvokeDynamicInstruction;
import org.glavo.classfile.instruction.InvokeInstruction;
import org.glavo.classfile.instruction.LoadInstruction;
import org.glavo.classfile.instruction.LookupSwitchInstruction;
import org.glavo.classfile.instruction.NewMultiArrayInstruction;
import org.glavo.classfile.instruction.NewObjectInstruction;
import org.glavo.classfile.instruction.NewPrimitiveArrayInstruction;
import org.glavo.classfile.instruction.NewReferenceArrayInstruction;
import org.glavo.classfile.instruction.StoreInstruction;
import org.glavo.classfile.instruction.TableSwitchInstruction;
import org.glavo.classfile.instruction.TypeCheckInstruction;

public final class ClassPrinterImpl {
    private static final String NL = System.lineSeparator();
    private static final char[] DIGITS = "0123456789ABCDEF".toCharArray();

    private static ClassPrinter.Node leaf(ConstantDesc name, ConstantDesc value) {
        return new LeafNodeImpl(name, value);
    }

    private static ClassPrinter.Node[] leafs(ConstantDesc ... namesAndValues) {
        if ((namesAndValues.length & 1) > 0) {
            throw new AssertionError((Object)("Odd number of arguments: " + Arrays.toString(namesAndValues)));
        }
        ClassPrinter.Node[] nodes = new ClassPrinter.Node[namesAndValues.length >> 1];
        int j = 0;
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = ClassPrinterImpl.leaf(namesAndValues[j++], namesAndValues[j++]);
        }
        return nodes;
    }

    private static ClassPrinter.Node list(ConstantDesc listName, ConstantDesc itemsName, Stream<ConstantDesc> values) {
        return new ListNodeImpl(Style.FLOW, listName, values.map(v -> ClassPrinterImpl.leaf(itemsName, v)));
    }

    private static ClassPrinter.Node map(ConstantDesc mapName, ConstantDesc ... keysAndValues) {
        return new MapNodeImpl(Style.FLOW, mapName).with(ClassPrinterImpl.leafs(keysAndValues));
    }

    private static void escape(int c, StringBuilder sb) {
        switch (c) {
            case 92: {
                sb.append('\\').append('\\');
                break;
            }
            case 34: {
                sb.append('\\').append('\"');
                break;
            }
            case 8: {
                sb.append('\\').append('b');
                break;
            }
            case 10: {
                sb.append('\\').append('n');
                break;
            }
            case 9: {
                sb.append('\\').append('t');
                break;
            }
            case 12: {
                sb.append('\\').append('f');
                break;
            }
            case 13: {
                sb.append('\\').append('r');
                break;
            }
            default: {
                if (c >= 32 && c < 127) {
                    sb.append((char)c);
                    break;
                }
                sb.append('\\').append('u').append(DIGITS[c >> 12 & 0xF]).append(DIGITS[c >> 8 & 0xF]).append(DIGITS[c >> 4 & 0xF]).append(DIGITS[c & 0xF]);
            }
        }
    }

    public static void toYaml(ClassPrinter.Node node, Consumer<String> out) {
        ClassPrinterImpl.toYaml(0, false, new ListNodeImpl(Style.BLOCK, null, Stream.of(node)), out);
        out.accept(NL);
    }

    private static void toYaml(int indent, boolean skipFirstIndent, ClassPrinter.Node node, Consumer<String> out) {
        ClassPrinter.Node node2 = node;
        Objects.requireNonNull(node2);
        ClassPrinter.Node node3 = node2;
        int n = 0;
        block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassPrinter.LeafNode.class, ListNodeImpl.class, MapNodeImpl.class}, (Object)node3, n)) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                ClassPrinter.LeafNode leaf = (ClassPrinter.LeafNode)node3;
                out.accept(ClassPrinterImpl.quoteAndEscapeYaml(leaf.value()));
                break;
            }
            case 1: {
                ListNodeImpl list = (ListNodeImpl)node3;
                switch (list.style()) {
                    case FLOW: {
                        out.accept("[");
                        boolean first = true;
                        for (ClassPrinter.Node n2 : list) {
                            if (first) {
                                first = false;
                            } else {
                                out.accept(", ");
                            }
                            ClassPrinterImpl.toYaml(0, false, n2, out);
                        }
                        out.accept("]");
                        break;
                    }
                    case BLOCK: {
                        for (ClassPrinter.Node n3 : list) {
                            out.accept(NL + "    ".repeat(indent) + "  - ");
                            ClassPrinterImpl.toYaml(indent + 1, true, n3, out);
                        }
                        break;
                    }
                }
                break;
            }
            case 2: {
                MapNodeImpl map = (MapNodeImpl)node3;
                switch (map.style()) {
                    case FLOW: {
                        out.accept("{");
                        boolean first = true;
                        for (ClassPrinter.Node n4 : map.values()) {
                            if (first) {
                                first = false;
                            } else {
                                out.accept(", ");
                            }
                            out.accept(ClassPrinterImpl.quoteAndEscapeYaml(n4.name()) + ": ");
                            ClassPrinterImpl.toYaml(0, false, n4, out);
                        }
                        out.accept("}");
                        break block0;
                    }
                    case BLOCK: {
                        for (ClassPrinter.Node n5 : map.values()) {
                            ListNodeImpl pl;
                            if (skipFirstIndent) {
                                skipFirstIndent = false;
                            } else {
                                out.accept(NL + "    ".repeat(indent));
                            }
                            out.accept(ClassPrinterImpl.quoteAndEscapeYaml(n5.name()) + ": ");
                            ClassPrinterImpl.toYaml(n5 instanceof ListNodeImpl && (pl = (ListNodeImpl)n5).style() == Style.BLOCK ? indent : indent + 1, false, n5, out);
                        }
                        break block0;
                    }
                }
            }
        }
    }

    private static String quoteAndEscapeYaml(ConstantDesc value) {
        String s = String.valueOf(value);
        if (value instanceof Number) {
            return s;
        }
        if (s.length() == 0) {
            return "''";
        }
        StringBuilder sb = new StringBuilder(s.length() << 1);
        s.chars().forEach(c -> {
            switch (c) {
                case 39: {
                    sb.append("''");
                    break;
                }
                default: {
                    ClassPrinterImpl.escape(c, sb);
                }
            }
        });
        String esc = sb.toString();
        if (esc.length() != s.length()) {
            return "'" + esc + "'";
        }
        switch (esc.charAt(0)) {
            case '!': 
            case '\"': 
            case '#': 
            case '%': 
            case '&': 
            case '\'': 
            case '*': 
            case ',': 
            case '-': 
            case ':': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case ']': 
            case '`': 
            case '{': 
            case '|': 
            case '}': {
                return "'" + esc + "'";
            }
        }
        for (int i = 1; i < esc.length(); ++i) {
            switch (esc.charAt(i)) {
                case ',': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    return "'" + esc + "'";
                }
            }
        }
        return esc;
    }

    public static void toJson(ClassPrinter.Node node, Consumer<String> out) {
        ClassPrinterImpl.toJson(1, true, node, out);
        out.accept(NL);
    }

    private static void toJson(int indent, boolean skipFirstIndent, ClassPrinter.Node node, Consumer<String> out) {
        ClassPrinter.Node node2 = node;
        Objects.requireNonNull(node2);
        ClassPrinter.Node node3 = node2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassPrinter.LeafNode.class, ListNodeImpl.class, MapNodeImpl.class}, (Object)node3, n)) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                ClassPrinter.LeafNode leaf = (ClassPrinter.LeafNode)node3;
                out.accept(ClassPrinterImpl.quoteAndEscapeJson(leaf.value()));
                break;
            }
            case 1: {
                ListNodeImpl list = (ListNodeImpl)node3;
                out.accept("[");
                boolean first = true;
                switch (list.style()) {
                    case FLOW: {
                        for (ClassPrinter.Node n2 : list) {
                            if (first) {
                                first = false;
                            } else {
                                out.accept(", ");
                            }
                            ClassPrinterImpl.toJson(0, false, n2, out);
                        }
                        break;
                    }
                    case BLOCK: {
                        for (ClassPrinter.Node n3 : list) {
                            if (first) {
                                first = false;
                            } else {
                                out.accept(",");
                            }
                            out.accept(NL + "    ".repeat(indent));
                            ClassPrinterImpl.toJson(indent + 1, true, n3, out);
                        }
                        break;
                    }
                }
                out.accept("]");
                break;
            }
            case 2: {
                MapNodeImpl map = (MapNodeImpl)node3;
                switch (map.style()) {
                    case FLOW: {
                        out.accept("{");
                        boolean first = true;
                        for (ClassPrinter.Node n4 : map.values()) {
                            if (first) {
                                first = false;
                            } else {
                                out.accept(", ");
                            }
                            out.accept(ClassPrinterImpl.quoteAndEscapeJson((ConstantDesc)((Object)n4.name().toString())) + ": ");
                            ClassPrinterImpl.toJson(0, false, n4, out);
                        }
                        break;
                    }
                    case BLOCK: {
                        if (skipFirstIndent) {
                            out.accept("  { ");
                        } else {
                            out.accept("{");
                        }
                        boolean first = true;
                        for (ClassPrinter.Node n5 : map.values()) {
                            if (first) {
                                first = false;
                            } else {
                                out.accept(",");
                            }
                            if (skipFirstIndent) {
                                skipFirstIndent = false;
                            } else {
                                out.accept(NL + "    ".repeat(indent));
                            }
                            out.accept(ClassPrinterImpl.quoteAndEscapeJson((ConstantDesc)((Object)n5.name().toString())) + ": ");
                            ClassPrinterImpl.toJson(indent + 1, false, n5, out);
                        }
                        break;
                    }
                }
                out.accept("}");
            }
        }
    }

    private static String quoteAndEscapeJson(ConstantDesc value) {
        String s = String.valueOf(value);
        if (value instanceof Number) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() << 1);
        sb.append('\"');
        s.chars().forEach(c -> ClassPrinterImpl.escape(c, sb));
        sb.append('\"');
        return sb.toString();
    }

    public static void toXml(ClassPrinter.Node node, Consumer<String> out) {
        out.accept("<?xml version = '1.0'?>");
        ClassPrinterImpl.toXml(0, false, node, out);
        out.accept(NL);
    }

    private static void toXml(int indent, boolean skipFirstIndent, ClassPrinter.Node node, Consumer<String> out) {
        String name = ClassPrinterImpl.toXmlName(node.name().toString());
        ClassPrinter.Node node2 = node;
        Objects.requireNonNull(node2);
        ClassPrinter.Node node3 = node2;
        int n = 0;
        block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassPrinter.LeafNode.class, ListNodeImpl.class, MapNodeImpl.class}, (Object)node3, n)) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                ClassPrinter.LeafNode leaf = (ClassPrinter.LeafNode)node3;
                out.accept("<" + name + ">");
                out.accept(ClassPrinterImpl.xmlEscape(leaf.value()));
                break;
            }
            case 1: {
                ListNodeImpl list = (ListNodeImpl)node3;
                switch (list.style()) {
                    case FLOW: {
                        out.accept("<" + name + ">");
                        for (ClassPrinter.Node n2 : list) {
                            ClassPrinterImpl.toXml(0, false, n2, out);
                        }
                        break block0;
                    }
                    case BLOCK: {
                        if (!skipFirstIndent) {
                            out.accept(NL + "    ".repeat(indent));
                        }
                        out.accept("<" + name + ">");
                        for (ClassPrinter.Node n3 : list) {
                            out.accept(NL + "    ".repeat(indent + 1));
                            ClassPrinterImpl.toXml(indent + 1, true, n3, out);
                        }
                    }
                }
                break;
            }
            case 2: {
                MapNodeImpl map = (MapNodeImpl)node3;
                switch (map.style()) {
                    case FLOW: {
                        out.accept("<" + name + ">");
                        for (ClassPrinter.Node n4 : map.values()) {
                            ClassPrinterImpl.toXml(0, false, n4, out);
                        }
                        break block0;
                    }
                    case BLOCK: {
                        if (!skipFirstIndent) {
                            out.accept(NL + "    ".repeat(indent));
                        }
                        out.accept("<" + name + ">");
                        for (ClassPrinter.Node n5 : map.values()) {
                            out.accept(NL + "    ".repeat(indent + 1));
                            ClassPrinterImpl.toXml(indent + 1, true, n5, out);
                        }
                        break block0;
                    }
                }
            }
        }
        out.accept("</" + name + ">");
    }

    private static String xmlEscape(ConstantDesc value) {
        String s = String.valueOf(value);
        StringBuilder sb = new StringBuilder(s.length() << 1);
        s.chars().forEach(c -> {
            switch (c) {
                case 60: {
                    sb.append("&lt;");
                    break;
                }
                case 62: {
                    sb.append("&gt;");
                    break;
                }
                case 34: {
                    sb.append("&quot;");
                    break;
                }
                case 38: {
                    sb.append("&amp;");
                    break;
                }
                case 39: {
                    sb.append("&apos;");
                    break;
                }
                default: {
                    ClassPrinterImpl.escape(c, sb);
                }
            }
        });
        return sb.toString();
    }

    private static String toXmlName(String name) {
        if (Character.isDigit(((String)name).charAt(0))) {
            name = "_" + (String)name;
        }
        return ((String)name).replaceAll("[^A-Za-z_0-9]", "_");
    }

    private static ClassPrinter.Node[] elementValueToTree(AnnotationValue v) {
        ClassPrinter.Node[] nodeArray;
        AnnotationValue annotationValue = v;
        Objects.requireNonNull(annotationValue);
        AnnotationValue annotationValue2 = annotationValue;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnnotationValue.OfString.class, AnnotationValue.OfDouble.class, AnnotationValue.OfFloat.class, AnnotationValue.OfLong.class, AnnotationValue.OfInteger.class, AnnotationValue.OfShort.class, AnnotationValue.OfCharacter.class, AnnotationValue.OfByte.class, AnnotationValue.OfBoolean.class, AnnotationValue.OfClass.class, AnnotationValue.OfEnum.class, AnnotationValue.OfAnnotation.class, AnnotationValue.OfArray.class}, (Object)annotationValue2, n)) {
            case 0: {
                AnnotationValue.OfString cv = (AnnotationValue.OfString)annotationValue2;
                nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"string", String.valueOf(cv.constantValue())});
                break;
            }
            case 1: {
                AnnotationValue.OfDouble cv = (AnnotationValue.OfDouble)annotationValue2;
                nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"double", String.valueOf(cv.constantValue())});
                break;
            }
            case 2: {
                AnnotationValue.OfFloat cv = (AnnotationValue.OfFloat)annotationValue2;
                nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"float", String.valueOf(cv.constantValue())});
                break;
            }
            case 3: {
                AnnotationValue.OfLong cv = (AnnotationValue.OfLong)annotationValue2;
                nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"long", String.valueOf(cv.constantValue())});
                break;
            }
            case 4: {
                AnnotationValue.OfInteger cv = (AnnotationValue.OfInteger)annotationValue2;
                nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"int", String.valueOf(cv.constantValue())});
                break;
            }
            case 5: {
                AnnotationValue.OfShort cv = (AnnotationValue.OfShort)annotationValue2;
                nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"short", String.valueOf(cv.constantValue())});
                break;
            }
            case 6: {
                AnnotationValue.OfCharacter cv = (AnnotationValue.OfCharacter)annotationValue2;
                nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"char", String.valueOf(cv.constantValue())});
                break;
            }
            case 7: {
                AnnotationValue.OfByte cv = (AnnotationValue.OfByte)annotationValue2;
                nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"byte", String.valueOf(cv.constantValue())});
                break;
            }
            case 8: {
                AnnotationValue.OfBoolean cv = (AnnotationValue.OfBoolean)annotationValue2;
                nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"boolean", String.valueOf((Integer)cv.constantValue() != 0)});
                break;
            }
            case 9: {
                AnnotationValue.OfClass clv = (AnnotationValue.OfClass)annotationValue2;
                nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"class", clv.className().stringValue()});
                break;
            }
            case 10: {
                AnnotationValue.OfEnum ev2 = (AnnotationValue.OfEnum)annotationValue2;
                nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"enum class", ev2.className().stringValue(), "contant name", ev2.constantName().stringValue()});
                break;
            }
            case 11: {
                AnnotationValue.OfAnnotation av = (AnnotationValue.OfAnnotation)annotationValue2;
                nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"annotation class", av.annotation().className().stringValue()});
                break;
            }
            case 12: {
                AnnotationValue.OfArray av = (AnnotationValue.OfArray)annotationValue2;
                ClassPrinter.Node[] nodeArray2 = new ClassPrinter.Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = new ListNodeImpl(Style.FLOW, (ConstantDesc)((Object)"array"), av.values().stream().map(ev -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"value")).with(ClassPrinterImpl.elementValueToTree(ev))));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return nodeArray;
    }

    private static ClassPrinter.Node elementValuePairsToTree(List<AnnotationElement> evps) {
        return new ListNodeImpl(Style.FLOW, (ConstantDesc)((Object)"values"), evps.stream().map(evp -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"pair")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"name"), (ConstantDesc)((Object)evp.name().stringValue())), new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"value")).with(ClassPrinterImpl.elementValueToTree(evp.value())))));
    }

    private static Stream<ConstantDesc> convertVTIs(CodeAttribute lr, List<StackMapFrameInfo.VerificationTypeInfo> vtis) {
        return vtis.stream().mapMulti((vti, ret) -> {
            StackMapFrameInfo.VerificationTypeInfo verificationTypeInfo = vti;
            Objects.requireNonNull(verificationTypeInfo);
            StackMapFrameInfo.VerificationTypeInfo selector19784$temp = verificationTypeInfo;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StackMapFrameInfo.SimpleVerificationTypeInfo.class, StackMapFrameInfo.ObjectVerificationTypeInfo.class, StackMapFrameInfo.UninitializedVerificationTypeInfo.class}, (Object)selector19784$temp, n)) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case 0: {
                    StackMapFrameInfo.SimpleVerificationTypeInfo s = (StackMapFrameInfo.SimpleVerificationTypeInfo)selector19784$temp;
                    switch (s) {
                        case ITEM_DOUBLE: {
                            ret.accept("double");
                            ret.accept("double2");
                            break;
                        }
                        case ITEM_FLOAT: {
                            ret.accept("float");
                            break;
                        }
                        case ITEM_INTEGER: {
                            ret.accept("int");
                            break;
                        }
                        case ITEM_LONG: {
                            ret.accept("long");
                            ret.accept("long2");
                            break;
                        }
                        case ITEM_NULL: {
                            ret.accept("null");
                            break;
                        }
                        case ITEM_TOP: {
                            ret.accept("?");
                            break;
                        }
                        case ITEM_UNINITIALIZED_THIS: {
                            ret.accept("THIS");
                        }
                    }
                    break;
                }
                case 1: {
                    StackMapFrameInfo.ObjectVerificationTypeInfo o = (StackMapFrameInfo.ObjectVerificationTypeInfo)selector19784$temp;
                    ret.accept(o.className().name().stringValue());
                    break;
                }
                case 2: {
                    StackMapFrameInfo.UninitializedVerificationTypeInfo u = (StackMapFrameInfo.UninitializedVerificationTypeInfo)selector19784$temp;
                    ret.accept("UNITIALIZED @" + lr.labelToBci(u.newTarget()));
                }
            }
        });
    }

    public static ClassPrinter.MapNode modelToTree(CompoundElement<?> model, ClassPrinter.Verbosity verbosity) {
        CompoundElement<?> compoundElement = model;
        Objects.requireNonNull(compoundElement);
        CompoundElement<?> compoundElement2 = compoundElement;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassModel.class, FieldModel.class, MethodModel.class, CodeModel.class}, compoundElement2, n)) {
            case 0 -> {
                ClassModel cm = (ClassModel)compoundElement2;
                yield ClassPrinterImpl.classToTree(cm, verbosity);
            }
            case 1 -> {
                FieldModel fm = (FieldModel)compoundElement2;
                yield ClassPrinterImpl.fieldToTree(fm, verbosity);
            }
            case 2 -> {
                MethodModel mm = (MethodModel)compoundElement2;
                yield ClassPrinterImpl.methodToTree(mm, verbosity);
            }
            case 3 -> {
                CodeModel com = (CodeModel)compoundElement2;
                yield ClassPrinterImpl.codeToTree((CodeAttribute)com, verbosity);
            }
            default -> throw new AssertionError();
        };
    }

    private static ClassPrinter.MapNode classToTree(ClassModel clm, ClassPrinter.Verbosity verbosity) {
        return new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"class")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"class name"), (ConstantDesc)((Object)clm.thisClass().asInternalName())), ClassPrinterImpl.leaf((ConstantDesc)((Object)"version"), (ConstantDesc)((Object)(clm.majorVersion() + "." + clm.minorVersion()))), ClassPrinterImpl.list((ConstantDesc)((Object)"flags"), (ConstantDesc)((Object)"flag"), clm.flags().flags().stream().map(Enum::name)), ClassPrinterImpl.leaf((ConstantDesc)((Object)"superclass"), (ConstantDesc)((Object)clm.superclass().map(ClassEntry::asInternalName).orElse(""))), ClassPrinterImpl.list((ConstantDesc)((Object)"interfaces"), (ConstantDesc)((Object)"interface"), clm.interfaces().stream().map(ClassEntry::asInternalName)), ClassPrinterImpl.list((ConstantDesc)((Object)"attributes"), (ConstantDesc)((Object)"attribute"), clm.attributes().stream().map(Attribute::attributeName))).with(ClassPrinterImpl.constantPoolToTree(clm.constantPool(), verbosity)).with(ClassPrinterImpl.attributesToTree(clm.attributes(), verbosity)).with(new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"fields"), clm.fields().stream().map(f -> ClassPrinterImpl.fieldToTree(f, verbosity)))).with(new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"methods"), clm.methods().stream().map(mm -> ClassPrinterImpl.methodToTree(mm, verbosity))));
    }

    private static ClassPrinter.Node[] constantPoolToTree(ConstantPool cp, ClassPrinter.Verbosity verbosity) {
        if (verbosity == ClassPrinter.Verbosity.TRACE_ALL) {
            PoolEntry e;
            MapNodeImpl cpNode = new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"constant pool"));
            for (int i = 1; i < cp.entryCount(); i += e.width()) {
                ClassPrinter.Node[] nodeArray;
                PoolEntry poolEntry;
                e = cp.entryByIndex(i);
                ClassPrinter.Node[] nodeArray2 = new ClassPrinter.Node[1];
                MapNodeImpl mapNodeImpl = new MapNodeImpl(Style.FLOW, Integer.valueOf(i));
                ClassPrinter.Node[] nodeArray3 = new ClassPrinter.Node[1];
                nodeArray3[0] = ClassPrinterImpl.leaf((ConstantDesc)((Object)"tag"), (ConstantDesc)((Object)(switch (e.tag()) {
                    case 1 -> "Utf8";
                    case 3 -> "Integer";
                    case 4 -> "Float";
                    case 5 -> "Long";
                    case 6 -> "Double";
                    case 7 -> "Class";
                    case 8 -> "String";
                    case 9 -> "Fieldref";
                    case 10 -> "Methodref";
                    case 11 -> "InterfaceMethodref";
                    case 12 -> "NameAndType";
                    case 15 -> "MethodHandle";
                    case 16 -> "MethodType";
                    case 17 -> "Dynamic";
                    case 18 -> "InvokeDynamic";
                    case 19 -> "Module";
                    case 20 -> "Package";
                    default -> throw new AssertionError((Object)("Unknown CP tag: " + e.tag()));
                })));
                MapNodeImpl mapNodeImpl2 = mapNodeImpl.with(nodeArray3);
                Objects.requireNonNull(e);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassEntry.class, ModuleEntry.class, PackageEntry.class, StringEntry.class, MemberRefEntry.class, NameAndTypeEntry.class, MethodHandleEntry.class, MethodTypeEntry.class, DynamicConstantPoolEntry.class, AnnotationConstantValueEntry.class}, (Object)poolEntry, n)) {
                    case 0: {
                        ClassEntry ce = (ClassEntry)poolEntry;
                        nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"class name index", Integer.valueOf(ce.name().index()), "class internal name", ce.asInternalName()});
                        break;
                    }
                    case 1: {
                        ModuleEntry me = (ModuleEntry)poolEntry;
                        nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"module name index", Integer.valueOf(me.name().index()), "module name", me.name().stringValue()});
                        break;
                    }
                    case 2: {
                        PackageEntry pe = (PackageEntry)poolEntry;
                        nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"package name index", Integer.valueOf(pe.name().index()), "package name", pe.name().stringValue()});
                        break;
                    }
                    case 3: {
                        StringEntry se = (StringEntry)poolEntry;
                        nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"value index", Integer.valueOf(se.utf8().index()), "value", se.stringValue()});
                        break;
                    }
                    case 4: {
                        MemberRefEntry mre = (MemberRefEntry)poolEntry;
                        nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"owner index", Integer.valueOf(mre.owner().index()), "name and type index", Integer.valueOf(mre.nameAndType().index()), "owner", mre.owner().name().stringValue(), "name", mre.name().stringValue(), "type", mre.type().stringValue()});
                        break;
                    }
                    case 5: {
                        NameAndTypeEntry nte = (NameAndTypeEntry)poolEntry;
                        nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"name index", Integer.valueOf(nte.name().index()), "type index", Integer.valueOf(nte.type().index()), "name", nte.name().stringValue(), "type", nte.type().stringValue()});
                        break;
                    }
                    case 6: {
                        MethodHandleEntry mhe = (MethodHandleEntry)poolEntry;
                        nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"reference kind", DirectMethodHandleDesc.Kind.valueOf(mhe.kind()).name(), "reference index", Integer.valueOf(mhe.reference().index()), "owner", mhe.reference().owner().asInternalName(), "name", mhe.reference().name().stringValue(), "type", mhe.reference().type().stringValue()});
                        break;
                    }
                    case 7: {
                        MethodTypeEntry mte = (MethodTypeEntry)poolEntry;
                        nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"descriptor index", Integer.valueOf(mte.descriptor().index()), "descriptor", mte.descriptor().stringValue()});
                        break;
                    }
                    case 8: {
                        DynamicConstantPoolEntry dcpe = (DynamicConstantPoolEntry)poolEntry;
                        ClassPrinter.Node[] nodeArray4 = new ClassPrinter.Node[5];
                        nodeArray4[0] = ClassPrinterImpl.leaf((ConstantDesc)((Object)"bootstrap method handle index"), Integer.valueOf(dcpe.bootstrap().bootstrapMethod().index()));
                        nodeArray4[1] = ClassPrinterImpl.list((ConstantDesc)((Object)"bootstrap method arguments indexes"), (ConstantDesc)((Object)"index"), dcpe.bootstrap().arguments().stream().map(en -> Integer.valueOf(en.index())));
                        nodeArray4[2] = ClassPrinterImpl.leaf((ConstantDesc)((Object)"name and type index"), Integer.valueOf(dcpe.nameAndType().index()));
                        nodeArray4[3] = ClassPrinterImpl.leaf((ConstantDesc)((Object)"name"), (ConstantDesc)((Object)dcpe.name().stringValue()));
                        nodeArray = nodeArray4;
                        nodeArray4[4] = ClassPrinterImpl.leaf((ConstantDesc)((Object)"type"), (ConstantDesc)((Object)dcpe.type().stringValue()));
                        break;
                    }
                    case 9: {
                        AnnotationConstantValueEntry ve = (AnnotationConstantValueEntry)poolEntry;
                        nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"value", String.valueOf(ve.constantValue())});
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                nodeArray2[0] = mapNodeImpl2.with(nodeArray);
                cpNode.with(nodeArray2);
            }
            return new ClassPrinter.Node[]{cpNode};
        }
        return new ClassPrinter.Node[0];
    }

    private static ClassPrinter.Node frameToTree(ConstantDesc name, CodeAttribute lr, StackMapFrameInfo f) {
        return new MapNodeImpl(Style.FLOW, name).with(ClassPrinterImpl.list((ConstantDesc)((Object)"locals"), (ConstantDesc)((Object)"item"), ClassPrinterImpl.convertVTIs(lr, f.locals())), ClassPrinterImpl.list((ConstantDesc)((Object)"stack"), (ConstantDesc)((Object)"item"), ClassPrinterImpl.convertVTIs(lr, f.stack())));
    }

    private static ClassPrinter.MapNode fieldToTree(FieldModel f, ClassPrinter.Verbosity verbosity) {
        return new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"field")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"field name"), (ConstantDesc)((Object)f.fieldName().stringValue())), ClassPrinterImpl.list((ConstantDesc)((Object)"flags"), (ConstantDesc)((Object)"flag"), f.flags().flags().stream().map(Enum::name)), ClassPrinterImpl.leaf((ConstantDesc)((Object)"field type"), (ConstantDesc)((Object)f.fieldType().stringValue())), ClassPrinterImpl.list((ConstantDesc)((Object)"attributes"), (ConstantDesc)((Object)"attribute"), f.attributes().stream().map(Attribute::attributeName))).with(ClassPrinterImpl.attributesToTree(f.attributes(), verbosity));
    }

    public static ClassPrinter.MapNode methodToTree(MethodModel m, ClassPrinter.Verbosity verbosity) {
        return new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"method")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"method name"), (ConstantDesc)((Object)m.methodName().stringValue())), ClassPrinterImpl.list((ConstantDesc)((Object)"flags"), (ConstantDesc)((Object)"flag"), m.flags().flags().stream().map(Enum::name)), ClassPrinterImpl.leaf((ConstantDesc)((Object)"method type"), (ConstantDesc)((Object)m.methodType().stringValue())), ClassPrinterImpl.list((ConstantDesc)((Object)"attributes"), (ConstantDesc)((Object)"attribute"), m.attributes().stream().map(Attribute::attributeName))).with(ClassPrinterImpl.attributesToTree(m.attributes(), verbosity)).with(ClassPrinterImpl.codeToTree(m.code().orElse(null), verbosity));
    }

    private static ClassPrinter.MapNode codeToTree(CodeAttribute com, ClassPrinter.Verbosity verbosity) {
        if (verbosity != ClassPrinter.Verbosity.MEMBERS_ONLY && com != null) {
            MapNodeImpl codeNode = new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"code"));
            codeNode.with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"max stack"), Integer.valueOf(com.maxStack())));
            codeNode.with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"max locals"), Integer.valueOf(com.maxLocals())));
            codeNode.with(ClassPrinterImpl.list((ConstantDesc)((Object)"attributes"), (ConstantDesc)((Object)"attribute"), com.attributes().stream().map(Attribute::attributeName)));
            MapNodeImpl stackMap = new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"stack map frames"));
            LinkedHashMap visibleTypeAnnos = new LinkedHashMap();
            LinkedHashMap invisibleTypeAnnos = new LinkedHashMap();
            List<Object> locals = List.of();
            block25: for (Attribute<?> attr : com.attributes()) {
                if (attr instanceof StackMapTableAttribute) {
                    StackMapTableAttribute smta = (StackMapTableAttribute)attr;
                    codeNode.with(stackMap);
                    for (StackMapFrameInfo smf : smta.entries()) {
                        stackMap.with(ClassPrinterImpl.frameToTree(Integer.valueOf(com.labelToBci(smf.target())), com, smf));
                    }
                    continue;
                }
                if (verbosity != ClassPrinter.Verbosity.TRACE_ALL || attr == null) continue;
                Attribute<?> attribute = attr;
                int smf = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocalVariableTableAttribute.class, LocalVariableTypeTableAttribute.class, LineNumberTableAttribute.class, CharacterRangeTableAttribute.class, RuntimeVisibleTypeAnnotationsAttribute.class, RuntimeInvisibleTypeAnnotationsAttribute.class, Attribute.class}, attribute, smf)) {
                    case 0: {
                        LocalVariableTableAttribute lvta = (LocalVariableTableAttribute)attribute;
                        locals = lvta.localVariables();
                        codeNode.with(new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"local variables"), IntStream.range(0, locals.size()).mapToObj(i -> {
                            LocalVariableInfo lv = lvta.localVariables().get(i);
                            return ClassPrinterImpl.map(Integer.valueOf(i + 1), new ConstantDesc[]{"start", Integer.valueOf(lv.startPc()), "end", Integer.valueOf(lv.startPc() + lv.length()), "slot", Integer.valueOf(lv.slot()), "name", lv.name().stringValue(), "type", lv.type().stringValue()});
                        })));
                        continue block25;
                    }
                    case 1: {
                        LocalVariableTypeTableAttribute lvtta = (LocalVariableTypeTableAttribute)attribute;
                        codeNode.with(new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"local variable types"), IntStream.range(0, lvtta.localVariableTypes().size()).mapToObj(i -> {
                            LocalVariableTypeInfo lvt = lvtta.localVariableTypes().get(i);
                            return ClassPrinterImpl.map(Integer.valueOf(i + 1), new ConstantDesc[]{"start", Integer.valueOf(lvt.startPc()), "end", Integer.valueOf(lvt.startPc() + lvt.length()), "slot", Integer.valueOf(lvt.slot()), "name", lvt.name().stringValue(), "signature", lvt.signature().stringValue()});
                        })));
                        continue block25;
                    }
                    case 2: {
                        LineNumberTableAttribute lnta = (LineNumberTableAttribute)attribute;
                        codeNode.with(new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"line numbers"), IntStream.range(0, lnta.lineNumbers().size()).mapToObj(i -> {
                            LineNumberInfo ln = lnta.lineNumbers().get(i);
                            return ClassPrinterImpl.map(Integer.valueOf(i + 1), new ConstantDesc[]{"start", Integer.valueOf(ln.startPc()), "line number", Integer.valueOf(ln.lineNumber())});
                        })));
                        continue block25;
                    }
                    case 3: {
                        CharacterRangeTableAttribute crta = (CharacterRangeTableAttribute)attribute;
                        codeNode.with(new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"character ranges"), IntStream.range(0, crta.characterRangeTable().size()).mapToObj(i -> {
                            CharacterRangeInfo cr = crta.characterRangeTable().get(i);
                            return ClassPrinterImpl.map(Integer.valueOf(i + 1), new ConstantDesc[]{"start", Integer.valueOf(cr.startPc()), "end", Integer.valueOf(cr.endPc()), "range start", Integer.valueOf(cr.characterRangeStart()), "range end", Integer.valueOf(cr.characterRangeEnd()), "flags", Integer.valueOf(cr.flags())});
                        })));
                        continue block25;
                    }
                    case 4: {
                        RuntimeVisibleTypeAnnotationsAttribute rvtaa = (RuntimeVisibleTypeAnnotationsAttribute)attribute;
                        rvtaa.annotations().forEach(a -> ClassPrinterImpl.forEachOffset(a, com, (off, an) -> visibleTypeAnnos.computeIfAbsent(off, o -> new LinkedList()).add(an)));
                        continue block25;
                    }
                    case 5: {
                        RuntimeInvisibleTypeAnnotationsAttribute ritaa = (RuntimeInvisibleTypeAnnotationsAttribute)attribute;
                        ritaa.annotations().forEach(a -> ClassPrinterImpl.forEachOffset(a, com, (off, an) -> invisibleTypeAnnos.computeIfAbsent(off, o -> new LinkedList()).add(an)));
                        continue block25;
                    }
                }
                Attribute<?> attribute2 = attribute;
            }
            codeNode.with(ClassPrinterImpl.attributesToTree(com.attributes(), verbosity));
            if (!stackMap.containsKey(0)) {
                codeNode.with(new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"//stack map frame @0")).with(ClassPrinterImpl.list((ConstantDesc)((Object)"locals"), (ConstantDesc)((Object)"item"), ClassPrinterImpl.convertVTIs(com, StackMapDecoder.initFrameLocals(com.parent().get()))), ClassPrinterImpl.list((ConstantDesc)((Object)"stack"), (ConstantDesc)((Object)"item"), Stream.of(new ConstantDesc[0]))));
            }
            List<ExceptionHandler> excHandlers = com.exceptionHandlers().stream().map(exc -> new ExceptionHandler(com.labelToBci(exc.tryStart()), com.labelToBci(exc.tryEnd()), com.labelToBci(exc.handler()), exc.catchType().map(ct -> ct.name().stringValue()).orElse(null))).toList();
            int bci = 0;
            for (CodeElement coe : com) {
                CodeElement codeElement;
                List annos;
                if (!(coe instanceof Instruction)) continue;
                Instruction ins = (Instruction)coe;
                ClassPrinter.Node frame = stackMap.get(bci);
                if (frame != null) {
                    codeNode.with(new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)("//stack map frame @" + bci))).with(((MapNodeImpl)frame).values().toArray(new ClassPrinter.Node[2])));
                }
                if ((annos = (List)invisibleTypeAnnos.get(bci)) != null) {
                    codeNode.with(ClassPrinterImpl.typeAnnotationsToTree(Style.FLOW, "//invisible type annotations @" + bci, annos));
                }
                if ((annos = (List)visibleTypeAnnos.get(bci)) != null) {
                    codeNode.with(ClassPrinterImpl.typeAnnotationsToTree(Style.FLOW, "//visible type annotations @" + bci, annos));
                }
                for (int i2 = 0; i2 < excHandlers.size(); ++i2) {
                    ExceptionHandler exc2 = excHandlers.get(i2);
                    if (exc2.start() == bci) {
                        codeNode.with(ClassPrinterImpl.map((ConstantDesc)((Object)("//try block " + (i2 + 1) + " start")), new ConstantDesc[]{"start", Integer.valueOf(exc2.start()), "end", Integer.valueOf(exc2.end()), "handler", Integer.valueOf(exc2.handler()), "catch type", exc2.catchType()}));
                    }
                    if (exc2.end() == bci) {
                        codeNode.with(ClassPrinterImpl.map((ConstantDesc)((Object)("//try block " + (i2 + 1) + " end")), new ConstantDesc[]{"start", Integer.valueOf(exc2.start()), "end", Integer.valueOf(exc2.end()), "handler", Integer.valueOf(exc2.handler()), "catch type", exc2.catchType()}));
                    }
                    if (exc2.handler() != bci) continue;
                    codeNode.with(ClassPrinterImpl.map((ConstantDesc)((Object)("//exception handler " + (i2 + 1) + " start")), new ConstantDesc[]{"start", Integer.valueOf(exc2.start()), "end", Integer.valueOf(exc2.end()), "handler", Integer.valueOf(exc2.handler()), "catch type", exc2.catchType()}));
                }
                MapNodeImpl in = new MapNodeImpl(Style.FLOW, Integer.valueOf(bci)).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"opcode"), (ConstantDesc)((Object)ins.opcode().name())));
                codeNode.with(in);
                Objects.requireNonNull(coe);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IncrementInstruction.class, LoadInstruction.class, StoreInstruction.class, FieldInstruction.class, InvokeInstruction.class, InvokeDynamicInstruction.class, NewObjectInstruction.class, NewPrimitiveArrayInstruction.class, NewReferenceArrayInstruction.class, NewMultiArrayInstruction.class, TypeCheckInstruction.class, ConstantInstruction.class, BranchInstruction.class, LookupSwitchInstruction.class, TableSwitchInstruction.class}, (Object)codeElement, n)) {
                    case 0: {
                        IncrementInstruction inc = (IncrementInstruction)codeElement;
                        in.with(ClassPrinterImpl.leafs(new ConstantDesc[]{"slot", Integer.valueOf(inc.slot()), "const", Integer.valueOf(inc.constant())})).with(ClassPrinterImpl.localInfoToTree(locals, inc.slot(), bci));
                        break;
                    }
                    case 1: {
                        LoadInstruction lv = (LoadInstruction)codeElement;
                        in.with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"slot"), Integer.valueOf(lv.slot()))).with(ClassPrinterImpl.localInfoToTree(locals, lv.slot(), bci));
                        break;
                    }
                    case 2: {
                        StoreInstruction lv = (StoreInstruction)codeElement;
                        in.with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"slot"), Integer.valueOf(lv.slot()))).with(ClassPrinterImpl.localInfoToTree(locals, lv.slot(), bci));
                        break;
                    }
                    case 3: {
                        FieldInstruction fa = (FieldInstruction)codeElement;
                        in.with(ClassPrinterImpl.leafs(new ConstantDesc[]{"owner", fa.owner().name().stringValue(), "field name", fa.name().stringValue(), "field type", fa.type().stringValue()}));
                        break;
                    }
                    case 4: {
                        InvokeInstruction inv = (InvokeInstruction)codeElement;
                        in.with(ClassPrinterImpl.leafs(new ConstantDesc[]{"owner", inv.owner().name().stringValue(), "method name", inv.name().stringValue(), "method type", inv.type().stringValue()}));
                        break;
                    }
                    case 5: {
                        InvokeDynamicInstruction invd = (InvokeDynamicInstruction)codeElement;
                        in.with(ClassPrinterImpl.leafs(new ConstantDesc[]{"name", invd.name().stringValue(), "descriptor", invd.type().stringValue(), "kind", invd.bootstrapMethod().kind().name(), "owner", invd.bootstrapMethod().owner().descriptorString(), "method name", invd.bootstrapMethod().methodName(), "invocation type", invd.bootstrapMethod().invocationType().descriptorString()}));
                        break;
                    }
                    case 6: {
                        NewObjectInstruction newo = (NewObjectInstruction)codeElement;
                        in.with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"type"), (ConstantDesc)((Object)newo.className().name().stringValue())));
                        break;
                    }
                    case 7: {
                        NewPrimitiveArrayInstruction newa = (NewPrimitiveArrayInstruction)codeElement;
                        in.with(ClassPrinterImpl.leafs(new ConstantDesc[]{"dimensions", Integer.valueOf(1), "descriptor", newa.typeKind().typeName()}));
                        break;
                    }
                    case 8: {
                        NewReferenceArrayInstruction newa = (NewReferenceArrayInstruction)codeElement;
                        in.with(ClassPrinterImpl.leafs(new ConstantDesc[]{"dimensions", Integer.valueOf(1), "descriptor", newa.componentType().name().stringValue()}));
                        break;
                    }
                    case 9: {
                        NewMultiArrayInstruction newa = (NewMultiArrayInstruction)codeElement;
                        in.with(ClassPrinterImpl.leafs(new ConstantDesc[]{"dimensions", Integer.valueOf(newa.dimensions()), "descriptor", newa.arrayType().name().stringValue()}));
                        break;
                    }
                    case 10: {
                        TypeCheckInstruction tch = (TypeCheckInstruction)codeElement;
                        in.with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"type"), (ConstantDesc)((Object)tch.type().name().stringValue())));
                        break;
                    }
                    case 11: {
                        ConstantInstruction cons = (ConstantInstruction)codeElement;
                        in.with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"constant value"), cons.constantValue()));
                        break;
                    }
                    case 12: {
                        BranchInstruction br = (BranchInstruction)codeElement;
                        in.with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"target"), Integer.valueOf(com.labelToBci(br.target()))));
                        break;
                    }
                    case 13: {
                        LookupSwitchInstruction si = (LookupSwitchInstruction)codeElement;
                        ClassPrinter.Node[] nodeArray = new ClassPrinter.Node[1];
                        nodeArray[0] = ClassPrinterImpl.list((ConstantDesc)((Object)"targets"), (ConstantDesc)((Object)"target"), Stream.concat(Stream.of(si.defaultTarget()).map(com::labelToBci), si.cases().stream().map(sc -> com.labelToBci(sc.target()))));
                        in.with(nodeArray);
                        break;
                    }
                    case 14: {
                        TableSwitchInstruction si = (TableSwitchInstruction)codeElement;
                        ClassPrinter.Node[] nodeArray = new ClassPrinter.Node[1];
                        nodeArray[0] = ClassPrinterImpl.list((ConstantDesc)((Object)"targets"), (ConstantDesc)((Object)"target"), Stream.concat(Stream.of(si.defaultTarget()).map(com::labelToBci), si.cases().stream().map(sc -> com.labelToBci(sc.target()))));
                        in.with(nodeArray);
                        break;
                    }
                }
                bci += ins.sizeInBytes();
            }
            if (!excHandlers.isEmpty()) {
                MapNodeImpl handlersNode = new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"exception handlers"));
                codeNode.with(handlersNode);
                for (int i3 = 0; i3 < excHandlers.size(); ++i3) {
                    ExceptionHandler exc3 = excHandlers.get(i3);
                    handlersNode.with(ClassPrinterImpl.map((ConstantDesc)((Object)("handler " + (i3 + 1))), new ConstantDesc[]{"start", Integer.valueOf(exc3.start()), "end", Integer.valueOf(exc3.end()), "handler", Integer.valueOf(exc3.handler()), "type", exc3.catchType()}));
                }
            }
            return codeNode;
        }
        return null;
    }

    private static ClassPrinter.Node[] attributesToTree(List<Attribute<?>> attributes, ClassPrinter.Verbosity verbosity) {
        LinkedList<ClassPrinter.Node> nodes = new LinkedList<ClassPrinter.Node>();
        if (verbosity != ClassPrinter.Verbosity.MEMBERS_ONLY) {
            block26: for (Attribute<?> attr : attributes) {
                Attribute<?> attribute;
                Attribute<?> attribute2;
                Objects.requireNonNull(attr);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BootstrapMethodsAttribute.class, ConstantValueAttribute.class, NestHostAttribute.class, NestMembersAttribute.class, PermittedSubclassesAttribute.class}, attribute2, n)) {
                    case 0: {
                        BootstrapMethodsAttribute bma = (BootstrapMethodsAttribute)attribute2;
                        nodes.add(new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"bootstrap methods"), bma.bootstrapMethods().stream().map(bm -> {
                            MethodHandleEntry mh = bm.bootstrapMethod();
                            MemberRefEntry mref = mh.reference();
                            return ClassPrinterImpl.map((ConstantDesc)((Object)"bm"), new ConstantDesc[]{"kind", DirectMethodHandleDesc.Kind.valueOf(mh.kind(), mref instanceof InterfaceMethodRefEntry).name(), "owner", mref.owner().name().stringValue(), "name", mref.nameAndType().name().stringValue(), "type", mref.nameAndType().type().stringValue()});
                        })));
                        break;
                    }
                    case 1: {
                        ConstantValueAttribute cva = (ConstantValueAttribute)attribute2;
                        nodes.add(ClassPrinterImpl.leaf((ConstantDesc)((Object)"constant value"), cva.constant().constantValue()));
                        break;
                    }
                    case 2: {
                        NestHostAttribute nha = (NestHostAttribute)attribute2;
                        nodes.add(ClassPrinterImpl.leaf((ConstantDesc)((Object)"nest host"), (ConstantDesc)((Object)nha.nestHost().name().stringValue())));
                        break;
                    }
                    case 3: {
                        NestMembersAttribute nma = (NestMembersAttribute)attribute2;
                        nodes.add(ClassPrinterImpl.list((ConstantDesc)((Object)"nest members"), (ConstantDesc)((Object)"member"), nma.nestMembers().stream().map(mp -> mp.name().stringValue())));
                        break;
                    }
                    case 4: {
                        PermittedSubclassesAttribute psa = (PermittedSubclassesAttribute)attribute2;
                        nodes.add(ClassPrinterImpl.list((ConstantDesc)((Object)"permitted subclasses"), (ConstantDesc)((Object)"subclass"), psa.permittedSubclasses().stream().map(e -> e.name().stringValue())));
                        break;
                    }
                }
                if (verbosity != ClassPrinter.Verbosity.TRACE_ALL) continue;
                Objects.requireNonNull(attr);
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnclosingMethodAttribute.class, ExceptionsAttribute.class, InnerClassesAttribute.class, MethodParametersAttribute.class, ModuleAttribute.class, ModulePackagesAttribute.class, ModuleMainClassAttribute.class, RecordAttribute.class, AnnotationDefaultAttribute.class, RuntimeInvisibleAnnotationsAttribute.class, RuntimeVisibleAnnotationsAttribute.class, RuntimeInvisibleParameterAnnotationsAttribute.class, RuntimeVisibleParameterAnnotationsAttribute.class, RuntimeInvisibleTypeAnnotationsAttribute.class, RuntimeVisibleTypeAnnotationsAttribute.class, SignatureAttribute.class, SourceFileAttribute.class}, attribute, n2)) {
                    case 0: {
                        EnclosingMethodAttribute ema = (EnclosingMethodAttribute)attribute;
                        nodes.add(ClassPrinterImpl.map((ConstantDesc)((Object)"enclosing method"), new ConstantDesc[]{"class", ema.enclosingClass().name().stringValue(), "method name", (ConstantDesc)((Object)ema.enclosingMethodName().map(Utf8Entry::stringValue).orElse("null")), "method type", (ConstantDesc)((Object)ema.enclosingMethodType().map(Utf8Entry::stringValue).orElse("null"))}));
                        break;
                    }
                    case 1: {
                        ExceptionsAttribute exa = (ExceptionsAttribute)attribute;
                        nodes.add(ClassPrinterImpl.list((ConstantDesc)((Object)"excceptions"), (ConstantDesc)((Object)"exc"), exa.exceptions().stream().map(e -> e.name().stringValue())));
                        break;
                    }
                    case 2: {
                        InnerClassesAttribute ica = (InnerClassesAttribute)attribute;
                        nodes.add(new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"inner classes"), ica.classes().stream().map(ic -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"cls")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"inner class"), (ConstantDesc)((Object)ic.innerClass().name().stringValue())), ClassPrinterImpl.leaf((ConstantDesc)((Object)"outer class"), (ConstantDesc)((Object)ic.outerClass().map(cle -> cle.name().stringValue()).orElse("null"))), ClassPrinterImpl.leaf((ConstantDesc)((Object)"inner name"), (ConstantDesc)((Object)ic.innerName().map(Utf8Entry::stringValue).orElse("null"))), ClassPrinterImpl.list((ConstantDesc)((Object)"flags"), (ConstantDesc)((Object)"flag"), ic.flags().stream().map(Enum::name))))));
                        break;
                    }
                    case 3: {
                        MethodParametersAttribute mpa = (MethodParametersAttribute)attribute;
                        MapNodeImpl n3 = new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"method parameters"));
                        for (int i = 0; i < mpa.parameters().size(); ++i) {
                            MethodParameterInfo p = mpa.parameters().get(i);
                            n3.with(new MapNodeImpl(Style.FLOW, Integer.valueOf(i + 1)).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"name"), (ConstantDesc)((Object)p.name().map(Utf8Entry::stringValue).orElse("null"))), ClassPrinterImpl.list((ConstantDesc)((Object)"flags"), (ConstantDesc)((Object)"flag"), p.flags().stream().map(Enum::name))));
                        }
                        continue block26;
                    }
                    case 4: {
                        ModuleAttribute ma = (ModuleAttribute)attribute;
                        nodes.add(new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"module")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"name"), (ConstantDesc)((Object)ma.moduleName().name().stringValue())), ClassPrinterImpl.list((ConstantDesc)((Object)"flags"), (ConstantDesc)((Object)"flag"), ma.moduleFlags().stream().map(Enum::name)), ClassPrinterImpl.leaf((ConstantDesc)((Object)"version"), (ConstantDesc)((Object)ma.moduleVersion().map(Utf8Entry::stringValue).orElse("null"))), ClassPrinterImpl.list((ConstantDesc)((Object)"uses"), (ConstantDesc)((Object)"class"), ma.uses().stream().map(ce -> ce.name().stringValue())), new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"requires"), ma.requires().stream().map(req -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"req")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"name"), (ConstantDesc)((Object)req.requires().name().stringValue())), ClassPrinterImpl.list((ConstantDesc)((Object)"flags"), (ConstantDesc)((Object)"flag"), req.requiresFlags().stream().map(Enum::name)), ClassPrinterImpl.leaf((ConstantDesc)((Object)"version"), req.requiresVersion().map(Utf8Entry::stringValue).orElse(null))))), new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"exports"), ma.exports().stream().map(exp -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"exp")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"package"), (ConstantDesc)((Object)exp.exportedPackage().asSymbol().packageName())), ClassPrinterImpl.list((ConstantDesc)((Object)"flags"), (ConstantDesc)((Object)"flag"), exp.exportsFlags().stream().map(Enum::name)), ClassPrinterImpl.list((ConstantDesc)((Object)"to"), (ConstantDesc)((Object)"module"), exp.exportsTo().stream().map(me -> me.name().stringValue()))))), new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"opens"), ma.opens().stream().map(opn -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"opn")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"package"), (ConstantDesc)((Object)opn.openedPackage().asSymbol().packageName())), ClassPrinterImpl.list((ConstantDesc)((Object)"flags"), (ConstantDesc)((Object)"flag"), opn.opensFlags().stream().map(Enum::name)), ClassPrinterImpl.list((ConstantDesc)((Object)"to"), (ConstantDesc)((Object)"module"), opn.opensTo().stream().map(me -> me.name().stringValue()))))), new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"provides"), ma.provides().stream().map(prov -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"prov")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"class"), (ConstantDesc)((Object)prov.provides().name().stringValue())), ClassPrinterImpl.list((ConstantDesc)((Object)"with"), (ConstantDesc)((Object)"cls"), prov.providesWith().stream().map(ce -> ce.name().stringValue())))))));
                        break;
                    }
                    case 5: {
                        ModulePackagesAttribute mopa = (ModulePackagesAttribute)attribute;
                        nodes.add(ClassPrinterImpl.list((ConstantDesc)((Object)"module packages"), (ConstantDesc)((Object)"subclass"), mopa.packages().stream().map(mp -> mp.asSymbol().packageName())));
                        break;
                    }
                    case 6: {
                        ModuleMainClassAttribute mmca = (ModuleMainClassAttribute)attribute;
                        nodes.add(ClassPrinterImpl.leaf((ConstantDesc)((Object)"module main class"), (ConstantDesc)((Object)mmca.mainClass().name().stringValue())));
                        break;
                    }
                    case 7: {
                        RecordAttribute ra = (RecordAttribute)attribute;
                        nodes.add(new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"record components"), ra.components().stream().map(rc -> new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"record")).with(ClassPrinterImpl.leafs(new ConstantDesc[]{"name", rc.name().stringValue(), "type", rc.descriptor().stringValue()})).with(ClassPrinterImpl.list((ConstantDesc)((Object)"attributes"), (ConstantDesc)((Object)"attribute"), rc.attributes().stream().map(Attribute::attributeName))).with(ClassPrinterImpl.attributesToTree(rc.attributes(), verbosity)))));
                        break;
                    }
                    case 8: {
                        AnnotationDefaultAttribute ada = (AnnotationDefaultAttribute)attribute;
                        nodes.add(new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"annotation default")).with(ClassPrinterImpl.elementValueToTree(ada.defaultValue())));
                        break;
                    }
                    case 9: {
                        RuntimeInvisibleAnnotationsAttribute aa = (RuntimeInvisibleAnnotationsAttribute)attribute;
                        nodes.add(ClassPrinterImpl.annotationsToTree("invisible annotations", aa.annotations()));
                        break;
                    }
                    case 10: {
                        RuntimeVisibleAnnotationsAttribute aa = (RuntimeVisibleAnnotationsAttribute)attribute;
                        nodes.add(ClassPrinterImpl.annotationsToTree("visible annotations", aa.annotations()));
                        break;
                    }
                    case 11: {
                        RuntimeInvisibleParameterAnnotationsAttribute aa = (RuntimeInvisibleParameterAnnotationsAttribute)attribute;
                        nodes.add(ClassPrinterImpl.parameterAnnotationsToTree("invisible parameter annotations", aa.parameterAnnotations()));
                        break;
                    }
                    case 12: {
                        RuntimeVisibleParameterAnnotationsAttribute aa = (RuntimeVisibleParameterAnnotationsAttribute)attribute;
                        nodes.add(ClassPrinterImpl.parameterAnnotationsToTree("visible parameter annotations", aa.parameterAnnotations()));
                        break;
                    }
                    case 13: {
                        RuntimeInvisibleTypeAnnotationsAttribute aa = (RuntimeInvisibleTypeAnnotationsAttribute)attribute;
                        nodes.add(ClassPrinterImpl.typeAnnotationsToTree(Style.BLOCK, "invisible type annotations", aa.annotations()));
                        break;
                    }
                    case 14: {
                        RuntimeVisibleTypeAnnotationsAttribute aa = (RuntimeVisibleTypeAnnotationsAttribute)attribute;
                        nodes.add(ClassPrinterImpl.typeAnnotationsToTree(Style.BLOCK, "visible type annotations", aa.annotations()));
                        break;
                    }
                    case 15: {
                        SignatureAttribute sa = (SignatureAttribute)attribute;
                        nodes.add(ClassPrinterImpl.leaf((ConstantDesc)((Object)"signature"), (ConstantDesc)((Object)sa.signature().stringValue())));
                        break;
                    }
                    case 16: {
                        SourceFileAttribute sfa = (SourceFileAttribute)attribute;
                        nodes.add(ClassPrinterImpl.leaf((ConstantDesc)((Object)"source file"), (ConstantDesc)((Object)sfa.sourceFile().stringValue())));
                        break;
                    }
                }
            }
        }
        return (ClassPrinter.Node[])nodes.toArray(ClassPrinter.Node[]::new);
    }

    private static ClassPrinter.Node annotationsToTree(String name, List<Annotation> annos) {
        return new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)name), annos.stream().map(a -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"anno")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"annotation class"), (ConstantDesc)((Object)a.className().stringValue()))).with(ClassPrinterImpl.elementValuePairsToTree(a.elements()))));
    }

    private static ClassPrinter.Node typeAnnotationsToTree(Style style, String name, List<TypeAnnotation> annos) {
        return new ListNodeImpl(style, (ConstantDesc)((Object)name), annos.stream().map(a -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"anno")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"annotation class"), (ConstantDesc)((Object)a.className().stringValue())), ClassPrinterImpl.leaf((ConstantDesc)((Object)"target info"), (ConstantDesc)((Object)a.targetInfo().targetType().name()))).with(ClassPrinterImpl.elementValuePairsToTree(a.elements()))));
    }

    private static MapNodeImpl parameterAnnotationsToTree(String name, List<List<Annotation>> paramAnnotations) {
        MapNodeImpl node = new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)name));
        for (int i = 0; i < paramAnnotations.size(); ++i) {
            List<Annotation> annos = paramAnnotations.get(i);
            if (annos.isEmpty()) continue;
            node.with(new ListNodeImpl(Style.FLOW, (ConstantDesc)((Object)("parameter " + (i + 1))), annos.stream().map(a -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"anno")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"annotation class"), (ConstantDesc)((Object)a.className().stringValue()))).with(ClassPrinterImpl.elementValuePairsToTree(a.elements())))));
        }
        return node;
    }

    private static ClassPrinter.Node[] localInfoToTree(List<LocalVariableInfo> locals, int slot, int bci) {
        if (locals != null) {
            for (LocalVariableInfo l : locals) {
                if (l.slot() != slot || l.startPc() > bci || l.length() + l.startPc() < bci) continue;
                return ClassPrinterImpl.leafs(new ConstantDesc[]{"type", l.type().stringValue(), "variable name", l.name().stringValue()});
            }
        }
        return new ClassPrinter.Node[0];
    }

    private static void forEachOffset(TypeAnnotation ta, CodeAttribute lr, BiConsumer<Integer, TypeAnnotation> consumer) {
        TypeAnnotation.TargetInfo targetInfo = ta.targetInfo();
        Objects.requireNonNull(targetInfo);
        TypeAnnotation.TargetInfo targetInfo2 = targetInfo;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TypeAnnotation.OffsetTarget.class, TypeAnnotation.TypeArgumentTarget.class, TypeAnnotation.LocalVarTarget.class}, (Object)targetInfo2, n)) {
            case 0: {
                TypeAnnotation.OffsetTarget ot = (TypeAnnotation.OffsetTarget)targetInfo2;
                consumer.accept(lr.labelToBci(ot.target()), ta);
                break;
            }
            case 1: {
                TypeAnnotation.TypeArgumentTarget tat = (TypeAnnotation.TypeArgumentTarget)targetInfo2;
                consumer.accept(lr.labelToBci(tat.target()), ta);
                break;
            }
            case 2: {
                TypeAnnotation.LocalVarTarget lvt = (TypeAnnotation.LocalVarTarget)targetInfo2;
                lvt.table().forEach(lvti -> consumer.accept(lr.labelToBci(lvti.startLabel()), ta));
                break;
            }
        }
    }

    public record LeafNodeImpl(ConstantDesc name, ConstantDesc value) implements ClassPrinter.LeafNode
    {
        @Override
        public Stream<ClassPrinter.Node> walk() {
            return Stream.of(this);
        }
    }

    public static final class ListNodeImpl
    extends AbstractList<ClassPrinter.Node>
    implements ClassPrinter.ListNode {
        private final Style style;
        private final ConstantDesc name;
        private final ClassPrinter.Node[] nodes;

        public ListNodeImpl(Style style, ConstantDesc name, Stream<ClassPrinter.Node> nodes) {
            this.style = style;
            this.name = name;
            this.nodes = (ClassPrinter.Node[])nodes.toArray(ClassPrinter.Node[]::new);
        }

        @Override
        public ConstantDesc name() {
            return this.name;
        }

        @Override
        public Stream<ClassPrinter.Node> walk() {
            return Stream.concat(Stream.of(this), this.stream().flatMap(ClassPrinter.Node::walk));
        }

        public Style style() {
            return this.style;
        }

        @Override
        public ClassPrinter.Node get(int index) {
            Objects.checkIndex(index, this.nodes.length);
            return this.nodes[index];
        }

        @Override
        public int size() {
            return this.nodes.length;
        }
    }

    public static enum Style {
        BLOCK,
        FLOW;

    }

    public static final class MapNodeImpl
    implements ClassPrinter.MapNode {
        private final Style style;
        private final ConstantDesc name;
        private final Map<ConstantDesc, ClassPrinter.Node> map;

        public MapNodeImpl(Style style, ConstantDesc name) {
            this.style = style;
            this.name = name;
            this.map = new LinkedHashMap<ConstantDesc, ClassPrinter.Node>();
        }

        @Override
        public ConstantDesc name() {
            return this.name;
        }

        @Override
        public Stream<ClassPrinter.Node> walk() {
            return Stream.concat(Stream.of(this), this.values().stream().flatMap(ClassPrinter.Node::walk));
        }

        public Style style() {
            return this.style;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public ClassPrinter.Node get(Object key) {
            return this.map.get(key);
        }

        @Override
        public ClassPrinter.Node put(ConstantDesc key, ClassPrinter.Node value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ClassPrinter.Node remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends ConstantDesc, ? extends ClassPrinter.Node> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<ConstantDesc> keySet() {
            return Collections.unmodifiableSet(this.map.keySet());
        }

        @Override
        public Collection<ClassPrinter.Node> values() {
            return Collections.unmodifiableCollection(this.map.values());
        }

        @Override
        public Set<Map.Entry<ConstantDesc, ClassPrinter.Node>> entrySet() {
            return Collections.unmodifiableSet(this.map.entrySet());
        }

        MapNodeImpl with(ClassPrinter.Node ... nodes) {
            for (ClassPrinter.Node n : nodes) {
                if (n != null && this.map.put(n.name(), n) != null) {
                    throw new AssertionError((Object)("Double entry of " + n.name() + " into " + this.name));
                }
            }
            return this;
        }
    }

    private record ExceptionHandler(int start, int end, int handler, String catchType) {
    }
}

