/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.function.Consumer;
import org.glavo.classfile.Attribute;
import org.glavo.classfile.BufWriter;
import org.glavo.classfile.CodeBuilder;
import org.glavo.classfile.CodeModel;
import org.glavo.classfile.CodeTransform;
import org.glavo.classfile.MethodBuilder;
import org.glavo.classfile.MethodElement;
import org.glavo.classfile.MethodModel;
import org.glavo.classfile.WritableElement;
import org.glavo.classfile.attribute.CodeAttribute;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AbstractDirectBuilder;
import org.glavo.classfile.impl.AbstractElement;
import org.glavo.classfile.impl.BufWriterImpl;
import org.glavo.classfile.impl.BufferedCodeBuilder;
import org.glavo.classfile.impl.DirectCodeBuilder;
import org.glavo.classfile.impl.MethodInfo;
import org.glavo.classfile.impl.SplitConstantPool;
import org.glavo.classfile.impl.TerminalMethodBuilder;
import org.glavo.classfile.impl.Util;

public final class DirectMethodBuilder
extends AbstractDirectBuilder<MethodModel>
implements TerminalMethodBuilder,
WritableElement<MethodModel>,
MethodInfo {
    final Utf8Entry name;
    final Utf8Entry desc;
    int flags;
    int[] parameterSlots;

    public DirectMethodBuilder(SplitConstantPool constantPool, Utf8Entry nameInfo, Utf8Entry typeInfo, int flags, MethodModel original) {
        super(constantPool);
        this.setOriginal(original);
        this.name = nameInfo;
        this.desc = typeInfo;
        this.flags = flags;
    }

    void setFlags(int flags) {
        boolean isStatic;
        boolean wasStatic = (this.flags & 8) != 0;
        boolean bl = isStatic = (flags & 8) != 0;
        if (wasStatic != isStatic) {
            throw new IllegalArgumentException("Cannot change ACC_STATIC flag of method");
        }
        this.flags = flags;
    }

    @Override
    public Utf8Entry methodName() {
        return this.name;
    }

    @Override
    public Utf8Entry methodType() {
        return this.desc;
    }

    @Override
    public int methodFlags() {
        return this.flags;
    }

    @Override
    public int parameterSlot(int paramNo) {
        if (this.parameterSlots == null) {
            this.parameterSlots = Util.parseParameterSlots(this.methodFlags(), this.methodType().stringValue());
        }
        return this.parameterSlots[paramNo];
    }

    @Override
    public BufferedCodeBuilder bufferedCodeBuilder(CodeModel original) {
        return new BufferedCodeBuilder(this, this.constantPool, original);
    }

    @Override
    public MethodBuilder with(MethodElement element) {
        ((AbstractElement)((Object)element)).writeTo(this);
        return this;
    }

    private MethodBuilder withCode(CodeModel original, Consumer<? super CodeBuilder> handler) {
        Attribute<CodeAttribute> cb = DirectCodeBuilder.build(this, handler, this.constantPool, original);
        this.writeAttribute(cb);
        return this;
    }

    @Override
    public MethodBuilder withCode(Consumer<? super CodeBuilder> handler) {
        return this.withCode(null, handler);
    }

    @Override
    public MethodBuilder transformCode(final CodeModel code, final CodeTransform transform) {
        return this.withCode(code, (Consumer<? super CodeBuilder>)new Consumer<CodeBuilder>(){

            @Override
            public void accept(CodeBuilder builder) {
                builder.transform(code, transform);
            }
        });
    }

    public DirectMethodBuilder run(Consumer<? super MethodBuilder> handler) {
        handler.accept(this);
        return this;
    }

    @Override
    public void writeTo(BufWriter b) {
        BufWriterImpl buf = (BufWriterImpl)b;
        buf.writeU2(this.flags);
        buf.writeIndex(this.name);
        buf.writeIndex(this.desc);
        this.attributes.writeTo(buf);
    }
}

