/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.glavo.classfile.ClassSignature;
import org.glavo.classfile.MethodSignature;
import org.glavo.classfile.Signature;

public final class SignaturesImpl {
    private String sig;
    private int sigp;

    public ClassSignature parseClassSignature(String signature) {
        this.sig = signature;
        this.sigp = 0;
        List<Signature.TypeParam> typeParamTypes = this.parseParamTypes();
        Signature.RefTypeSig superclass = this.referenceTypeSig();
        ArrayList<Signature.RefTypeSig> superinterfaces = null;
        while (this.sigp < this.sig.length()) {
            if (superinterfaces == null) {
                superinterfaces = new ArrayList<Signature.RefTypeSig>();
            }
            superinterfaces.add(this.referenceTypeSig());
        }
        return new ClassSignatureImpl(typeParamTypes, superclass, SignaturesImpl.null2Empty(superinterfaces));
    }

    public MethodSignature parseMethodSignature(String signature) {
        this.sig = signature;
        this.sigp = 0;
        List<Signature.TypeParam> typeParamTypes = this.parseParamTypes();
        assert (this.sig.charAt(this.sigp) == '(');
        ++this.sigp;
        ArrayList<Signature> paramTypes = null;
        while (this.sig.charAt(this.sigp) != ')') {
            if (paramTypes == null) {
                paramTypes = new ArrayList<Signature>();
            }
            paramTypes.add(this.typeSig());
        }
        ++this.sigp;
        Signature returnType = this.typeSig();
        ArrayList<Signature.ThrowableSig> throwsTypes = null;
        while (this.sigp < this.sig.length() && this.sig.charAt(this.sigp) == '^') {
            Signature t;
            ++this.sigp;
            if (throwsTypes == null) {
                throwsTypes = new ArrayList<Signature.ThrowableSig>();
            }
            if ((t = this.typeSig()) instanceof Signature.ThrowableSig) {
                Signature.ThrowableSig ts = (Signature.ThrowableSig)t;
                throwsTypes.add(ts);
                continue;
            }
            throw new IllegalStateException("not a valid type signature: " + this.sig);
        }
        return new MethodSignatureImpl(typeParamTypes, SignaturesImpl.null2Empty(throwsTypes), returnType, SignaturesImpl.null2Empty(paramTypes));
    }

    public Signature parseSignature(String signature) {
        this.sig = signature;
        this.sigp = 0;
        return this.typeSig();
    }

    private List<Signature.TypeParam> parseParamTypes() {
        ArrayList<TypeParamImpl> typeParamTypes = null;
        if (this.sig.charAt(this.sigp) == '<') {
            ++this.sigp;
            typeParamTypes = new ArrayList<TypeParamImpl>();
            while (this.sig.charAt(this.sigp) != '>') {
                int sep = this.sig.indexOf(":", this.sigp);
                String name = this.sig.substring(this.sigp, sep);
                Signature.RefTypeSig classBound = null;
                ArrayList<Signature.RefTypeSig> interfaceBounds = null;
                this.sigp = sep + 1;
                if (this.sig.charAt(this.sigp) != ':') {
                    classBound = this.referenceTypeSig();
                }
                while (this.sig.charAt(this.sigp) == ':') {
                    ++this.sigp;
                    if (interfaceBounds == null) {
                        interfaceBounds = new ArrayList<Signature.RefTypeSig>();
                    }
                    interfaceBounds.add(this.referenceTypeSig());
                }
                typeParamTypes.add(new TypeParamImpl(name, Optional.ofNullable(classBound), SignaturesImpl.null2Empty(interfaceBounds)));
            }
            ++this.sigp;
        }
        return SignaturesImpl.null2Empty(typeParamTypes);
    }

    private Signature typeSig() {
        char c = this.sig.charAt(this.sigp++);
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return Signature.BaseTypeSig.of(c);
            }
        }
        --this.sigp;
        return this.referenceTypeSig();
    }

    private Signature.RefTypeSig referenceTypeSig() {
        char c = this.sig.charAt(this.sigp++);
        switch (c) {
            case 'L': {
                char sigch;
                StringBuilder sb = new StringBuilder();
                ArrayList<Signature.TypeArg> argTypes = null;
                ClassTypeSigImpl t = null;
                do {
                    sigch = this.sig.charAt(this.sigp++);
                    switch (sigch) {
                        case '<': {
                            argTypes = new ArrayList<Signature.TypeArg>();
                            while (this.sig.charAt(this.sigp) != '>') {
                                argTypes.add(this.typeArg());
                            }
                            ++this.sigp;
                            break;
                        }
                        case '.': 
                        case ';': {
                            t = new ClassTypeSigImpl(Optional.ofNullable(t), sb.toString(), SignaturesImpl.null2Empty(argTypes));
                            sb.setLength(0);
                            argTypes = null;
                            break;
                        }
                        default: {
                            sb.append(sigch);
                        }
                    }
                } while (sigch != ';');
                return t;
            }
            case 'T': {
                int sep = this.sig.indexOf(59, this.sigp);
                Signature.TypeVarSig ty = Signature.TypeVarSig.of(this.sig.substring(this.sigp, sep));
                this.sigp = sep + 1;
                return ty;
            }
            case '[': {
                return Signature.ArrayTypeSig.of(this.typeSig());
            }
        }
        throw new IllegalStateException("not a valid type signature: " + this.sig);
    }

    private Signature.TypeArg typeArg() {
        char c = this.sig.charAt(this.sigp++);
        switch (c) {
            case '*': {
                return Signature.TypeArg.unbounded();
            }
            case '+': {
                return Signature.TypeArg.extendsOf(this.referenceTypeSig());
            }
            case '-': {
                return Signature.TypeArg.superOf(this.referenceTypeSig());
            }
        }
        --this.sigp;
        return Signature.TypeArg.of(this.referenceTypeSig());
    }

    private static StringBuilder printTypeParameters(List<Signature.TypeParam> typeParameters) {
        StringBuilder sb = new StringBuilder();
        if (typeParameters != null && !typeParameters.isEmpty()) {
            sb.append('<');
            for (Signature.TypeParam tp : typeParameters) {
                sb.append(tp.identifier()).append(':');
                if (tp.classBound().isPresent()) {
                    sb.append(tp.classBound().get().signatureString());
                }
                if (tp.interfaceBounds() == null) continue;
                for (Signature.RefTypeSig is : tp.interfaceBounds()) {
                    sb.append(':').append(is.signatureString());
                }
            }
            sb.append('>');
        }
        return sb;
    }

    private static <T> List<T> null2Empty(ArrayList<T> l) {
        return l == null ? List.of() : Collections.unmodifiableList(l);
    }

    public record ClassSignatureImpl(List<Signature.TypeParam> typeParameters, Signature.RefTypeSig superclassSignature, List<Signature.RefTypeSig> superinterfaceSignatures) implements ClassSignature
    {
        @Override
        public String signatureString() {
            StringBuilder sb = SignaturesImpl.printTypeParameters(this.typeParameters);
            sb.append(this.superclassSignature.signatureString());
            if (this.superinterfaceSignatures != null) {
                for (Signature.RefTypeSig in : this.superinterfaceSignatures) {
                    sb.append(in.signatureString());
                }
            }
            return sb.toString();
        }
    }

    public record MethodSignatureImpl(List<Signature.TypeParam> typeParameters, List<Signature.ThrowableSig> throwableSignatures, Signature result, List<Signature> arguments) implements MethodSignature
    {
        @Override
        public String signatureString() {
            StringBuilder sb = SignaturesImpl.printTypeParameters(this.typeParameters);
            sb.append('(');
            for (Signature a : this.arguments) {
                sb.append(a.signatureString());
            }
            sb.append(')').append(this.result.signatureString());
            if (!this.throwableSignatures.isEmpty()) {
                for (Signature.ThrowableSig t : this.throwableSignatures) {
                    sb.append('^').append(t.signatureString());
                }
            }
            return sb.toString();
        }
    }

    public record TypeParamImpl(String identifier, Optional<Signature.RefTypeSig> classBound, List<Signature.RefTypeSig> interfaceBounds) implements Signature.TypeParam
    {
    }

    public record ClassTypeSigImpl(Optional<Signature.ClassTypeSig> outerType, String className, List<Signature.TypeArg> typeArgs) implements Signature.ClassTypeSig
    {
        @Override
        public String signatureString() {
            Object prefix = "L";
            if (this.outerType.isPresent()) {
                prefix = this.outerType.get().signatureString();
                assert (((String)prefix).charAt(((String)prefix).length() - 1) == ';');
                prefix = ((String)prefix).substring(0, ((String)prefix).length() - 1) + ".";
            }
            String suffix = ";";
            if (!this.typeArgs.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append('<');
                for (Signature.TypeArg ta : this.typeArgs) {
                    sb.append(((TypeArgImpl)ta).signatureString());
                }
                suffix = sb.append(">;").toString();
            }
            return (String)prefix + this.className + suffix;
        }
    }

    public record TypeArgImpl(Signature.TypeArg.WildcardIndicator wildcardIndicator, Optional<Signature.RefTypeSig> boundType) implements Signature.TypeArg
    {
        public String signatureString() {
            return switch (this.wildcardIndicator) {
                default -> throw new IncompatibleClassChangeError();
                case Signature.TypeArg.WildcardIndicator.DEFAULT -> this.boundType.get().signatureString();
                case Signature.TypeArg.WildcardIndicator.EXTENDS -> "+" + this.boundType.get().signatureString();
                case Signature.TypeArg.WildcardIndicator.SUPER -> "-" + this.boundType.get().signatureString();
                case Signature.TypeArg.WildcardIndicator.UNBOUNDED -> "*";
            };
        }
    }

    public record ArrayTypeSigImpl(int arrayDepth, Signature elemType) implements Signature.ArrayTypeSig
    {
        @Override
        public Signature componentSignature() {
            return this.arrayDepth > 1 ? new ArrayTypeSigImpl(this.arrayDepth - 1, this.elemType) : this.elemType;
        }

        @Override
        public String signatureString() {
            return "[".repeat(this.arrayDepth) + this.elemType.signatureString();
        }
    }

    public record TypeVarSigImpl(String identifier) implements Signature.TypeVarSig
    {
        @Override
        public String signatureString() {
            return "T" + this.identifier + ";";
        }
    }

    public record BaseTypeSigImpl(char baseType) implements Signature.BaseTypeSig
    {
        @Override
        public String signatureString() {
            return "" + this.baseType;
        }
    }
}

