/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl.verifier;

import org.glavo.classfile.impl.verifier.VerificationFrame;
import org.glavo.classfile.impl.verifier.VerificationType;
import org.glavo.classfile.impl.verifier.VerificationWrapper;
import org.glavo.classfile.impl.verifier.VerifierImpl;

class VerificationTable {
    private final int _code_length;
    private final int _frame_count;
    private final VerificationFrame[] _frame_array;
    private final VerifierImpl _verifier;

    int get_frame_count() {
        return this._frame_count;
    }

    int get_offset(int index) {
        return this._frame_array[index].offset();
    }

    VerificationTable(byte[] stackmap_data, VerificationFrame init_frame, int max_locals, int max_stack, byte[] code_data, int code_len, VerificationWrapper.ConstantPoolWrapper cp, VerifierImpl v) {
        this._verifier = v;
        StackMapReader reader = new StackMapReader(stackmap_data, code_data, code_len, cp, v);
        this._code_length = code_len;
        this._frame_count = reader.get_frame_count();
        this._frame_array = new VerificationFrame[this._frame_count];
        if (this._frame_count > 0) {
            VerificationFrame pre_frame = init_frame;
            for (int i = 0; i < this._frame_count; ++i) {
                VerificationFrame frame;
                this._frame_array[i] = frame = reader.next(pre_frame, i == 0, max_locals, max_stack);
                int offset = frame.offset();
                if (offset >= code_len || code_data[offset] == 0) {
                    this._verifier.verifyError("StackMapTable error: bad offset");
                }
                pre_frame = frame;
            }
        }
        reader.check_end();
    }

    int get_index_from_offset(int offset) {
        int i;
        for (i = 0; i < this._frame_count; ++i) {
            if (this._frame_array[i].offset() != offset) continue;
            return i;
        }
        return i;
    }

    boolean match_stackmap(VerificationFrame frame, int target, boolean match, boolean update) {
        int index = this.get_index_from_offset(target);
        return this.match_stackmap(frame, target, index, match, update);
    }

    boolean match_stackmap(VerificationFrame frame, int target, int frame_index, boolean match, boolean update) {
        if (frame_index < 0 || frame_index >= this._frame_count) {
            this._verifier.verifyError(String.format("Expecting a stackmap frame at branch target %d", target));
        }
        VerificationFrame stackmap_frame = this._frame_array[frame_index];
        boolean result = true;
        if (match) {
            result = frame.is_assignable_to(stackmap_frame);
        }
        if (update) {
            int lsize = stackmap_frame.locals_size();
            int ssize = stackmap_frame.stack_size();
            if (frame.locals_size() > lsize || frame.stack_size() > ssize) {
                frame.reset();
            }
            frame.set_locals_size(lsize);
            frame.copy_locals(stackmap_frame);
            frame.set_stack_size(ssize);
            frame.copy_stack(stackmap_frame);
            frame.set_flags(stackmap_frame.flags());
        }
        return result;
    }

    void check_jump_target(VerificationFrame frame, int target) {
        boolean match = this.match_stackmap(frame, target, true, false);
        if (!match || target < 0 || target >= this._code_length) {
            this._verifier.verifyError(String.format("Inconsistent stackmap frames at branch target %d", target));
        }
    }

    static class StackMapReader {
        private final VerificationWrapper.ConstantPoolWrapper _cp;
        private final StackMapStream _stream;
        private final byte[] _code_data;
        private final int _code_length;
        private final int _frame_count;
        private static final int SAME_LOCALS_1_STACK_ITEM_EXTENDED = 247;
        private static final int SAME_EXTENDED = 251;
        private static final int FULL = 255;
        private final VerifierImpl _verifier;

        void check_verification_type_array_size(int size, int max_size) {
            if (size < 0 || size > max_size) {
                this._verifier.classError("StackMapTable format error: bad type array size");
            }
        }

        public int get_frame_count() {
            return this._frame_count;
        }

        public void check_end() {
            if (!this._stream.at_end()) {
                this._verifier.classError("wrong attribute size");
            }
        }

        public StackMapReader(byte[] stackmapData, byte[] code_data, int code_len, VerificationWrapper.ConstantPoolWrapper cp, VerifierImpl context) {
            this._verifier = context;
            this._stream = new StackMapStream(stackmapData, this._verifier);
            this._frame_count = stackmapData != null ? this._stream.get_u2() : 0;
            this._code_data = code_data;
            this._code_length = code_len;
            this._cp = cp;
        }

        int chop(VerificationType[] locals, int length, int chops) {
            if (locals == null) {
                return -1;
            }
            int pos = length - 1;
            for (int i = 0; i < chops; ++i) {
                pos = locals[pos].is_category2_2nd() ? (pos -= 2) : --pos;
                if (pos >= 0 || i >= chops - 1) continue;
                return -1;
            }
            return pos + 1;
        }

        VerificationType parse_verification_type(int[] flags) {
            int tag = this._stream.get_u1();
            if (tag < 6) {
                return VerificationType.from_tag(tag, this._verifier);
            }
            if (tag == 7) {
                int class_index = this._stream.get_u2();
                int nconstants = this._cp.entryCount();
                if (class_index <= 0 || class_index >= nconstants || this._cp.tagAt(class_index) != 7) {
                    this._verifier.classError("bad class index");
                }
                return VerificationType.reference_type(this._cp.classNameAt(class_index));
            }
            if (tag == 6) {
                if (flags != null) {
                    flags[0] = flags[0] | 1;
                }
                return VerificationType.uninitialized_this_type;
            }
            if (tag == 8) {
                int offset = this._stream.get_u2();
                if (offset >= this._code_length || this._code_data[offset] != 2) {
                    this._verifier.classError("StackMapTable format error: bad offset for Uninitialized");
                }
                return VerificationType.uninitialized_type(offset);
            }
            this._verifier.classError("bad verification type");
            return VerificationType.bogus_type;
        }

        public VerificationFrame next(VerificationFrame pre_frame, boolean first, int max_locals, int max_stack) {
            Object locals = null;
            int frame_type = this._stream.get_u1();
            if (frame_type < 64) {
                int offset;
                if (first) {
                    offset = frame_type;
                    if (pre_frame.locals_size() > 0) {
                        locals = new VerificationType[pre_frame.locals_size()];
                    }
                } else {
                    offset = pre_frame.offset() + frame_type + 1;
                    locals = pre_frame.locals();
                }
                VerificationFrame frame = new VerificationFrame(offset, pre_frame.flags(), pre_frame.locals_size(), 0, max_locals, max_stack, (VerificationType[])locals, null, this._verifier);
                if (first && locals != null) {
                    frame.copy_locals(pre_frame);
                }
                return frame;
            }
            if (frame_type < 128) {
                int offset;
                if (first) {
                    offset = frame_type - 64;
                    if (pre_frame.locals_size() > 0) {
                        locals = new VerificationType[pre_frame.locals_size()];
                    }
                } else {
                    offset = pre_frame.offset() + frame_type - 63;
                    locals = pre_frame.locals();
                }
                VerificationType[] stack = new VerificationType[2];
                int stack_size = 1;
                stack[0] = this.parse_verification_type(null);
                if (stack[0].is_category2()) {
                    stack[1] = stack[0].to_category2_2nd(this._verifier);
                    stack_size = 2;
                }
                this.check_verification_type_array_size(stack_size, max_stack);
                VerificationFrame frame = new VerificationFrame(offset, pre_frame.flags(), pre_frame.locals_size(), stack_size, max_locals, max_stack, (VerificationType[])locals, stack, this._verifier);
                if (first && locals != null) {
                    frame.copy_locals(pre_frame);
                }
                return frame;
            }
            int offset_delta = this._stream.get_u2();
            if (frame_type < 247) {
                this._verifier.classError("reserved frame type");
            }
            if (frame_type == 247) {
                int offset;
                if (first) {
                    offset = offset_delta;
                    if (pre_frame.locals_size() > 0) {
                        locals = new VerificationType[pre_frame.locals_size()];
                    }
                } else {
                    offset = pre_frame.offset() + offset_delta + 1;
                    locals = pre_frame.locals();
                }
                VerificationType[] stack = new VerificationType[2];
                int stack_size = 1;
                stack[0] = this.parse_verification_type(null);
                if (stack[0].is_category2()) {
                    stack[1] = stack[0].to_category2_2nd(this._verifier);
                    stack_size = 2;
                }
                this.check_verification_type_array_size(stack_size, max_stack);
                VerificationFrame frame = new VerificationFrame(offset, pre_frame.flags(), pre_frame.locals_size(), stack_size, max_locals, max_stack, (VerificationType[])locals, stack, this._verifier);
                if (first && locals != null) {
                    frame.copy_locals(pre_frame);
                }
                return frame;
            }
            if (frame_type <= 251) {
                int offset;
                locals = pre_frame.locals();
                int length = pre_frame.locals_size();
                int chops = 251 - frame_type;
                int new_length = length;
                int flags = pre_frame.flags();
                if (chops != 0) {
                    new_length = this.chop((VerificationType[])locals, length, chops);
                    this.check_verification_type_array_size(new_length, max_locals);
                    flags = 0;
                    for (int i = 0; i < new_length; ++i) {
                        if (!locals[i].is_uninitialized_this(this._verifier)) continue;
                        flags |= 1;
                        break;
                    }
                }
                if (first) {
                    offset = offset_delta;
                    locals = new_length > 0 ? new VerificationType[new_length] : null;
                } else {
                    offset = pre_frame.offset() + offset_delta + 1;
                }
                VerificationFrame frame = new VerificationFrame(offset, flags, new_length, 0, max_locals, max_stack, (VerificationType[])locals, null, this._verifier);
                if (first && locals != null) {
                    frame.copy_locals(pre_frame);
                }
                return frame;
            }
            if (frame_type < 255) {
                int i;
                int appends = frame_type - 251;
                int real_length = pre_frame.locals_size();
                int new_length = real_length + appends * 2;
                locals = new VerificationType[new_length];
                VerificationType[] pre_locals = pre_frame.locals();
                for (i = 0; i < pre_frame.locals_size(); ++i) {
                    locals[i] = pre_locals[i];
                }
                int[] flags = new int[]{pre_frame.flags()};
                for (i = 0; i < appends; ++i) {
                    locals[real_length] = this.parse_verification_type(flags);
                    if (locals[real_length].is_category2()) {
                        locals[real_length + 1] = locals[real_length].to_category2_2nd(this._verifier);
                        ++real_length;
                    }
                    ++real_length;
                }
                this.check_verification_type_array_size(real_length, max_locals);
                int offset = first ? offset_delta : pre_frame.offset() + offset_delta + 1;
                VerificationFrame frame = new VerificationFrame(offset, flags[0], real_length, 0, max_locals, max_stack, (VerificationType[])locals, null, this._verifier);
                return frame;
            }
            if (frame_type == 255) {
                int i;
                int[] flags = new int[]{0};
                int locals_size = this._stream.get_u2();
                int real_locals_size = 0;
                if (locals_size > 0) {
                    locals = new VerificationType[locals_size * 2];
                }
                for (i = 0; i < locals_size; ++i) {
                    locals[real_locals_size] = this.parse_verification_type(flags);
                    if (locals[real_locals_size].is_category2()) {
                        locals[real_locals_size + 1] = locals[real_locals_size].to_category2_2nd(this._verifier);
                        ++real_locals_size;
                    }
                    ++real_locals_size;
                }
                this.check_verification_type_array_size(real_locals_size, max_locals);
                int stack_size = this._stream.get_u2();
                int real_stack_size = 0;
                VerificationType[] stack = null;
                if (stack_size > 0) {
                    stack = new VerificationType[stack_size * 2];
                }
                for (i = 0; i < stack_size; ++i) {
                    stack[real_stack_size] = this.parse_verification_type(null);
                    if (stack[real_stack_size].is_category2()) {
                        stack[real_stack_size + 1] = stack[real_stack_size].to_category2_2nd(this._verifier);
                        ++real_stack_size;
                    }
                    ++real_stack_size;
                }
                this.check_verification_type_array_size(real_stack_size, max_stack);
                int offset = first ? offset_delta : pre_frame.offset() + offset_delta + 1;
                VerificationFrame frame = new VerificationFrame(offset, flags[0], real_locals_size, real_stack_size, max_locals, max_stack, (VerificationType[])locals, stack, this._verifier);
                return frame;
            }
            this._verifier.classError("reserved frame type");
            return null;
        }
    }

    static class StackMapStream {
        private final byte[] _data;
        private int _index;
        private final VerifierImpl _verifier;

        StackMapStream(byte[] ah, VerifierImpl context) {
            this._data = ah;
            this._index = 0;
            this._verifier = context;
        }

        int get_u1() {
            if (this._data == null || this._index >= this._data.length) {
                this._verifier.classError("access beyond the end of attribute");
            }
            return this._data[this._index++] & 0xFF;
        }

        int get_u2() {
            int res = this.get_u1() << 8;
            return res | this.get_u1();
        }

        boolean at_end() {
            return this._data == null || this._index == this._data.length;
        }
    }
}

