/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl.verifier;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.glavo.classfile.ClassHierarchyResolver;
import org.glavo.classfile.ClassModel;
import org.glavo.classfile.attribute.LocalVariableInfo;
import org.glavo.classfile.components.ClassPrinter;
import org.glavo.classfile.impl.ClassHierarchyImpl;
import org.glavo.classfile.impl.RawBytecodeHelper;
import org.glavo.classfile.impl.verifier.VerificationBytecodes;
import org.glavo.classfile.impl.verifier.VerificationFrame;
import org.glavo.classfile.impl.verifier.VerificationSignature;
import org.glavo.classfile.impl.verifier.VerificationTable;
import org.glavo.classfile.impl.verifier.VerificationType;
import org.glavo.classfile.impl.verifier.VerificationWrapper;

public final class VerifierImpl {
    static final int JVM_CONSTANT_Utf8 = 1;
    static final int JVM_CONSTANT_Unicode = 2;
    static final int JVM_CONSTANT_Integer = 3;
    static final int JVM_CONSTANT_Float = 4;
    static final int JVM_CONSTANT_Long = 5;
    static final int JVM_CONSTANT_Double = 6;
    static final int JVM_CONSTANT_Class = 7;
    static final int JVM_CONSTANT_String = 8;
    static final int JVM_CONSTANT_Fieldref = 9;
    static final int JVM_CONSTANT_Methodref = 10;
    static final int JVM_CONSTANT_InterfaceMethodref = 11;
    static final int JVM_CONSTANT_NameAndType = 12;
    static final int JVM_CONSTANT_MethodHandle = 15;
    static final int JVM_CONSTANT_MethodType = 16;
    static final int JVM_CONSTANT_Dynamic = 17;
    static final int JVM_CONSTANT_InvokeDynamic = 18;
    static final int JVM_CONSTANT_Module = 19;
    static final int JVM_CONSTANT_Package = 20;
    static final int JVM_CONSTANT_ExternalMax = 20;
    static final char JVM_SIGNATURE_SPECIAL = '<';
    static final char JVM_SIGNATURE_ARRAY = '[';
    static final char JVM_SIGNATURE_BYTE = 'B';
    static final char JVM_SIGNATURE_CHAR = 'C';
    static final char JVM_SIGNATURE_CLASS = 'L';
    static final char JVM_SIGNATURE_FLOAT = 'F';
    static final char JVM_SIGNATURE_DOUBLE = 'D';
    static final char JVM_SIGNATURE_INT = 'I';
    static final char JVM_SIGNATURE_LONG = 'J';
    static final char JVM_SIGNATURE_SHORT = 'S';
    static final char JVM_SIGNATURE_BOOLEAN = 'Z';
    static final String java_lang_String = "java/lang/String";
    static final String object_initializer_name = "<init>";
    static final String java_lang_invoke_MethodHandle = "java/lang/invoke/MethodHandle";
    static final String java_lang_Object = "java/lang/Object";
    static final String java_lang_invoke_MethodType = "java/lang/invoke/MethodType";
    static final String java_lang_Throwable = "java/lang/Throwable";
    static final String java_lang_Class = "java/lang/Class";
    String errorContext = "";
    private int bci;
    private final Consumer<String> _logger;
    static final int STACKMAP_ATTRIBUTE_MAJOR_VERSION = 50;
    static final int INVOKEDYNAMIC_MAJOR_VERSION = 51;
    static final int NOFAILOVER_MAJOR_VERSION = 51;
    final VerificationWrapper _klass;
    final ClassHierarchyImpl _class_hierarchy;
    VerificationWrapper.MethodWrapper _method;
    VerificationType _this_type;
    static final int BYTECODE_OFFSET = 1;
    static final int NEW_OFFSET = 2;
    private static final int NONZERO_PADDING_BYTES_IN_SWITCH_MAJOR_VERSION = 51;
    private static final int STATIC_METHOD_IN_INTERFACE_MAJOR_VERSION = 52;
    private static final int MAX_ARRAY_DIMENSIONS = 255;

    static void log_info(Consumer<String> logger, String messageFormat, Object ... args) {
        if (logger != null) {
            logger.accept(String.format(messageFormat + "%n", args));
        }
    }

    void log_info(String messageFormat, Object ... args) {
        VerifierImpl.log_info(this._logger, messageFormat, args);
    }

    public static List<VerifyError> verify(ClassModel classModel, Consumer<String> logger) {
        return VerifierImpl.verify(classModel, ClassHierarchyResolver.DEFAULT_CLASS_HIERARCHY_RESOLVER, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<VerifyError> verify(ClassModel classModel, ClassHierarchyResolver classHierarchyResolver, Consumer<String> logger) {
        VerificationWrapper klass;
        block5: {
            List<VerifyError> errors;
            block6: {
                List<VerifyError> list;
                klass = new VerificationWrapper(classModel);
                if (!VerifierImpl.is_eligible_for_verification(klass)) {
                    return List.of();
                }
                VerifierImpl.log_info(logger, "Start class verification for: %s", klass.thisClassName());
                try {
                    if (klass.majorVersion() < 50) break block5;
                    errors = new VerifierImpl(klass, classHierarchyResolver, logger).verify_class();
                    if (errors.isEmpty() || klass.majorVersion() >= 51) break block6;
                    VerifierImpl.log_info(logger, "Fail over class verification to old verifier for: %s", klass.thisClassName());
                    list = VerifierImpl.inference_verify(klass);
                }
                catch (Throwable throwable) {
                    VerifierImpl.log_info(logger, "End class verification for: %s", klass.thisClassName());
                    throw throwable;
                }
                VerifierImpl.log_info(logger, "End class verification for: %s", klass.thisClassName());
                return list;
            }
            List<VerifyError> list = errors;
            VerifierImpl.log_info(logger, "End class verification for: %s", klass.thisClassName());
            return list;
        }
        List<VerifyError> list = VerifierImpl.inference_verify(klass);
        VerifierImpl.log_info(logger, "End class verification for: %s", klass.thisClassName());
        return list;
    }

    public static boolean is_eligible_for_verification(VerificationWrapper klass) {
        String name = klass.thisClassName();
        return !java_lang_Object.equals(name) && !java_lang_Class.equals(name) && !java_lang_String.equals(name) && !java_lang_Throwable.equals(name);
    }

    static List<VerifyError> inference_verify(VerificationWrapper klass) {
        return List.of(new VerifyError("Inference verification is not supported"));
    }

    VerificationType cp_ref_index_to_type(int index, VerificationWrapper.ConstantPoolWrapper cp) {
        return this.cp_index_to_type(cp.refClassIndexAt(index), cp);
    }

    VerificationWrapper current_class() {
        return this._klass;
    }

    ClassHierarchyImpl class_hierarchy() {
        return this._class_hierarchy;
    }

    VerificationType current_type() {
        return this._this_type;
    }

    VerificationType cp_index_to_type(int index, VerificationWrapper.ConstantPoolWrapper cp) {
        return VerificationType.reference_type(cp.classNameAt(index));
    }

    int change_sig_to_verificationType(VerificationSignature sig_type, VerificationType[] inference_types, int inference_type_index) {
        VerificationSignature.BasicType bt = sig_type.type();
        switch (bt) {
            case T_OBJECT: 
            case T_ARRAY: {
                String name = sig_type.asSymbol();
                inference_types[inference_type_index] = VerificationType.reference_type(name);
                return 1;
            }
            case T_LONG: {
                inference_types[inference_type_index] = VerificationType.long_type;
                inference_types[++inference_type_index] = VerificationType.long2_type;
                return 2;
            }
            case T_DOUBLE: {
                inference_types[inference_type_index] = VerificationType.double_type;
                inference_types[++inference_type_index] = VerificationType.double2_type;
                return 2;
            }
            case T_INT: 
            case T_BOOLEAN: 
            case T_BYTE: 
            case T_CHAR: 
            case T_SHORT: {
                inference_types[inference_type_index] = VerificationType.integer_type;
                return 1;
            }
            case T_FLOAT: {
                inference_types[inference_type_index] = VerificationType.float_type;
                return 1;
            }
        }
        this.verifyError("Should not reach here");
        return 1;
    }

    VerifierImpl(VerificationWrapper klass, ClassHierarchyResolver classHierarchyResolver, Consumer<String> logger) {
        this._klass = klass;
        this._class_hierarchy = new ClassHierarchyImpl(classHierarchyResolver);
        this._this_type = VerificationType.reference_type(klass.thisClassName());
        this._logger = logger;
    }

    private VerificationType object_type() {
        return VerificationType.reference_type(java_lang_Object);
    }

    List<VerifyError> verify_class() {
        this.log_info("Verifying class %s with new format", this._klass.thisClassName());
        ArrayList<VerifyError> errors = new ArrayList<VerifyError>();
        for (VerificationWrapper.MethodWrapper m : this._klass.methods()) {
            if (m.isNative() || m.isAbstract() || m.isBridge()) continue;
            this.verify_method(m, errors);
        }
        return errors;
    }

    void translate_signature(String method_sig, sig_as_verification_types sig_verif_types) {
        int n;
        VerificationSignature sig_stream = new VerificationSignature(method_sig, true, this);
        VerificationType[] sig_type = new VerificationType[2];
        int sig_i = 0;
        ArrayList<VerificationType> verif_types = sig_verif_types.sig_verif_types();
        while (!sig_stream.atReturnType()) {
            n = this.change_sig_to_verificationType(sig_stream, sig_type, 0);
            if (n > 2) {
                this.verifyError("Unexpected signature type");
            }
            for (int x = 0; x < n; ++x) {
                verif_types.add(sig_type[x]);
            }
            sig_i += n;
            sig_stream.next();
        }
        sig_verif_types.set_num_args(sig_i);
        if (sig_stream.type() != VerificationSignature.BasicType.T_VOID) {
            n = this.change_sig_to_verificationType(sig_stream, sig_type, 0);
            if (n > 2) {
                this.verifyError("Unexpected signature return type");
            }
            for (int y = 0; y < n; ++y) {
                verif_types.add(sig_type[y]);
            }
        }
    }

    void create_method_sig_entry(sig_as_verification_types sig_verif_types, String method_sig) {
        this.translate_signature(method_sig, sig_verif_types);
    }

    void verify_method(VerificationWrapper.MethodWrapper m, List<VerifyError> errorsCollector) {
        try {
            this.verify_method(m, m.maxLocals(), m.maxStack(), m.stackMapTableRawData());
        }
        catch (VerifyError err) {
            errorsCollector.add(err);
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            errorsCollector.add(new VerifyError(e.toString()));
        }
    }

    void verify_method(VerificationWrapper.MethodWrapper m, int max_locals, int max_stack, byte[] stackmap_data) {
        this._method = m;
        VerifierImpl.log_info(this._logger, "Verifying method %s%s", m.name(), m.descriptor());
        VerificationWrapper.ConstantPoolWrapper cp = m.constantPool();
        if (!VerificationSignature.isValidMethodSignature(m.descriptor())) {
            this.verifyError("Invalid method signature");
        }
        VerificationFrame current_frame = new VerificationFrame(max_locals, max_stack, this);
        VerificationType return_type = current_frame.set_locals_from_arg(m, this.current_type());
        int stackmap_index = 0;
        int code_length = m.codeLength();
        ByteBuffer code = ByteBuffer.wrap(this._method.codeArray(), 0, this._method.codeLength());
        byte[] code_data = this.generate_code_data(code, code_length);
        int[] ex_minmax = new int[]{code_length, -1};
        this.verify_exception_handler_table(code_length, code_data, ex_minmax);
        this.verify_local_variable_table(code_length, code_data);
        VerificationTable stackmap_table = new VerificationTable(stackmap_data, current_frame, max_locals, max_stack, code_data, code_length, cp, this);
        RawBytecodeHelper bcs = new RawBytecodeHelper(code);
        boolean no_control_flow = false;
        while (!bcs.isLastBytecode()) {
            int opcode = bcs.rawNext();
            this.bci = bcs.bci;
            current_frame.set_offset(this.bci);
            current_frame.set_mark();
            stackmap_index = this.verify_stackmap_table(stackmap_index, this.bci, current_frame, stackmap_table, no_control_flow);
            boolean this_uninit = false;
            boolean verified_exc_handlers = false;
            VerificationType type2 = null;
            if (bcs.isWide && opcode != 132 && opcode != 21 && opcode != 25 && opcode != 22 && opcode != 54 && opcode != 58 && opcode != 55 && opcode != 23 && opcode != 24 && opcode != 56 && opcode != 57) {
                this.verifyError("Bad wide instruction");
            }
            if (VerificationBytecodes.is_store_into_local(opcode) && this.bci >= ex_minmax[0] && this.bci < ex_minmax[1]) {
                this.verify_exception_handler_targets(this.bci, this_uninit, current_frame, stackmap_table);
                verified_exc_handlers = true;
            }
            switch (opcode) {
                case 0: {
                    no_control_flow = false;
                    break;
                }
                case 1: {
                    current_frame.push_stack(VerificationType.null_type);
                    no_control_flow = false;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    current_frame.push_stack(VerificationType.integer_type);
                    no_control_flow = false;
                    break;
                }
                case 9: 
                case 10: {
                    current_frame.push_stack_2(VerificationType.long_type, VerificationType.long2_type);
                    no_control_flow = false;
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    current_frame.push_stack(VerificationType.float_type);
                    no_control_flow = false;
                    break;
                }
                case 14: 
                case 15: {
                    current_frame.push_stack_2(VerificationType.double_type, VerificationType.double2_type);
                    no_control_flow = false;
                    break;
                }
                case 16: 
                case 17: {
                    current_frame.push_stack(VerificationType.integer_type);
                    no_control_flow = false;
                    break;
                }
                case 18: {
                    this.verify_ldc(opcode, bcs.getIndexU1(), current_frame, cp, this.bci);
                    no_control_flow = false;
                    break;
                }
                case 19: 
                case 20: {
                    this.verify_ldc(opcode, bcs.getIndexU2(), current_frame, cp, this.bci);
                    no_control_flow = false;
                    break;
                }
                case 21: {
                    this.verify_iload(bcs.getIndex(), current_frame);
                    no_control_flow = false;
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    int index = opcode - 26;
                    this.verify_iload(index, current_frame);
                    no_control_flow = false;
                    break;
                }
                case 22: {
                    this.verify_lload(bcs.getIndex(), current_frame);
                    no_control_flow = false;
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    int index = opcode - 30;
                    this.verify_lload(index, current_frame);
                    no_control_flow = false;
                    break;
                }
                case 23: {
                    this.verify_fload(bcs.getIndex(), current_frame);
                    no_control_flow = false;
                    break;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    int index = opcode - 34;
                    this.verify_fload(index, current_frame);
                    no_control_flow = false;
                    break;
                }
                case 24: {
                    this.verify_dload(bcs.getIndex(), current_frame);
                    no_control_flow = false;
                    break;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    int index = opcode - 38;
                    this.verify_dload(index, current_frame);
                    no_control_flow = false;
                    break;
                }
                case 25: {
                    this.verify_aload(bcs.getIndex(), current_frame);
                    no_control_flow = false;
                    break;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    int index = opcode - 42;
                    this.verify_aload(index, current_frame);
                    no_control_flow = false;
                    break;
                }
                case 46: {
                    VerificationType type = current_frame.pop_stack(VerificationType.integer_type);
                    VerificationType atype = current_frame.pop_stack(VerificationType.reference_check);
                    if (!atype.is_int_array()) {
                        this.verifyError("Bad type");
                    }
                    current_frame.push_stack(VerificationType.integer_type);
                    no_control_flow = false;
                    break;
                }
                case 51: {
                    VerificationType type = current_frame.pop_stack(VerificationType.integer_type);
                    VerificationType atype = current_frame.pop_stack(VerificationType.reference_check);
                    if (!atype.is_bool_array() && !atype.is_byte_array()) {
                        this.verifyError("Bad type");
                    }
                    current_frame.push_stack(VerificationType.integer_type);
                    no_control_flow = false;
                    break;
                }
                case 52: {
                    VerificationType type = current_frame.pop_stack(VerificationType.integer_type);
                    VerificationType atype = current_frame.pop_stack(VerificationType.reference_check);
                    if (!atype.is_char_array()) {
                        this.verifyError("Bad type");
                    }
                    current_frame.push_stack(VerificationType.integer_type);
                    no_control_flow = false;
                    break;
                }
                case 53: {
                    VerificationType type = current_frame.pop_stack(VerificationType.integer_type);
                    VerificationType atype = current_frame.pop_stack(VerificationType.reference_check);
                    if (!atype.is_short_array()) {
                        this.verifyError("Bad type");
                    }
                    current_frame.push_stack(VerificationType.integer_type);
                    no_control_flow = false;
                    break;
                }
                case 47: {
                    VerificationType type = current_frame.pop_stack(VerificationType.integer_type);
                    VerificationType atype = current_frame.pop_stack(VerificationType.reference_check);
                    if (!atype.is_long_array()) {
                        this.verifyError("Bad type");
                    }
                    current_frame.push_stack_2(VerificationType.long_type, VerificationType.long2_type);
                    no_control_flow = false;
                    break;
                }
                case 48: {
                    VerificationType type = current_frame.pop_stack(VerificationType.integer_type);
                    VerificationType atype = current_frame.pop_stack(VerificationType.reference_check);
                    if (!atype.is_float_array()) {
                        this.verifyError("Bad type");
                    }
                    current_frame.push_stack(VerificationType.float_type);
                    no_control_flow = false;
                    break;
                }
                case 49: {
                    VerificationType type = current_frame.pop_stack(VerificationType.integer_type);
                    VerificationType atype = current_frame.pop_stack(VerificationType.reference_check);
                    if (!atype.is_double_array()) {
                        this.verifyError("Bad type");
                    }
                    current_frame.push_stack_2(VerificationType.double_type, VerificationType.double2_type);
                    no_control_flow = false;
                    break;
                }
                case 50: {
                    VerificationType type = current_frame.pop_stack(VerificationType.integer_type);
                    VerificationType atype = current_frame.pop_stack(VerificationType.reference_check);
                    if (!atype.is_reference_array()) {
                        this.verifyError("Bad type");
                    }
                    if (atype.is_null()) {
                        current_frame.push_stack(VerificationType.null_type);
                    } else {
                        VerificationType component = atype.get_component(this);
                        current_frame.push_stack(component);
                    }
                    no_control_flow = false;
                    break;
                }
                case 54: {
                    this.verify_istore(bcs.getIndex(), current_frame);
                    no_control_flow = false;
                    break;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    int index = opcode - 59;
                    this.verify_istore(index, current_frame);
                    no_control_flow = false;
                    break;
                }
                case 55: {
                    this.verify_lstore(bcs.getIndex(), current_frame);
                    no_control_flow = false;
                    break;
                }
                case 63: 
                case 64: 
                case 65: 
                case 66: {
                    int index = opcode - 63;
                    this.verify_lstore(index, current_frame);
                    no_control_flow = false;
                    break;
                }
                case 56: {
                    this.verify_fstore(bcs.getIndex(), current_frame);
                    no_control_flow = false;
                    break;
                }
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    int index = opcode - 67;
                    this.verify_fstore(index, current_frame);
                    no_control_flow = false;
                    break;
                }
                case 57: {
                    this.verify_dstore(bcs.getIndex(), current_frame);
                    no_control_flow = false;
                    break;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: {
                    int index = opcode - 71;
                    this.verify_dstore(index, current_frame);
                    no_control_flow = false;
                    break;
                }
                case 58: {
                    this.verify_astore(bcs.getIndex(), current_frame);
                    no_control_flow = false;
                    break;
                }
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    int index = opcode - 75;
                    this.verify_astore(index, current_frame);
                    no_control_flow = false;
                    break;
                }
                case 79: {
                    VerificationType type = current_frame.pop_stack(VerificationType.integer_type);
                    type2 = current_frame.pop_stack(VerificationType.integer_type);
                    VerificationType atype = current_frame.pop_stack(VerificationType.reference_check);
                    if (!atype.is_int_array()) {
                        this.verifyError("Bad type");
                    }
                    no_control_flow = false;
                    break;
                }
                case 84: {
                    VerificationType type = current_frame.pop_stack(VerificationType.integer_type);
                    type2 = current_frame.pop_stack(VerificationType.integer_type);
                    VerificationType atype = current_frame.pop_stack(VerificationType.reference_check);
                    if (!atype.is_bool_array() && !atype.is_byte_array()) {
                        this.verifyError("Bad type");
                    }
                    no_control_flow = false;
                    break;
                }
                case 85: {
                    current_frame.pop_stack(VerificationType.integer_type);
                    current_frame.pop_stack(VerificationType.integer_type);
                    VerificationType atype = current_frame.pop_stack(VerificationType.reference_check);
                    if (!atype.is_char_array()) {
                        this.verifyError("Bad type");
                    }
                    no_control_flow = false;
                    break;
                }
                case 86: {
                    current_frame.pop_stack(VerificationType.integer_type);
                    current_frame.pop_stack(VerificationType.integer_type);
                    VerificationType atype = current_frame.pop_stack(VerificationType.reference_check);
                    if (!atype.is_short_array()) {
                        this.verifyError("Bad type");
                    }
                    no_control_flow = false;
                    break;
                }
                case 80: {
                    current_frame.pop_stack_2(VerificationType.long2_type, VerificationType.long_type);
                    current_frame.pop_stack(VerificationType.integer_type);
                    VerificationType atype = current_frame.pop_stack(VerificationType.reference_check);
                    if (!atype.is_long_array()) {
                        this.verifyError("Bad type");
                    }
                    no_control_flow = false;
                    break;
                }
                case 81: {
                    current_frame.pop_stack(VerificationType.float_type);
                    current_frame.pop_stack(VerificationType.integer_type);
                    VerificationType atype = current_frame.pop_stack(VerificationType.reference_check);
                    if (!atype.is_float_array()) {
                        this.verifyError("Bad type");
                    }
                    no_control_flow = false;
                    break;
                }
                case 82: {
                    current_frame.pop_stack_2(VerificationType.double2_type, VerificationType.double_type);
                    current_frame.pop_stack(VerificationType.integer_type);
                    VerificationType atype = current_frame.pop_stack(VerificationType.reference_check);
                    if (!atype.is_double_array()) {
                        this.verifyError("Bad type");
                    }
                    no_control_flow = false;
                    break;
                }
                case 83: {
                    VerificationType type = current_frame.pop_stack(this.object_type());
                    type2 = current_frame.pop_stack(VerificationType.integer_type);
                    VerificationType atype = current_frame.pop_stack(VerificationType.reference_check);
                    if (!atype.is_reference_array()) {
                        this.verifyError("Bad type");
                    }
                    no_control_flow = false;
                    break;
                }
                case 87: {
                    current_frame.pop_stack(VerificationType.category1_check);
                    no_control_flow = false;
                    break;
                }
                case 88: {
                    VerificationType type = current_frame.pop_stack();
                    if (type.is_category1(this)) {
                        current_frame.pop_stack(VerificationType.category1_check);
                    } else if (type.is_category2_2nd()) {
                        current_frame.pop_stack(VerificationType.category2_check);
                    } else {
                        this.verifyError("Bad type");
                    }
                    no_control_flow = false;
                    break;
                }
                case 89: {
                    VerificationType type = current_frame.pop_stack(VerificationType.category1_check);
                    current_frame.push_stack(type);
                    current_frame.push_stack(type);
                    no_control_flow = false;
                    break;
                }
                case 90: {
                    VerificationType type = current_frame.pop_stack(VerificationType.category1_check);
                    type2 = current_frame.pop_stack(VerificationType.category1_check);
                    current_frame.push_stack(type);
                    current_frame.push_stack(type2);
                    current_frame.push_stack(type);
                    no_control_flow = false;
                    break;
                }
                case 91: {
                    VerificationType type3 = null;
                    VerificationType type = current_frame.pop_stack(VerificationType.category1_check);
                    type2 = current_frame.pop_stack();
                    if (type2.is_category1(this)) {
                        type3 = current_frame.pop_stack(VerificationType.category1_check);
                    } else if (type2.is_category2_2nd()) {
                        type3 = current_frame.pop_stack(VerificationType.category2_check);
                    } else {
                        this.verifyError("Bad type");
                    }
                    current_frame.push_stack(type);
                    current_frame.push_stack(type3);
                    current_frame.push_stack(type2);
                    current_frame.push_stack(type);
                    no_control_flow = false;
                    break;
                }
                case 92: {
                    VerificationType type = current_frame.pop_stack();
                    if (type.is_category1(this)) {
                        type2 = current_frame.pop_stack(VerificationType.category1_check);
                    } else if (type.is_category2_2nd()) {
                        type2 = current_frame.pop_stack(VerificationType.category2_check);
                    } else {
                        this.verifyError("Bad type");
                    }
                    current_frame.push_stack(type2);
                    current_frame.push_stack(type);
                    current_frame.push_stack(type2);
                    current_frame.push_stack(type);
                    no_control_flow = false;
                    break;
                }
                case 93: {
                    VerificationType type = current_frame.pop_stack();
                    if (type.is_category1(this)) {
                        type2 = current_frame.pop_stack(VerificationType.category1_check);
                    } else if (type.is_category2_2nd()) {
                        type2 = current_frame.pop_stack(VerificationType.category2_check);
                    } else {
                        this.verifyError("Bad type");
                    }
                    VerificationType type3 = current_frame.pop_stack(VerificationType.category1_check);
                    current_frame.push_stack(type2);
                    current_frame.push_stack(type);
                    current_frame.push_stack(type3);
                    current_frame.push_stack(type2);
                    current_frame.push_stack(type);
                    no_control_flow = false;
                    break;
                }
                case 94: {
                    VerificationType type4 = null;
                    VerificationType type = current_frame.pop_stack();
                    if (type.is_category1(this)) {
                        type2 = current_frame.pop_stack(VerificationType.category1_check);
                    } else if (type.is_category2_2nd()) {
                        type2 = current_frame.pop_stack(VerificationType.category2_check);
                    } else {
                        this.verifyError("Bad type");
                    }
                    VerificationType type3 = current_frame.pop_stack();
                    if (type3.is_category1(this)) {
                        type4 = current_frame.pop_stack(VerificationType.category1_check);
                    } else if (type3.is_category2_2nd()) {
                        type4 = current_frame.pop_stack(VerificationType.category2_check);
                    } else {
                        this.verifyError("Bad type");
                    }
                    current_frame.push_stack(type2);
                    current_frame.push_stack(type);
                    current_frame.push_stack(type4);
                    current_frame.push_stack(type3);
                    current_frame.push_stack(type2);
                    current_frame.push_stack(type);
                    no_control_flow = false;
                    break;
                }
                case 95: {
                    VerificationType type = current_frame.pop_stack(VerificationType.category1_check);
                    type2 = current_frame.pop_stack(VerificationType.category1_check);
                    current_frame.push_stack(type);
                    current_frame.push_stack(type2);
                    no_control_flow = false;
                    break;
                }
                case 96: 
                case 100: 
                case 104: 
                case 108: 
                case 112: 
                case 120: 
                case 122: 
                case 124: 
                case 126: 
                case 128: 
                case 130: {
                    current_frame.pop_stack(VerificationType.integer_type);
                }
                case 116: {
                    current_frame.pop_stack(VerificationType.integer_type);
                    current_frame.push_stack(VerificationType.integer_type);
                    no_control_flow = false;
                    break;
                }
                case 97: 
                case 101: 
                case 105: 
                case 109: 
                case 113: 
                case 127: 
                case 129: 
                case 131: {
                    current_frame.pop_stack_2(VerificationType.long2_type, VerificationType.long_type);
                }
                case 117: {
                    current_frame.pop_stack_2(VerificationType.long2_type, VerificationType.long_type);
                    current_frame.push_stack_2(VerificationType.long_type, VerificationType.long2_type);
                    no_control_flow = false;
                    break;
                }
                case 121: 
                case 123: 
                case 125: {
                    current_frame.pop_stack(VerificationType.integer_type);
                    current_frame.pop_stack_2(VerificationType.long2_type, VerificationType.long_type);
                    current_frame.push_stack_2(VerificationType.long_type, VerificationType.long2_type);
                    no_control_flow = false;
                    break;
                }
                case 98: 
                case 102: 
                case 106: 
                case 110: 
                case 114: {
                    current_frame.pop_stack(VerificationType.float_type);
                }
                case 118: {
                    current_frame.pop_stack(VerificationType.float_type);
                    current_frame.push_stack(VerificationType.float_type);
                    no_control_flow = false;
                    break;
                }
                case 99: 
                case 103: 
                case 107: 
                case 111: 
                case 115: {
                    current_frame.pop_stack_2(VerificationType.double2_type, VerificationType.double_type);
                }
                case 119: {
                    current_frame.pop_stack_2(VerificationType.double2_type, VerificationType.double_type);
                    current_frame.push_stack_2(VerificationType.double_type, VerificationType.double2_type);
                    no_control_flow = false;
                    break;
                }
                case 132: {
                    this.verify_iinc(bcs.getIndex(), current_frame);
                    no_control_flow = false;
                    break;
                }
                case 133: {
                    VerificationType type = current_frame.pop_stack(VerificationType.integer_type);
                    current_frame.push_stack_2(VerificationType.long_type, VerificationType.long2_type);
                    no_control_flow = false;
                    break;
                }
                case 136: {
                    current_frame.pop_stack_2(VerificationType.long2_type, VerificationType.long_type);
                    current_frame.push_stack(VerificationType.integer_type);
                    no_control_flow = false;
                    break;
                }
                case 134: {
                    current_frame.pop_stack(VerificationType.integer_type);
                    current_frame.push_stack(VerificationType.float_type);
                    no_control_flow = false;
                    break;
                }
                case 135: {
                    current_frame.pop_stack(VerificationType.integer_type);
                    current_frame.push_stack_2(VerificationType.double_type, VerificationType.double2_type);
                    no_control_flow = false;
                    break;
                }
                case 137: {
                    current_frame.pop_stack_2(VerificationType.long2_type, VerificationType.long_type);
                    current_frame.push_stack(VerificationType.float_type);
                    no_control_flow = false;
                    break;
                }
                case 138: {
                    current_frame.pop_stack_2(VerificationType.long2_type, VerificationType.long_type);
                    current_frame.push_stack_2(VerificationType.double_type, VerificationType.double2_type);
                    no_control_flow = false;
                    break;
                }
                case 139: {
                    current_frame.pop_stack(VerificationType.float_type);
                    current_frame.push_stack(VerificationType.integer_type);
                    no_control_flow = false;
                    break;
                }
                case 140: {
                    current_frame.pop_stack(VerificationType.float_type);
                    current_frame.push_stack_2(VerificationType.long_type, VerificationType.long2_type);
                    no_control_flow = false;
                    break;
                }
                case 141: {
                    current_frame.pop_stack(VerificationType.float_type);
                    current_frame.push_stack_2(VerificationType.double_type, VerificationType.double2_type);
                    no_control_flow = false;
                    break;
                }
                case 142: {
                    current_frame.pop_stack_2(VerificationType.double2_type, VerificationType.double_type);
                    current_frame.push_stack(VerificationType.integer_type);
                    no_control_flow = false;
                    break;
                }
                case 143: {
                    current_frame.pop_stack_2(VerificationType.double2_type, VerificationType.double_type);
                    current_frame.push_stack_2(VerificationType.long_type, VerificationType.long2_type);
                    no_control_flow = false;
                    break;
                }
                case 144: {
                    current_frame.pop_stack_2(VerificationType.double2_type, VerificationType.double_type);
                    current_frame.push_stack(VerificationType.float_type);
                    no_control_flow = false;
                    break;
                }
                case 145: 
                case 146: 
                case 147: {
                    current_frame.pop_stack(VerificationType.integer_type);
                    current_frame.push_stack(VerificationType.integer_type);
                    no_control_flow = false;
                    break;
                }
                case 148: {
                    current_frame.pop_stack_2(VerificationType.long2_type, VerificationType.long_type);
                    current_frame.pop_stack_2(VerificationType.long2_type, VerificationType.long_type);
                    current_frame.push_stack(VerificationType.integer_type);
                    no_control_flow = false;
                    break;
                }
                case 149: 
                case 150: {
                    current_frame.pop_stack(VerificationType.float_type);
                    current_frame.pop_stack(VerificationType.float_type);
                    current_frame.push_stack(VerificationType.integer_type);
                    no_control_flow = false;
                    break;
                }
                case 151: 
                case 152: {
                    current_frame.pop_stack_2(VerificationType.double2_type, VerificationType.double_type);
                    current_frame.pop_stack_2(VerificationType.double2_type, VerificationType.double_type);
                    current_frame.push_stack(VerificationType.integer_type);
                    no_control_flow = false;
                    break;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    current_frame.pop_stack(VerificationType.integer_type);
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: {
                    current_frame.pop_stack(VerificationType.integer_type);
                    int target = bcs.dest();
                    stackmap_table.check_jump_target(current_frame, target);
                    no_control_flow = false;
                    break;
                }
                case 165: 
                case 166: {
                    current_frame.pop_stack(VerificationType.reference_check);
                }
                case 198: 
                case 199: {
                    current_frame.pop_stack(VerificationType.reference_check);
                    int target = bcs.dest();
                    stackmap_table.check_jump_target(current_frame, target);
                    no_control_flow = false;
                    break;
                }
                case 167: {
                    int target = bcs.dest();
                    stackmap_table.check_jump_target(current_frame, target);
                    no_control_flow = true;
                    break;
                }
                case 200: {
                    int target = bcs.destW();
                    stackmap_table.check_jump_target(current_frame, target);
                    no_control_flow = true;
                    break;
                }
                case 170: 
                case 171: {
                    this.verify_switch(bcs, code_length, code_data, current_frame, stackmap_table);
                    no_control_flow = true;
                    break;
                }
                case 172: {
                    VerificationType type = current_frame.pop_stack(VerificationType.integer_type);
                    this.verify_return_value(return_type, type, this.bci, current_frame);
                    no_control_flow = true;
                    break;
                }
                case 173: {
                    type2 = current_frame.pop_stack(VerificationType.long2_type);
                    VerificationType type = current_frame.pop_stack(VerificationType.long_type);
                    this.verify_return_value(return_type, type, this.bci, current_frame);
                    no_control_flow = true;
                    break;
                }
                case 174: {
                    VerificationType type = current_frame.pop_stack(VerificationType.float_type);
                    this.verify_return_value(return_type, type, this.bci, current_frame);
                    no_control_flow = true;
                    break;
                }
                case 175: {
                    type2 = current_frame.pop_stack(VerificationType.double2_type);
                    VerificationType type = current_frame.pop_stack(VerificationType.double_type);
                    this.verify_return_value(return_type, type, this.bci, current_frame);
                    no_control_flow = true;
                    break;
                }
                case 176: {
                    VerificationType type = current_frame.pop_stack(VerificationType.reference_check);
                    this.verify_return_value(return_type, type, this.bci, current_frame);
                    no_control_flow = true;
                    break;
                }
                case 177: {
                    if (!return_type.is_bogus()) {
                        this.verifyError("Method expects a return value");
                    }
                    if (object_initializer_name.equals(this._method.name()) && current_frame.flag_this_uninit()) {
                        this.verifyError("Constructor must call super() or this() before return");
                    }
                    no_control_flow = true;
                    break;
                }
                case 178: 
                case 179: {
                    this.verify_field_instructions(bcs, current_frame, cp, true);
                    no_control_flow = false;
                    break;
                }
                case 180: 
                case 181: {
                    this.verify_field_instructions(bcs, current_frame, cp, false);
                    no_control_flow = false;
                    break;
                }
                case 182: 
                case 183: 
                case 184: {
                    this_uninit = this.verify_invoke_instructions(bcs, code_length, current_frame, this.bci >= ex_minmax[0] && this.bci < ex_minmax[1], this_uninit, return_type, cp, stackmap_table);
                    no_control_flow = false;
                    break;
                }
                case 185: 
                case 186: {
                    this_uninit = this.verify_invoke_instructions(bcs, code_length, current_frame, this.bci >= ex_minmax[0] && this.bci < ex_minmax[1], this_uninit, return_type, cp, stackmap_table);
                    no_control_flow = false;
                    break;
                }
                case 187: {
                    int index = bcs.getIndexU2();
                    this.verify_cp_class_type(this.bci, index, cp);
                    VerificationType new_class_type = this.cp_index_to_type(index, cp);
                    if (!new_class_type.is_object()) {
                        this.verifyError("Illegal new instruction");
                    }
                    VerificationType type = VerificationType.uninitialized_type(this.bci);
                    current_frame.push_stack(type);
                    no_control_flow = false;
                    break;
                }
                case 188: {
                    VerificationType type = this.get_newarray_type(bcs.getIndex(), this.bci);
                    current_frame.pop_stack(VerificationType.integer_type);
                    current_frame.push_stack(type);
                    no_control_flow = false;
                    break;
                }
                case 189: {
                    this.verify_anewarray(this.bci, bcs.getIndexU2(), cp, current_frame);
                    no_control_flow = false;
                    break;
                }
                case 190: {
                    VerificationType type = current_frame.pop_stack(VerificationType.reference_check);
                    if (!type.is_null() && !type.is_array()) {
                        this.verifyError("Bad type");
                    }
                    current_frame.push_stack(VerificationType.integer_type);
                    no_control_flow = false;
                    break;
                }
                case 192: {
                    int index = bcs.getIndexU2();
                    this.verify_cp_class_type(this.bci, index, cp);
                    current_frame.pop_stack(this.object_type());
                    VerificationType klass_type = this.cp_index_to_type(index, cp);
                    current_frame.push_stack(klass_type);
                    no_control_flow = false;
                    break;
                }
                case 193: {
                    int index = bcs.getIndexU2();
                    this.verify_cp_class_type(this.bci, index, cp);
                    current_frame.pop_stack(this.object_type());
                    current_frame.push_stack(VerificationType.integer_type);
                    no_control_flow = false;
                    break;
                }
                case 194: 
                case 195: {
                    current_frame.pop_stack(VerificationType.reference_check);
                    no_control_flow = false;
                    break;
                }
                case 197: {
                    int index = bcs.getIndexU2();
                    int dim = this._method.codeArray()[bcs.bci + 3] & 0xFF;
                    this.verify_cp_class_type(this.bci, index, cp);
                    VerificationType new_array_type = this.cp_index_to_type(index, cp);
                    if (!new_array_type.is_array()) {
                        this.verifyError("Illegal constant pool index in multianewarray instruction");
                    }
                    if (dim < 1 || new_array_type.dimensions(this) < dim) {
                        this.verifyError(String.format("Illegal dimension in multianewarray instruction: %d", dim));
                    }
                    for (int i = 0; i < dim; ++i) {
                        current_frame.pop_stack(VerificationType.integer_type);
                    }
                    current_frame.push_stack(new_array_type);
                    no_control_flow = false;
                    break;
                }
                case 191: {
                    VerificationType type = VerificationType.reference_type(java_lang_Throwable);
                    current_frame.pop_stack(type);
                    no_control_flow = true;
                    break;
                }
                default: {
                    this.verifyError(String.format("Bad instruction: %02x", opcode));
                }
            }
            if (verified_exc_handlers && this_uninit) {
                this.verifyError("Exception handler targets got verified before this_uninit got set");
            }
            if (verified_exc_handlers || this.bci < ex_minmax[0] || this.bci >= ex_minmax[1]) continue;
            this.verify_exception_handler_targets(this.bci, this_uninit, current_frame, stackmap_table);
        }
        if (!no_control_flow) {
            this.verifyError("Control flow falls through code end");
        }
    }

    private byte[] generate_code_data(ByteBuffer code, int code_length) {
        byte[] code_data = new byte[code_length];
        RawBytecodeHelper bcs = new RawBytecodeHelper(code);
        while (!bcs.isLastBytecode()) {
            if (bcs.rawNext() != -1) {
                int bci = bcs.bci;
                if (bcs.rawCode == 187) {
                    code_data[bci] = 2;
                    continue;
                }
                code_data[bci] = 1;
                continue;
            }
            this.verifyError("Bad instruction");
        }
        return code_data;
    }

    void verify_exception_handler_table(int code_length, byte[] code_data, int[] minmax) {
        VerificationWrapper.ConstantPoolWrapper cp = this._method.constantPool();
        for (int[] exhandler : this._method.exceptionTable()) {
            int catch_type_index;
            int start_pc = exhandler[0];
            int end_pc = exhandler[1];
            int handler_pc = exhandler[2];
            if (start_pc >= code_length || code_data[start_pc] == 0) {
                this.classError(String.format("Illegal exception table start_pc %d", start_pc));
            }
            if (end_pc != code_length && (end_pc > code_length || code_data[end_pc] == 0)) {
                this.classError(String.format("Illegal exception table end_pc %d", end_pc));
            }
            if (handler_pc >= code_length || code_data[handler_pc] == 0) {
                this.classError(String.format("Illegal exception table handler_pc %d", handler_pc));
            }
            if ((catch_type_index = exhandler[3]) != 0) {
                VerificationType catch_type = this.cp_index_to_type(catch_type_index, cp);
                VerificationType throwable = VerificationType.reference_type(java_lang_Throwable);
                boolean is_subclass = throwable.is_assignable_from(catch_type, this);
                if (!is_subclass) {
                    this.verifyError(String.format("Catch type is not a subclass of Throwable in exception handler %d", handler_pc));
                }
            }
            if (start_pc < minmax[0]) {
                minmax[0] = start_pc;
            }
            if (end_pc <= minmax[1]) continue;
            minmax[1] = end_pc;
        }
    }

    void verify_local_variable_table(int code_length, byte[] code_data) {
        for (LocalVariableInfo lvte : this._method.localVariableTable()) {
            int end_bci;
            int start_bci = lvte.startPc();
            int length = lvte.length();
            if (start_bci >= code_length || code_data[start_bci] == 0) {
                this.classError(String.format("Illegal local variable table start_pc %d", start_bci));
            }
            if ((end_bci = start_bci + length) == code_length || end_bci < code_length && code_data[end_bci] != 0) continue;
            this.classError(String.format("Illegal local variable table length %d", length));
        }
    }

    int verify_stackmap_table(int stackmap_index, int bci, VerificationFrame current_frame, VerificationTable stackmap_table, boolean no_control_flow) {
        if (stackmap_index < stackmap_table.get_frame_count()) {
            int this_offset = stackmap_table.get_offset(stackmap_index);
            if (no_control_flow && this_offset > bci) {
                this.verifyError("Expecting a stack map frame");
            }
            if (this_offset == bci) {
                boolean matches = stackmap_table.match_stackmap(current_frame, this_offset, stackmap_index, !no_control_flow, true);
                if (!matches) {
                    this.verifyError("Instruction type does not match stack map");
                }
                ++stackmap_index;
            } else if (this_offset < bci) {
                this.classError(String.format("Bad stack map offset %d", this_offset));
            }
        } else if (no_control_flow) {
            this.verifyError("Expecting a stack map frame");
        }
        return stackmap_index;
    }

    void verify_exception_handler_targets(int bci, boolean this_uninit, VerificationFrame current_frame, VerificationTable stackmap_table) {
        VerificationWrapper.ConstantPoolWrapper cp = this._method.constantPool();
        for (int[] exhandler : this._method.exceptionTable()) {
            boolean matches;
            int start_pc = exhandler[0];
            int end_pc = exhandler[1];
            int handler_pc = exhandler[2];
            int catch_type_index = exhandler[3];
            if (bci < start_pc || bci >= end_pc) continue;
            int flags = current_frame.flags();
            if (this_uninit) {
                flags |= 1;
            }
            VerificationFrame new_frame = current_frame.frame_in_exception_handler(flags);
            if (catch_type_index != 0) {
                VerificationType catch_type = this.cp_index_to_type(catch_type_index, cp);
                new_frame.push_stack(catch_type);
            } else {
                VerificationType throwable = VerificationType.reference_type(java_lang_Throwable);
                new_frame.push_stack(throwable);
            }
            if (matches = stackmap_table.match_stackmap(new_frame, handler_pc, true, false)) continue;
            this.verifyError(String.format("Stack map does not match the one at exception handler %d", handler_pc));
        }
    }

    void verify_cp_index(int bci, VerificationWrapper.ConstantPoolWrapper cp, int index) {
        int nconstants = cp.entryCount();
        if (index <= 0 || index >= nconstants) {
            this.verifyError(String.format("Illegal constant pool index %d", index));
        }
    }

    void verify_cp_type(int bci, int index, VerificationWrapper.ConstantPoolWrapper cp, int types) {
        this.verify_cp_index(bci, cp, index);
        int tag = cp.tagAt(index);
        if ((types & 1 << tag) == 0) {
            this.verifyError(String.format("Illegal type at constant pool entry %d", index));
        }
    }

    void verify_cp_class_type(int bci, int index, VerificationWrapper.ConstantPoolWrapper cp) {
        this.verify_cp_index(bci, cp, index);
        int tag = cp.tagAt(index);
        if (tag != 7) {
            this.verifyError(String.format("Illegal type at constant pool entry %d", index));
        }
    }

    void verify_ldc(int opcode, int index, VerificationFrame current_frame, VerificationWrapper.ConstantPoolWrapper cp, int bci) {
        this.verify_cp_index(bci, cp, index);
        int tag = cp.tagAt(index);
        int types = 0;
        if (opcode == 18 || opcode == 19) {
            types = 229784;
            this.verify_cp_type(bci, index, cp, types);
        } else {
            if (opcode != 20) {
                this.verifyError("must be ldc2_w");
            }
            types = 131168;
            this.verify_cp_type(bci, index, cp, types);
        }
        switch (tag) {
            case 1: {
                current_frame.push_stack(this.object_type());
                break;
            }
            case 8: {
                current_frame.push_stack(VerificationType.reference_type(java_lang_String));
                break;
            }
            case 7: {
                current_frame.push_stack(VerificationType.reference_type(java_lang_Class));
                break;
            }
            case 3: {
                current_frame.push_stack(VerificationType.integer_type);
                break;
            }
            case 4: {
                current_frame.push_stack(VerificationType.float_type);
                break;
            }
            case 6: {
                current_frame.push_stack_2(VerificationType.double_type, VerificationType.double2_type);
                break;
            }
            case 5: {
                current_frame.push_stack_2(VerificationType.long_type, VerificationType.long2_type);
                break;
            }
            case 15: {
                current_frame.push_stack(VerificationType.reference_type(java_lang_invoke_MethodHandle));
                break;
            }
            case 16: {
                current_frame.push_stack(VerificationType.reference_type(java_lang_invoke_MethodType));
                break;
            }
            case 17: {
                int opcode_n;
                String constant_type = cp.dynamicConstantSignatureAt(index);
                if (!VerificationSignature.isValidTypeSignature(constant_type)) {
                    this.verifyError("Invalid type for dynamic constant");
                }
                VerificationType[] v_constant_type = new VerificationType[2];
                VerificationSignature sig_stream = new VerificationSignature(constant_type, false, this);
                int n = this.change_sig_to_verificationType(sig_stream, v_constant_type, 0);
                int n2 = opcode_n = opcode == 20 ? 2 : 1;
                if (n != opcode_n) {
                    this.verify_cp_type(bci, index, cp, types &= 0xFFFDFFFF);
                }
                for (int i = 0; i < n; ++i) {
                    current_frame.push_stack(v_constant_type[i]);
                }
                break;
            }
            default: {
                this.verifyError("Invalid index in ldc");
            }
        }
    }

    void verify_switch(RawBytecodeHelper bcs, int code_length, byte[] code_data, VerificationFrame current_frame, VerificationTable stackmap_table) {
        int delta;
        int keys;
        int bci = bcs.bci;
        int aligned_bci = VerificationBytecodes.align(bci + 1);
        if (this._klass.majorVersion() < 51) {
            int padding_offset = 1;
            while (bci + padding_offset < aligned_bci) {
                if (this._method.codeArray()[bci + padding_offset] != 0) {
                    this.verifyError("Nonzero padding byte in lookupswitch or tableswitch");
                }
                ++padding_offset;
            }
        }
        int default_ofset = bcs.getInt(aligned_bci);
        current_frame.pop_stack(VerificationType.integer_type);
        if (bcs.rawCode == 170) {
            int high;
            int low = bcs.getInt(aligned_bci + 4);
            if (low > (high = bcs.getInt(aligned_bci + 8))) {
                this.verifyError("low must be less than or equal to high in tableswitch");
            }
            if ((keys = high - low + 1) < 0) {
                this.verifyError("too many keys in tableswitch");
            }
            delta = 1;
        } else {
            keys = bcs.getInt(aligned_bci + 4);
            if (keys < 0) {
                this.verifyError("number of keys in lookupswitch less than 0");
            }
            delta = 2;
            for (int i = 0; i < keys - 1; ++i) {
                int next_key;
                int this_key = bcs.getInt(aligned_bci + (2 + 2 * i) * 4);
                if (this_key < (next_key = bcs.getInt(aligned_bci + (2 + 2 * i + 2) * 4))) continue;
                this.verifyError("Bad lookupswitch instruction");
            }
        }
        int target = bci + default_ofset;
        stackmap_table.check_jump_target(current_frame, target);
        for (int i = 0; i < keys; ++i) {
            aligned_bci = VerificationBytecodes.align(bcs.bci + 1);
            target = bci + bcs.getInt(aligned_bci + (3 + i * delta) * 4);
            stackmap_table.check_jump_target(current_frame, target);
        }
    }

    void verify_field_instructions(RawBytecodeHelper bcs, VerificationFrame current_frame, VerificationWrapper.ConstantPoolWrapper cp, boolean allow_arrays) {
        VerificationType ref_class_type;
        int index = bcs.getIndexU2();
        this.verify_cp_type(bcs.bci, index, cp, 512);
        String field_name = cp.refNameAt(index);
        String field_sig = cp.refSignatureAt(index);
        if (!VerificationSignature.isValidTypeSignature(field_sig)) {
            this.verifyError("Invalid field signature");
        }
        if (!((ref_class_type = this.cp_ref_index_to_type(index, cp)).is_object() || allow_arrays && ref_class_type.is_array())) {
            this.verifyError(String.format("Expecting reference to class in class %s at constant pool index %d", this._klass.thisClassName(), index));
        }
        VerificationType target_class_type = ref_class_type;
        VerificationType[] field_type = new VerificationType[2];
        VerificationSignature sig_stream = new VerificationSignature(field_sig, false, this);
        VerificationType stack_object_type = null;
        int n = this.change_sig_to_verificationType(sig_stream, field_type, 0);
        switch (bcs.rawCode) {
            case 178: {
                for (int i = 0; i < n; ++i) {
                    current_frame.push_stack(field_type[i]);
                }
                break;
            }
            case 179: {
                for (int i = n - 1; i >= 0; --i) {
                    current_frame.pop_stack(field_type[i]);
                }
                break;
            }
            case 180: {
                stack_object_type = current_frame.pop_stack(target_class_type);
                for (int i = 0; i < n; ++i) {
                    current_frame.push_stack(field_type[i]);
                }
                break;
            }
            case 181: {
                boolean is_assignable;
                for (int i = n - 1; i >= 0; --i) {
                    current_frame.pop_stack(field_type[i]);
                }
                stack_object_type = current_frame.pop_stack();
                if (stack_object_type.is_uninitialized_this(this) && target_class_type.equals(this.current_type()) && this._klass.findField(field_name, field_sig)) {
                    stack_object_type = this.current_type();
                }
                if (is_assignable = target_class_type.is_assignable_from(stack_object_type, this)) break;
                this.verifyError("Bad type on operand stack in putfield");
                break;
            }
            default: {
                this.verifyError("Should not reach here");
            }
        }
    }

    boolean ends_in_athrow(int start_bc_offset) {
        this.log_info("unimplemented VerifierImpl.ends_in_athrow", new Object[0]);
        return true;
    }

    boolean verify_invoke_init(RawBytecodeHelper bcs, int ref_class_index, VerificationType ref_class_type, VerificationFrame current_frame, int code_length, boolean in_try_block, boolean this_uninit, VerificationWrapper.ConstantPoolWrapper cp, VerificationTable stackmap_table) {
        int bci = bcs.bci;
        VerificationType type = current_frame.pop_stack(VerificationType.reference_check);
        if (type.is_uninitialized_this(this)) {
            String superk_name = this.current_class().superclassName();
            if (!this.current_class().thisClassName().equals(ref_class_type.name()) && !superk_name.equals(ref_class_type.name())) {
                this.verifyError("Bad <init> method call");
            }
            if (in_try_block) {
                for (int[] exhandler : this._method.exceptionTable()) {
                    int start_pc = exhandler[0];
                    int end_pc = exhandler[1];
                    if (bci < start_pc || bci >= end_pc || this.ends_in_athrow(exhandler[2])) continue;
                    this.verifyError("Bad <init> method call from after the start of a try block");
                }
                this.verify_exception_handler_targets(bci, true, current_frame, stackmap_table);
            }
            current_frame.initialize_object(type, this.current_type());
            this_uninit = true;
        } else if (type.is_uninitialized()) {
            int new_offset = type.bci(this);
            if (new_offset > code_length - 3 || (this._method.codeArray()[new_offset] & 0xFF) != 187) {
                this.verifyError("Expecting new instruction");
            }
            int new_class_index = bcs.getIndexU2Raw(new_offset + 1);
            this.verify_cp_class_type(bci, new_class_index, cp);
            VerificationType new_class_type = this.cp_index_to_type(new_class_index, cp);
            if (!new_class_type.equals(ref_class_type)) {
                this.verifyError("Call to wrong <init> method");
            }
            if (in_try_block) {
                this.verify_exception_handler_targets(bci, this_uninit, current_frame, stackmap_table);
            }
            current_frame.initialize_object(type, new_class_type);
        } else {
            this.verifyError("Bad operand type when invoking <init>");
        }
        return this_uninit;
    }

    static boolean is_same_or_direct_interface(VerificationWrapper klass, VerificationType klass_type, VerificationType ref_class_type) {
        if (ref_class_type.equals(klass_type)) {
            return true;
        }
        for (String k_name : klass.interfaceNames()) {
            if (!ref_class_type.equals(VerificationType.reference_type(k_name))) continue;
            return true;
        }
        return false;
    }

    boolean verify_invoke_instructions(RawBytecodeHelper bcs, int code_length, VerificationFrame current_frame, boolean in_try_block, boolean this_uninit, VerificationType return_type, VerificationWrapper.ConstantPoolWrapper cp, VerificationTable stackmap_table) {
        int sig_verif_types_len;
        ArrayList<VerificationType> sig_verif_types;
        int index = bcs.getIndexU2();
        int opcode = bcs.rawCode;
        int types = 0;
        switch (opcode) {
            case 185: {
                types = 2048;
                break;
            }
            case 186: {
                types = 262144;
                break;
            }
            case 183: 
            case 184: {
                types = this._klass.majorVersion() < 52 ? 1024 : 3072;
                break;
            }
            default: {
                types = 1024;
            }
        }
        this.verify_cp_type(bcs.bci, index, cp, types);
        String method_name = cp.refNameAt(index);
        String method_sig = cp.refSignatureAt(index);
        if (!VerificationSignature.isValidMethodSignature(method_sig)) {
            this.verifyError("Invalid method signature");
        }
        VerificationType ref_class_type = null;
        if (opcode == 186) {
            if (this._klass.majorVersion() < 51) {
                this.classError(String.format("invokedynamic instructions not supported by this class file version (%d), class %s", this._klass.majorVersion(), this._klass.thisClassName()));
            }
        } else {
            ref_class_type = this.cp_ref_index_to_type(index, cp);
        }
        String sig = cp.refSignatureAt(index);
        ArrayList<VerificationType> verif_types = new ArrayList<VerificationType>(10);
        sig_as_verification_types mth_sig_verif_types = new sig_as_verification_types(verif_types);
        this.create_method_sig_entry(mth_sig_verif_types, sig);
        int nargs = mth_sig_verif_types.num_args();
        int bci = bcs.bci;
        if (opcode == 185) {
            if ((this._method.codeArray()[bci + 3] & 0xFF) != nargs + 1) {
                this.verifyError("Inconsistent args count operand in invokeinterface");
            }
            if ((this._method.codeArray()[bci + 4] & 0xFF) != 0) {
                this.verifyError("Fourth operand byte of invokeinterface must be zero");
            }
        }
        if (opcode == 186 && ((this._method.codeArray()[bci + 3] & 0xFF) != 0 || (this._method.codeArray()[bci + 4] & 0xFF) != 0)) {
            this.verifyError("Third and fourth operand bytes of invokedynamic must be zero");
        }
        if (method_name.charAt(0) == '<') {
            if (opcode != 183 || !object_initializer_name.equals(method_name)) {
                this.verifyError("Illegal call to internal method");
            }
        } else if (opcode == 183 && !VerifierImpl.is_same_or_direct_interface(this.current_class(), this.current_type(), ref_class_type) && !ref_class_type.equals(VerificationType.reference_type(this.current_class().superclassName()))) {
            boolean have_imr_indirect = cp.tagAt(index) == 11;
            boolean subtype = ref_class_type.is_assignable_from(this.current_type(), this);
            if (!subtype) {
                this.verifyError("Bad invokespecial instruction: current class isn't assignable to reference class.");
            } else if (have_imr_indirect) {
                this.verifyError("Bad invokespecial instruction: interface method reference is in an indirect superinterface.");
            }
        }
        if ((sig_verif_types = mth_sig_verif_types.sig_verif_types()) == null) {
            this.verifyError("Missing signature's array of verification types");
        }
        for (int i = nargs - 1; i >= 0; --i) {
            current_frame.pop_stack(sig_verif_types.get(i));
        }
        if (opcode != 184 && opcode != 186) {
            if (object_initializer_name.equals(method_name)) {
                this_uninit = this.verify_invoke_init(bcs, index, ref_class_type, current_frame, code_length, in_try_block, this_uninit, cp, stackmap_table);
            } else {
                switch (opcode) {
                    case 183: {
                        current_frame.pop_stack(this.current_type());
                        break;
                    }
                    case 182: {
                        VerificationType stack_object_type = current_frame.pop_stack(ref_class_type);
                        if (this.current_type() == stack_object_type) break;
                        cp.classNameAt(cp.refClassIndexAt(index));
                        break;
                    }
                    default: {
                        if (opcode != 185) {
                            this.verifyError("Unexpected opcode encountered");
                        }
                        current_frame.pop_stack(ref_class_type);
                    }
                }
            }
        }
        if ((sig_verif_types_len = sig_verif_types.size()) > nargs) {
            if (object_initializer_name.equals(method_name)) {
                this.verifyError("Return type must be void in <init> method");
            }
            if (sig_verif_types_len > nargs + 2) {
                this.verifyError("Signature verification types array return type is bogus");
            }
            for (int i = nargs; i < sig_verif_types_len; ++i) {
                if (i != nargs && !sig_verif_types.get(i).is_long2() && !sig_verif_types.get(i).is_double2()) {
                    this.verifyError("Unexpected return verificationType");
                }
                current_frame.push_stack(sig_verif_types.get(i));
            }
        }
        return this_uninit;
    }

    VerificationType get_newarray_type(int index, int bci) {
        String[] from_bt = new String[]{null, null, null, null, "[Z", "[C", "[F", "[D", "[B", "[S", "[I", "[J"};
        if (index < VerificationSignature.BasicType.T_BOOLEAN.type || index > VerificationSignature.BasicType.T_LONG.type) {
            this.verifyError("Illegal newarray instruction");
        }
        String sig = from_bt[index];
        return VerificationType.reference_type(sig);
    }

    void verify_anewarray(int bci, int index, VerificationWrapper.ConstantPoolWrapper cp, VerificationFrame current_frame) {
        String arr_sig_str;
        this.verify_cp_class_type(bci, index, cp);
        current_frame.pop_stack(VerificationType.integer_type);
        VerificationType component_type = this.cp_index_to_type(index, cp);
        if (component_type.is_array()) {
            component_name = component_type.name();
            int length = component_name.length();
            if (length > 255 && component_name.charAt(254) == '[') {
                this.verifyError("Illegal anewarray instruction, array has more than 255 dimensions");
            }
            if ((arr_sig_str = String.format("%c%s", Character.valueOf('['), component_name)).length() != ++length) {
                this.verifyError("Unexpected number of characters in string");
            }
        } else {
            component_name = component_type.name();
            int length = component_name.length() + 3;
            arr_sig_str = String.format("%c%c%s;", Character.valueOf('['), Character.valueOf('L'), component_name);
            if (arr_sig_str.length() != length) {
                this.verifyError("Unexpected number of characters in string");
            }
        }
        VerificationType new_array_type = VerificationType.reference_type(arr_sig_str);
        current_frame.push_stack(new_array_type);
    }

    void verify_iload(int index, VerificationFrame current_frame) {
        current_frame.get_local(index, VerificationType.integer_type);
        current_frame.push_stack(VerificationType.integer_type);
    }

    void verify_lload(int index, VerificationFrame current_frame) {
        current_frame.get_local_2(index, VerificationType.long_type, VerificationType.long2_type);
        current_frame.push_stack_2(VerificationType.long_type, VerificationType.long2_type);
    }

    void verify_fload(int index, VerificationFrame current_frame) {
        current_frame.get_local(index, VerificationType.float_type);
        current_frame.push_stack(VerificationType.float_type);
    }

    void verify_dload(int index, VerificationFrame current_frame) {
        current_frame.get_local_2(index, VerificationType.double_type, VerificationType.double2_type);
        current_frame.push_stack_2(VerificationType.double_type, VerificationType.double2_type);
    }

    void verify_aload(int index, VerificationFrame current_frame) {
        VerificationType type = current_frame.get_local(index, VerificationType.reference_check);
        current_frame.push_stack(type);
    }

    void verify_istore(int index, VerificationFrame current_frame) {
        current_frame.pop_stack(VerificationType.integer_type);
        current_frame.set_local(index, VerificationType.integer_type);
    }

    void verify_lstore(int index, VerificationFrame current_frame) {
        current_frame.pop_stack_2(VerificationType.long2_type, VerificationType.long_type);
        current_frame.set_local_2(index, VerificationType.long_type, VerificationType.long2_type);
    }

    void verify_fstore(int index, VerificationFrame current_frame) {
        current_frame.pop_stack(VerificationType.float_type);
        current_frame.set_local(index, VerificationType.float_type);
    }

    void verify_dstore(int index, VerificationFrame current_frame) {
        current_frame.pop_stack_2(VerificationType.double2_type, VerificationType.double_type);
        current_frame.set_local_2(index, VerificationType.double_type, VerificationType.double2_type);
    }

    void verify_astore(int index, VerificationFrame current_frame) {
        VerificationType type = current_frame.pop_stack(VerificationType.reference_check);
        current_frame.set_local(index, type);
    }

    void verify_iinc(int index, VerificationFrame current_frame) {
        VerificationType type = current_frame.get_local(index, VerificationType.integer_type);
        current_frame.set_local(index, type);
    }

    void verify_return_value(VerificationType return_type, VerificationType type, int bci, VerificationFrame current_frame) {
        boolean match;
        if (return_type.is_bogus()) {
            this.verifyError("Method expects a return value");
        }
        if (!(match = return_type.is_assignable_from(type, this))) {
            this.verifyError("Bad return type");
        }
    }

    private void dumpMethod() {
        if (this._logger != null) {
            ClassPrinter.toTree(this._method.m, ClassPrinter.Verbosity.CRITICAL_ATTRIBUTES).toYaml(this._logger);
        }
    }

    void verifyError(String msg) {
        this.dumpMethod();
        throw new VerifyError(String.format("%s at %s.%s%s @%d %s", msg, this._klass.thisClassName(), this._method.name(), this._method.descriptor(), this.bci, this.errorContext));
    }

    void verifyError(String msg, VerificationFrame from, VerificationFrame target) {
        this.dumpMethod();
        throw new VerifyError(String.format("%s at %s.%s%s @%d %s%n  while assigning %s%n  to %s", msg, this._klass.thisClassName(), this._method.name(), this._method.descriptor(), this.bci, this.errorContext, from, target));
    }

    void classError(String msg) {
        this.dumpMethod();
        throw new ClassFormatError(String.format("%s at %s.%s%s", msg, this._klass.thisClassName(), this._method.name(), this._method.descriptor()));
    }

    static class sig_as_verification_types {
        private int _num_args;
        private ArrayList<VerificationType> _sig_verif_types;

        sig_as_verification_types(ArrayList<VerificationType> sig_verif_types) {
            this._sig_verif_types = sig_verif_types;
            this._num_args = 0;
        }

        int num_args() {
            return this._num_args;
        }

        void set_num_args(int num_args) {
            this._num_args = num_args;
        }

        ArrayList<VerificationType> sig_verif_types() {
            return this._sig_verif_types;
        }
    }
}

