/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.instruction;

import org.glavo.classfile.Instruction;
import org.glavo.classfile.Opcode;
import org.glavo.classfile.TypeKind;
import org.glavo.classfile.impl.AbstractInstruction;
import org.glavo.classfile.impl.BytecodeHelpers;
import org.glavo.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface StoreInstruction
extends Instruction {
    public int slot();

    public TypeKind typeKind();

    public static StoreInstruction of(TypeKind kind, int slot) {
        return StoreInstruction.of(BytecodeHelpers.storeOpcode(kind, slot), slot);
    }

    public static StoreInstruction of(Opcode op, int slot) {
        Util.checkKind(op, Opcode.Kind.STORE);
        return new AbstractInstruction.UnboundStoreInstruction(op, slot);
    }
}

