/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.util.Set;
import org.glavo.classfile.AccessFlag;
import org.glavo.classfile.ClassElement;
import org.glavo.classfile.FieldElement;
import org.glavo.classfile.MethodElement;
import org.glavo.classfile.impl.AccessFlagsImpl;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface AccessFlags
extends ClassElement,
MethodElement,
FieldElement {
    public int flagsMask();

    public Set<AccessFlag> flags();

    public boolean has(AccessFlag var1);

    public AccessFlag.Location location();

    public static AccessFlags ofClass(int mask) {
        return new AccessFlagsImpl(AccessFlag.Location.CLASS, mask);
    }

    public static AccessFlags ofClass(AccessFlag ... flags) {
        return new AccessFlagsImpl(AccessFlag.Location.CLASS, flags);
    }

    public static AccessFlags ofField(int mask) {
        return new AccessFlagsImpl(AccessFlag.Location.FIELD, mask);
    }

    public static AccessFlags ofField(AccessFlag ... flags) {
        return new AccessFlagsImpl(AccessFlag.Location.FIELD, flags);
    }

    public static AccessFlags ofMethod(int mask) {
        return new AccessFlagsImpl(AccessFlag.Location.METHOD, mask);
    }

    public static AccessFlags ofMethod(AccessFlag ... flags) {
        return new AccessFlagsImpl(AccessFlag.Location.METHOD, flags);
    }
}

