/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.lang.constant.ClassDesc;
import java.util.List;
import org.glavo.classfile.AnnotationElement;
import org.glavo.classfile.WritableElement;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AnnotationImpl;
import org.glavo.classfile.impl.TemporaryConstantPool;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Annotation
extends WritableElement<Annotation> {
    public Utf8Entry className();

    default public ClassDesc classSymbol() {
        return ClassDesc.ofDescriptor(this.className().stringValue());
    }

    public List<AnnotationElement> elements();

    public static Annotation of(Utf8Entry annotationClass, List<AnnotationElement> elements) {
        return new AnnotationImpl(annotationClass, elements);
    }

    public static Annotation of(Utf8Entry annotationClass, AnnotationElement ... elements) {
        return Annotation.of(annotationClass, List.of(elements));
    }

    public static Annotation of(ClassDesc annotationClass, List<AnnotationElement> elements) {
        return Annotation.of(TemporaryConstantPool.INSTANCE.utf8Entry(annotationClass.descriptorString()), elements);
    }

    public static Annotation of(ClassDesc annotationClass, AnnotationElement ... elements) {
        return Annotation.of(TemporaryConstantPool.INSTANCE.utf8Entry(annotationClass.descriptorString()), elements);
    }
}

