/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.glavo.classfile.Attribute;
import org.glavo.classfile.AttributeMapper;
import org.glavo.classfile.ClassFileElement;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface AttributedElement
extends ClassFileElement {
    public List<Attribute<?>> attributes();

    default public <T extends Attribute<T>> Optional<T> findAttribute(AttributeMapper<T> attr) {
        for (Attribute<?> la : this.attributes()) {
            if (la.attributeMapper() != attr) continue;
            Optional<Attribute<?>> res = Optional.of(la);
            return res;
        }
        return Optional.empty();
    }

    default public <T extends Attribute<T>> List<T> findAttributes(AttributeMapper<T> attr) {
        ArrayList list = new ArrayList();
        for (Attribute<?> a : this.attributes()) {
            if (a.attributeMapper() != attr) continue;
            Attribute<?> t = a;
            list.add(t);
        }
        return list;
    }
}

