/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.glavo.classfile.AccessFlag;
import org.glavo.classfile.AccessFlags;
import org.glavo.classfile.ClassElement;
import org.glavo.classfile.ClassFileBuilder;
import org.glavo.classfile.ClassFileVersion;
import org.glavo.classfile.ClassModel;
import org.glavo.classfile.CodeBuilder;
import org.glavo.classfile.FieldBuilder;
import org.glavo.classfile.FieldModel;
import org.glavo.classfile.FieldTransform;
import org.glavo.classfile.Interfaces;
import org.glavo.classfile.MethodBuilder;
import org.glavo.classfile.MethodModel;
import org.glavo.classfile.MethodTransform;
import org.glavo.classfile.Superclass;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClassBuilder
extends ClassFileBuilder<ClassElement, ClassBuilder> {
    public Optional<ClassModel> original();

    default public ClassBuilder withVersion(int major, int minor) {
        return (ClassBuilder)this.with(ClassFileVersion.of(major, minor));
    }

    default public ClassBuilder withFlags(int flags) {
        return (ClassBuilder)this.with(AccessFlags.ofClass(flags));
    }

    default public ClassBuilder withFlags(AccessFlag ... flags) {
        return (ClassBuilder)this.with(AccessFlags.ofClass(flags));
    }

    default public ClassBuilder withSuperclass(ClassEntry superclassEntry) {
        return (ClassBuilder)this.with(Superclass.of(superclassEntry));
    }

    default public ClassBuilder withSuperclass(ClassDesc desc) {
        return this.withSuperclass(this.constantPool().classEntry(desc));
    }

    default public ClassBuilder withInterfaces(List<ClassEntry> interfaces) {
        return (ClassBuilder)this.with(Interfaces.of(interfaces));
    }

    default public ClassBuilder withInterfaces(ClassEntry ... interfaces) {
        return this.withInterfaces(List.of(interfaces));
    }

    default public ClassBuilder withInterfaceSymbols(List<ClassDesc> interfaces) {
        return this.withInterfaces(Util.entryList(interfaces));
    }

    default public ClassBuilder withInterfaceSymbols(ClassDesc ... interfaces) {
        return this.withInterfaceSymbols(Arrays.asList(interfaces));
    }

    public ClassBuilder withField(Utf8Entry var1, Utf8Entry var2, Consumer<? super FieldBuilder> var3);

    default public ClassBuilder withField(Utf8Entry name, Utf8Entry descriptor, int flags) {
        return this.withField(name, descriptor, (? super FieldBuilder fb) -> fb.withFlags(flags));
    }

    default public ClassBuilder withField(String name, ClassDesc descriptor, Consumer<? super FieldBuilder> handler) {
        return this.withField(this.constantPool().utf8Entry(name), this.constantPool().utf8Entry(descriptor), handler);
    }

    default public ClassBuilder withField(String name, ClassDesc descriptor, int flags) {
        return this.withField(name, descriptor, (? super FieldBuilder fb) -> fb.withFlags(flags));
    }

    public ClassBuilder transformField(FieldModel var1, FieldTransform var2);

    public ClassBuilder withMethod(Utf8Entry var1, Utf8Entry var2, int var3, Consumer<? super MethodBuilder> var4);

    default public ClassBuilder withMethodBody(Utf8Entry name, Utf8Entry descriptor, int methodFlags, Consumer<? super CodeBuilder> handler) {
        return this.withMethod(name, descriptor, methodFlags, (? super MethodBuilder mb) -> mb.withCode(handler));
    }

    default public ClassBuilder withMethod(String name, MethodTypeDesc descriptor, int methodFlags, Consumer<? super MethodBuilder> handler) {
        return this.withMethod(this.constantPool().utf8Entry(name), this.constantPool().utf8Entry(descriptor), methodFlags, handler);
    }

    default public ClassBuilder withMethodBody(String name, MethodTypeDesc descriptor, int methodFlags, Consumer<? super CodeBuilder> handler) {
        return this.withMethodBody(this.constantPool().utf8Entry(name), this.constantPool().utf8Entry(descriptor), methodFlags, handler);
    }

    public ClassBuilder transformMethod(MethodModel var1, MethodTransform var2);
}

