/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.util.function.Consumer;
import org.glavo.classfile.ClassFileElement;
import org.glavo.classfile.ClassFileTransform;
import org.glavo.classfile.CompoundElement;
import org.glavo.classfile.constantpool.ConstantPool;
import org.glavo.classfile.constantpool.ConstantPoolBuilder;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClassFileBuilder<E extends ClassFileElement, B extends ClassFileBuilder<E, B>>
extends Consumer<E> {
    @Override
    default public void accept(E e) {
        this.with(e);
    }

    public B with(E var1);

    public ConstantPoolBuilder constantPool();

    default public boolean canWriteDirect(ConstantPool source) {
        return this.constantPool().canWriteDirect(source);
    }

    default public void transform(CompoundElement<E> model, ClassFileTransform<?, E, B> transform) {
        ClassFileBuilder builder = this;
        ClassFileTransform.ResolvedTransform<E> resolved = transform.resolve(builder);
        resolved.startHandler().run();
        model.forEachElement(resolved.consumer());
        resolved.endHandler().run();
    }
}

