/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

public enum ClassFileFormatVersion {
    RELEASE_0(45),
    RELEASE_1(45),
    RELEASE_2(46),
    RELEASE_3(47),
    RELEASE_4(48),
    RELEASE_5(49),
    RELEASE_6(50),
    RELEASE_7(51),
    RELEASE_8(52),
    RELEASE_9(53),
    RELEASE_10(54),
    RELEASE_11(55),
    RELEASE_12(56),
    RELEASE_13(57),
    RELEASE_14(58),
    RELEASE_15(59),
    RELEASE_16(60),
    RELEASE_17(61),
    RELEASE_18(62),
    RELEASE_19(63),
    RELEASE_20(64),
    RELEASE_21(65),
    RELEASE_22(66),
    RELEASE_23(67);

    private final int major;

    private ClassFileFormatVersion(int major) {
        this.major = major;
    }

    public static ClassFileFormatVersion latest() {
        return RELEASE_23;
    }

    public int major() {
        return this.major;
    }

    public static ClassFileFormatVersion valueOf(Runtime.Version rv) {
        return ClassFileFormatVersion.valueOf("RELEASE_" + rv.feature());
    }

    public Runtime.Version runtimeVersion() {
        if (this.compareTo(RELEASE_6) >= 0) {
            return Runtime.Version.parse(Integer.toString(this.ordinal()));
        }
        return null;
    }

    public static ClassFileFormatVersion fromMajor(int major) {
        if (major < 45 || major > ClassFileFormatVersion.latest().major()) {
            throw new IllegalArgumentException("Out of range major class file version " + major);
        }
        return ClassFileFormatVersion.values()[major - 44];
    }
}

