/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.io.InputStream;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.glavo.classfile.impl.ClassHierarchyImpl;
import org.glavo.classfile.impl.Util;

@FunctionalInterface
public interface ClassHierarchyResolver {
    public static ClassHierarchyResolver defaultResolver() {
        return ClassHierarchyImpl.DEFAULT_RESOLVER;
    }

    public ClassHierarchyInfo getClassInfo(ClassDesc var1);

    default public ClassHierarchyResolver orElse(final ClassHierarchyResolver other) {
        return new ClassHierarchyResolver(){

            @Override
            public ClassHierarchyInfo getClassInfo(ClassDesc classDesc) {
                ClassHierarchyInfo chi = ClassHierarchyResolver.this.getClassInfo(classDesc);
                if (chi == null) {
                    return other.getClassInfo(classDesc);
                }
                return chi;
            }
        };
    }

    default public ClassHierarchyResolver cached(Supplier<Map<ClassDesc, ClassHierarchyInfo>> cacheFactory) {
        return new ClassHierarchyImpl.CachedClassHierarchyResolver(this, cacheFactory.get());
    }

    default public ClassHierarchyResolver cached() {
        record Factory() implements Supplier<Map<ClassDesc, ClassHierarchyInfo>>
        {
            static final Factory INSTANCE = new Factory();

            @Override
            public Map<ClassDesc, ClassHierarchyInfo> get() {
                return new HashMap<ClassDesc, ClassHierarchyInfo>();
            }
        }
        return this.cached(Factory.INSTANCE);
    }

    public static ClassHierarchyResolver ofResourceParsing(Function<ClassDesc, InputStream> classStreamResolver) {
        return new ClassHierarchyImpl.ResourceParsingClassHierarchyResolver(classStreamResolver);
    }

    public static ClassHierarchyResolver ofResourceParsing(final ClassLoader loader) {
        return ClassHierarchyResolver.ofResourceParsing(new Function<ClassDesc, InputStream>(){

            @Override
            public InputStream apply(ClassDesc classDesc) {
                return loader.getResourceAsStream(Util.toInternalName(classDesc) + ".class");
            }
        });
    }

    public static ClassHierarchyResolver of(Collection<ClassDesc> interfaces, Map<ClassDesc, ClassDesc> classToSuperClass) {
        return new ClassHierarchyImpl.StaticClassHierarchyResolver(interfaces, classToSuperClass);
    }

    public static ClassHierarchyResolver ofClassLoading(final ClassLoader loader) {
        return new ClassHierarchyImpl.ClassLoadingClassHierarchyResolver(new Function<ClassDesc, Class<?>>(){

            @Override
            public Class<?> apply(ClassDesc cd) {
                try {
                    return Class.forName(Util.toBinaryName(cd), false, loader);
                }
                catch (ClassNotFoundException ex) {
                    return null;
                }
            }
        });
    }

    public static ClassHierarchyResolver ofClassLoading(final MethodHandles.Lookup lookup) {
        return new ClassHierarchyImpl.ClassLoadingClassHierarchyResolver(new Function<ClassDesc, Class<?>>(){

            @Override
            public Class<?> apply(ClassDesc cd) {
                try {
                    return (Class)cd.resolveConstantDesc(lookup);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalArgumentException(ex);
                }
                catch (ReflectiveOperationException ex) {
                    return null;
                }
            }
        });
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ClassHierarchyInfo {
        public static ClassHierarchyInfo ofClass(ClassDesc superClass) {
            return new ClassHierarchyImpl.ClassHierarchyInfoImpl(superClass, false);
        }

        public static ClassHierarchyInfo ofInterface() {
            return new ClassHierarchyImpl.ClassHierarchyInfoImpl(ConstantDescs.CD_Object, true);
        }
    }
}

