/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.util.List;
import java.util.Objects;
import org.glavo.classfile.Signature;
import org.glavo.classfile.impl.SignaturesImpl;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClassSignature {
    public List<Signature.TypeParam> typeParameters();

    public Signature.ClassTypeSig superclassSignature();

    public List<Signature.ClassTypeSig> superinterfaceSignatures();

    public String signatureString();

    public static ClassSignature of(Signature.ClassTypeSig superclassSignature, Signature.ClassTypeSig ... superinterfaceSignatures) {
        return ClassSignature.of(List.of(), superclassSignature, superinterfaceSignatures);
    }

    public static ClassSignature of(List<Signature.TypeParam> typeParameters, Signature.ClassTypeSig superclassSignature, Signature.ClassTypeSig ... superinterfaceSignatures) {
        return new SignaturesImpl.ClassSignatureImpl(Objects.requireNonNull(typeParameters), Objects.requireNonNull(superclassSignature), List.of(superinterfaceSignatures));
    }

    public static ClassSignature parseFrom(String classSignature) {
        return new SignaturesImpl(classSignature).parseClassSignature();
    }
}

