/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.glavo.classfile.ClassFileTransform;
import org.glavo.classfile.CodeBuilder;
import org.glavo.classfile.CodeElement;
import org.glavo.classfile.impl.TransformImpl;

@FunctionalInterface
public interface CodeTransform
extends ClassFileTransform<CodeTransform, CodeElement, CodeBuilder> {
    public static final CodeTransform ACCEPT_ALL = new CodeTransform(){

        @Override
        public void accept(CodeBuilder builder, CodeElement element) {
            builder.with(element);
        }
    };

    public static CodeTransform ofStateful(Supplier<CodeTransform> supplier) {
        return new TransformImpl.SupplierCodeTransform(supplier);
    }

    public static CodeTransform endHandler(final Consumer<CodeBuilder> finisher) {
        return new CodeTransform(){

            @Override
            public void accept(CodeBuilder builder, CodeElement element) {
                builder.with(element);
            }

            @Override
            public void atEnd(CodeBuilder builder) {
                finisher.accept(builder);
            }
        };
    }

    @Override
    default public CodeTransform andThen(CodeTransform t) {
        return new TransformImpl.ChainedCodeTransform(this, t);
    }

    @Override
    default public ClassFileTransform.ResolvedTransform<CodeElement> resolve(CodeBuilder builder) {
        return new TransformImpl.ResolvedTransformImpl<CodeElement>(e -> this.accept(builder, e), () -> this.atEnd(builder), () -> this.atStart(builder));
    }
}

