/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.glavo.classfile.ClassFileTransform;
import org.glavo.classfile.FieldBuilder;
import org.glavo.classfile.FieldElement;
import org.glavo.classfile.impl.TransformImpl;

@FunctionalInterface
public interface FieldTransform
extends ClassFileTransform<FieldTransform, FieldElement, FieldBuilder> {
    public static final FieldTransform ACCEPT_ALL = new FieldTransform(){

        @Override
        public void accept(FieldBuilder builder, FieldElement element) {
            builder.with(element);
        }
    };

    public static FieldTransform ofStateful(Supplier<FieldTransform> supplier) {
        return new TransformImpl.SupplierFieldTransform(supplier);
    }

    public static FieldTransform endHandler(final Consumer<FieldBuilder> finisher) {
        return new FieldTransform(){

            @Override
            public void accept(FieldBuilder builder, FieldElement element) {
                builder.with(element);
            }

            @Override
            public void atEnd(FieldBuilder builder) {
                finisher.accept(builder);
            }
        };
    }

    public static FieldTransform dropping(Predicate<FieldElement> filter) {
        return (b, e) -> {
            if (!filter.test((FieldElement)e)) {
                b.with(e);
            }
        };
    }

    @Override
    default public FieldTransform andThen(FieldTransform t) {
        return new TransformImpl.ChainedFieldTransform(this, t);
    }

    @Override
    default public ClassFileTransform.ResolvedTransform<FieldElement> resolve(FieldBuilder builder) {
        return new TransformImpl.ResolvedTransformImpl<FieldElement>(e -> this.accept(builder, e), () -> this.atEnd(builder), () -> this.atStart(builder));
    }
}

