/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.lang.constant.MethodTypeDesc;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.glavo.classfile.Signature;
import org.glavo.classfile.impl.SignaturesImpl;
import org.glavo.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface MethodSignature {
    public List<Signature.TypeParam> typeParameters();

    public List<Signature> arguments();

    public Signature result();

    public List<Signature.ThrowableSig> throwableSignatures();

    public String signatureString();

    public static MethodSignature of(MethodTypeDesc methodDescriptor) {
        Objects.requireNonNull(methodDescriptor);
        return new SignaturesImpl.MethodSignatureImpl(List.of(), List.of(), Signature.of(methodDescriptor.returnType()), Util.mappedList(methodDescriptor.parameterList(), Signature::of));
    }

    public static MethodSignature of(Signature result, Signature ... arguments) {
        return new SignaturesImpl.MethodSignatureImpl(List.of(), List.of(), Objects.requireNonNull(result), List.of(arguments));
    }

    public static MethodSignature of(List<Signature.TypeParam> typeParameters, List<Signature.ThrowableSig> exceptions, Signature result, Signature ... arguments) {
        return new SignaturesImpl.MethodSignatureImpl(List.copyOf((Collection)Objects.requireNonNull(typeParameters)), List.copyOf((Collection)Objects.requireNonNull(exceptions)), Objects.requireNonNull(result), List.of(arguments));
    }

    public static MethodSignature parseFrom(String methodSignature) {
        return new SignaturesImpl(methodSignature).parseMethodSignature();
    }
}

