/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import org.glavo.classfile.TypeKind;

public enum Opcode {
    NOP(0, 1, Kind.NOP),
    ACONST_NULL(1, 1, Kind.CONSTANT, TypeKind.ReferenceType, 0, ConstantDescs.NULL),
    ICONST_M1(2, 1, Kind.CONSTANT, TypeKind.IntType, 0, Integer.valueOf(-1)),
    ICONST_0(3, 1, Kind.CONSTANT, TypeKind.IntType, 0, Integer.valueOf(0)),
    ICONST_1(4, 1, Kind.CONSTANT, TypeKind.IntType, 0, Integer.valueOf(1)),
    ICONST_2(5, 1, Kind.CONSTANT, TypeKind.IntType, 0, Integer.valueOf(2)),
    ICONST_3(6, 1, Kind.CONSTANT, TypeKind.IntType, 0, Integer.valueOf(3)),
    ICONST_4(7, 1, Kind.CONSTANT, TypeKind.IntType, 0, Integer.valueOf(4)),
    ICONST_5(8, 1, Kind.CONSTANT, TypeKind.IntType, 0, Integer.valueOf(5)),
    LCONST_0(9, 1, Kind.CONSTANT, TypeKind.LongType, 0, Long.valueOf(0L)),
    LCONST_1(10, 1, Kind.CONSTANT, TypeKind.LongType, 0, Long.valueOf(1L)),
    FCONST_0(11, 1, Kind.CONSTANT, TypeKind.FloatType, 0, Float.valueOf(0.0f)),
    FCONST_1(12, 1, Kind.CONSTANT, TypeKind.FloatType, 0, Float.valueOf(1.0f)),
    FCONST_2(13, 1, Kind.CONSTANT, TypeKind.FloatType, 0, Float.valueOf(2.0f)),
    DCONST_0(14, 1, Kind.CONSTANT, TypeKind.DoubleType, 0, Double.valueOf(0.0)),
    DCONST_1(15, 1, Kind.CONSTANT, TypeKind.DoubleType, 0, Double.valueOf(1.0)),
    BIPUSH(16, 2, Kind.CONSTANT, TypeKind.ByteType),
    SIPUSH(17, 3, Kind.CONSTANT, TypeKind.ShortType),
    LDC(18, 2, Kind.CONSTANT),
    LDC_W(19, 3, Kind.CONSTANT),
    LDC2_W(20, 3, Kind.CONSTANT),
    ILOAD(21, 2, Kind.LOAD, TypeKind.IntType, -1),
    LLOAD(22, 2, Kind.LOAD, TypeKind.LongType, -1),
    FLOAD(23, 2, Kind.LOAD, TypeKind.FloatType, -1),
    DLOAD(24, 2, Kind.LOAD, TypeKind.DoubleType, -1),
    ALOAD(25, 2, Kind.LOAD, TypeKind.ReferenceType, -1),
    ILOAD_0(26, 1, Kind.LOAD, TypeKind.IntType, 0),
    ILOAD_1(27, 1, Kind.LOAD, TypeKind.IntType, 1),
    ILOAD_2(28, 1, Kind.LOAD, TypeKind.IntType, 2),
    ILOAD_3(29, 1, Kind.LOAD, TypeKind.IntType, 3),
    LLOAD_0(30, 1, Kind.LOAD, TypeKind.LongType, 0),
    LLOAD_1(31, 1, Kind.LOAD, TypeKind.LongType, 1),
    LLOAD_2(32, 1, Kind.LOAD, TypeKind.LongType, 2),
    LLOAD_3(33, 1, Kind.LOAD, TypeKind.LongType, 3),
    FLOAD_0(34, 1, Kind.LOAD, TypeKind.FloatType, 0),
    FLOAD_1(35, 1, Kind.LOAD, TypeKind.FloatType, 1),
    FLOAD_2(36, 1, Kind.LOAD, TypeKind.FloatType, 2),
    FLOAD_3(37, 1, Kind.LOAD, TypeKind.FloatType, 3),
    DLOAD_0(38, 1, Kind.LOAD, TypeKind.DoubleType, 0),
    DLOAD_1(39, 1, Kind.LOAD, TypeKind.DoubleType, 1),
    DLOAD_2(40, 1, Kind.LOAD, TypeKind.DoubleType, 2),
    DLOAD_3(41, 1, Kind.LOAD, TypeKind.DoubleType, 3),
    ALOAD_0(42, 1, Kind.LOAD, TypeKind.ReferenceType, 0),
    ALOAD_1(43, 1, Kind.LOAD, TypeKind.ReferenceType, 1),
    ALOAD_2(44, 1, Kind.LOAD, TypeKind.ReferenceType, 2),
    ALOAD_3(45, 1, Kind.LOAD, TypeKind.ReferenceType, 3),
    IALOAD(46, 1, Kind.ARRAY_LOAD, TypeKind.IntType),
    LALOAD(47, 1, Kind.ARRAY_LOAD, TypeKind.LongType),
    FALOAD(48, 1, Kind.ARRAY_LOAD, TypeKind.FloatType),
    DALOAD(49, 1, Kind.ARRAY_LOAD, TypeKind.DoubleType),
    AALOAD(50, 1, Kind.ARRAY_LOAD, TypeKind.ReferenceType),
    BALOAD(51, 1, Kind.ARRAY_LOAD, TypeKind.ByteType),
    CALOAD(52, 1, Kind.ARRAY_LOAD, TypeKind.CharType),
    SALOAD(53, 1, Kind.ARRAY_LOAD, TypeKind.ShortType),
    ISTORE(54, 2, Kind.STORE, TypeKind.IntType, -1),
    LSTORE(55, 2, Kind.STORE, TypeKind.LongType, -1),
    FSTORE(56, 2, Kind.STORE, TypeKind.FloatType, -1),
    DSTORE(57, 2, Kind.STORE, TypeKind.DoubleType, -1),
    ASTORE(58, 2, Kind.STORE, TypeKind.ReferenceType, -1),
    ISTORE_0(59, 1, Kind.STORE, TypeKind.IntType, 0),
    ISTORE_1(60, 1, Kind.STORE, TypeKind.IntType, 1),
    ISTORE_2(61, 1, Kind.STORE, TypeKind.IntType, 2),
    ISTORE_3(62, 1, Kind.STORE, TypeKind.IntType, 3),
    LSTORE_0(63, 1, Kind.STORE, TypeKind.LongType, 0),
    LSTORE_1(64, 1, Kind.STORE, TypeKind.LongType, 1),
    LSTORE_2(65, 1, Kind.STORE, TypeKind.LongType, 2),
    LSTORE_3(66, 1, Kind.STORE, TypeKind.LongType, 3),
    FSTORE_0(67, 1, Kind.STORE, TypeKind.FloatType, 0),
    FSTORE_1(68, 1, Kind.STORE, TypeKind.FloatType, 1),
    FSTORE_2(69, 1, Kind.STORE, TypeKind.FloatType, 2),
    FSTORE_3(70, 1, Kind.STORE, TypeKind.FloatType, 3),
    DSTORE_0(71, 1, Kind.STORE, TypeKind.DoubleType, 0),
    DSTORE_1(72, 1, Kind.STORE, TypeKind.DoubleType, 1),
    DSTORE_2(73, 1, Kind.STORE, TypeKind.DoubleType, 2),
    DSTORE_3(74, 1, Kind.STORE, TypeKind.DoubleType, 3),
    ASTORE_0(75, 1, Kind.STORE, TypeKind.ReferenceType, 0),
    ASTORE_1(76, 1, Kind.STORE, TypeKind.ReferenceType, 1),
    ASTORE_2(77, 1, Kind.STORE, TypeKind.ReferenceType, 2),
    ASTORE_3(78, 1, Kind.STORE, TypeKind.ReferenceType, 3),
    IASTORE(79, 1, Kind.ARRAY_STORE, TypeKind.IntType),
    LASTORE(80, 1, Kind.ARRAY_STORE, TypeKind.LongType),
    FASTORE(81, 1, Kind.ARRAY_STORE, TypeKind.FloatType),
    DASTORE(82, 1, Kind.ARRAY_STORE, TypeKind.DoubleType),
    AASTORE(83, 1, Kind.ARRAY_STORE, TypeKind.ReferenceType),
    BASTORE(84, 1, Kind.ARRAY_STORE, TypeKind.ByteType),
    CASTORE(85, 1, Kind.ARRAY_STORE, TypeKind.CharType),
    SASTORE(86, 1, Kind.ARRAY_STORE, TypeKind.ShortType),
    POP(87, 1, Kind.STACK),
    POP2(88, 1, Kind.STACK),
    DUP(89, 1, Kind.STACK),
    DUP_X1(90, 1, Kind.STACK),
    DUP_X2(91, 1, Kind.STACK),
    DUP2(92, 1, Kind.STACK),
    DUP2_X1(93, 1, Kind.STACK),
    DUP2_X2(94, 1, Kind.STACK),
    SWAP(95, 1, Kind.STACK),
    IADD(96, 1, Kind.OPERATOR, TypeKind.IntType),
    LADD(97, 1, Kind.OPERATOR, TypeKind.LongType),
    FADD(98, 1, Kind.OPERATOR, TypeKind.FloatType),
    DADD(99, 1, Kind.OPERATOR, TypeKind.DoubleType),
    ISUB(100, 1, Kind.OPERATOR, TypeKind.IntType),
    LSUB(101, 1, Kind.OPERATOR, TypeKind.LongType),
    FSUB(102, 1, Kind.OPERATOR, TypeKind.FloatType),
    DSUB(103, 1, Kind.OPERATOR, TypeKind.DoubleType),
    IMUL(104, 1, Kind.OPERATOR, TypeKind.IntType),
    LMUL(105, 1, Kind.OPERATOR, TypeKind.LongType),
    FMUL(106, 1, Kind.OPERATOR, TypeKind.FloatType),
    DMUL(107, 1, Kind.OPERATOR, TypeKind.DoubleType),
    IDIV(108, 1, Kind.OPERATOR, TypeKind.IntType),
    LDIV(109, 1, Kind.OPERATOR, TypeKind.LongType),
    FDIV(110, 1, Kind.OPERATOR, TypeKind.FloatType),
    DDIV(111, 1, Kind.OPERATOR, TypeKind.DoubleType),
    IREM(112, 1, Kind.OPERATOR, TypeKind.IntType),
    LREM(113, 1, Kind.OPERATOR, TypeKind.LongType),
    FREM(114, 1, Kind.OPERATOR, TypeKind.FloatType),
    DREM(115, 1, Kind.OPERATOR, TypeKind.DoubleType),
    INEG(116, 1, Kind.OPERATOR, TypeKind.IntType),
    LNEG(117, 1, Kind.OPERATOR, TypeKind.LongType),
    FNEG(118, 1, Kind.OPERATOR, TypeKind.FloatType),
    DNEG(119, 1, Kind.OPERATOR, TypeKind.DoubleType),
    ISHL(120, 1, Kind.OPERATOR, TypeKind.IntType),
    LSHL(121, 1, Kind.OPERATOR, TypeKind.LongType),
    ISHR(122, 1, Kind.OPERATOR, TypeKind.IntType),
    LSHR(123, 1, Kind.OPERATOR, TypeKind.LongType),
    IUSHR(124, 1, Kind.OPERATOR, TypeKind.IntType),
    LUSHR(125, 1, Kind.OPERATOR, TypeKind.LongType),
    IAND(126, 1, Kind.OPERATOR, TypeKind.IntType),
    LAND(127, 1, Kind.OPERATOR, TypeKind.LongType),
    IOR(128, 1, Kind.OPERATOR, TypeKind.IntType),
    LOR(129, 1, Kind.OPERATOR, TypeKind.LongType),
    IXOR(130, 1, Kind.OPERATOR, TypeKind.IntType),
    LXOR(131, 1, Kind.OPERATOR, TypeKind.LongType),
    IINC(132, 3, Kind.INCREMENT, TypeKind.IntType, -1),
    I2L(133, 1, Kind.CONVERT, TypeKind.IntType, TypeKind.LongType),
    I2F(134, 1, Kind.CONVERT, TypeKind.IntType, TypeKind.FloatType),
    I2D(135, 1, Kind.CONVERT, TypeKind.IntType, TypeKind.DoubleType),
    L2I(136, 1, Kind.CONVERT, TypeKind.LongType, TypeKind.IntType),
    L2F(137, 1, Kind.CONVERT, TypeKind.LongType, TypeKind.FloatType),
    L2D(138, 1, Kind.CONVERT, TypeKind.LongType, TypeKind.DoubleType),
    F2I(139, 1, Kind.CONVERT, TypeKind.FloatType, TypeKind.IntType),
    F2L(140, 1, Kind.CONVERT, TypeKind.FloatType, TypeKind.LongType),
    F2D(141, 1, Kind.CONVERT, TypeKind.FloatType, TypeKind.DoubleType),
    D2I(142, 1, Kind.CONVERT, TypeKind.DoubleType, TypeKind.IntType),
    D2L(143, 1, Kind.CONVERT, TypeKind.DoubleType, TypeKind.LongType),
    D2F(144, 1, Kind.CONVERT, TypeKind.DoubleType, TypeKind.FloatType),
    I2B(145, 1, Kind.CONVERT, TypeKind.IntType, TypeKind.ByteType),
    I2C(146, 1, Kind.CONVERT, TypeKind.IntType, TypeKind.CharType),
    I2S(147, 1, Kind.CONVERT, TypeKind.IntType, TypeKind.ShortType),
    LCMP(148, 1, Kind.OPERATOR, TypeKind.LongType),
    FCMPL(149, 1, Kind.OPERATOR, TypeKind.FloatType),
    FCMPG(150, 1, Kind.OPERATOR, TypeKind.FloatType),
    DCMPL(151, 1, Kind.OPERATOR, TypeKind.DoubleType),
    DCMPG(152, 1, Kind.OPERATOR, TypeKind.DoubleType),
    IFEQ(153, 3, Kind.BRANCH, TypeKind.IntType),
    IFNE(154, 3, Kind.BRANCH, TypeKind.IntType),
    IFLT(155, 3, Kind.BRANCH, TypeKind.IntType),
    IFGE(156, 3, Kind.BRANCH, TypeKind.IntType),
    IFGT(157, 3, Kind.BRANCH, TypeKind.IntType),
    IFLE(158, 3, Kind.BRANCH, TypeKind.IntType),
    IF_ICMPEQ(159, 3, Kind.BRANCH, TypeKind.IntType),
    IF_ICMPNE(160, 3, Kind.BRANCH, TypeKind.IntType),
    IF_ICMPLT(161, 3, Kind.BRANCH, TypeKind.IntType),
    IF_ICMPGE(162, 3, Kind.BRANCH, TypeKind.IntType),
    IF_ICMPGT(163, 3, Kind.BRANCH, TypeKind.IntType),
    IF_ICMPLE(164, 3, Kind.BRANCH, TypeKind.IntType),
    IF_ACMPEQ(165, 3, Kind.BRANCH, TypeKind.ReferenceType),
    IF_ACMPNE(166, 3, Kind.BRANCH, TypeKind.ReferenceType),
    GOTO(167, 3, Kind.BRANCH, TypeKind.VoidType),
    JSR(168, 3, Kind.DISCONTINUED_JSR),
    RET(169, 2, Kind.DISCONTINUED_RET),
    TABLESWITCH(170, -1, Kind.TABLE_SWITCH),
    LOOKUPSWITCH(171, -1, Kind.LOOKUP_SWITCH),
    IRETURN(172, 1, Kind.RETURN, TypeKind.IntType),
    LRETURN(173, 1, Kind.RETURN, TypeKind.LongType),
    FRETURN(174, 1, Kind.RETURN, TypeKind.FloatType),
    DRETURN(175, 1, Kind.RETURN, TypeKind.DoubleType),
    ARETURN(176, 1, Kind.RETURN, TypeKind.ReferenceType),
    RETURN(177, 1, Kind.RETURN, TypeKind.VoidType),
    GETSTATIC(178, 3, Kind.FIELD_ACCESS),
    PUTSTATIC(179, 3, Kind.FIELD_ACCESS),
    GETFIELD(180, 3, Kind.FIELD_ACCESS),
    PUTFIELD(181, 3, Kind.FIELD_ACCESS),
    INVOKEVIRTUAL(182, 3, Kind.INVOKE),
    INVOKESPECIAL(183, 3, Kind.INVOKE),
    INVOKESTATIC(184, 3, Kind.INVOKE),
    INVOKEINTERFACE(185, 5, Kind.INVOKE),
    INVOKEDYNAMIC(186, 5, Kind.INVOKE_DYNAMIC),
    NEW(187, 3, Kind.NEW_OBJECT),
    NEWARRAY(188, 2, Kind.NEW_PRIMITIVE_ARRAY),
    ANEWARRAY(189, 3, Kind.NEW_REF_ARRAY),
    ARRAYLENGTH(190, 1, Kind.OPERATOR, TypeKind.IntType),
    ATHROW(191, 1, Kind.THROW_EXCEPTION),
    CHECKCAST(192, 3, Kind.TYPE_CHECK),
    INSTANCEOF(193, 3, Kind.TYPE_CHECK),
    MONITORENTER(194, 1, Kind.MONITOR),
    MONITOREXIT(195, 1, Kind.MONITOR),
    MULTIANEWARRAY(197, 4, Kind.NEW_MULTI_ARRAY),
    IFNULL(198, 3, Kind.BRANCH, TypeKind.ReferenceType),
    IFNONNULL(199, 3, Kind.BRANCH, TypeKind.IntType),
    GOTO_W(200, 5, Kind.BRANCH, TypeKind.VoidType),
    JSR_W(201, 5, Kind.DISCONTINUED_JSR),
    ILOAD_W(50197, 4, Kind.LOAD, TypeKind.IntType, -1),
    LLOAD_W(50198, 4, Kind.LOAD, TypeKind.LongType, -1),
    FLOAD_W(50199, 4, Kind.LOAD, TypeKind.FloatType, -1),
    DLOAD_W(50200, 4, Kind.LOAD, TypeKind.DoubleType, -1),
    ALOAD_W(50201, 4, Kind.LOAD, TypeKind.ReferenceType, -1),
    ISTORE_W(50230, 4, Kind.STORE, TypeKind.IntType, -1),
    LSTORE_W(50231, 4, Kind.STORE, TypeKind.LongType, -1),
    FSTORE_W(50232, 4, Kind.STORE, TypeKind.FloatType, -1),
    DSTORE_W(50233, 4, Kind.STORE, TypeKind.DoubleType, -1),
    ASTORE_W(50234, 4, Kind.STORE, TypeKind.ReferenceType, -1),
    RET_W(50345, 4, Kind.DISCONTINUED_RET),
    IINC_W(50308, 6, Kind.INCREMENT, TypeKind.IntType, -1);

    private final int bytecode;
    private final int sizeIfFixed;
    private final Kind kind;
    private final TypeKind primaryTypeKind;
    private final TypeKind secondaryTypeKind;
    private final int slot;
    private final ConstantDesc constantValue;

    private Opcode(int bytecode, int sizeIfFixed, Kind kind) {
        this(bytecode, sizeIfFixed, kind, null, null, -1, null);
    }

    private Opcode(int bytecode, int sizeIfFixed, Kind kind, TypeKind typeKind) {
        this(bytecode, sizeIfFixed, kind, typeKind, null, -1, null);
    }

    private Opcode(int bytecode, int sizeIfFixed, Kind kind, TypeKind typeKind, int slot) {
        this(bytecode, sizeIfFixed, kind, typeKind, null, slot, null);
    }

    private Opcode(int bytecode, int sizeIfFixed, Kind kind, TypeKind typeKind, int slot, ConstantDesc constantValue) {
        this(bytecode, sizeIfFixed, kind, typeKind, null, slot, constantValue);
    }

    private Opcode(int bytecode, int sizeIfFixed, Kind kind, TypeKind primaryTypeKind, TypeKind secondaryTypeKind) {
        this(bytecode, sizeIfFixed, kind, primaryTypeKind, secondaryTypeKind, 0, null);
    }

    private Opcode(int bytecode, int sizeIfFixed, Kind kind, TypeKind primaryTypeKind, TypeKind secondaryTypeKind, int slot, ConstantDesc constantValue) {
        this.bytecode = bytecode;
        this.sizeIfFixed = sizeIfFixed;
        this.kind = kind;
        this.primaryTypeKind = primaryTypeKind;
        this.secondaryTypeKind = secondaryTypeKind;
        this.slot = slot;
        this.constantValue = constantValue;
    }

    public int bytecode() {
        return this.bytecode;
    }

    public boolean isWide() {
        return this.bytecode > 255;
    }

    public int sizeIfFixed() {
        return this.sizeIfFixed;
    }

    public Kind kind() {
        return this.kind;
    }

    public TypeKind primaryTypeKind() {
        return this.primaryTypeKind;
    }

    public TypeKind secondaryTypeKind() {
        return this.secondaryTypeKind;
    }

    public int slot() {
        return this.slot;
    }

    public ConstantDesc constantValue() {
        return this.constantValue;
    }

    public boolean isUnconditionalBranch() {
        return switch (this) {
            case GOTO, ATHROW, GOTO_W, LOOKUPSWITCH, TABLESWITCH -> true;
            default -> this.kind() == Kind.RETURN;
        };
    }

    public static enum Kind {
        LOAD,
        STORE,
        INCREMENT,
        BRANCH,
        LOOKUP_SWITCH,
        TABLE_SWITCH,
        RETURN,
        THROW_EXCEPTION,
        FIELD_ACCESS,
        INVOKE,
        INVOKE_DYNAMIC,
        NEW_OBJECT,
        NEW_PRIMITIVE_ARRAY,
        NEW_REF_ARRAY,
        NEW_MULTI_ARRAY,
        TYPE_CHECK,
        ARRAY_LOAD,
        ARRAY_STORE,
        STACK,
        CONVERT,
        OPERATOR,
        CONSTANT,
        MONITOR,
        NOP,
        DISCONTINUED_JSR,
        DISCONTINUED_RET;

    }
}

