/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile;

import java.lang.constant.ClassDesc;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.glavo.classfile.impl.SignaturesImpl;
import org.glavo.classfile.impl.Util;
import org.glavo.classfile.jdk.ClassDescUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Signature {
    public String signatureString();

    public static Signature parseFrom(String javaTypeSignature) {
        return new SignaturesImpl(javaTypeSignature).parseSignature();
    }

    public static Signature of(ClassDesc classDesc) {
        Objects.requireNonNull(classDesc);
        if (classDesc.isArray()) {
            return ArrayTypeSig.of(Signature.of(classDesc.componentType()));
        }
        if (classDesc.isPrimitive()) {
            return BaseTypeSig.of(classDesc);
        }
        return ClassTypeSig.of(classDesc, new TypeArg[0]);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ArrayTypeSig
    extends RefTypeSig {
        public Signature componentSignature();

        public static ArrayTypeSig of(Signature componentSignature) {
            return ArrayTypeSig.of(1, Objects.requireNonNull(componentSignature));
        }

        public static ArrayTypeSig of(int dims, Signature componentSignature) {
            Objects.requireNonNull(componentSignature);
            if (dims < 1 || dims > 255) {
                throw new IllegalArgumentException("illegal array depth value");
            }
            if (componentSignature instanceof SignaturesImpl.ArrayTypeSigImpl) {
                SignaturesImpl.ArrayTypeSigImpl arr = (SignaturesImpl.ArrayTypeSigImpl)componentSignature;
                return new SignaturesImpl.ArrayTypeSigImpl(dims + arr.arrayDepth(), arr.elemType());
            }
            return new SignaturesImpl.ArrayTypeSigImpl(dims, componentSignature);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface BaseTypeSig
    extends Signature {
        public char baseType();

        public static BaseTypeSig of(ClassDesc classDesc) {
            Objects.requireNonNull(classDesc);
            if (!classDesc.isPrimitive()) {
                throw new IllegalArgumentException("primitive class type required");
            }
            return new SignaturesImpl.BaseTypeSigImpl(classDesc.descriptorString().charAt(0));
        }

        public static BaseTypeSig of(char baseType) {
            if ("VIJCSBFDZ".indexOf(baseType) < 0) {
                throw new IllegalArgumentException("invalid base type signature");
            }
            return new SignaturesImpl.BaseTypeSigImpl(baseType);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface TypeArg {
        public WildcardIndicator wildcardIndicator();

        public Optional<RefTypeSig> boundType();

        public static TypeArg of(RefTypeSig boundType) {
            Objects.requireNonNull(boundType);
            return TypeArg.of(WildcardIndicator.DEFAULT, Optional.of(boundType));
        }

        public static TypeArg unbounded() {
            return TypeArg.of(WildcardIndicator.UNBOUNDED, Optional.empty());
        }

        public static TypeArg extendsOf(RefTypeSig boundType) {
            Objects.requireNonNull(boundType);
            return TypeArg.of(WildcardIndicator.EXTENDS, Optional.of(boundType));
        }

        public static TypeArg superOf(RefTypeSig boundType) {
            Objects.requireNonNull(boundType);
            return TypeArg.of(WildcardIndicator.SUPER, Optional.of(boundType));
        }

        public static TypeArg of(WildcardIndicator wildcard, Optional<RefTypeSig> boundType) {
            return new SignaturesImpl.TypeArgImpl(wildcard, boundType);
        }

        public static enum WildcardIndicator {
            DEFAULT,
            UNBOUNDED,
            EXTENDS,
            SUPER;

        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ClassTypeSig
    extends RefTypeSig,
    ThrowableSig {
        public Optional<ClassTypeSig> outerType();

        public String className();

        default public ClassDesc classDesc() {
            Optional<ClassTypeSig> outer = this.outerType();
            return outer.isEmpty() ? ClassDescUtils.ofInternalName(this.className()) : outer.get().classDesc().nested(this.className());
        }

        public List<TypeArg> typeArgs();

        public static ClassTypeSig of(ClassDesc className, TypeArg ... typeArgs) {
            return ClassTypeSig.of(null, className, typeArgs);
        }

        public static ClassTypeSig of(ClassTypeSig outerType, ClassDesc className, TypeArg ... typeArgs) {
            Objects.requireNonNull(className);
            return ClassTypeSig.of(outerType, Util.toInternalName(className), typeArgs);
        }

        public static ClassTypeSig of(String className, TypeArg ... typeArgs) {
            return ClassTypeSig.of(null, className, typeArgs);
        }

        public static ClassTypeSig of(ClassTypeSig outerType, String className, TypeArg ... typeArgs) {
            Objects.requireNonNull(className);
            return new SignaturesImpl.ClassTypeSigImpl(Optional.ofNullable(outerType), className.replace(".", "/"), List.of(typeArgs));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ThrowableSig
    extends Signature {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface TypeParam {
        public String identifier();

        public Optional<RefTypeSig> classBound();

        public List<RefTypeSig> interfaceBounds();

        public static TypeParam of(String identifier, RefTypeSig classBound, RefTypeSig ... interfaceBounds) {
            return new SignaturesImpl.TypeParamImpl(Objects.requireNonNull(identifier), Optional.ofNullable(classBound), List.of(interfaceBounds));
        }

        public static TypeParam of(String identifier, Optional<RefTypeSig> classBound, RefTypeSig ... interfaceBounds) {
            return new SignaturesImpl.TypeParamImpl(Objects.requireNonNull(identifier), Objects.requireNonNull(classBound), List.of(interfaceBounds));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface TypeVarSig
    extends RefTypeSig,
    ThrowableSig {
        public String identifier();

        public static TypeVarSig of(String identifier) {
            return new SignaturesImpl.TypeVarSigImpl(Objects.requireNonNull(identifier));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface RefTypeSig
    extends Signature {
    }
}

