/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.attribute;

import java.lang.constant.ConstantDesc;
import java.util.Objects;
import org.glavo.classfile.Attribute;
import org.glavo.classfile.FieldElement;
import org.glavo.classfile.constantpool.ConstantValueEntry;
import org.glavo.classfile.impl.TemporaryConstantPool;
import org.glavo.classfile.impl.UnboundAttribute;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ConstantValueAttribute
extends Attribute<ConstantValueAttribute>,
FieldElement {
    public ConstantValueEntry constant();

    public static ConstantValueAttribute of(ConstantValueEntry value) {
        return new UnboundAttribute.UnboundConstantValueAttribute(value);
    }

    public static ConstantValueAttribute of(ConstantDesc value) {
        ConstantValueEntry entry;
        Objects.requireNonNull(value);
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            entry = TemporaryConstantPool.INSTANCE.intEntry(i);
        } else if (value instanceof Float) {
            Float f = (Float)value;
            entry = TemporaryConstantPool.INSTANCE.floatEntry(f.floatValue());
        } else if (value instanceof Long) {
            Long l = (Long)value;
            entry = TemporaryConstantPool.INSTANCE.longEntry(l);
        } else if (value instanceof Double) {
            Double d = (Double)value;
            entry = TemporaryConstantPool.INSTANCE.doubleEntry(d);
        } else if (value instanceof String) {
            String s = (String)((Object)value);
            entry = TemporaryConstantPool.INSTANCE.stringEntry(s);
        } else {
            throw new IllegalArgumentException("Invalid ConstantValueAttribute value: " + value);
        }
        return ConstantValueAttribute.of(entry);
    }
}

