/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.attribute;

import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.Optional;
import org.glavo.classfile.Attribute;
import org.glavo.classfile.ClassElement;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.NameAndTypeEntry;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.TemporaryConstantPool;
import org.glavo.classfile.impl.UnboundAttribute;
import org.glavo.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface EnclosingMethodAttribute
extends Attribute<EnclosingMethodAttribute>,
ClassElement {
    public ClassEntry enclosingClass();

    public Optional<NameAndTypeEntry> enclosingMethod();

    default public Optional<Utf8Entry> enclosingMethodName() {
        return this.enclosingMethod().map(NameAndTypeEntry::name);
    }

    default public Optional<Utf8Entry> enclosingMethodType() {
        return this.enclosingMethod().map(NameAndTypeEntry::type);
    }

    default public Optional<MethodTypeDesc> enclosingMethodTypeSymbol() {
        return this.enclosingMethod().map(Util::methodTypeSymbol);
    }

    public static EnclosingMethodAttribute of(ClassEntry className, Optional<NameAndTypeEntry> method) {
        return new UnboundAttribute.UnboundEnclosingMethodAttribute(className, method.orElse(null));
    }

    public static EnclosingMethodAttribute of(ClassDesc className, Optional<String> methodName, Optional<MethodTypeDesc> methodType) {
        return new UnboundAttribute.UnboundEnclosingMethodAttribute(TemporaryConstantPool.INSTANCE.classEntry(className), methodName.isPresent() && methodType.isPresent() ? TemporaryConstantPool.INSTANCE.nameAndTypeEntry(methodName.get(), methodType.get()) : null);
    }
}

