/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.components;

import java.lang.constant.ConstantDesc;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.glavo.classfile.CompoundElement;
import org.glavo.classfile.impl.ClassPrinterImpl;

public final class ClassPrinter {
    private ClassPrinter() {
    }

    public static MapNode toTree(CompoundElement<?> model, Verbosity verbosity) {
        return ClassPrinterImpl.modelToTree(model, verbosity);
    }

    public static void toJson(CompoundElement<?> model, Verbosity verbosity, Consumer<String> out) {
        ClassPrinter.toTree(model, verbosity).toJson(out);
    }

    public static void toXml(CompoundElement<?> model, Verbosity verbosity, Consumer<String> out) {
        ClassPrinter.toTree(model, verbosity).toXml(out);
    }

    public static void toYaml(CompoundElement<?> model, Verbosity verbosity, Consumer<String> out) {
        ClassPrinter.toTree(model, verbosity).toYaml(out);
    }

    public static enum Verbosity {
        MEMBERS_ONLY,
        CRITICAL_ATTRIBUTES,
        TRACE_ALL;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface MapNode
    extends Node,
    Map<ConstantDesc, Node> {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ListNode
    extends Node,
    List<Node> {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface LeafNode
    extends Node {
        public ConstantDesc value();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Node {
        public ConstantDesc name();

        public Stream<Node> walk();

        default public void toJson(Consumer<String> out) {
            ClassPrinterImpl.toJson(this, out);
        }

        default public void toXml(Consumer<String> out) {
            ClassPrinterImpl.toXml(this, out);
        }

        default public void toYaml(Consumer<String> out) {
            ClassPrinterImpl.toYaml(this, out);
        }
    }
}

