/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.components;

import java.lang.constant.ClassDesc;
import java.util.Map;
import java.util.function.Function;
import org.glavo.classfile.ClassFile;
import org.glavo.classfile.ClassModel;
import org.glavo.classfile.ClassTransform;
import org.glavo.classfile.CodeTransform;
import org.glavo.classfile.FieldTransform;
import org.glavo.classfile.MethodTransform;
import org.glavo.classfile.impl.ClassRemapperImpl;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClassRemapper
extends ClassTransform {
    public static ClassRemapper of(Map<ClassDesc, ClassDesc> classMap) {
        return ClassRemapper.of((ClassDesc desc) -> classMap.getOrDefault(desc, (ClassDesc)desc));
    }

    public static ClassRemapper of(Function<ClassDesc, ClassDesc> mapFunction) {
        return new ClassRemapperImpl(mapFunction);
    }

    public ClassDesc map(ClassDesc var1);

    public FieldTransform asFieldTransform();

    public MethodTransform asMethodTransform();

    public CodeTransform asCodeTransform();

    default public byte[] remapClass(ClassFile context, ClassModel clm) {
        return context.transform(clm, this.map(clm.thisClass().asSymbol()), (ClassTransform)this);
    }
}

