/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.constant;

import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ConstantUtils {
    public static final String INIT_NAME = "<init>";
    public static final String CLASS_INIT_NAME = "<clinit>";
    public static final MethodTypeDesc MTD_void = MethodTypeDesc.of(ConstantDescs.CD_void, new ClassDesc[0]);
    public static final ConstantDesc[] EMPTY_CONSTANTDESC = new ConstantDesc[0];
    static final Constable[] EMPTY_CONSTABLE = new Constable[0];
    static final int MAX_ARRAY_TYPE_DESC_DIMENSIONS = 255;
    private static final Set<String> pointyNames = Set.of("<init>", "<clinit>");
    private static final char JVM_SIGNATURE_ARRAY = '[';
    private static final char JVM_SIGNATURE_BYTE = 'B';
    private static final char JVM_SIGNATURE_CHAR = 'C';
    private static final char JVM_SIGNATURE_CLASS = 'L';
    private static final char JVM_SIGNATURE_ENDCLASS = ';';
    private static final char JVM_SIGNATURE_ENUM = 'E';
    private static final char JVM_SIGNATURE_FLOAT = 'F';
    private static final char JVM_SIGNATURE_DOUBLE = 'D';
    private static final char JVM_SIGNATURE_FUNC = '(';
    private static final char JVM_SIGNATURE_ENDFUNC = ')';
    private static final char JVM_SIGNATURE_INT = 'I';
    private static final char JVM_SIGNATURE_LONG = 'J';
    private static final char JVM_SIGNATURE_SHORT = 'S';
    private static final char JVM_SIGNATURE_VOID = 'V';
    private static final char JVM_SIGNATURE_BOOLEAN = 'Z';

    static String validateBinaryClassName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch != ';' && ch != '[' && ch != '/') continue;
            throw new IllegalArgumentException("Invalid class name: " + name);
        }
        return name;
    }

    static String validateInternalClassName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch != ';' && ch != '[' && ch != '.') continue;
            throw new IllegalArgumentException("Invalid class name: " + name);
        }
        return name;
    }

    public static String validateBinaryPackageName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch != ';' && ch != '[' && ch != '/') continue;
            throw new IllegalArgumentException("Invalid package name: " + name);
        }
        return name;
    }

    public static String validateInternalPackageName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch != ';' && ch != '[' && ch != '.') continue;
            throw new IllegalArgumentException("Invalid package name: " + name);
        }
        return name;
    }

    public static String validateModuleName(String name) {
        for (int i = name.length() - 1; i >= 0; --i) {
            char ch = name.charAt(i);
            if ((ch < '\u0000' || ch > '\u001f') && (ch != '\\' && ch != ':' && ch != '@' || i != 0 && name.charAt(--i) == '\\')) continue;
            throw new IllegalArgumentException("Invalid module name: " + name);
        }
        return name;
    }

    public static String validateMemberName(String name, boolean method) {
        Objects.requireNonNull(name);
        if (name.length() == 0) {
            throw new IllegalArgumentException("zero-length member name");
        }
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch == '.' || ch == ';' || ch == '[' || ch == '/') {
                throw new IllegalArgumentException("Invalid member name: " + name);
            }
            if (!method || ch != '<' && ch != '>' || pointyNames.contains(name)) continue;
            throw new IllegalArgumentException("Invalid member name: " + name);
        }
        return name;
    }

    static void validateClassOrInterface(ClassDesc classDesc) {
        if (!classDesc.isClassOrInterface()) {
            throw new IllegalArgumentException("not a class or interface type: " + classDesc);
        }
    }

    static int arrayDepth(String descriptorString) {
        int depth = 0;
        while (descriptorString.charAt(depth) == '[') {
            ++depth;
        }
        return depth;
    }

    static String binaryToInternal(String name) {
        return name.replace('.', '/');
    }

    static String internalToBinary(String name) {
        return name.replace('/', '.');
    }

    static String dropLastChar(String s) {
        return s.substring(0, s.length() - 1);
    }

    static String dropFirstAndLastChar(String s) {
        return s.substring(1, s.length() - 1);
    }

    static List<String> parseMethodDescriptor(String descriptor) {
        int rLen;
        int cur = 0;
        int end = descriptor.length();
        ArrayList<String> ptypes = new ArrayList<String>();
        ptypes.add(null);
        if (cur >= end || descriptor.charAt(cur) != '(') {
            throw new IllegalArgumentException("Bad method descriptor: " + descriptor);
        }
        ++cur;
        while (cur < end && descriptor.charAt(cur) != ')') {
            int len = ConstantUtils.skipOverFieldSignature(descriptor, cur, end, false);
            if (len == 0) {
                throw new IllegalArgumentException("Bad method descriptor: " + descriptor);
            }
            ptypes.add(descriptor.substring(cur, cur + len));
            cur += len;
        }
        if (cur >= end) {
            throw new IllegalArgumentException("Bad method descriptor: " + descriptor);
        }
        if ((rLen = ConstantUtils.skipOverFieldSignature(descriptor, ++cur, end, true)) == 0 || cur + rLen != end) {
            throw new IllegalArgumentException("Bad method descriptor: " + descriptor);
        }
        ptypes.set(0, descriptor.substring(cur, cur + rLen));
        return ptypes;
    }

    static int skipOverFieldSignature(String descriptor, int start, int end, boolean voidOK) {
        int arrayDim = 0;
        block11: for (int index = start; index < end; ++index) {
            switch (descriptor.charAt(index)) {
                case 'V': {
                    if (!voidOK) {
                        return 0;
                    }
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    return index - start + 1;
                }
                case 'L': {
                    boolean legal = false;
                    block12: while (++index < end) {
                        switch (descriptor.charAt(index)) {
                            case ';': {
                                return legal ? index - start + 1 : 0;
                            }
                            case '.': 
                            case '[': {
                                return 0;
                            }
                            case '/': {
                                if (!legal) {
                                    return 0;
                                }
                                legal = false;
                                continue block12;
                            }
                        }
                        legal = true;
                    }
                    return 0;
                }
                case '[': {
                    if (++arrayDim > 255) {
                        throw new IllegalArgumentException(String.format("Cannot create an array type descriptor with more than %d dimensions", 255));
                    }
                    voidOK = false;
                    continue block11;
                }
            }
            return 0;
        }
        return 0;
    }
}

