/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.constant;

import java.util.Objects;
import org.glavo.classfile.constant.ConstantUtils;
import org.glavo.classfile.constant.PackageDescImpl;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface PackageDesc {
    public static PackageDesc of(String name) {
        ConstantUtils.validateBinaryPackageName(Objects.requireNonNull(name));
        return new PackageDescImpl(ConstantUtils.binaryToInternal(name));
    }

    public static PackageDesc ofInternalName(String name) {
        ConstantUtils.validateInternalPackageName(Objects.requireNonNull(name));
        return new PackageDescImpl(name);
    }

    public String internalName();

    default public String name() {
        return ConstantUtils.internalToBinary(this.internalName());
    }

    public boolean equals(Object var1);
}

