/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import org.glavo.classfile.Attribute;
import org.glavo.classfile.AttributeMapper;
import org.glavo.classfile.BufWriter;

public abstract class AbstractAttributeMapper<T extends Attribute<T>>
implements AttributeMapper<T> {
    private final String name;
    private final boolean allowMultiple;

    protected abstract void writeBody(BufWriter var1, T var2);

    public AbstractAttributeMapper(String name) {
        this(name, false);
    }

    public AbstractAttributeMapper(String name, boolean allowMultiple) {
        this.name = name;
        this.allowMultiple = allowMultiple;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void writeAttribute(BufWriter buf, T attr) {
        buf.writeIndex(buf.constantPool().utf8Entry(this.name));
        buf.writeInt(0);
        int start = buf.size();
        this.writeBody(buf, attr);
        int written = buf.size() - start;
        buf.patchInt(start - 4, 4, written);
    }

    @Override
    public boolean allowMultiple() {
        return this.allowMultiple;
    }

    public String toString() {
        return String.format("AttributeMapper[name=%s, allowMultiple=%b, stability=%s]", new Object[]{this.name, this.allowMultiple, this.stability()});
    }
}

