/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.Optional;
import org.glavo.classfile.Attribute;
import org.glavo.classfile.impl.AttributeHolder;
import org.glavo.classfile.impl.ClassFileImpl;
import org.glavo.classfile.impl.SplitConstantPool;
import org.glavo.classfile.impl.Util;

public class AbstractDirectBuilder<M> {
    protected final SplitConstantPool constantPool;
    protected final ClassFileImpl context;
    protected final AttributeHolder attributes = new AttributeHolder();
    protected M original;

    public AbstractDirectBuilder(SplitConstantPool constantPool, ClassFileImpl context) {
        this.constantPool = constantPool;
        this.context = context;
    }

    public SplitConstantPool constantPool() {
        return this.constantPool;
    }

    public Optional<M> original() {
        return Optional.ofNullable(this.original);
    }

    public void setOriginal(M original) {
        this.original = original;
    }

    public void writeAttribute(Attribute<?> a) {
        if (Util.isAttributeAllowed(a, this.context.attributesProcessingOption())) {
            this.attributes.withAttribute(a);
        }
    }
}

