/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.lang.constant.ConstantDesc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glavo.classfile.Instruction;
import org.glavo.classfile.Label;
import org.glavo.classfile.Opcode;
import org.glavo.classfile.TypeKind;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.FieldRefEntry;
import org.glavo.classfile.constantpool.InterfaceMethodRefEntry;
import org.glavo.classfile.constantpool.InvokeDynamicEntry;
import org.glavo.classfile.constantpool.LoadableConstantEntry;
import org.glavo.classfile.constantpool.MemberRefEntry;
import org.glavo.classfile.impl.AbstractElement;
import org.glavo.classfile.impl.CodeImpl;
import org.glavo.classfile.impl.DirectCodeBuilder;
import org.glavo.classfile.impl.Util;
import org.glavo.classfile.instruction.ArrayLoadInstruction;
import org.glavo.classfile.instruction.ArrayStoreInstruction;
import org.glavo.classfile.instruction.BranchInstruction;
import org.glavo.classfile.instruction.ConstantInstruction;
import org.glavo.classfile.instruction.ConvertInstruction;
import org.glavo.classfile.instruction.DiscontinuedInstruction;
import org.glavo.classfile.instruction.FieldInstruction;
import org.glavo.classfile.instruction.IncrementInstruction;
import org.glavo.classfile.instruction.InvokeDynamicInstruction;
import org.glavo.classfile.instruction.InvokeInstruction;
import org.glavo.classfile.instruction.LoadInstruction;
import org.glavo.classfile.instruction.LookupSwitchInstruction;
import org.glavo.classfile.instruction.MonitorInstruction;
import org.glavo.classfile.instruction.NewMultiArrayInstruction;
import org.glavo.classfile.instruction.NewObjectInstruction;
import org.glavo.classfile.instruction.NewPrimitiveArrayInstruction;
import org.glavo.classfile.instruction.NewReferenceArrayInstruction;
import org.glavo.classfile.instruction.NopInstruction;
import org.glavo.classfile.instruction.OperatorInstruction;
import org.glavo.classfile.instruction.ReturnInstruction;
import org.glavo.classfile.instruction.StackInstruction;
import org.glavo.classfile.instruction.StoreInstruction;
import org.glavo.classfile.instruction.SwitchCase;
import org.glavo.classfile.instruction.TableSwitchInstruction;
import org.glavo.classfile.instruction.ThrowInstruction;
import org.glavo.classfile.instruction.TypeCheckInstruction;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractInstruction
extends AbstractElement
implements Instruction {
    private static final String FMT_ArgumentConstant = "ArgumentConstant[OP=%s, val=%s]";
    private static final String FMT_Branch = "Branch[OP=%s]";
    private static final String FMT_Field = "Field[OP=%s, field=%s.%s:%s]";
    private static final String FMT_Increment = "Increment[OP=%s, slot=%d, val=%d]";
    private static final String FMT_Invoke = "Invoke[OP=%s, m=%s.%s%s]";
    private static final String FMT_InvokeDynamic = "InvokeDynamic[OP=%s, bsm=%s %s]";
    private static final String FMT_InvokeInterface = "InvokeInterface[OP=%s, m=%s.%s%s]";
    private static final String FMT_Load = "Load[OP=%s, slot=%d]";
    private static final String FMT_LoadConstant = "LoadConstant[OP=%s, val=%s]";
    private static final String FMT_LookupSwitch = "LookupSwitch[OP=%s]";
    private static final String FMT_NewMultiArray = "NewMultiArray[OP=%s, type=%s[%d]]";
    private static final String FMT_NewObj = "NewObj[OP=%s, type=%s]";
    private static final String FMT_NewPrimitiveArray = "NewPrimitiveArray[OP=%s, type=%s]";
    private static final String FMT_NewRefArray = "NewRefArray[OP=%s, type=%s]";
    private static final String FMT_Return = "Return[OP=%s]";
    private static final String FMT_Store = "Store[OP=%s, slot=%d]";
    private static final String FMT_TableSwitch = "TableSwitch[OP=%s]";
    private static final String FMT_Throw = "Throw[OP=%s]";
    private static final String FMT_TypeCheck = "TypeCheck[OP=%s, type=%s]";
    private static final String FMT_Unbound = "%s[op=%s]";
    private static final String FMT_Discontinued = "Discontinued[OP=%s]";
    final Opcode op;
    final int size;

    @Override
    public Opcode opcode() {
        return this.op;
    }

    @Override
    public int sizeInBytes() {
        return this.size;
    }

    public AbstractInstruction(Opcode op, int size) {
        this.op = op;
        this.size = size;
    }

    @Override
    public abstract void writeTo(DirectCodeBuilder var1);

    public static final class UnboundRetInstruction
    extends UnboundInstruction
    implements DiscontinuedInstruction.RetInstruction {
        final int slot;

        public UnboundRetInstruction(Opcode op, int slot) {
            super(op);
            this.slot = slot;
        }

        @Override
        public int slot() {
            return this.slot;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeLocalVar(this.op, this.slot);
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_Discontinued, new Object[]{this.opcode()});
        }
    }

    public static final class UnboundJsrInstruction
    extends UnboundInstruction
    implements DiscontinuedInstruction.JsrInstruction {
        final Label target;

        public UnboundJsrInstruction(Opcode op, Label target) {
            super(op);
            this.target = target;
        }

        @Override
        public Label target() {
            return this.target;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeBranch(this.op, this.target);
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_Discontinued, new Object[]{this.opcode()});
        }
    }

    public static final class UnboundNopInstruction
    extends UnboundInstruction
    implements NopInstruction {
        public UnboundNopInstruction() {
            super(Opcode.NOP);
        }
    }

    public static final class UnboundMonitorInstruction
    extends UnboundInstruction
    implements MonitorInstruction {
        public UnboundMonitorInstruction(Opcode op) {
            super(op);
        }
    }

    public static final class UnboundLoadConstantInstruction
    extends UnboundInstruction
    implements ConstantInstruction.LoadConstantInstruction {
        final LoadableConstantEntry constant;

        public UnboundLoadConstantInstruction(Opcode op, LoadableConstantEntry constant) {
            super(op);
            this.constant = constant;
        }

        @Override
        public LoadableConstantEntry constantEntry() {
            return this.constant;
        }

        @Override
        public ConstantDesc constantValue() {
            return this.constant.constantValue();
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeLoadConstant(this.op, this.constant);
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_LoadConstant, new Object[]{this.opcode(), this.constantValue()});
        }
    }

    public static final class UnboundArgumentConstantInstruction
    extends UnboundInstruction
    implements ConstantInstruction.ArgumentConstantInstruction {
        final int value;

        public UnboundArgumentConstantInstruction(Opcode op, int value) {
            super(op);
            this.value = value;
        }

        @Override
        public Integer constantValue() {
            return this.value;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeArgumentConstant(this.op, this.value);
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_ArgumentConstant, new Object[]{this.opcode(), this.constantValue()});
        }
    }

    public static final class UnboundIntrinsicConstantInstruction
    extends UnboundInstruction
    implements ConstantInstruction.IntrinsicConstantInstruction {
        final ConstantDesc constant;

        public UnboundIntrinsicConstantInstruction(Opcode op) {
            super(op);
            this.constant = op.constantValue();
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            super.writeTo(writer);
        }

        @Override
        public ConstantDesc constantValue() {
            return this.constant;
        }
    }

    public static final class UnboundOperatorInstruction
    extends UnboundInstruction
    implements OperatorInstruction {
        public UnboundOperatorInstruction(Opcode op) {
            super(op);
        }

        @Override
        public TypeKind typeKind() {
            return this.op.primaryTypeKind();
        }
    }

    public static final class UnboundConvertInstruction
    extends UnboundInstruction
    implements ConvertInstruction {
        public UnboundConvertInstruction(Opcode op) {
            super(op);
        }

        @Override
        public TypeKind fromType() {
            return this.op.primaryTypeKind();
        }

        @Override
        public TypeKind toType() {
            return this.op.secondaryTypeKind();
        }
    }

    public static final class UnboundStackInstruction
    extends UnboundInstruction
    implements StackInstruction {
        public UnboundStackInstruction(Opcode op) {
            super(op);
        }
    }

    public static final class UnboundTypeCheckInstruction
    extends UnboundInstruction
    implements TypeCheckInstruction {
        final ClassEntry typeEntry;

        public UnboundTypeCheckInstruction(Opcode op, ClassEntry typeEntry) {
            super(op);
            this.typeEntry = typeEntry;
        }

        @Override
        public ClassEntry type() {
            return this.typeEntry;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeTypeCheck(this.op, this.type());
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_TypeCheck, new Object[]{this.opcode(), this.type().asInternalName()});
        }
    }

    public static final class UnboundArrayStoreInstruction
    extends UnboundInstruction
    implements ArrayStoreInstruction {
        public UnboundArrayStoreInstruction(Opcode op) {
            super(op);
        }

        @Override
        public TypeKind typeKind() {
            return this.op.primaryTypeKind();
        }
    }

    public static final class UnboundArrayLoadInstruction
    extends UnboundInstruction
    implements ArrayLoadInstruction {
        public UnboundArrayLoadInstruction(Opcode op) {
            super(op);
        }

        @Override
        public TypeKind typeKind() {
            return this.op.primaryTypeKind();
        }
    }

    public static final class UnboundNewMultidimensionalArrayInstruction
    extends UnboundInstruction
    implements NewMultiArrayInstruction {
        final ClassEntry arrayTypeEntry;
        final int dimensions;

        public UnboundNewMultidimensionalArrayInstruction(ClassEntry arrayTypeEntry, int dimensions) {
            super(Opcode.MULTIANEWARRAY);
            this.arrayTypeEntry = arrayTypeEntry;
            this.dimensions = dimensions;
        }

        @Override
        public int dimensions() {
            return this.dimensions;
        }

        @Override
        public ClassEntry arrayType() {
            return this.arrayTypeEntry;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeNewMultidimensionalArray(this.dimensions(), this.arrayType());
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_NewMultiArray, new Object[]{this.opcode(), this.arrayType().asInternalName(), this.dimensions()});
        }
    }

    public static final class UnboundNewReferenceArrayInstruction
    extends UnboundInstruction
    implements NewReferenceArrayInstruction {
        final ClassEntry componentTypeEntry;

        public UnboundNewReferenceArrayInstruction(ClassEntry componentTypeEntry) {
            super(Opcode.ANEWARRAY);
            this.componentTypeEntry = componentTypeEntry;
        }

        @Override
        public ClassEntry componentType() {
            return this.componentTypeEntry;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeNewReferenceArray(this.componentType());
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_NewRefArray, new Object[]{this.opcode(), this.componentType().asInternalName()});
        }
    }

    public static final class UnboundNewPrimitiveArrayInstruction
    extends UnboundInstruction
    implements NewPrimitiveArrayInstruction {
        final TypeKind typeKind;

        public UnboundNewPrimitiveArrayInstruction(TypeKind typeKind) {
            super(Opcode.NEWARRAY);
            this.typeKind = typeKind;
        }

        @Override
        public TypeKind typeKind() {
            return this.typeKind;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeNewPrimitiveArray(this.typeKind.newarraycode());
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_NewPrimitiveArray, new Object[]{this.opcode(), this.typeKind()});
        }
    }

    public static final class UnboundNewObjectInstruction
    extends UnboundInstruction
    implements NewObjectInstruction {
        final ClassEntry classEntry;

        public UnboundNewObjectInstruction(ClassEntry classEntry) {
            super(Opcode.NEW);
            this.classEntry = classEntry;
        }

        @Override
        public ClassEntry className() {
            return this.classEntry;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeNewObject(this.className());
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_NewObj, new Object[]{this.opcode(), this.className().asInternalName()});
        }
    }

    public static final class UnboundInvokeDynamicInstruction
    extends UnboundInstruction
    implements InvokeDynamicInstruction {
        final InvokeDynamicEntry indyEntry;

        public UnboundInvokeDynamicInstruction(InvokeDynamicEntry indyEntry) {
            super(Opcode.INVOKEDYNAMIC);
            this.indyEntry = indyEntry;
        }

        @Override
        public InvokeDynamicEntry invokedynamic() {
            return this.indyEntry;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeInvokeDynamic(this.invokedynamic());
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_InvokeDynamic, new Object[]{this.opcode(), this.bootstrapMethod(), this.bootstrapArgs()});
        }
    }

    public static final class UnboundInvokeInstruction
    extends UnboundInstruction
    implements InvokeInstruction {
        final MemberRefEntry methodEntry;

        public UnboundInvokeInstruction(Opcode op, MemberRefEntry methodEntry) {
            super(op);
            this.methodEntry = methodEntry;
        }

        @Override
        public MemberRefEntry method() {
            return this.methodEntry;
        }

        @Override
        public boolean isInterface() {
            return this.op == Opcode.INVOKEINTERFACE || this.methodEntry instanceof InterfaceMethodRefEntry;
        }

        @Override
        public int count() {
            return this.op == Opcode.INVOKEINTERFACE ? Util.parameterSlots(Util.methodTypeSymbol(this.methodEntry.nameAndType())) + 1 : 0;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            if (this.op == Opcode.INVOKEINTERFACE) {
                writer.writeInvokeInterface(this.op, (InterfaceMethodRefEntry)this.method(), this.count());
            } else {
                writer.writeInvokeNormal(this.op, this.method());
            }
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_Invoke, new Object[]{this.opcode(), this.owner().asInternalName(), this.name().stringValue(), this.type().stringValue()});
        }
    }

    public static final class UnboundFieldInstruction
    extends UnboundInstruction
    implements FieldInstruction {
        final FieldRefEntry fieldEntry;

        public UnboundFieldInstruction(Opcode op, FieldRefEntry fieldEntry) {
            super(op);
            this.fieldEntry = fieldEntry;
        }

        @Override
        public FieldRefEntry field() {
            return this.fieldEntry;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeFieldAccess(this.op, this.fieldEntry);
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_Field, new Object[]{this.opcode(), this.owner().asInternalName(), this.name().stringValue(), this.type().stringValue()});
        }
    }

    public static final class UnboundThrowInstruction
    extends UnboundInstruction
    implements ThrowInstruction {
        public UnboundThrowInstruction() {
            super(Opcode.ATHROW);
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_Throw, new Object[]{this.opcode()});
        }
    }

    public static final class UnboundReturnInstruction
    extends UnboundInstruction
    implements ReturnInstruction {
        public UnboundReturnInstruction(Opcode op) {
            super(op);
        }

        @Override
        public TypeKind typeKind() {
            return this.op.primaryTypeKind();
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_Return, new Object[]{this.opcode()});
        }
    }

    public static final class UnboundTableSwitchInstruction
    extends UnboundInstruction
    implements TableSwitchInstruction {
        private final int lowValue;
        private final int highValue;
        private final Label defaultTarget;
        private final List<SwitchCase> cases;

        public UnboundTableSwitchInstruction(int lowValue, int highValue, Label defaultTarget, List<SwitchCase> cases) {
            super(Opcode.TABLESWITCH);
            this.lowValue = lowValue;
            this.highValue = highValue;
            this.defaultTarget = defaultTarget;
            this.cases = List.copyOf(cases);
        }

        @Override
        public int lowValue() {
            return this.lowValue;
        }

        @Override
        public int highValue() {
            return this.highValue;
        }

        @Override
        public Label defaultTarget() {
            return this.defaultTarget;
        }

        @Override
        public List<SwitchCase> cases() {
            return this.cases;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeTableSwitch(this.lowValue, this.highValue, this.defaultTarget, this.cases);
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_TableSwitch, new Object[]{this.opcode()});
        }
    }

    public static final class UnboundLookupSwitchInstruction
    extends UnboundInstruction
    implements LookupSwitchInstruction {
        private final Label defaultTarget;
        private final List<SwitchCase> cases;

        public UnboundLookupSwitchInstruction(Label defaultTarget, List<SwitchCase> cases) {
            super(Opcode.LOOKUPSWITCH);
            this.defaultTarget = defaultTarget;
            this.cases = List.copyOf(cases);
        }

        @Override
        public List<SwitchCase> cases() {
            return this.cases;
        }

        @Override
        public Label defaultTarget() {
            return this.defaultTarget;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeLookupSwitch(this.defaultTarget, this.cases);
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_LookupSwitch, new Object[]{this.opcode()});
        }
    }

    public static final class UnboundBranchInstruction
    extends UnboundInstruction
    implements BranchInstruction {
        final Label target;

        public UnboundBranchInstruction(Opcode op, Label target) {
            super(op);
            this.target = target;
        }

        @Override
        public Label target() {
            return this.target;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeBranch(this.op, this.target);
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_Branch, new Object[]{this.opcode()});
        }
    }

    public static final class UnboundIncrementInstruction
    extends UnboundInstruction
    implements IncrementInstruction {
        final int slot;
        final int constant;

        public UnboundIncrementInstruction(int slot, int constant) {
            super(slot <= 255 && constant < 128 && constant > -127 ? Opcode.IINC : Opcode.IINC_W);
            this.slot = slot;
            this.constant = constant;
        }

        @Override
        public int slot() {
            return this.slot;
        }

        @Override
        public int constant() {
            return 0;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeIncrement(this.slot, this.constant);
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_Increment, new Object[]{this.opcode(), this.slot(), this.constant()});
        }
    }

    public static final class UnboundStoreInstruction
    extends UnboundInstruction
    implements StoreInstruction {
        final int slot;

        public UnboundStoreInstruction(Opcode op, int slot) {
            super(op);
            this.slot = slot;
        }

        @Override
        public int slot() {
            return this.slot;
        }

        @Override
        public TypeKind typeKind() {
            return this.op.primaryTypeKind();
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeLocalVar(this.op, this.slot);
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_Store, new Object[]{this.opcode(), this.slot()});
        }
    }

    public static final class UnboundLoadInstruction
    extends UnboundInstruction
    implements LoadInstruction {
        final int slot;

        public UnboundLoadInstruction(Opcode op, int slot) {
            super(op);
            this.slot = slot;
        }

        @Override
        public int slot() {
            return this.slot;
        }

        @Override
        public TypeKind typeKind() {
            return this.op.primaryTypeKind();
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeLocalVar(this.op, this.slot);
        }

        @Override
        public String toString() {
            return String.format(AbstractInstruction.FMT_Load, new Object[]{this.opcode(), this.slot()});
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class UnboundInstruction
    extends AbstractInstruction {
        UnboundInstruction(Opcode op) {
            super(op, op.sizeIfFixed());
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeBytecode(this.op);
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_Unbound, new Object[]{this.getClass().getSimpleName(), this.op});
        }
    }

    public static final class BoundRetInstruction
    extends BoundInstruction
    implements DiscontinuedInstruction.RetInstruction {
        public BoundRetInstruction(Opcode op, CodeImpl code, int pos) {
            super(op, op.sizeIfFixed(), code, pos);
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_Discontinued, new Object[]{this.opcode()});
        }

        @Override
        public int slot() {
            return switch (this.size) {
                case 2 -> this.code.classReader.readU1(this.pos + 1);
                case 4 -> this.code.classReader.readU2(this.pos + 2);
                default -> throw new IllegalArgumentException("Unexpected op size: " + this.op.sizeIfFixed() + " -- " + this.op);
            };
        }
    }

    public static final class BoundJsrInstruction
    extends BoundInstruction
    implements DiscontinuedInstruction.JsrInstruction {
        public BoundJsrInstruction(Opcode op, CodeImpl code, int pos) {
            super(op, op.sizeIfFixed(), code, pos);
        }

        @Override
        public Label target() {
            return this.offsetToLabel(this.branchByteOffset());
        }

        public int branchByteOffset() {
            return this.size == 3 ? this.code.classReader.readS2(this.pos + 1) : this.code.classReader.readInt(this.pos + 1);
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeBranch(this.opcode(), this.target());
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_Discontinued, new Object[]{this.opcode()});
        }
    }

    public static final class BoundLoadConstantInstruction
    extends BoundInstruction
    implements ConstantInstruction.LoadConstantInstruction {
        public BoundLoadConstantInstruction(Opcode op, CodeImpl code, int pos) {
            super(op, op.sizeIfFixed(), code, pos);
        }

        @Override
        public LoadableConstantEntry constantEntry() {
            return (LoadableConstantEntry)this.code.classReader.entryByIndex(this.op == Opcode.LDC ? this.code.classReader.readU1(this.pos + 1) : this.code.classReader.readU2(this.pos + 1));
        }

        @Override
        public ConstantDesc constantValue() {
            return this.constantEntry().constantValue();
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            if (writer.canWriteDirect(this.code.constantPool())) {
                super.writeTo(writer);
            } else {
                writer.writeLoadConstant(this.op, this.constantEntry());
            }
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_LoadConstant, new Object[]{this.opcode(), this.constantValue()});
        }
    }

    public static final class BoundArgumentConstantInstruction
    extends BoundInstruction
    implements ConstantInstruction.ArgumentConstantInstruction {
        public BoundArgumentConstantInstruction(Opcode op, CodeImpl code, int pos) {
            super(op, op.sizeIfFixed(), code, pos);
        }

        @Override
        public Integer constantValue() {
            return this.constantInt();
        }

        public int constantInt() {
            return this.size == 3 ? this.code.classReader.readS2(this.pos + 1) : this.code.classReader.readS1(this.pos + 1);
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_ArgumentConstant, new Object[]{this.opcode(), this.constantValue()});
        }
    }

    public static final class BoundTypeCheckInstruction
    extends BoundInstruction
    implements TypeCheckInstruction {
        ClassEntry typeEntry;

        public BoundTypeCheckInstruction(Opcode op, CodeImpl code, int pos) {
            super(op, op.sizeIfFixed(), code, pos);
        }

        @Override
        public ClassEntry type() {
            if (this.typeEntry == null) {
                this.typeEntry = this.code.classReader.readClassEntry(this.pos + 1);
            }
            return this.typeEntry;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            if (writer.canWriteDirect(this.code.constantPool())) {
                super.writeTo(writer);
            } else {
                writer.writeTypeCheck(this.op, this.type());
            }
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_TypeCheck, new Object[]{this.opcode(), this.type().asInternalName()});
        }
    }

    public static final class BoundNewMultidimensionalArrayInstruction
    extends BoundInstruction
    implements NewMultiArrayInstruction {
        public BoundNewMultidimensionalArrayInstruction(Opcode op, CodeImpl code, int pos) {
            super(op, op.sizeIfFixed(), code, pos);
        }

        @Override
        public int dimensions() {
            return this.code.classReader.readU1(this.pos + 3);
        }

        @Override
        public ClassEntry arrayType() {
            return this.code.classReader.readClassEntry(this.pos + 1);
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            if (writer.canWriteDirect(this.code.constantPool())) {
                super.writeTo(writer);
            } else {
                writer.writeNewMultidimensionalArray(this.dimensions(), this.arrayType());
            }
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_NewMultiArray, new Object[]{this.opcode(), this.arrayType().asInternalName(), this.dimensions()});
        }
    }

    public static final class BoundNewReferenceArrayInstruction
    extends BoundInstruction
    implements NewReferenceArrayInstruction {
        public BoundNewReferenceArrayInstruction(Opcode op, CodeImpl code, int pos) {
            super(op, op.sizeIfFixed(), code, pos);
        }

        @Override
        public ClassEntry componentType() {
            return this.code.classReader.readClassEntry(this.pos + 1);
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            if (writer.canWriteDirect(this.code.constantPool())) {
                super.writeTo(writer);
            } else {
                writer.writeNewReferenceArray(this.componentType());
            }
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_NewRefArray, new Object[]{this.opcode(), this.componentType().asInternalName()});
        }
    }

    public static final class BoundNewPrimitiveArrayInstruction
    extends BoundInstruction
    implements NewPrimitiveArrayInstruction {
        public BoundNewPrimitiveArrayInstruction(Opcode op, CodeImpl code, int pos) {
            super(op, op.sizeIfFixed(), code, pos);
        }

        @Override
        public TypeKind typeKind() {
            return TypeKind.fromNewArrayCode(this.code.classReader.readU1(this.pos + 1));
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_NewPrimitiveArray, new Object[]{this.opcode(), this.typeKind()});
        }
    }

    public static final class BoundNewObjectInstruction
    extends BoundInstruction
    implements NewObjectInstruction {
        ClassEntry classEntry;

        BoundNewObjectInstruction(CodeImpl code, int pos) {
            super(Opcode.NEW, Opcode.NEW.sizeIfFixed(), code, pos);
        }

        @Override
        public ClassEntry className() {
            if (this.classEntry == null) {
                this.classEntry = this.code.classReader.readClassEntry(this.pos + 1);
            }
            return this.classEntry;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            if (writer.canWriteDirect(this.code.constantPool())) {
                super.writeTo(writer);
            } else {
                writer.writeNewObject(this.className());
            }
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_NewObj, new Object[]{this.opcode(), this.className().asInternalName()});
        }
    }

    public static final class BoundInvokeDynamicInstruction
    extends BoundInstruction
    implements InvokeDynamicInstruction {
        InvokeDynamicEntry indyEntry;

        BoundInvokeDynamicInstruction(Opcode op, CodeImpl code, int pos) {
            super(op, op.sizeIfFixed(), code, pos);
        }

        @Override
        public InvokeDynamicEntry invokedynamic() {
            if (this.indyEntry == null) {
                this.indyEntry = this.code.classReader.readEntry(this.pos + 1, InvokeDynamicEntry.class);
            }
            return this.indyEntry;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            if (writer.canWriteDirect(this.code.constantPool())) {
                super.writeTo(writer);
            } else {
                writer.writeInvokeDynamic(this.invokedynamic());
            }
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_InvokeDynamic, new Object[]{this.opcode(), this.bootstrapMethod(), this.bootstrapArgs()});
        }
    }

    public static final class BoundInvokeInterfaceInstruction
    extends BoundInstruction
    implements InvokeInstruction {
        InterfaceMethodRefEntry methodEntry;

        public BoundInvokeInterfaceInstruction(Opcode op, CodeImpl code, int pos) {
            super(op, op.sizeIfFixed(), code, pos);
        }

        @Override
        public MemberRefEntry method() {
            if (this.methodEntry == null) {
                this.methodEntry = this.code.classReader.readEntry(this.pos + 1, InterfaceMethodRefEntry.class);
            }
            return this.methodEntry;
        }

        @Override
        public int count() {
            return this.code.classReader.readU1(this.pos + 3);
        }

        @Override
        public boolean isInterface() {
            return true;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            if (writer.canWriteDirect(this.code.constantPool())) {
                super.writeTo(writer);
            } else {
                writer.writeInvokeInterface(this.op, (InterfaceMethodRefEntry)this.method(), this.count());
            }
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_InvokeInterface, new Object[]{this.opcode(), this.owner().asInternalName(), this.name().stringValue(), this.type().stringValue()});
        }
    }

    public static final class BoundInvokeInstruction
    extends BoundInstruction
    implements InvokeInstruction {
        MemberRefEntry methodEntry;

        public BoundInvokeInstruction(Opcode op, CodeImpl code, int pos) {
            super(op, op.sizeIfFixed(), code, pos);
        }

        @Override
        public MemberRefEntry method() {
            if (this.methodEntry == null) {
                this.methodEntry = this.code.classReader.readEntry(this.pos + 1, MemberRefEntry.class);
            }
            return this.methodEntry;
        }

        @Override
        public boolean isInterface() {
            return this.method().tag() == 11;
        }

        @Override
        public int count() {
            return 0;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            if (writer.canWriteDirect(this.code.constantPool())) {
                super.writeTo(writer);
            } else {
                writer.writeInvokeNormal(this.op, this.method());
            }
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_Invoke, new Object[]{this.opcode(), this.owner().asInternalName(), this.name().stringValue(), this.type().stringValue()});
        }
    }

    public static final class BoundFieldInstruction
    extends BoundInstruction
    implements FieldInstruction {
        private FieldRefEntry fieldEntry;

        public BoundFieldInstruction(Opcode op, CodeImpl code, int pos) {
            super(op, op.sizeIfFixed(), code, pos);
        }

        @Override
        public FieldRefEntry field() {
            if (this.fieldEntry == null) {
                this.fieldEntry = this.code.classReader.readEntry(this.pos + 1, FieldRefEntry.class);
            }
            return this.fieldEntry;
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            if (writer.canWriteDirect(this.code.constantPool())) {
                super.writeTo(writer);
            } else {
                writer.writeFieldAccess(this.op, this.field());
            }
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_Field, new Object[]{this.opcode(), this.owner().asInternalName(), this.name().stringValue(), this.type().stringValue()});
        }
    }

    public static final class BoundTableSwitchInstruction
    extends BoundInstruction
    implements TableSwitchInstruction {
        BoundTableSwitchInstruction(Opcode op, CodeImpl code, int pos) {
            super(op, BoundTableSwitchInstruction.size(code, code.codeStart, pos), code, pos);
        }

        static int size(CodeImpl code, int codeStart, int pos) {
            int ap = pos + 1 + (4 - (pos + 1 - codeStart & 3) & 3);
            int pad = ap - (pos + 1);
            int low = code.classReader.readInt(ap + 4);
            int high = code.classReader.readInt(ap + 8);
            int cnt = high - low + 1;
            return 1 + pad + 12 + cnt * 4;
        }

        private int afterPadding() {
            int p = this.pos;
            return p + 1 + (4 - (p + 1 - this.code.codeStart & 3) & 3);
        }

        @Override
        public Label defaultTarget() {
            return this.offsetToLabel(this.defaultOffset());
        }

        @Override
        public int lowValue() {
            return this.code.classReader.readInt(this.afterPadding() + 4);
        }

        @Override
        public int highValue() {
            return this.code.classReader.readInt(this.afterPadding() + 8);
        }

        @Override
        public List<SwitchCase> cases() {
            int low = this.lowValue();
            int high = this.highValue();
            int defOff = this.defaultOffset();
            ArrayList<SwitchCase> cases = new ArrayList<SwitchCase>(high - low + 1);
            int z = this.afterPadding() + 12;
            for (int i = this.lowValue(); i <= high; ++i) {
                int off = this.code.classReader.readInt(z);
                if (defOff != off) {
                    cases.add(SwitchCase.of(i, this.offsetToLabel(off)));
                }
                z += 4;
            }
            return Collections.unmodifiableList(cases);
        }

        private int defaultOffset() {
            return this.code.classReader.readInt(this.afterPadding());
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeTableSwitch(this.lowValue(), this.highValue(), this.defaultTarget(), this.cases());
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_TableSwitch, new Object[]{this.opcode()});
        }
    }

    public static final class BoundLookupSwitchInstruction
    extends BoundInstruction
    implements LookupSwitchInstruction {
        private final int afterPad;
        private final int npairs;

        BoundLookupSwitchInstruction(Opcode op, CodeImpl code, int pos) {
            super(op, BoundLookupSwitchInstruction.size(code, code.codeStart, pos), code, pos);
            this.afterPad = pos + 1 + (4 - (pos + 1 - code.codeStart & 3) & 3);
            this.npairs = code.classReader.readInt(this.afterPad + 4);
        }

        static int size(CodeImpl code, int codeStart, int pos) {
            int afterPad = pos + 1 + (4 - (pos + 1 - codeStart & 3) & 3);
            int pad = afterPad - (pos + 1);
            int npairs = code.classReader.readInt(afterPad + 4);
            return 1 + pad + 8 + npairs * 8;
        }

        private int defaultOffset() {
            return this.code.classReader.readInt(this.afterPad);
        }

        @Override
        public List<SwitchCase> cases() {
            SwitchCase[] cases = new SwitchCase[this.npairs];
            for (int i = 0; i < this.npairs; ++i) {
                int z = this.afterPad + 8 + 8 * i;
                cases[i] = SwitchCase.of(this.code.classReader.readInt(z), this.offsetToLabel(this.code.classReader.readInt(z + 4)));
            }
            return List.of(cases);
        }

        @Override
        public Label defaultTarget() {
            return this.offsetToLabel(this.defaultOffset());
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeLookupSwitch(this.defaultTarget(), this.cases());
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_LookupSwitch, new Object[]{this.opcode()});
        }
    }

    public record SwitchCaseImpl(int caseValue, Label target) implements SwitchCase
    {
    }

    public static final class BoundBranchInstruction
    extends BoundInstruction
    implements BranchInstruction {
        public BoundBranchInstruction(Opcode op, CodeImpl code, int pos) {
            super(op, op.sizeIfFixed(), code, pos);
        }

        @Override
        public Label target() {
            return this.offsetToLabel(this.branchByteOffset());
        }

        public int branchByteOffset() {
            return this.size == 3 ? (int)this.code.classReader.readU2(this.pos + 1) : this.code.classReader.readInt(this.pos + 1);
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            writer.writeBranch(this.opcode(), this.target());
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_Branch, new Object[]{this.opcode()});
        }
    }

    public static final class BoundIncrementInstruction
    extends BoundInstruction
    implements IncrementInstruction {
        public BoundIncrementInstruction(Opcode op, CodeImpl code, int pos) {
            super(op, op.sizeIfFixed(), code, pos);
        }

        @Override
        public int slot() {
            return this.size == 6 ? this.code.classReader.readU2(this.pos + 2) : this.code.classReader.readU1(this.pos + 1);
        }

        @Override
        public int constant() {
            return (byte)(this.size == 6 ? this.code.classReader.readS2(this.pos + 4) : (byte)this.code.classReader.readS1(this.pos + 2));
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_Increment, new Object[]{this.opcode(), this.slot(), this.constant()});
        }
    }

    public static final class BoundStoreInstruction
    extends BoundInstruction
    implements StoreInstruction {
        public BoundStoreInstruction(Opcode op, CodeImpl code, int pos) {
            super(op, op.sizeIfFixed(), code, pos);
        }

        @Override
        public TypeKind typeKind() {
            return this.op.primaryTypeKind();
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_Store, new Object[]{this.opcode(), this.slot()});
        }

        @Override
        public int slot() {
            return switch (this.size) {
                case 2 -> this.code.classReader.readU1(this.pos + 1);
                case 4 -> this.code.classReader.readU2(this.pos + 2);
                default -> throw new IllegalArgumentException("Unexpected op size: " + this.size + " -- " + this.op);
            };
        }
    }

    public static final class BoundLoadInstruction
    extends BoundInstruction
    implements LoadInstruction {
        public BoundLoadInstruction(Opcode op, CodeImpl code, int pos) {
            super(op, op.sizeIfFixed(), code, pos);
        }

        @Override
        public TypeKind typeKind() {
            return this.op.primaryTypeKind();
        }

        public String toString() {
            return String.format(AbstractInstruction.FMT_Load, new Object[]{this.opcode(), this.slot()});
        }

        @Override
        public int slot() {
            return switch (this.size) {
                case 2 -> this.code.classReader.readU1(this.pos + 1);
                case 4 -> this.code.classReader.readU2(this.pos + 2);
                default -> throw new IllegalArgumentException("Unexpected op size: " + this.op.sizeIfFixed() + " -- " + this.op);
            };
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class BoundInstruction
    extends AbstractInstruction {
        final CodeImpl code;
        final int pos;

        protected BoundInstruction(Opcode op, int size, CodeImpl code, int pos) {
            super(op, size);
            this.code = code;
            this.pos = pos;
        }

        protected Label offsetToLabel(int offset) {
            return this.code.getLabel(this.pos - this.code.codeStart + offset);
        }

        @Override
        public void writeTo(DirectCodeBuilder writer) {
            this.code.classReader.copyBytesTo(writer.bytecodesBufWriter, this.pos, this.size);
        }
    }
}

