/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.TypeDescriptor;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.glavo.classfile.BufWriter;
import org.glavo.classfile.constant.ModuleDesc;
import org.glavo.classfile.constant.PackageDesc;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.ConstantDynamicEntry;
import org.glavo.classfile.constantpool.ConstantPool;
import org.glavo.classfile.constantpool.ConstantPoolBuilder;
import org.glavo.classfile.constantpool.DoubleEntry;
import org.glavo.classfile.constantpool.FieldRefEntry;
import org.glavo.classfile.constantpool.FloatEntry;
import org.glavo.classfile.constantpool.IntegerEntry;
import org.glavo.classfile.constantpool.InterfaceMethodRefEntry;
import org.glavo.classfile.constantpool.InvokeDynamicEntry;
import org.glavo.classfile.constantpool.LongEntry;
import org.glavo.classfile.constantpool.MemberRefEntry;
import org.glavo.classfile.constantpool.MethodHandleEntry;
import org.glavo.classfile.constantpool.MethodRefEntry;
import org.glavo.classfile.constantpool.MethodTypeEntry;
import org.glavo.classfile.constantpool.ModuleEntry;
import org.glavo.classfile.constantpool.NameAndTypeEntry;
import org.glavo.classfile.constantpool.PackageEntry;
import org.glavo.classfile.constantpool.PoolEntry;
import org.glavo.classfile.constantpool.StringEntry;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.BootstrapMethodEntryImpl;
import org.glavo.classfile.impl.SplitConstantPool;
import org.glavo.classfile.impl.Util;
import org.glavo.classfile.jdk.ArrayUtils;
import org.glavo.classfile.jdk.JavaLangAccessUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractPoolEntry {
    private static final int TAG_SMEAR = 331657937;
    private static final int INT_PHI = -1640531527;
    final ConstantPool constantPool;
    public final byte tag;
    private final int index;
    private final int hash;

    public static int hash1(int tag, int x1) {
        return AbstractPoolEntry.phiMix(tag * 331657937 + x1);
    }

    public static int hash2(int tag, int x1, int x2) {
        return AbstractPoolEntry.phiMix(tag * 331657937 + x1 + 31 * x2);
    }

    public static int hashString(int stringHash) {
        return AbstractPoolEntry.phiMix(stringHash | 0x40000000);
    }

    public static int phiMix(int x) {
        int h = x * -1640531527;
        return h ^ h >> 16;
    }

    public static Utf8Entry rawUtf8EntryFromStandardAttributeName(String name) {
        byte[] raw = name.getBytes(StandardCharsets.US_ASCII);
        return new Utf8EntryImpl(null, 0, raw, 0, raw.length);
    }

    public static <T extends PoolEntry> T maybeClone(ConstantPoolBuilder cp, T entry) {
        return (T)((AbstractPoolEntry)((Object)entry)).clone(cp);
    }

    private AbstractPoolEntry(ConstantPool constantPool, int tag, int index, int hash) {
        this.tag = (byte)tag;
        this.index = index;
        this.hash = hash;
        this.constantPool = constantPool;
    }

    public ConstantPool constantPool() {
        return this.constantPool;
    }

    public int index() {
        return this.index;
    }

    public int hashCode() {
        return this.hash;
    }

    public byte tag() {
        return this.tag;
    }

    public int width() {
        return this.tag == 5 || this.tag == 6 ? 2 : 1;
    }

    abstract PoolEntry clone(ConstantPoolBuilder var1);

    public static final class Utf8EntryImpl
    extends AbstractPoolEntry
    implements Utf8Entry {
        private State state;
        private final byte[] rawBytes;
        private final int offset;
        private final int rawLen;
        private int hash;
        private int charLen;
        private char[] chars;
        private String stringValue;

        Utf8EntryImpl(ConstantPool cpm, int index, byte[] rawBytes, int offset, int rawLen) {
            super(cpm, 1, index, 0);
            this.rawBytes = rawBytes;
            this.offset = offset;
            this.rawLen = rawLen;
            this.state = State.RAW;
        }

        Utf8EntryImpl(ConstantPool cpm, int index, String s) {
            this(cpm, index, s, Utf8EntryImpl.hashString(s.hashCode()));
        }

        Utf8EntryImpl(ConstantPool cpm, int index, String s, int hash) {
            super(cpm, 1, index, 0);
            this.rawBytes = null;
            this.offset = 0;
            this.rawLen = 0;
            this.state = State.STRING;
            this.stringValue = s;
            this.charLen = s.length();
            this.hash = hash;
        }

        Utf8EntryImpl(ConstantPool cpm, int index, Utf8EntryImpl u) {
            super(cpm, 1, index, 0);
            this.rawBytes = u.rawBytes;
            this.offset = u.offset;
            this.rawLen = u.rawLen;
            this.state = u.state;
            this.hash = u.hash;
            this.charLen = u.charLen;
            this.chars = u.chars;
            this.stringValue = u.stringValue;
        }

        private void inflate() {
            int singleBytes = JavaLangAccessUtils.countPositives(this.rawBytes, this.offset, this.rawLen);
            int hash = ArrayUtils.signedHashCode(0, this.rawBytes, this.offset, singleBytes);
            if (singleBytes == this.rawLen) {
                this.hash = Utf8EntryImpl.hashString(hash);
                this.charLen = this.rawLen;
                this.state = State.BYTE;
            } else {
                char[] chararr = new char[this.rawLen];
                int chararr_count = singleBytes;
                JavaLangAccessUtils.inflateBytesToChars(this.rawBytes, this.offset, chararr, 0, singleBytes);
                int px = this.offset + singleBytes;
                int utfend = this.offset + this.rawLen;
                block5: while (px < utfend) {
                    int c = this.rawBytes[px] & 0xFF;
                    switch (c >> 4) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            ++px;
                            chararr[chararr_count++] = (char)c;
                            hash = 31 * hash + c;
                            continue block5;
                        }
                        case 12: 
                        case 13: {
                            if ((px += 2) > utfend) {
                                throw new CpException("malformed input: partial character at end");
                            }
                            byte char2 = this.rawBytes[px - 1];
                            if ((char2 & 0xC0) != 128) {
                                throw new CpException("malformed input around byte " + px);
                            }
                            char v = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                            chararr[chararr_count++] = v;
                            hash = 31 * hash + v;
                            continue block5;
                        }
                        case 14: {
                            if ((px += 3) > utfend) {
                                throw new CpException("malformed input: partial character at end");
                            }
                            byte char2 = this.rawBytes[px - 2];
                            byte char3 = this.rawBytes[px - 1];
                            if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                                throw new CpException("malformed input around byte " + (px - 1));
                            }
                            char v = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                            chararr[chararr_count++] = v;
                            hash = 31 * hash + v;
                            continue block5;
                        }
                    }
                    throw new CpException("malformed input around byte " + px);
                }
                this.hash = Utf8EntryImpl.hashString(hash);
                this.charLen = chararr_count;
                this.chars = chararr;
                this.state = State.CHAR;
            }
        }

        @Override
        public Utf8EntryImpl clone(ConstantPoolBuilder cp) {
            if (cp.canWriteDirect(this.constantPool)) {
                return this;
            }
            return this.state == State.STRING && this.rawBytes == null ? (Utf8EntryImpl)cp.utf8Entry(this.stringValue) : ((SplitConstantPool)cp).maybeCloneUtf8Entry(this);
        }

        @Override
        public int hashCode() {
            if (this.state == State.RAW) {
                this.inflate();
            }
            return this.hash;
        }

        @Override
        public String toString() {
            if (this.state == State.RAW) {
                this.inflate();
            }
            if (this.state != State.STRING) {
                this.stringValue = this.chars != null ? new String(this.chars, 0, this.charLen) : new String(this.rawBytes, this.offset, this.charLen, StandardCharsets.ISO_8859_1);
                this.state = State.STRING;
            }
            return this.stringValue;
        }

        @Override
        public String stringValue() {
            return this.toString();
        }

        @Override
        public ConstantDesc constantValue() {
            return this.stringValue();
        }

        @Override
        public int length() {
            if (this.state == State.RAW) {
                this.inflate();
            }
            return this.charLen;
        }

        @Override
        public char charAt(int index) {
            if (this.state == State.STRING) {
                return this.stringValue.charAt(index);
            }
            if (this.state == State.RAW) {
                this.inflate();
            }
            return this.chars != null ? this.chars[index] : (char)this.rawBytes[index + this.offset];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.toString().subSequence(start, end);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Utf8EntryImpl) {
                Utf8EntryImpl u = (Utf8EntryImpl)o;
                return this.equalsUtf8(u);
            }
            return false;
        }

        public boolean equalsUtf8(Utf8EntryImpl u) {
            if (this.hashCode() != u.hashCode() || this.length() != u.length()) {
                return false;
            }
            if (this.rawBytes != null && u.rawBytes != null) {
                return Arrays.equals(this.rawBytes, this.offset, this.offset + this.rawLen, u.rawBytes, u.offset, u.offset + u.rawLen);
            }
            if (this.state == State.STRING && u.state == State.STRING) {
                return this.stringValue.equals(u.stringValue);
            }
            return this.stringValue().equals(u.stringValue());
        }

        @Override
        public boolean equalsString(String s) {
            if (this.state == State.RAW) {
                this.inflate();
            }
            switch (this.state) {
                case STRING: {
                    return this.stringValue.equals(s);
                }
                case CHAR: {
                    if (this.charLen != s.length() || this.hash != Utf8EntryImpl.hashString(s.hashCode())) {
                        return false;
                    }
                    for (int i = 0; i < this.charLen; ++i) {
                        if (this.chars[i] == s.charAt(i)) continue;
                        return false;
                    }
                    this.stringValue = s;
                    this.state = State.STRING;
                    return true;
                }
                case BYTE: {
                    if (this.rawLen != s.length() || this.hash != Utf8EntryImpl.hashString(s.hashCode())) {
                        return false;
                    }
                    for (int i = 0; i < this.rawLen; ++i) {
                        if (this.rawBytes[this.offset + i] == s.charAt(i)) continue;
                        return false;
                    }
                    this.stringValue = s;
                    this.state = State.STRING;
                    return true;
                }
            }
            throw new IllegalStateException("cannot reach here");
        }

        @Override
        public void writeTo(BufWriter pool) {
            if (this.rawBytes != null) {
                pool.writeU1(this.tag);
                pool.writeU2(this.rawLen);
                pool.writeBytes(this.rawBytes, this.offset, this.rawLen);
            } else {
                if (this.stringValue.length() > 65535) {
                    throw new IllegalArgumentException("string too long");
                }
                pool.writeU1(this.tag);
                pool.writeU2(this.charLen);
                for (int i = 0; i < this.charLen; ++i) {
                    char c1;
                    char c = this.stringValue.charAt(i);
                    if (c >= '\u0001' && c <= '\u007f') {
                        pool.writeU1((byte)c);
                        continue;
                    }
                    int charLength = this.stringValue.length();
                    int byteLength = i;
                    for (int j = i; j < charLength; ++j) {
                        c1 = this.stringValue.charAt(j);
                        if (c1 >= '\u0001' && c1 <= '\u007f') {
                            ++byteLength;
                            continue;
                        }
                        if (c1 > '\u07ff') {
                            byteLength += 3;
                            continue;
                        }
                        byteLength += 2;
                    }
                    if (byteLength > 65535) {
                        throw new IllegalArgumentException();
                    }
                    int byteLengthFinal = byteLength;
                    pool.patchInt(pool.size() - i - 2, 2, byteLengthFinal);
                    for (int j = i; j < charLength; ++j) {
                        c1 = this.stringValue.charAt(j);
                        if (c1 >= '\u0001' && c1 <= '\u007f') {
                            pool.writeU1((byte)c1);
                            continue;
                        }
                        if (c1 > '\u07ff') {
                            pool.writeU1((byte)(0xE0 | c1 >> 12 & 0xF));
                            pool.writeU1((byte)(0x80 | c1 >> 6 & 0x3F));
                            pool.writeU1((byte)(0x80 | c1 & 0x3F));
                            continue;
                        }
                        pool.writeU1((byte)(0xC0 | c1 >> 6 & 0x1F));
                        pool.writeU1((byte)(0x80 | c1 & 0x3F));
                    }
                    break;
                }
            }
        }

        static enum State {
            RAW,
            BYTE,
            CHAR,
            STRING;

        }
    }

    static class CpException
    extends RuntimeException {
        static final long serialVersionUID = 32L;

        CpException(String s) {
            super(s);
        }
    }

    public static final class DoubleEntryImpl
    extends PrimitiveEntry<Double>
    implements DoubleEntry {
        DoubleEntryImpl(ConstantPool cpm, int index, double d) {
            super(cpm, 6, index, d);
        }

        @Override
        public void writeTo(BufWriter pool) {
            pool.writeU1(this.tag);
            pool.writeDouble((Double)this.val);
        }

        @Override
        public DoubleEntry clone(ConstantPoolBuilder cp) {
            return cp.canWriteDirect(this.constantPool) ? this : cp.doubleEntry((Double)this.val);
        }

        @Override
        public double doubleValue() {
            return (Double)this.value();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof DoubleEntryImpl) {
                DoubleEntryImpl e = (DoubleEntryImpl)o;
                return this.doubleValue() == e.doubleValue();
            }
            return false;
        }
    }

    public static final class LongEntryImpl
    extends PrimitiveEntry<Long>
    implements LongEntry {
        LongEntryImpl(ConstantPool cpm, int index, long l) {
            super(cpm, 5, index, l);
        }

        @Override
        public void writeTo(BufWriter pool) {
            pool.writeU1(this.tag);
            pool.writeLong((Long)this.val);
        }

        @Override
        public LongEntry clone(ConstantPoolBuilder cp) {
            return cp.canWriteDirect(this.constantPool) ? this : cp.longEntry((Long)this.val);
        }

        @Override
        public long longValue() {
            return (Long)this.value();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof LongEntryImpl) {
                LongEntryImpl e = (LongEntryImpl)o;
                return this.longValue() == e.longValue();
            }
            return false;
        }
    }

    public static final class FloatEntryImpl
    extends PrimitiveEntry<Float>
    implements FloatEntry {
        FloatEntryImpl(ConstantPool cpm, int index, float f) {
            super(cpm, 4, index, Float.valueOf(f));
        }

        @Override
        public void writeTo(BufWriter pool) {
            pool.writeU1(this.tag);
            pool.writeFloat(((Float)this.val).floatValue());
        }

        @Override
        public FloatEntry clone(ConstantPoolBuilder cp) {
            return cp.canWriteDirect(this.constantPool) ? this : cp.floatEntry(((Float)this.val).floatValue());
        }

        @Override
        public float floatValue() {
            return ((Float)this.value()).floatValue();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof FloatEntryImpl) {
                FloatEntryImpl e = (FloatEntryImpl)o;
                return this.floatValue() == e.floatValue();
            }
            return false;
        }
    }

    public static final class IntegerEntryImpl
    extends PrimitiveEntry<Integer>
    implements IntegerEntry {
        IntegerEntryImpl(ConstantPool cpm, int index, int i) {
            super(cpm, 3, index, Integer.valueOf(i));
        }

        @Override
        public void writeTo(BufWriter pool) {
            pool.writeU1(this.tag);
            pool.writeInt((Integer)this.val);
        }

        @Override
        public IntegerEntry clone(ConstantPoolBuilder cp) {
            return cp.canWriteDirect(this.constantPool) ? this : cp.intEntry((Integer)this.val);
        }

        @Override
        public int intValue() {
            return (Integer)this.value();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof IntegerEntryImpl) {
                IntegerEntryImpl e = (IntegerEntryImpl)o;
                return this.intValue() == e.intValue();
            }
            return false;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static abstract class PrimitiveEntry<T extends ConstantDesc>
    extends AbstractPoolEntry {
        protected final T val;

        public PrimitiveEntry(ConstantPool constantPool, int tag, int index, T val) {
            super(constantPool, tag, index, PrimitiveEntry.hash1(tag, val.hashCode()));
            this.val = val;
        }

        public T value() {
            return this.val;
        }

        public ConstantDesc constantValue() {
            return this.value();
        }

        public String toString() {
            return "" + this.tag() + this.value();
        }
    }

    public static final class StringEntryImpl
    extends AbstractRefEntry<Utf8EntryImpl>
    implements StringEntry {
        StringEntryImpl(ConstantPool cpm, int index, Utf8EntryImpl utf8) {
            super(cpm, 8, index, utf8);
        }

        @Override
        public Utf8EntryImpl utf8() {
            return (Utf8EntryImpl)this.ref1;
        }

        @Override
        public String stringValue() {
            return ((Utf8EntryImpl)this.ref1).toString();
        }

        @Override
        public ConstantDesc constantValue() {
            return this.stringValue();
        }

        @Override
        public StringEntry clone(ConstantPoolBuilder cp) {
            return cp.canWriteDirect(this.constantPool) ? this : cp.stringEntry((Utf8Entry)this.ref1);
        }

        @Override
        public String toString() {
            return this.tag() + " \"" + this.stringValue() + "\"";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof StringEntryImpl) {
                StringEntryImpl s = (StringEntryImpl)o;
                return this.utf8().equals(s.utf8());
            }
            return false;
        }
    }

    public static final class MethodTypeEntryImpl
    extends AbstractRefEntry<Utf8EntryImpl>
    implements MethodTypeEntry {
        public MethodTypeDesc sym = null;

        MethodTypeEntryImpl(ConstantPool cpm, int index, Utf8EntryImpl descriptor) {
            super(cpm, 16, index, descriptor);
        }

        @Override
        public Utf8Entry descriptor() {
            return (Utf8Entry)this.ref1;
        }

        @Override
        public MethodTypeEntry clone(ConstantPoolBuilder cp) {
            if (cp.canWriteDirect(this.constantPool)) {
                return this;
            }
            MethodTypeEntryImpl ret = (MethodTypeEntryImpl)cp.methodTypeEntry((Utf8Entry)this.ref1);
            ret.sym = this.sym;
            return ret;
        }

        @Override
        public MethodTypeDesc asSymbol() {
            MethodTypeDesc sym = this.sym;
            if (sym != null) {
                return sym;
            }
            this.sym = MethodTypeDesc.ofDescriptor(this.descriptor().stringValue());
            return this.sym;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof MethodTypeEntryImpl) {
                MethodTypeEntryImpl m = (MethodTypeEntryImpl)o;
                return this.descriptor().equals(m.descriptor());
            }
            return false;
        }
    }

    public static final class MethodHandleEntryImpl
    extends AbstractPoolEntry
    implements MethodHandleEntry {
        private final int refKind;
        private final AbstractMemberRefEntry reference;

        MethodHandleEntryImpl(ConstantPool cpm, int index, int hash, int refKind, AbstractMemberRefEntry reference) {
            super(cpm, 15, index, hash);
            this.refKind = refKind;
            this.reference = reference;
        }

        MethodHandleEntryImpl(ConstantPool cpm, int index, int refKind, AbstractMemberRefEntry reference) {
            super(cpm, 15, index, MethodHandleEntryImpl.hash2(15, refKind, reference.index()));
            this.refKind = refKind;
            this.reference = reference;
        }

        @Override
        public int kind() {
            return this.refKind;
        }

        @Override
        public AbstractMemberRefEntry reference() {
            return this.reference;
        }

        @Override
        public DirectMethodHandleDesc asSymbol() {
            return MethodHandleDesc.of(DirectMethodHandleDesc.Kind.valueOf(this.kind(), this.reference() instanceof InterfaceMethodRefEntry), this.reference().owner().asSymbol(), this.reference().nameAndType().name().stringValue(), this.reference().nameAndType().type().stringValue());
        }

        @Override
        public void writeTo(BufWriter pool) {
            pool.writeU1(this.tag);
            pool.writeU1(this.refKind);
            pool.writeU2(this.reference.index());
        }

        @Override
        public MethodHandleEntry clone(ConstantPoolBuilder cp) {
            return cp.canWriteDirect(this.constantPool) ? this : cp.methodHandleEntry(this.refKind, this.reference);
        }

        public String toString() {
            return this.tag() + " " + this.kind() + ":" + this.reference().owner().asInternalName() + "." + this.reference().nameAndType().name().stringValue() + "-" + this.reference().nameAndType().type().stringValue();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof MethodHandleEntryImpl) {
                MethodHandleEntryImpl m = (MethodHandleEntryImpl)o;
                return this.kind() == m.kind() && this.reference.equals(m.reference());
            }
            return false;
        }
    }

    public static final class ConstantDynamicEntryImpl
    extends AbstractDynamicConstantPoolEntry
    implements ConstantDynamicEntry {
        ConstantDynamicEntryImpl(ConstantPool cpm, int index, int hash, BootstrapMethodEntryImpl bootstrapMethod, NameAndTypeEntryImpl nameAndType) {
            super(cpm, 17, index, hash, bootstrapMethod, nameAndType);
        }

        ConstantDynamicEntryImpl(ConstantPool cpm, int index, int bsmIndex, NameAndTypeEntryImpl nameAndType) {
            super(cpm, 17, index, ConstantDynamicEntryImpl.hash2(17, bsmIndex, nameAndType.index()), bsmIndex, nameAndType);
        }

        @Override
        public ConstantDynamicEntry clone(ConstantPoolBuilder cp) {
            return cp.canWriteDirect(this.constantPool) ? this : cp.constantDynamicEntry(this.bootstrap(), this.nameAndType());
        }
    }

    public static final class InvokeDynamicEntryImpl
    extends AbstractDynamicConstantPoolEntry
    implements InvokeDynamicEntry {
        InvokeDynamicEntryImpl(ConstantPool cpm, int index, int hash, BootstrapMethodEntryImpl bootstrapMethod, NameAndTypeEntryImpl nameAndType) {
            super(cpm, 18, index, hash, bootstrapMethod, nameAndType);
        }

        InvokeDynamicEntryImpl(ConstantPool cpm, int index, int bsmIndex, NameAndTypeEntryImpl nameAndType) {
            super(cpm, 18, index, InvokeDynamicEntryImpl.hash2(18, bsmIndex, nameAndType.index()), bsmIndex, nameAndType);
        }

        @Override
        public InvokeDynamicEntry clone(ConstantPoolBuilder cp) {
            return cp.canWriteDirect(this.constantPool) ? this : cp.invokeDynamicEntry(this.bootstrap(), this.nameAndType());
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class AbstractDynamicConstantPoolEntry
    extends AbstractPoolEntry {
        private final int bsmIndex;
        private BootstrapMethodEntryImpl bootstrapMethod;
        private final NameAndTypeEntryImpl nameAndType;

        AbstractDynamicConstantPoolEntry(ConstantPool cpm, int tag, int index, int hash, BootstrapMethodEntryImpl bootstrapMethod, NameAndTypeEntryImpl nameAndType) {
            super(cpm, tag, index, hash);
            this.bsmIndex = bootstrapMethod.bsmIndex();
            this.bootstrapMethod = bootstrapMethod;
            this.nameAndType = nameAndType;
        }

        AbstractDynamicConstantPoolEntry(ConstantPool cpm, int tag, int index, int hash, int bsmIndex, NameAndTypeEntryImpl nameAndType) {
            super(cpm, tag, index, hash);
            this.bsmIndex = bsmIndex;
            this.bootstrapMethod = null;
            this.nameAndType = nameAndType;
        }

        public BootstrapMethodEntryImpl bootstrap() {
            if (this.bootstrapMethod == null) {
                this.bootstrapMethod = (BootstrapMethodEntryImpl)this.constantPool.bootstrapMethodEntry(this.bsmIndex);
            }
            return this.bootstrapMethod;
        }

        public int bootstrapMethodIndex() {
            return this.bsmIndex;
        }

        public NameAndTypeEntryImpl nameAndType() {
            return this.nameAndType;
        }

        public void writeTo(BufWriter pool) {
            pool.writeU1(this.tag);
            pool.writeU2(this.bsmIndex);
            pool.writeU2(this.nameAndType.index());
        }

        public String toString() {
            return this.tag() + " " + this.bootstrap() + "." + this.nameAndType().name().stringValue() + "-" + this.nameAndType().type().stringValue();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof AbstractDynamicConstantPoolEntry) {
                AbstractDynamicConstantPoolEntry d = (AbstractDynamicConstantPoolEntry)o;
                return this.tag() == d.tag() && this.bootstrap().equals(d.bootstrap()) && this.nameAndType.equals(d.nameAndType());
            }
            return false;
        }
    }

    public static final class InterfaceMethodRefEntryImpl
    extends AbstractMemberRefEntry
    implements InterfaceMethodRefEntry {
        InterfaceMethodRefEntryImpl(ConstantPool cpm, int index, ClassEntryImpl owner, NameAndTypeEntryImpl nameAndType) {
            super(cpm, 11, index, owner, nameAndType);
        }

        @Override
        public InterfaceMethodRefEntry clone(ConstantPoolBuilder cp) {
            return cp.canWriteDirect(this.constantPool) ? this : cp.interfaceMethodRefEntry((ClassEntry)this.ref1, (NameAndTypeEntry)this.ref2);
        }
    }

    public static final class MethodRefEntryImpl
    extends AbstractMemberRefEntry
    implements MethodRefEntry {
        MethodRefEntryImpl(ConstantPool cpm, int index, ClassEntryImpl owner, NameAndTypeEntryImpl nameAndType) {
            super(cpm, 10, index, owner, nameAndType);
        }

        @Override
        public MethodRefEntry clone(ConstantPoolBuilder cp) {
            return cp.canWriteDirect(this.constantPool) ? this : cp.methodRefEntry((ClassEntry)this.ref1, (NameAndTypeEntry)this.ref2);
        }
    }

    public static final class FieldRefEntryImpl
    extends AbstractMemberRefEntry
    implements FieldRefEntry {
        FieldRefEntryImpl(ConstantPool cpm, int index, ClassEntryImpl owner, NameAndTypeEntryImpl nameAndType) {
            super(cpm, 9, index, owner, nameAndType);
        }

        @Override
        public FieldRefEntry clone(ConstantPoolBuilder cp) {
            return cp.canWriteDirect(this.constantPool) ? this : cp.fieldRefEntry((ClassEntry)this.ref1, (NameAndTypeEntry)this.ref2);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class AbstractMemberRefEntry
    extends AbstractRefsEntry<ClassEntryImpl, NameAndTypeEntryImpl>
    implements MemberRefEntry {
        AbstractMemberRefEntry(ConstantPool cpm, int tag, int index, ClassEntryImpl owner, NameAndTypeEntryImpl nameAndType) {
            super(cpm, tag, index, owner, nameAndType);
        }

        @Override
        public ClassEntryImpl owner() {
            return (ClassEntryImpl)this.ref1;
        }

        @Override
        public NameAndTypeEntryImpl nameAndType() {
            return (NameAndTypeEntryImpl)this.ref2;
        }

        @Override
        public String toString() {
            return this.tag() + " " + this.owner().asInternalName() + "." + this.nameAndType().name().stringValue() + "-" + this.nameAndType().type().stringValue();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof AbstractMemberRefEntry) {
                AbstractMemberRefEntry m = (AbstractMemberRefEntry)o;
                return this.tag == m.tag() && this.owner().equals(m.owner()) && this.nameAndType().equals(m.nameAndType());
            }
            return false;
        }
    }

    public static final class NameAndTypeEntryImpl
    extends AbstractRefsEntry<Utf8EntryImpl, Utf8EntryImpl>
    implements NameAndTypeEntry {
        public TypeDescriptor typeSym = null;

        NameAndTypeEntryImpl(ConstantPool cpm, int index, Utf8EntryImpl name, Utf8EntryImpl type) {
            super(cpm, 12, index, name, type);
        }

        @Override
        public Utf8Entry name() {
            return (Utf8Entry)this.ref1;
        }

        @Override
        public Utf8Entry type() {
            return (Utf8Entry)this.ref2;
        }

        public ClassDesc fieldTypeSymbol() {
            TypeDescriptor typeDescriptor = this.typeSym;
            if (typeDescriptor instanceof ClassDesc) {
                ClassDesc cd = (ClassDesc)typeDescriptor;
                return cd;
            }
            this.typeSym = ClassDesc.ofDescriptor(((Utf8EntryImpl)this.ref2).stringValue());
            return this.typeSym;
        }

        public MethodTypeDesc methodTypeSymbol() {
            TypeDescriptor typeDescriptor = this.typeSym;
            if (typeDescriptor instanceof MethodTypeDesc) {
                MethodTypeDesc mtd = (MethodTypeDesc)typeDescriptor;
                return mtd;
            }
            this.typeSym = MethodTypeDesc.ofDescriptor(((Utf8EntryImpl)this.ref2).stringValue());
            return this.typeSym;
        }

        @Override
        public NameAndTypeEntry clone(ConstantPoolBuilder cp) {
            if (cp.canWriteDirect(this.constantPool)) {
                return this;
            }
            NameAndTypeEntryImpl ret = (NameAndTypeEntryImpl)cp.nameAndTypeEntry((Utf8Entry)this.ref1, (Utf8Entry)this.ref2);
            ret.typeSym = this.typeSym;
            return ret;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof NameAndTypeEntryImpl) {
                NameAndTypeEntryImpl nat = (NameAndTypeEntryImpl)o;
                return this.name().equals(nat.name()) && this.type().equals(nat.type());
            }
            return false;
        }
    }

    public static final class ModuleEntryImpl
    extends AbstractNamedEntry
    implements ModuleEntry {
        ModuleEntryImpl(ConstantPool cpm, int index, Utf8EntryImpl name) {
            super(cpm, 19, index, name);
        }

        @Override
        public ModuleEntry clone(ConstantPoolBuilder cp) {
            return cp.canWriteDirect(this.constantPool) ? this : cp.moduleEntry((Utf8Entry)this.ref1);
        }

        @Override
        public ModuleDesc asSymbol() {
            return ModuleDesc.of(this.asInternalName());
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ModuleEntryImpl) {
                ModuleEntryImpl m = (ModuleEntryImpl)o;
                return this.name().equals(m.name());
            }
            return false;
        }
    }

    public static final class PackageEntryImpl
    extends AbstractNamedEntry
    implements PackageEntry {
        PackageEntryImpl(ConstantPool cpm, int index, Utf8EntryImpl name) {
            super(cpm, 20, index, name);
        }

        @Override
        public PackageEntry clone(ConstantPoolBuilder cp) {
            return cp.canWriteDirect(this.constantPool) ? this : cp.packageEntry((Utf8Entry)this.ref1);
        }

        @Override
        public PackageDesc asSymbol() {
            return PackageDesc.ofInternalName(this.asInternalName());
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof PackageEntry) {
                PackageEntry p = (PackageEntry)o;
                return this.name().equals(p.name());
            }
            return false;
        }
    }

    public static final class ClassEntryImpl
    extends AbstractNamedEntry
    implements ClassEntry {
        public ClassDesc sym = null;

        ClassEntryImpl(ConstantPool cpm, int index, Utf8EntryImpl name) {
            super(cpm, 7, index, name);
        }

        @Override
        public ClassEntry clone(ConstantPoolBuilder cp) {
            if (cp.canWriteDirect(this.constantPool)) {
                return this;
            }
            ClassEntryImpl ret = (ClassEntryImpl)cp.classEntry((Utf8Entry)this.ref1);
            ret.sym = this.sym;
            return ret;
        }

        @Override
        public ClassDesc asSymbol() {
            ClassDesc sym = this.sym;
            if (sym != null) {
                return sym;
            }
            this.sym = Util.toClassDesc(this.asInternalName());
            return this.sym;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ClassEntryImpl) {
                ClassEntryImpl cce = (ClassEntryImpl)o;
                return cce.name().equals(this.name());
            }
            if (o instanceof ClassEntry) {
                ClassEntry c = (ClassEntry)o;
                return c.asSymbol().equals(this.asSymbol());
            }
            return false;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static abstract class AbstractNamedEntry
    extends AbstractRefEntry<Utf8EntryImpl> {
        public AbstractNamedEntry(ConstantPool constantPool, int tag, int index, Utf8EntryImpl ref1) {
            super(constantPool, tag, index, ref1);
        }

        public Utf8Entry name() {
            return (Utf8Entry)this.ref1;
        }

        public String asInternalName() {
            return ((Utf8EntryImpl)this.ref1).stringValue();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AbstractNamedEntry) {
                AbstractNamedEntry ne = (AbstractNamedEntry)o;
                return this.tag == ne.tag() && this.name().equals(this.ref1());
            }
            return false;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static abstract class AbstractRefsEntry<T extends PoolEntry, U extends PoolEntry>
    extends AbstractPoolEntry {
        protected final T ref1;
        protected final U ref2;

        public AbstractRefsEntry(ConstantPool constantPool, int tag, int index, T ref1, U ref2) {
            super(constantPool, tag, index, AbstractRefsEntry.hash2(tag, ref1.index(), ref2.index()));
            this.ref1 = ref1;
            this.ref2 = ref2;
        }

        public T ref1() {
            return this.ref1;
        }

        public U ref2() {
            return this.ref2;
        }

        public void writeTo(BufWriter pool) {
            pool.writeU1(this.tag);
            pool.writeU2(this.ref1.index());
            pool.writeU2(this.ref2.index());
        }

        public String toString() {
            return this.tag() + " " + this.ref1 + "-" + this.ref2;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static abstract class AbstractRefEntry<T extends PoolEntry>
    extends AbstractPoolEntry {
        protected final T ref1;

        public AbstractRefEntry(ConstantPool constantPool, int tag, int index, T ref1) {
            super(constantPool, tag, index, AbstractRefEntry.hash1(tag, ref1.index()));
            this.ref1 = ref1;
        }

        public T ref1() {
            return this.ref1;
        }

        public void writeTo(BufWriter pool) {
            pool.writeU1(this.tag);
            pool.writeU2(this.ref1.index());
        }

        public String toString() {
            return this.tag() + " " + this.ref1();
        }
    }
}

