/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.glavo.classfile.Attribute;
import org.glavo.classfile.AttributedElement;
import org.glavo.classfile.ClassFileElement;
import org.glavo.classfile.CompoundElement;
import org.glavo.classfile.impl.AbstractElement;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractUnboundModel<E extends ClassFileElement>
extends AbstractElement
implements CompoundElement<E>,
AttributedElement {
    private final List<E> elements;
    private List<Attribute<?>> attributes;

    public AbstractUnboundModel(List<E> elements) {
        this.elements = elements;
    }

    @Override
    public void forEachElement(Consumer<E> consumer) {
        this.elements.forEach(consumer);
    }

    @Override
    public Stream<E> elementStream() {
        return this.elements.stream();
    }

    @Override
    public List<E> elementList() {
        return this.elements;
    }

    @Override
    public List<Attribute<?>> attributes() {
        if (this.attributes == null) {
            this.attributes = this.elements.stream().filter(e -> e instanceof Attribute).map(e -> (Attribute)e).toList();
        }
        return this.attributes;
    }
}

