/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.ArrayList;
import java.util.List;
import org.glavo.classfile.Attribute;
import org.glavo.classfile.AttributeMapper;
import org.glavo.classfile.BufWriter;

public class AttributeHolder {
    private final List<Attribute<?>> attributes = new ArrayList();

    public <A extends Attribute<A>> void withAttribute(Attribute<?> a) {
        if (a == null) {
            return;
        }
        AttributeMapper<?> am = a.attributeMapper();
        if (!am.allowMultiple() && this.isPresent(am)) {
            this.remove(am);
        }
        this.attributes.add(a);
    }

    public int size() {
        return this.attributes.size();
    }

    public void writeTo(BufWriter buf) {
        buf.writeU2(this.attributes.size());
        for (Attribute<?> a : this.attributes) {
            a.writeTo(buf);
        }
    }

    boolean isPresent(AttributeMapper<?> am) {
        for (Attribute<?> a : this.attributes) {
            if (a.attributeMapper() != am) continue;
            return true;
        }
        return false;
    }

    private void remove(AttributeMapper<?> am) {
        this.attributes.removeIf(a -> a.attributeMapper() == am);
    }
}

