/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.Objects;
import org.glavo.classfile.CodeBuilder;
import org.glavo.classfile.CodeElement;
import org.glavo.classfile.Instruction;
import org.glavo.classfile.Label;
import org.glavo.classfile.TypeKind;
import org.glavo.classfile.impl.BufferedCodeBuilder;
import org.glavo.classfile.impl.ChainedCodeBuilder;
import org.glavo.classfile.impl.DirectCodeBuilder;
import org.glavo.classfile.impl.NonterminalCodeBuilder;
import org.glavo.classfile.impl.TransformingCodeBuilder;
import org.glavo.classfile.instruction.LabelTarget;

public final class BlockCodeBuilderImpl
extends NonterminalCodeBuilder
implements CodeBuilder.BlockCodeBuilder {
    private final Label startLabel;
    private final Label endLabel;
    private final Label breakLabel;
    private boolean reachable = true;
    private boolean hasInstructions = false;
    private int topLocal;
    private int terminalMaxLocals;

    public BlockCodeBuilderImpl(CodeBuilder parent, Label breakLabel) {
        super(parent);
        this.startLabel = parent.newLabel();
        this.endLabel = parent.newLabel();
        this.breakLabel = Objects.requireNonNull(breakLabel);
    }

    public void start() {
        this.topLocal = this.topLocal(this.parent);
        this.terminalMaxLocals = this.topLocal(this.terminal);
        this.terminal.with((LabelTarget)((Object)this.startLabel));
    }

    public void end() {
        this.terminal.with((LabelTarget)((Object)this.endLabel));
        if (this.terminalMaxLocals != this.topLocal(this.terminal)) {
            throw new IllegalStateException("Interference in local variable slot management");
        }
    }

    public boolean reachable() {
        return this.reachable;
    }

    public boolean isEmpty() {
        return !this.hasInstructions;
    }

    private int topLocal(CodeBuilder parent) {
        Objects.requireNonNull(parent);
        if (parent instanceof BlockCodeBuilderImpl) {
            BlockCodeBuilderImpl b = (BlockCodeBuilderImpl)parent;
            return b.topLocal;
        }
        if (parent instanceof ChainedCodeBuilder) {
            ChainedCodeBuilder b = (ChainedCodeBuilder)parent;
            return this.topLocal(b.terminal);
        }
        if (parent instanceof DirectCodeBuilder) {
            DirectCodeBuilder b = (DirectCodeBuilder)parent;
            return b.curTopLocal();
        }
        if (parent instanceof BufferedCodeBuilder) {
            BufferedCodeBuilder b = (BufferedCodeBuilder)parent;
            return b.curTopLocal();
        }
        if (parent instanceof TransformingCodeBuilder) {
            TransformingCodeBuilder b = (TransformingCodeBuilder)parent;
            return this.topLocal(b.delegate);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public CodeBuilder with(CodeElement element) {
        this.parent.with(element);
        this.hasInstructions |= element instanceof Instruction;
        if (this.reachable) {
            Instruction i;
            if (element instanceof Instruction && (i = (Instruction)element).opcode().isUnconditionalBranch()) {
                this.reachable = false;
            }
        } else if (element instanceof LabelTarget) {
            this.reachable = true;
        }
        return this;
    }

    @Override
    public Label startLabel() {
        return this.startLabel;
    }

    @Override
    public Label endLabel() {
        return this.endLabel;
    }

    @Override
    public int allocateLocal(TypeKind typeKind) {
        int retVal = this.topLocal;
        this.topLocal += typeKind.slotSize();
        return retVal;
    }

    @Override
    public Label breakLabel() {
        return this.breakLabel;
    }
}

