/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.glavo.classfile.BufWriter;
import org.glavo.classfile.WritableElement;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.ConstantPool;
import org.glavo.classfile.constantpool.ConstantPoolBuilder;
import org.glavo.classfile.constantpool.PoolEntry;
import org.glavo.classfile.impl.AbstractPoolEntry;
import org.glavo.classfile.impl.ClassFileImpl;
import org.glavo.classfile.impl.LabelContext;

public final class BufWriterImpl
implements BufWriter {
    private final ConstantPoolBuilder constantPool;
    private final ClassFileImpl context;
    private LabelContext labelContext;
    private final ClassEntry thisClass;
    private final int majorVersion;
    byte[] elems;
    int offset = 0;

    public BufWriterImpl(ConstantPoolBuilder constantPool, ClassFileImpl context) {
        this(constantPool, context, 64, null, 0);
    }

    public BufWriterImpl(ConstantPoolBuilder constantPool, ClassFileImpl context, int initialSize) {
        this(constantPool, context, initialSize, null, 0);
    }

    public BufWriterImpl(ConstantPoolBuilder constantPool, ClassFileImpl context, int initialSize, ClassEntry thisClass, int majorVersion) {
        this.constantPool = constantPool;
        this.context = context;
        this.elems = new byte[initialSize];
        this.thisClass = thisClass;
        this.majorVersion = majorVersion;
    }

    @Override
    public ConstantPoolBuilder constantPool() {
        return this.constantPool;
    }

    public LabelContext labelContext() {
        return this.labelContext;
    }

    public void setLabelContext(LabelContext labelContext) {
        this.labelContext = labelContext;
    }

    @Override
    public boolean canWriteDirect(ConstantPool other) {
        return this.constantPool.canWriteDirect(other);
    }

    public ClassEntry thisClass() {
        return this.thisClass;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public ClassFileImpl context() {
        return this.context;
    }

    @Override
    public void writeU1(int x) {
        this.writeIntBytes(1, x);
    }

    @Override
    public void writeU2(int x) {
        this.writeIntBytes(2, x);
    }

    @Override
    public void writeInt(int x) {
        this.writeIntBytes(4, x);
    }

    @Override
    public void writeFloat(float x) {
        this.writeInt(Float.floatToIntBits(x));
    }

    @Override
    public void writeLong(long x) {
        this.writeIntBytes(8, x);
    }

    @Override
    public void writeDouble(double x) {
        this.writeLong(Double.doubleToLongBits(x));
    }

    @Override
    public void writeBytes(byte[] arr) {
        this.writeBytes(arr, 0, arr.length);
    }

    @Override
    public void writeBytes(BufWriter other) {
        BufWriterImpl o = (BufWriterImpl)other;
        this.writeBytes(o.elems, 0, o.offset);
    }

    @Override
    public void writeBytes(byte[] arr, int start, int length) {
        this.reserveSpace(length);
        System.arraycopy(arr, start, this.elems, this.offset, length);
        this.offset += length;
    }

    @Override
    public void patchInt(int offset, int size, int value) {
        int prevOffset = this.offset;
        this.offset = offset;
        this.writeIntBytes(size, value);
        this.offset = prevOffset;
    }

    @Override
    public void writeIntBytes(int intSize, long intValue) {
        this.reserveSpace(intSize);
        for (int i = 0; i < intSize; ++i) {
            this.elems[this.offset++] = (byte)(intValue >> 8 * (intSize - i - 1) & 0xFFL);
        }
    }

    @Override
    public void reserveSpace(int freeBytes) {
        if (this.offset + freeBytes > this.elems.length) {
            int newsize;
            for (newsize = this.elems.length * 2; this.offset + freeBytes > newsize; newsize *= 2) {
            }
            this.elems = Arrays.copyOf(this.elems, newsize);
        }
    }

    @Override
    public int size() {
        return this.offset;
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.elems, 0, this.offset);
    }

    @Override
    public void copyTo(byte[] array, int bufferOffset) {
        System.arraycopy(this.elems, 0, array, bufferOffset, this.size());
    }

    @Override
    public void writeIndex(PoolEntry entry) {
        int idx = AbstractPoolEntry.maybeClone(this.constantPool, entry).index();
        if (idx < 1 || idx > 65535) {
            throw new IllegalArgumentException(idx + " is not a valid index. Entry: " + entry);
        }
        this.writeU2(idx);
    }

    @Override
    public void writeIndexOrZero(PoolEntry entry) {
        if (entry == null || entry.index() == 0) {
            this.writeU2(0);
        } else {
            this.writeIndex(entry);
        }
    }

    @Override
    public <T extends WritableElement<?>> void writeList(List<T> list) {
        this.writeU2(list.size());
        for (WritableElement t : list) {
            t.writeTo(this);
        }
    }

    @Override
    public void writeListIndices(List<? extends PoolEntry> list) {
        this.writeU2(list.size());
        for (PoolEntry poolEntry : list) {
            this.writeIndex(poolEntry);
        }
    }
}

