/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.glavo.classfile.BufWriter;
import org.glavo.classfile.CodeBuilder;
import org.glavo.classfile.CodeElement;
import org.glavo.classfile.CodeModel;
import org.glavo.classfile.Label;
import org.glavo.classfile.MethodModel;
import org.glavo.classfile.TypeKind;
import org.glavo.classfile.constantpool.ConstantPoolBuilder;
import org.glavo.classfile.impl.AbstractUnboundModel;
import org.glavo.classfile.impl.ClassFileImpl;
import org.glavo.classfile.impl.DirectCodeBuilder;
import org.glavo.classfile.impl.DirectMethodBuilder;
import org.glavo.classfile.impl.LabelContext;
import org.glavo.classfile.impl.LabelImpl;
import org.glavo.classfile.impl.MethodInfo;
import org.glavo.classfile.impl.SplitConstantPool;
import org.glavo.classfile.impl.TerminalCodeBuilder;
import org.glavo.classfile.impl.Util;
import org.glavo.classfile.instruction.ExceptionCatch;
import org.glavo.classfile.instruction.IncrementInstruction;
import org.glavo.classfile.instruction.LoadInstruction;
import org.glavo.classfile.instruction.StoreInstruction;

public final class BufferedCodeBuilder
implements TerminalCodeBuilder,
LabelContext {
    private final SplitConstantPool constantPool;
    private final ClassFileImpl context;
    private final List<CodeElement> elements = new ArrayList<CodeElement>();
    private final LabelImpl startLabel;
    private final LabelImpl endLabel;
    private final CodeModel original;
    private final MethodInfo methodInfo;
    private boolean finished;
    private int maxLocals;

    public BufferedCodeBuilder(MethodInfo methodInfo, SplitConstantPool constantPool, ClassFileImpl context, CodeModel original) {
        this.constantPool = constantPool;
        this.context = context;
        this.startLabel = new LabelImpl(this, -1);
        this.endLabel = new LabelImpl(this, -1);
        this.original = original;
        this.methodInfo = methodInfo;
        this.maxLocals = Util.maxLocals(methodInfo.methodFlags(), methodInfo.methodTypeSymbol());
        if (original != null) {
            this.maxLocals = Math.max(this.maxLocals, original.maxLocals());
        }
        this.elements.add(this.startLabel);
    }

    @Override
    public Optional<CodeModel> original() {
        return Optional.ofNullable(this.original);
    }

    @Override
    public Label newLabel() {
        return new LabelImpl(this, -1);
    }

    @Override
    public Label startLabel() {
        return this.startLabel;
    }

    @Override
    public Label endLabel() {
        return this.endLabel;
    }

    @Override
    public int receiverSlot() {
        return this.methodInfo.receiverSlot();
    }

    @Override
    public int parameterSlot(int paramNo) {
        return this.methodInfo.parameterSlot(paramNo);
    }

    public int curTopLocal() {
        return this.maxLocals;
    }

    @Override
    public int allocateLocal(TypeKind typeKind) {
        int retVal = this.maxLocals;
        this.maxLocals += typeKind.slotSize();
        return retVal;
    }

    @Override
    public Label getLabel(int bci) {
        throw new UnsupportedOperationException("Lookup by BCI not supported by BufferedCodeBuilder");
    }

    @Override
    public int labelToBci(Label label) {
        throw new UnsupportedOperationException("Label mapping not supported by BufferedCodeBuilder");
    }

    @Override
    public void setLabelTarget(Label label, int bci) {
        throw new UnsupportedOperationException("Label mapping not supported by BufferedCodeBuilder");
    }

    @Override
    public ConstantPoolBuilder constantPool() {
        return this.constantPool;
    }

    @Override
    public CodeBuilder with(CodeElement element) {
        if (this.finished) {
            throw new IllegalStateException("Can't add elements after traversal");
        }
        this.elements.add(element);
        return this;
    }

    public String toString() {
        return String.format("CodeModel[id=%d]", System.identityHashCode(this));
    }

    public BufferedCodeBuilder run(Consumer<? super CodeBuilder> handler) {
        handler.accept(this);
        return this;
    }

    public CodeModel toModel() {
        if (!this.finished) {
            this.elements.add(this.endLabel);
            this.finished = true;
        }
        return new Model();
    }

    public final class Model
    extends AbstractUnboundModel<CodeElement>
    implements CodeModel {
        private Model() {
            super(BufferedCodeBuilder.this.elements);
        }

        @Override
        public List<ExceptionCatch> exceptionHandlers() {
            return BufferedCodeBuilder.this.elements.stream().filter(x -> x instanceof ExceptionCatch).map(x -> (ExceptionCatch)x).toList();
        }

        @Override
        public int maxLocals() {
            for (CodeElement element : BufferedCodeBuilder.this.elements) {
                if (element instanceof LoadInstruction) {
                    LoadInstruction i = (LoadInstruction)element;
                    BufferedCodeBuilder.this.maxLocals = Math.max(BufferedCodeBuilder.this.maxLocals, i.slot() + i.typeKind().slotSize());
                    continue;
                }
                if (element instanceof StoreInstruction) {
                    StoreInstruction i = (StoreInstruction)element;
                    BufferedCodeBuilder.this.maxLocals = Math.max(BufferedCodeBuilder.this.maxLocals, i.slot() + i.typeKind().slotSize());
                    continue;
                }
                if (!(element instanceof IncrementInstruction)) continue;
                IncrementInstruction i = (IncrementInstruction)element;
                BufferedCodeBuilder.this.maxLocals = Math.max(BufferedCodeBuilder.this.maxLocals, i.slot() + 1);
            }
            return BufferedCodeBuilder.this.maxLocals;
        }

        @Override
        public int maxStack() {
            throw new UnsupportedOperationException("nyi");
        }

        @Override
        public Optional<MethodModel> parent() {
            return Optional.empty();
        }

        @Override
        public void writeTo(DirectMethodBuilder builder) {
            builder.withCode((Consumer<? super CodeBuilder>)new Consumer<CodeBuilder>(){

                @Override
                public void accept(CodeBuilder cb) {
                    Model.this.forEachElement(cb);
                }
            });
        }

        public void writeTo(BufWriter buf) {
            DirectCodeBuilder.build(BufferedCodeBuilder.this.methodInfo, cb -> BufferedCodeBuilder.this.elements.forEach(cb), BufferedCodeBuilder.this.constantPool, BufferedCodeBuilder.this.context, null).writeTo(buf);
        }

        public String toString() {
            return String.format("CodeModel[id=%s]", Integer.toHexString(System.identityHashCode(this)));
        }
    }
}

