/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.glavo.classfile.ClassBuilder;
import org.glavo.classfile.ClassElement;
import org.glavo.classfile.ClassModel;
import org.glavo.classfile.FieldBuilder;
import org.glavo.classfile.FieldModel;
import org.glavo.classfile.FieldTransform;
import org.glavo.classfile.MethodBuilder;
import org.glavo.classfile.MethodModel;
import org.glavo.classfile.MethodTransform;
import org.glavo.classfile.constantpool.ConstantPoolBuilder;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.BufferedFieldBuilder;
import org.glavo.classfile.impl.BufferedMethodBuilder;
import org.glavo.classfile.impl.DirectClassBuilder;

public final class ChainedClassBuilder
implements ClassBuilder,
Consumer<ClassElement> {
    private final ClassBuilder downstream;
    private final DirectClassBuilder terminal;
    private final Consumer<ClassElement> consumer;

    public ChainedClassBuilder(ClassBuilder downstream, Consumer<ClassElement> consumer) {
        Objects.requireNonNull(downstream);
        this.downstream = downstream;
        this.consumer = consumer;
        if (downstream instanceof ChainedClassBuilder) {
            ChainedClassBuilder cb = (ChainedClassBuilder)downstream;
            this.terminal = cb.terminal;
        } else if (downstream instanceof DirectClassBuilder) {
            DirectClassBuilder db;
            this.terminal = db = (DirectClassBuilder)downstream;
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public ClassBuilder with(ClassElement element) {
        this.consumer.accept(element);
        return this;
    }

    @Override
    public Optional<ClassModel> original() {
        return this.terminal.original();
    }

    @Override
    public ClassBuilder withField(Utf8Entry name, Utf8Entry descriptor, Consumer<? super FieldBuilder> handler) {
        return (ClassBuilder)this.downstream.with(new BufferedFieldBuilder(this.terminal.constantPool, this.terminal.context, name, descriptor, null).run(handler).toModel());
    }

    @Override
    public ClassBuilder transformField(FieldModel field, FieldTransform transform) {
        BufferedFieldBuilder builder = new BufferedFieldBuilder(this.terminal.constantPool, this.terminal.context, field.fieldName(), field.fieldType(), field);
        builder.transform(field, transform);
        return (ClassBuilder)this.downstream.with(builder.toModel());
    }

    @Override
    public ClassBuilder withMethod(Utf8Entry name, Utf8Entry descriptor, int flags, Consumer<? super MethodBuilder> handler) {
        return (ClassBuilder)this.downstream.with(new BufferedMethodBuilder(this.terminal.constantPool, this.terminal.context, name, descriptor, null).run(handler).toModel());
    }

    @Override
    public ClassBuilder transformMethod(MethodModel method, MethodTransform transform) {
        BufferedMethodBuilder builder = new BufferedMethodBuilder(this.terminal.constantPool, this.terminal.context, method.methodName(), method.methodType(), method);
        builder.transform(method, transform);
        return (ClassBuilder)this.downstream.with(builder.toModel());
    }

    @Override
    public ConstantPoolBuilder constantPool() {
        return this.terminal.constantPool();
    }
}

