/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.glavo.classfile.FieldBuilder;
import org.glavo.classfile.FieldElement;
import org.glavo.classfile.FieldModel;
import org.glavo.classfile.constantpool.ConstantPoolBuilder;
import org.glavo.classfile.impl.TerminalFieldBuilder;

public final class ChainedFieldBuilder
implements FieldBuilder {
    private final TerminalFieldBuilder terminal;
    private final Consumer<FieldElement> consumer;

    public ChainedFieldBuilder(FieldBuilder downstream, Consumer<FieldElement> consumer) {
        Objects.requireNonNull(downstream);
        this.consumer = consumer;
        if (downstream instanceof ChainedFieldBuilder) {
            ChainedFieldBuilder cb = (ChainedFieldBuilder)downstream;
            this.terminal = cb.terminal;
        } else if (downstream instanceof TerminalFieldBuilder) {
            TerminalFieldBuilder tb;
            this.terminal = tb = (TerminalFieldBuilder)downstream;
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public ConstantPoolBuilder constantPool() {
        return this.terminal.constantPool();
    }

    @Override
    public Optional<FieldModel> original() {
        return this.terminal.original();
    }

    @Override
    public FieldBuilder with(FieldElement element) {
        this.consumer.accept(element);
        return this;
    }
}

