/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.glavo.classfile.CodeBuilder;
import org.glavo.classfile.CodeModel;
import org.glavo.classfile.CodeTransform;
import org.glavo.classfile.MethodBuilder;
import org.glavo.classfile.MethodElement;
import org.glavo.classfile.MethodModel;
import org.glavo.classfile.constantpool.ConstantPoolBuilder;
import org.glavo.classfile.impl.BufferedCodeBuilder;
import org.glavo.classfile.impl.TerminalMethodBuilder;

public final class ChainedMethodBuilder
implements MethodBuilder {
    final MethodBuilder downstream;
    final TerminalMethodBuilder terminal;
    final Consumer<MethodElement> consumer;

    public ChainedMethodBuilder(MethodBuilder downstream, Consumer<MethodElement> consumer) {
        Objects.requireNonNull(downstream);
        this.downstream = downstream;
        this.consumer = consumer;
        if (downstream instanceof ChainedMethodBuilder) {
            ChainedMethodBuilder cb = (ChainedMethodBuilder)downstream;
            this.terminal = cb.terminal;
        } else if (downstream instanceof TerminalMethodBuilder) {
            TerminalMethodBuilder tb;
            this.terminal = tb = (TerminalMethodBuilder)downstream;
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public MethodBuilder with(MethodElement element) {
        this.consumer.accept(element);
        return this;
    }

    @Override
    public MethodBuilder withCode(Consumer<? super CodeBuilder> handler) {
        return (MethodBuilder)this.downstream.with(this.terminal.bufferedCodeBuilder(null).run(handler).toModel());
    }

    @Override
    public MethodBuilder transformCode(CodeModel code, CodeTransform transform) {
        BufferedCodeBuilder builder = this.terminal.bufferedCodeBuilder(code);
        builder.transform(code, transform);
        return (MethodBuilder)this.downstream.with(builder.toModel());
    }

    @Override
    public ConstantPoolBuilder constantPool() {
        return this.terminal.constantPool();
    }

    @Override
    public Optional<MethodModel> original() {
        return this.terminal.original();
    }
}

