/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.glavo.classfile.AttributeMapper;
import org.glavo.classfile.ClassBuilder;
import org.glavo.classfile.ClassFile;
import org.glavo.classfile.ClassHierarchyResolver;
import org.glavo.classfile.ClassModel;
import org.glavo.classfile.ClassTransform;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.ConstantPoolBuilder;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AbstractPoolEntry;
import org.glavo.classfile.impl.ClassImpl;
import org.glavo.classfile.impl.DirectClassBuilder;
import org.glavo.classfile.impl.SplitConstantPool;
import org.glavo.classfile.impl.verifier.VerifierImpl;

public record ClassFileImpl(ClassFile.StackMapsOption stackMapsOption, ClassFile.DebugElementsOption debugElementsOption, ClassFile.LineNumbersOption lineNumbersOption, ClassFile.AttributesProcessingOption attributesProcessingOption, ClassFile.ConstantPoolSharingOption constantPoolSharingOption, ClassFile.ShortJumpsOption shortJumpsOption, ClassFile.DeadCodeOption deadCodeOption, ClassFile.DeadLabelsOption deadLabelsOption, ClassFile.ClassHierarchyResolverOption classHierarchyResolverOption, ClassFile.AttributeMapperOption attributeMapperOption) implements ClassFile
{
    public static final ClassFileImpl DEFAULT_CONTEXT = new ClassFileImpl(ClassFile.StackMapsOption.STACK_MAPS_WHEN_REQUIRED, ClassFile.DebugElementsOption.PASS_DEBUG, ClassFile.LineNumbersOption.PASS_LINE_NUMBERS, ClassFile.AttributesProcessingOption.PASS_ALL_ATTRIBUTES, ClassFile.ConstantPoolSharingOption.SHARED_POOL, ClassFile.ShortJumpsOption.FIX_SHORT_JUMPS, ClassFile.DeadCodeOption.PATCH_DEAD_CODE, ClassFile.DeadLabelsOption.FAIL_ON_DEAD_LABELS, new ClassHierarchyResolverOptionImpl(ClassHierarchyResolver.defaultResolver()), new AttributeMapperOptionImpl(new Function<Utf8Entry, AttributeMapper<?>>(){

        @Override
        public AttributeMapper<?> apply(Utf8Entry k) {
            return null;
        }
    }));

    @Override
    public ClassFileImpl withOptions(ClassFile.Option ... options) {
        ClassFile.StackMapsOption smo = this.stackMapsOption;
        ClassFile.DebugElementsOption deo = this.debugElementsOption;
        ClassFile.LineNumbersOption lno = this.lineNumbersOption;
        ClassFile.AttributesProcessingOption apo = this.attributesProcessingOption;
        ClassFile.ConstantPoolSharingOption cpso = this.constantPoolSharingOption;
        ClassFile.ShortJumpsOption sjo = this.shortJumpsOption;
        ClassFile.DeadCodeOption dco = this.deadCodeOption;
        ClassFile.DeadLabelsOption dlo = this.deadLabelsOption;
        ClassFile.ClassHierarchyResolverOption chro = this.classHierarchyResolverOption;
        ClassFile.AttributeMapperOption amo = this.attributeMapperOption;
        for (ClassFile.Option o : options) {
            ClassFile.AttributeMapperOption oo;
            Objects.requireNonNull(o);
            if (o instanceof ClassFile.StackMapsOption) {
                ClassFile.StackMapsOption oo2;
                smo = oo2 = (ClassFile.StackMapsOption)o;
                continue;
            }
            if (o instanceof ClassFile.DebugElementsOption) {
                ClassFile.DebugElementsOption oo3;
                deo = oo3 = (ClassFile.DebugElementsOption)o;
                continue;
            }
            if (o instanceof ClassFile.LineNumbersOption) {
                ClassFile.LineNumbersOption oo4;
                lno = oo4 = (ClassFile.LineNumbersOption)o;
                continue;
            }
            if (o instanceof ClassFile.AttributesProcessingOption) {
                ClassFile.AttributesProcessingOption oo5;
                apo = oo5 = (ClassFile.AttributesProcessingOption)o;
                continue;
            }
            if (o instanceof ClassFile.ConstantPoolSharingOption) {
                ClassFile.ConstantPoolSharingOption oo6;
                cpso = oo6 = (ClassFile.ConstantPoolSharingOption)o;
                continue;
            }
            if (o instanceof ClassFile.ShortJumpsOption) {
                ClassFile.ShortJumpsOption oo7;
                sjo = oo7 = (ClassFile.ShortJumpsOption)o;
                continue;
            }
            if (o instanceof ClassFile.DeadCodeOption) {
                ClassFile.DeadCodeOption oo8;
                dco = oo8 = (ClassFile.DeadCodeOption)o;
                continue;
            }
            if (o instanceof ClassFile.DeadLabelsOption) {
                ClassFile.DeadLabelsOption oo9;
                dlo = oo9 = (ClassFile.DeadLabelsOption)o;
                continue;
            }
            if (o instanceof ClassFile.ClassHierarchyResolverOption) {
                ClassFile.ClassHierarchyResolverOption oo10;
                chro = oo10 = (ClassFile.ClassHierarchyResolverOption)o;
                continue;
            }
            if (!(o instanceof ClassFile.AttributeMapperOption)) continue;
            amo = oo = (ClassFile.AttributeMapperOption)o;
        }
        return new ClassFileImpl(smo, deo, lno, apo, cpso, sjo, dco, dlo, chro, amo);
    }

    @Override
    public ClassModel parse(byte[] bytes) {
        return new ClassImpl(bytes, this);
    }

    @Override
    public byte[] build(ClassEntry thisClassEntry, ConstantPoolBuilder constantPool, Consumer<? super ClassBuilder> handler) {
        thisClassEntry = AbstractPoolEntry.maybeClone(constantPool, thisClassEntry);
        DirectClassBuilder builder = new DirectClassBuilder((SplitConstantPool)constantPool, this, thisClassEntry);
        handler.accept(builder);
        return builder.build();
    }

    @Override
    public byte[] transform(final ClassModel model, ClassEntry newClassName, final ClassTransform transform) {
        ConstantPoolBuilder constantPool = this.constantPoolSharingOption() == ClassFile.ConstantPoolSharingOption.SHARED_POOL ? ConstantPoolBuilder.of(model) : ConstantPoolBuilder.of();
        return this.build(newClassName, constantPool, (Consumer<? super ClassBuilder>)new Consumer<ClassBuilder>(){

            @Override
            public void accept(ClassBuilder builder) {
                ((DirectClassBuilder)builder).setOriginal((ClassImpl)model);
                ((DirectClassBuilder)builder).setSizeHint(((ClassImpl)model).classfileLength());
                builder.transform((ClassImpl)model, transform);
            }
        });
    }

    @Override
    public List<VerifyError> verify(ClassModel model) {
        return VerifierImpl.verify(model, this.classHierarchyResolverOption().classHierarchyResolver(), null);
    }

    @Override
    public List<VerifyError> verify(byte[] bytes) {
        try {
            return this.verify(this.parse(bytes));
        }
        catch (IllegalArgumentException parsingError) {
            return List.of(new VerifyError(parsingError.getMessage()));
        }
    }

    public record ClassHierarchyResolverOptionImpl(ClassHierarchyResolver classHierarchyResolver) implements ClassFile.ClassHierarchyResolverOption
    {
    }

    public record AttributeMapperOptionImpl(Function<Utf8Entry, AttributeMapper<?>> attributeMapper) implements ClassFile.AttributeMapperOption
    {
    }
}

