/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.glavo.classfile.AccessFlag;
import org.glavo.classfile.AccessFlags;
import org.glavo.classfile.Attribute;
import org.glavo.classfile.AttributeMapper;
import org.glavo.classfile.Attributes;
import org.glavo.classfile.ClassElement;
import org.glavo.classfile.ClassFileVersion;
import org.glavo.classfile.ClassModel;
import org.glavo.classfile.ClassReader;
import org.glavo.classfile.FieldModel;
import org.glavo.classfile.Interfaces;
import org.glavo.classfile.MethodModel;
import org.glavo.classfile.Superclass;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.ConstantPool;
import org.glavo.classfile.impl.AbstractElement;
import org.glavo.classfile.impl.BoundAttribute;
import org.glavo.classfile.impl.ClassFileImpl;
import org.glavo.classfile.impl.ClassReaderImpl;
import org.glavo.classfile.impl.FieldImpl;
import org.glavo.classfile.impl.MethodImpl;
import org.glavo.classfile.jdk.CollectionUtils;

public final class ClassImpl
extends AbstractElement
implements ClassModel {
    final ClassReader reader;
    private final int attributesPos;
    private final List<MethodModel> methods;
    private final List<FieldModel> fields;
    private List<Attribute<?>> attributes;
    private List<ClassEntry> interfaces;
    private static final Set<AttributeMapper<?>> allowedModuleAttributes = Set.of(Attributes.MODULE, Attributes.MODULE_HASHES, Attributes.MODULE_MAIN_CLASS, Attributes.MODULE_PACKAGES, Attributes.MODULE_RESOLUTION, Attributes.MODULE_TARGET, Attributes.INNER_CLASSES, Attributes.SOURCE_FILE, Attributes.SOURCE_DEBUG_EXTENSION, Attributes.RUNTIME_VISIBLE_ANNOTATIONS, Attributes.RUNTIME_INVISIBLE_ANNOTATIONS);

    public ClassImpl(byte[] cfbytes, ClassFileImpl context) {
        this.reader = new ClassReaderImpl(cfbytes, context);
        ClassReaderImpl reader = (ClassReaderImpl)this.reader;
        int p = reader.interfacesPos;
        int icnt = reader.readU2(p);
        int fcnt = reader.readU2(p += 2 + icnt * 2);
        FieldImpl[] fields = new FieldImpl[fcnt];
        p += 2;
        for (int i = 0; i < fcnt; ++i) {
            int startPos = p;
            int attrStart = p + 6;
            p = reader.skipAttributeHolder(attrStart);
            fields[i] = new FieldImpl(reader, startPos, p, attrStart);
        }
        this.fields = List.of(fields);
        int mcnt = reader.readU2(p);
        MethodImpl[] methods = new MethodImpl[mcnt];
        p += 2;
        for (int i = 0; i < mcnt; ++i) {
            int startPos = p;
            int attrStart = p + 6;
            p = reader.skipAttributeHolder(attrStart);
            methods[i] = new MethodImpl(reader, startPos, p, attrStart);
        }
        this.methods = List.of(methods);
        this.attributesPos = p;
        reader.setContainedClass(this);
    }

    public int classfileLength() {
        return this.reader.classfileLength();
    }

    @Override
    public AccessFlags flags() {
        return AccessFlags.ofClass(this.reader.flags());
    }

    @Override
    public int majorVersion() {
        return this.reader.readU2(6);
    }

    @Override
    public int minorVersion() {
        return this.reader.readU2(4);
    }

    @Override
    public ConstantPool constantPool() {
        return this.reader;
    }

    @Override
    public ClassEntry thisClass() {
        return this.reader.thisClassEntry();
    }

    @Override
    public Optional<ClassEntry> superclass() {
        return this.reader.superclassEntry();
    }

    @Override
    public List<ClassEntry> interfaces() {
        if (this.interfaces == null) {
            int pos = this.reader.thisClassPos() + 4;
            int cnt = this.reader.readU2(pos);
            pos += 2;
            Object[] arr = new Object[cnt];
            for (int i = 0; i < cnt; ++i) {
                arr[i] = this.reader.readClassEntry(pos);
                pos += 2;
            }
            this.interfaces = CollectionUtils.listFromTrustedArray(arr);
        }
        return this.interfaces;
    }

    @Override
    public List<Attribute<?>> attributes() {
        if (this.attributes == null) {
            this.attributes = BoundAttribute.readAttributes(this, this.reader, this.attributesPos, this.reader.customAttributes());
        }
        return this.attributes;
    }

    @Override
    public void forEachElement(final Consumer<ClassElement> consumer) {
        consumer.accept(this.flags());
        consumer.accept(ClassFileVersion.of(this.majorVersion(), this.minorVersion()));
        this.superclass().ifPresent(new Consumer<ClassEntry>(){

            @Override
            public void accept(ClassEntry entry) {
                consumer.accept(Superclass.of(entry));
            }
        });
        consumer.accept(Interfaces.of(this.interfaces()));
        this.fields().forEach(consumer);
        this.methods().forEach(consumer);
        for (Attribute<?> attr : this.attributes()) {
            if (!(attr instanceof ClassElement)) continue;
            ClassElement e = (ClassElement)((Object)attr);
            consumer.accept(e);
        }
    }

    @Override
    public List<FieldModel> fields() {
        return this.fields;
    }

    @Override
    public List<MethodModel> methods() {
        return this.methods;
    }

    @Override
    public boolean isModuleInfo() {
        AccessFlags flags = this.flags();
        return flags.has(AccessFlag.MODULE) && this.majorVersion() >= 53 && this.thisClass().asInternalName().equals("module-info") && this.superclass().isEmpty() && this.interfaces().isEmpty() && this.fields().isEmpty() && this.methods().isEmpty() && this.verifyModuleAttributes();
    }

    public String toString() {
        return String.format("ClassModel[thisClass=%s, flags=%d]", this.thisClass().name().stringValue(), this.flags().flagsMask());
    }

    private boolean verifyModuleAttributes() {
        if (this.findAttribute(Attributes.MODULE).isEmpty()) {
            return false;
        }
        Set found = this.attributes().stream().map(Attribute::attributeMapper).collect(Collectors.toSet());
        found.removeAll(allowedModuleAttributes);
        found.retainAll(Attributes.PREDEFINED_ATTRIBUTES);
        return found.isEmpty();
    }
}

