/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicCallSiteDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.glavo.classfile.Annotation;
import org.glavo.classfile.AnnotationElement;
import org.glavo.classfile.AnnotationValue;
import org.glavo.classfile.ClassBuilder;
import org.glavo.classfile.ClassElement;
import org.glavo.classfile.ClassSignature;
import org.glavo.classfile.CodeModel;
import org.glavo.classfile.CodeTransform;
import org.glavo.classfile.FieldBuilder;
import org.glavo.classfile.FieldModel;
import org.glavo.classfile.FieldTransform;
import org.glavo.classfile.Interfaces;
import org.glavo.classfile.MethodBuilder;
import org.glavo.classfile.MethodModel;
import org.glavo.classfile.MethodSignature;
import org.glavo.classfile.MethodTransform;
import org.glavo.classfile.Signature;
import org.glavo.classfile.Superclass;
import org.glavo.classfile.TypeAnnotation;
import org.glavo.classfile.attribute.AnnotationDefaultAttribute;
import org.glavo.classfile.attribute.EnclosingMethodAttribute;
import org.glavo.classfile.attribute.ExceptionsAttribute;
import org.glavo.classfile.attribute.InnerClassInfo;
import org.glavo.classfile.attribute.InnerClassesAttribute;
import org.glavo.classfile.attribute.ModuleAttribute;
import org.glavo.classfile.attribute.ModuleProvideInfo;
import org.glavo.classfile.attribute.NestHostAttribute;
import org.glavo.classfile.attribute.NestMembersAttribute;
import org.glavo.classfile.attribute.PermittedSubclassesAttribute;
import org.glavo.classfile.attribute.RecordAttribute;
import org.glavo.classfile.attribute.RecordComponentInfo;
import org.glavo.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeInvisibleParameterAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeInvisibleTypeAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeVisibleParameterAnnotationsAttribute;
import org.glavo.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute;
import org.glavo.classfile.attribute.SignatureAttribute;
import org.glavo.classfile.components.ClassRemapper;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.TemporaryConstantPool;
import org.glavo.classfile.impl.Util;
import org.glavo.classfile.instruction.ConstantInstruction;
import org.glavo.classfile.instruction.ExceptionCatch;
import org.glavo.classfile.instruction.FieldInstruction;
import org.glavo.classfile.instruction.InvokeDynamicInstruction;
import org.glavo.classfile.instruction.InvokeInstruction;
import org.glavo.classfile.instruction.LocalVariable;
import org.glavo.classfile.instruction.LocalVariableType;
import org.glavo.classfile.instruction.NewMultiArrayInstruction;
import org.glavo.classfile.instruction.NewObjectInstruction;
import org.glavo.classfile.instruction.NewReferenceArrayInstruction;
import org.glavo.classfile.instruction.TypeCheckInstruction;

public record ClassRemapperImpl(Function<ClassDesc, ClassDesc> mapFunction) implements ClassRemapper
{
    @Override
    public void accept(ClassBuilder clb, ClassElement cle) {
        Objects.requireNonNull(cle);
        if (cle instanceof FieldModel) {
            FieldModel fm = (FieldModel)cle;
            clb.withField(fm.fieldName().stringValue(), this.map(fm.fieldTypeSymbol()), fb -> fm.forEachElement(this.asFieldTransform().resolve((FieldBuilder)fb).consumer()));
        } else if (cle instanceof MethodModel) {
            MethodModel mm = (MethodModel)cle;
            clb.withMethod(mm.methodName().stringValue(), this.mapMethodDesc(mm.methodTypeSymbol()), mm.flags().flagsMask(), mb -> mm.forEachElement(this.asMethodTransform().resolve((MethodBuilder)mb).consumer()));
        } else if (cle instanceof Superclass) {
            Superclass sc = (Superclass)cle;
            clb.withSuperclass(this.map(sc.superclassEntry().asSymbol()));
        } else if (cle instanceof Interfaces) {
            Interfaces ins = (Interfaces)cle;
            clb.withInterfaceSymbols(Util.mappedList(ins.interfaces(), in -> this.map(in.asSymbol())));
        } else if (cle instanceof SignatureAttribute) {
            SignatureAttribute sa = (SignatureAttribute)cle;
            clb.with(SignatureAttribute.of(this.mapClassSignature(sa.asClassSignature())));
        } else if (cle instanceof InnerClassesAttribute) {
            InnerClassesAttribute ica = (InnerClassesAttribute)cle;
            clb.with(InnerClassesAttribute.of(ica.classes().stream().map((? super T ici) -> InnerClassInfo.of(this.map(ici.innerClass().asSymbol()), ici.outerClass().map((? super T oc) -> this.map(oc.asSymbol())), ici.innerName().map(Utf8Entry::stringValue), ici.flagsMask())).toList()));
        } else if (cle instanceof EnclosingMethodAttribute) {
            EnclosingMethodAttribute ema = (EnclosingMethodAttribute)cle;
            clb.with(EnclosingMethodAttribute.of(this.map(ema.enclosingClass().asSymbol()), ema.enclosingMethodName().map(Utf8Entry::stringValue), ema.enclosingMethodTypeSymbol().map(this::mapMethodDesc)));
        } else if (cle instanceof RecordAttribute) {
            RecordAttribute ra = (RecordAttribute)cle;
            clb.with(RecordAttribute.of(ra.components().stream().map(this::mapRecordComponent).toList()));
        } else if (cle instanceof ModuleAttribute) {
            ModuleAttribute ma = (ModuleAttribute)cle;
            clb.with(ModuleAttribute.of(ma.moduleName(), ma.moduleFlagsMask(), ma.moduleVersion().orElse(null), ma.requires(), ma.exports(), ma.opens(), ma.uses().stream().map((? super T ce) -> clb.constantPool().classEntry(this.map(ce.asSymbol()))).toList(), ma.provides().stream().map((? super T mp) -> ModuleProvideInfo.of(this.map(mp.provides().asSymbol()), mp.providesWith().stream().map((? super T pw) -> this.map(pw.asSymbol())).toList())).toList()));
        } else if (cle instanceof NestHostAttribute) {
            NestHostAttribute nha = (NestHostAttribute)cle;
            clb.with(NestHostAttribute.of(this.map(nha.nestHost().asSymbol())));
        } else if (cle instanceof NestMembersAttribute) {
            NestMembersAttribute nma = (NestMembersAttribute)cle;
            clb.with(NestMembersAttribute.ofSymbols(nma.nestMembers().stream().map((? super T nm) -> this.map(nm.asSymbol())).toList()));
        } else if (cle instanceof PermittedSubclassesAttribute) {
            PermittedSubclassesAttribute psa = (PermittedSubclassesAttribute)cle;
            clb.with(PermittedSubclassesAttribute.ofSymbols(psa.permittedSubclasses().stream().map((? super T ps) -> this.map(ps.asSymbol())).toList()));
        } else if (cle instanceof RuntimeVisibleAnnotationsAttribute) {
            RuntimeVisibleAnnotationsAttribute aa = (RuntimeVisibleAnnotationsAttribute)cle;
            clb.with(RuntimeVisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations())));
        } else if (cle instanceof RuntimeInvisibleAnnotationsAttribute) {
            RuntimeInvisibleAnnotationsAttribute aa = (RuntimeInvisibleAnnotationsAttribute)cle;
            clb.with(RuntimeInvisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations())));
        } else if (cle instanceof RuntimeVisibleTypeAnnotationsAttribute) {
            RuntimeVisibleTypeAnnotationsAttribute aa = (RuntimeVisibleTypeAnnotationsAttribute)cle;
            clb.with(RuntimeVisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
        } else if (cle instanceof RuntimeInvisibleTypeAnnotationsAttribute) {
            RuntimeInvisibleTypeAnnotationsAttribute aa = (RuntimeInvisibleTypeAnnotationsAttribute)cle;
            clb.with(RuntimeInvisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
        } else {
            clb.with(cle);
        }
    }

    @Override
    public FieldTransform asFieldTransform() {
        return (fb, fe) -> {
            Objects.requireNonNull(fe);
            if (fe instanceof SignatureAttribute) {
                SignatureAttribute sa = (SignatureAttribute)fe;
                fb.with(SignatureAttribute.of(this.mapSignature(sa.asTypeSignature())));
            } else if (fe instanceof RuntimeVisibleAnnotationsAttribute) {
                RuntimeVisibleAnnotationsAttribute aa = (RuntimeVisibleAnnotationsAttribute)fe;
                fb.with(RuntimeVisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations())));
            } else if (fe instanceof RuntimeInvisibleAnnotationsAttribute) {
                RuntimeInvisibleAnnotationsAttribute aa = (RuntimeInvisibleAnnotationsAttribute)fe;
                fb.with(RuntimeInvisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations())));
            } else if (fe instanceof RuntimeVisibleTypeAnnotationsAttribute) {
                RuntimeVisibleTypeAnnotationsAttribute aa = (RuntimeVisibleTypeAnnotationsAttribute)fe;
                fb.with(RuntimeVisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
            } else if (fe instanceof RuntimeInvisibleTypeAnnotationsAttribute) {
                RuntimeInvisibleTypeAnnotationsAttribute aa = (RuntimeInvisibleTypeAnnotationsAttribute)fe;
                fb.with(RuntimeInvisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
            } else {
                fb.with(fe);
            }
        };
    }

    @Override
    public MethodTransform asMethodTransform() {
        return (mb, me) -> {
            Objects.requireNonNull(me);
            if (me instanceof AnnotationDefaultAttribute) {
                AnnotationDefaultAttribute ada = (AnnotationDefaultAttribute)me;
                mb.with(AnnotationDefaultAttribute.of(this.mapAnnotationValue(ada.defaultValue())));
            } else if (me instanceof CodeModel) {
                CodeModel com = (CodeModel)me;
                mb.transformCode(com, this.asCodeTransform());
            } else if (me instanceof ExceptionsAttribute) {
                ExceptionsAttribute ea = (ExceptionsAttribute)me;
                mb.with(ExceptionsAttribute.ofSymbols(ea.exceptions().stream().map((? super T ce) -> this.map(ce.asSymbol())).toList()));
            } else if (me instanceof SignatureAttribute) {
                SignatureAttribute sa = (SignatureAttribute)me;
                mb.with(SignatureAttribute.of(this.mapMethodSignature(sa.asMethodSignature())));
            } else if (me instanceof RuntimeVisibleAnnotationsAttribute) {
                RuntimeVisibleAnnotationsAttribute aa = (RuntimeVisibleAnnotationsAttribute)me;
                mb.with(RuntimeVisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations())));
            } else if (me instanceof RuntimeInvisibleAnnotationsAttribute) {
                RuntimeInvisibleAnnotationsAttribute aa = (RuntimeInvisibleAnnotationsAttribute)me;
                mb.with(RuntimeInvisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations())));
            } else if (me instanceof RuntimeVisibleParameterAnnotationsAttribute) {
                RuntimeVisibleParameterAnnotationsAttribute paa = (RuntimeVisibleParameterAnnotationsAttribute)me;
                mb.with(RuntimeVisibleParameterAnnotationsAttribute.of(paa.parameterAnnotations().stream().map(this::mapAnnotations).toList()));
            } else if (me instanceof RuntimeInvisibleParameterAnnotationsAttribute) {
                RuntimeInvisibleParameterAnnotationsAttribute paa = (RuntimeInvisibleParameterAnnotationsAttribute)me;
                mb.with(RuntimeInvisibleParameterAnnotationsAttribute.of(paa.parameterAnnotations().stream().map(this::mapAnnotations).toList()));
            } else if (me instanceof RuntimeVisibleTypeAnnotationsAttribute) {
                RuntimeVisibleTypeAnnotationsAttribute aa = (RuntimeVisibleTypeAnnotationsAttribute)me;
                mb.with(RuntimeVisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
            } else if (me instanceof RuntimeInvisibleTypeAnnotationsAttribute) {
                RuntimeInvisibleTypeAnnotationsAttribute aa = (RuntimeInvisibleTypeAnnotationsAttribute)me;
                mb.with(RuntimeInvisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
            } else {
                mb.with(me);
            }
        };
    }

    @Override
    public CodeTransform asCodeTransform() {
        return (cob, coe) -> {
            Objects.requireNonNull(coe);
            if (coe instanceof FieldInstruction) {
                FieldInstruction fai = (FieldInstruction)coe;
                cob.fieldInstruction(fai.opcode(), this.map(fai.owner().asSymbol()), fai.name().stringValue(), this.map(fai.typeSymbol()));
            } else if (coe instanceof InvokeInstruction) {
                InvokeInstruction ii = (InvokeInstruction)coe;
                cob.invokeInstruction(ii.opcode(), this.map(ii.owner().asSymbol()), ii.name().stringValue(), this.mapMethodDesc(ii.typeSymbol()), ii.isInterface());
            } else if (coe instanceof InvokeDynamicInstruction) {
                InvokeDynamicInstruction idi = (InvokeDynamicInstruction)coe;
                cob.invokeDynamicInstruction(DynamicCallSiteDesc.of(idi.bootstrapMethod(), idi.name().stringValue(), this.mapMethodDesc(idi.typeSymbol()), (ConstantDesc[])idi.bootstrapArgs().stream().map(this::mapConstantValue).toArray(ConstantDesc[]::new)));
            } else if (coe instanceof NewObjectInstruction) {
                NewObjectInstruction c = (NewObjectInstruction)coe;
                cob.newObjectInstruction(this.map(c.className().asSymbol()));
            } else if (coe instanceof NewReferenceArrayInstruction) {
                NewReferenceArrayInstruction c = (NewReferenceArrayInstruction)coe;
                cob.anewarray(this.map(c.componentType().asSymbol()));
            } else if (coe instanceof NewMultiArrayInstruction) {
                NewMultiArrayInstruction c = (NewMultiArrayInstruction)coe;
                cob.multianewarray(this.map(c.arrayType().asSymbol()), c.dimensions());
            } else if (coe instanceof TypeCheckInstruction) {
                TypeCheckInstruction c = (TypeCheckInstruction)coe;
                cob.typeCheckInstruction(c.opcode(), this.map(c.type().asSymbol()));
            } else if (coe instanceof ExceptionCatch) {
                ExceptionCatch c = (ExceptionCatch)coe;
                cob.exceptionCatch(c.tryStart(), c.tryEnd(), c.handler(), c.catchType().map((? super T d) -> TemporaryConstantPool.INSTANCE.classEntry(this.map(d.asSymbol()))));
            } else if (coe instanceof LocalVariable) {
                LocalVariable c = (LocalVariable)coe;
                cob.localVariable(c.slot(), c.name().stringValue(), this.map(c.typeSymbol()), c.startScope(), c.endScope());
            } else if (coe instanceof LocalVariableType) {
                LocalVariableType c = (LocalVariableType)coe;
                cob.localVariableType(c.slot(), c.name().stringValue(), this.mapSignature(c.signatureSymbol()), c.startScope(), c.endScope());
            } else if (coe instanceof ConstantInstruction.LoadConstantInstruction) {
                ConstantInstruction.LoadConstantInstruction ldc = (ConstantInstruction.LoadConstantInstruction)coe;
                cob.constantInstruction(ldc.opcode(), this.mapConstantValue(ldc.constantValue()));
            } else if (coe instanceof RuntimeVisibleTypeAnnotationsAttribute) {
                RuntimeVisibleTypeAnnotationsAttribute aa = (RuntimeVisibleTypeAnnotationsAttribute)coe;
                cob.with(RuntimeVisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
            } else if (coe instanceof RuntimeInvisibleTypeAnnotationsAttribute) {
                RuntimeInvisibleTypeAnnotationsAttribute aa = (RuntimeInvisibleTypeAnnotationsAttribute)coe;
                cob.with(RuntimeInvisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
            } else {
                cob.with(coe);
            }
        };
    }

    @Override
    public ClassDesc map(ClassDesc desc) {
        if (desc == null) {
            return null;
        }
        if (desc.isArray()) {
            return this.map(desc.componentType()).arrayType();
        }
        if (desc.isPrimitive()) {
            return desc;
        }
        return this.mapFunction.apply(desc);
    }

    MethodTypeDesc mapMethodDesc(MethodTypeDesc desc) {
        return MethodTypeDesc.of(this.map(desc.returnType()), (ClassDesc[])desc.parameterList().stream().map(this::map).toArray(ClassDesc[]::new));
    }

    ClassSignature mapClassSignature(ClassSignature signature) {
        return ClassSignature.of(this.mapTypeParams(signature.typeParameters()), this.mapSignature(signature.superclassSignature()), (Signature.ClassTypeSig[])signature.superinterfaceSignatures().stream().map(this::mapSignature).toArray(Signature.ClassTypeSig[]::new));
    }

    MethodSignature mapMethodSignature(MethodSignature signature) {
        return MethodSignature.of(this.mapTypeParams(signature.typeParameters()), signature.throwableSignatures().stream().map(this::mapSignature).toList(), this.mapSignature(signature.result()), (Signature[])signature.arguments().stream().map(this::mapSignature).toArray(Signature[]::new));
    }

    RecordComponentInfo mapRecordComponent(RecordComponentInfo component) {
        return RecordComponentInfo.of(component.name().stringValue(), this.map(component.descriptorSymbol()), component.attributes().stream().map((? super T atr) -> {
            Objects.requireNonNull(atr);
            if (atr instanceof SignatureAttribute) {
                SignatureAttribute sa = (SignatureAttribute)atr;
                return SignatureAttribute.of(this.mapSignature(sa.asTypeSignature()));
            }
            if (atr instanceof RuntimeVisibleAnnotationsAttribute) {
                RuntimeVisibleAnnotationsAttribute aa = (RuntimeVisibleAnnotationsAttribute)atr;
                return RuntimeVisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations()));
            }
            if (atr instanceof RuntimeInvisibleAnnotationsAttribute) {
                RuntimeInvisibleAnnotationsAttribute aa = (RuntimeInvisibleAnnotationsAttribute)atr;
                return RuntimeInvisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations()));
            }
            if (atr instanceof RuntimeVisibleTypeAnnotationsAttribute) {
                RuntimeVisibleTypeAnnotationsAttribute aa = (RuntimeVisibleTypeAnnotationsAttribute)atr;
                return RuntimeVisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations()));
            }
            if (atr instanceof RuntimeInvisibleTypeAnnotationsAttribute) {
                RuntimeInvisibleTypeAnnotationsAttribute aa = (RuntimeInvisibleTypeAnnotationsAttribute)atr;
                return RuntimeInvisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations()));
            }
            return atr;
        }).toList());
    }

    DirectMethodHandleDesc mapDirectMethodHandle(DirectMethodHandleDesc dmhd) {
        return switch (dmhd.kind()) {
            case DirectMethodHandleDesc.Kind.GETTER, DirectMethodHandleDesc.Kind.SETTER, DirectMethodHandleDesc.Kind.STATIC_GETTER, DirectMethodHandleDesc.Kind.STATIC_SETTER -> MethodHandleDesc.ofField(dmhd.kind(), this.map(dmhd.owner()), dmhd.methodName(), this.map(ClassDesc.ofDescriptor(dmhd.lookupDescriptor())));
            default -> MethodHandleDesc.ofMethod(dmhd.kind(), this.map(dmhd.owner()), dmhd.methodName(), this.mapMethodDesc(MethodTypeDesc.ofDescriptor(dmhd.lookupDescriptor())));
        };
    }

    ConstantDesc mapConstantValue(ConstantDesc value) {
        Objects.requireNonNull(value);
        if (value instanceof ClassDesc) {
            ClassDesc cd = (ClassDesc)value;
            return this.map(cd);
        }
        if (value instanceof DynamicConstantDesc) {
            DynamicConstantDesc dcd = (DynamicConstantDesc)value;
            return this.mapDynamicConstant(dcd);
        }
        if (value instanceof DirectMethodHandleDesc) {
            DirectMethodHandleDesc dmhd = (DirectMethodHandleDesc)value;
            return this.mapDirectMethodHandle(dmhd);
        }
        if (value instanceof MethodTypeDesc) {
            MethodTypeDesc mtd = (MethodTypeDesc)value;
            return this.mapMethodDesc(mtd);
        }
        return value;
    }

    DynamicConstantDesc<?> mapDynamicConstant(DynamicConstantDesc<?> dcd) {
        return DynamicConstantDesc.ofNamed(this.mapDirectMethodHandle(dcd.bootstrapMethod()), dcd.constantName(), this.map(dcd.constantType()), (ConstantDesc[])dcd.bootstrapArgsList().stream().map(this::mapConstantValue).toArray(ConstantDesc[]::new));
    }

    <S extends Signature> S mapSignature(S signature) {
        Objects.requireNonNull(signature);
        if (signature instanceof Signature.ArrayTypeSig) {
            Signature.ArrayTypeSig ats = (Signature.ArrayTypeSig)signature;
            return (S)Signature.ArrayTypeSig.of(this.mapSignature(ats.componentSignature()));
        }
        if (signature instanceof Signature.ClassTypeSig) {
            Signature.ClassTypeSig cts = (Signature.ClassTypeSig)signature;
            return (S)Signature.ClassTypeSig.of((Signature.ClassTypeSig)cts.outerType().map(this::mapSignature).orElse(null), this.map(cts.classDesc()), (Signature.TypeArg[])cts.typeArgs().stream().map((? super T ta) -> Signature.TypeArg.of(ta.wildcardIndicator(), ta.boundType().map(this::mapSignature))).toArray(Signature.TypeArg[]::new));
        }
        return signature;
    }

    List<Annotation> mapAnnotations(List<Annotation> annotations) {
        return annotations.stream().map(this::mapAnnotation).toList();
    }

    Annotation mapAnnotation(Annotation a) {
        return Annotation.of(this.map(a.classSymbol()), a.elements().stream().map((? super T el) -> AnnotationElement.of(el.name(), this.mapAnnotationValue(el.value()))).toList());
    }

    AnnotationValue mapAnnotationValue(AnnotationValue val) {
        Objects.requireNonNull(val);
        if (val instanceof AnnotationValue.OfAnnotation) {
            AnnotationValue.OfAnnotation oa = (AnnotationValue.OfAnnotation)val;
            return AnnotationValue.ofAnnotation(this.mapAnnotation(oa.annotation()));
        }
        if (val instanceof AnnotationValue.OfArray) {
            AnnotationValue.OfArray oa = (AnnotationValue.OfArray)val;
            return AnnotationValue.ofArray(oa.values().stream().map(this::mapAnnotationValue).toList());
        }
        if (val instanceof AnnotationValue.OfConstant) {
            AnnotationValue.OfConstant oc = (AnnotationValue.OfConstant)val;
            return oc;
        }
        if (val instanceof AnnotationValue.OfClass) {
            AnnotationValue.OfClass oc = (AnnotationValue.OfClass)val;
            return AnnotationValue.ofClass(this.map(oc.classSymbol()));
        }
        if (val instanceof AnnotationValue.OfEnum) {
            AnnotationValue.OfEnum oe = (AnnotationValue.OfEnum)val;
            return AnnotationValue.ofEnum(this.map(oe.classSymbol()), oe.constantName().stringValue());
        }
        throw new IllegalArgumentException();
    }

    List<TypeAnnotation> mapTypeAnnotations(List<TypeAnnotation> typeAnnotations) {
        return typeAnnotations.stream().map((? super T a) -> TypeAnnotation.of(a.targetInfo(), a.targetPath(), this.map(a.classSymbol()), a.elements().stream().map((? super T el) -> AnnotationElement.of(el.name(), this.mapAnnotationValue(el.value()))).toList())).toList();
    }

    List<Signature.TypeParam> mapTypeParams(List<Signature.TypeParam> typeParams) {
        return typeParams.stream().map((? super T tp) -> Signature.TypeParam.of(tp.identifier(), tp.classBound().map(this::mapSignature), (Signature.RefTypeSig[])tp.interfaceBounds().stream().map(this::mapSignature).toArray(Signature.RefTypeSig[]::new))).toList();
    }
}

