/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.Arrays;
import java.util.Objects;
import org.glavo.classfile.CodeBuilder;
import org.glavo.classfile.CodeElement;
import org.glavo.classfile.Signature;
import org.glavo.classfile.TypeKind;
import org.glavo.classfile.components.CodeLocalsShifter;
import org.glavo.classfile.instruction.IncrementInstruction;
import org.glavo.classfile.instruction.LoadInstruction;
import org.glavo.classfile.instruction.LocalVariable;
import org.glavo.classfile.instruction.LocalVariableType;
import org.glavo.classfile.instruction.StoreInstruction;

public final class CodeLocalsShifterImpl
implements CodeLocalsShifter {
    private int[] locals = new int[0];
    private final int fixed;

    public CodeLocalsShifterImpl(int fixed) {
        this.fixed = fixed;
    }

    @Override
    public void accept(CodeBuilder cob, CodeElement coe) {
        Objects.requireNonNull(coe);
        if (coe instanceof LoadInstruction) {
            LoadInstruction li = (LoadInstruction)coe;
            cob.loadInstruction(li.typeKind(), this.shift(cob, li.slot(), li.typeKind()));
        } else if (coe instanceof StoreInstruction) {
            StoreInstruction si = (StoreInstruction)coe;
            cob.storeInstruction(si.typeKind(), this.shift(cob, si.slot(), si.typeKind()));
        } else if (coe instanceof IncrementInstruction) {
            IncrementInstruction ii = (IncrementInstruction)coe;
            cob.incrementInstruction(this.shift(cob, ii.slot(), TypeKind.IntType), ii.constant());
        } else if (coe instanceof LocalVariable) {
            LocalVariable lv = (LocalVariable)coe;
            cob.localVariable(this.shift(cob, lv.slot(), TypeKind.fromDescriptor(lv.type().stringValue())), lv.name(), lv.type(), lv.startScope(), lv.endScope());
        } else if (coe instanceof LocalVariableType) {
            TypeKind typeKind;
            LocalVariableType lvt = (LocalVariableType)coe;
            int n = lvt.slot();
            Signature signature = lvt.signatureSymbol();
            if (signature instanceof Signature.BaseTypeSig) {
                Signature.BaseTypeSig bsig = (Signature.BaseTypeSig)signature;
                typeKind = TypeKind.fromDescriptor(bsig.signatureString());
            } else {
                typeKind = TypeKind.ReferenceType;
            }
            cob.localVariableType(this.shift(cob, n, typeKind), lvt.name(), lvt.signature(), lvt.startScope(), lvt.endScope());
        } else {
            cob.with(coe);
        }
    }

    private int shift(CodeBuilder cob, int slot, TypeKind tk) {
        if (tk == TypeKind.VoidType) {
            throw new IllegalArgumentException("Illegal local void type");
        }
        if (slot >= this.fixed) {
            int key = 2 * slot - this.fixed + tk.slotSize() - 1;
            if (key >= this.locals.length) {
                this.locals = Arrays.copyOf(this.locals, key + 20);
            }
            if ((slot = this.locals[key] - 1) < 0) {
                slot = cob.allocateLocal(tk);
                this.locals[key] = slot + 1;
                if (tk.slotSize() == 2) {
                    this.locals[key - 1] = slot + 1;
                }
            }
        }
        return slot;
    }
}

