/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.Objects;
import java.util.function.BiFunction;
import org.glavo.classfile.CodeBuilder;
import org.glavo.classfile.CodeElement;
import org.glavo.classfile.Label;
import org.glavo.classfile.components.CodeRelabeler;
import org.glavo.classfile.instruction.BranchInstruction;
import org.glavo.classfile.instruction.CharacterRange;
import org.glavo.classfile.instruction.ExceptionCatch;
import org.glavo.classfile.instruction.LabelTarget;
import org.glavo.classfile.instruction.LocalVariable;
import org.glavo.classfile.instruction.LocalVariableType;
import org.glavo.classfile.instruction.LookupSwitchInstruction;
import org.glavo.classfile.instruction.SwitchCase;
import org.glavo.classfile.instruction.TableSwitchInstruction;

public record CodeRelabelerImpl(BiFunction<Label, CodeBuilder, Label> mapFunction) implements CodeRelabeler
{
    @Override
    public Label relabel(Label label, CodeBuilder cob) {
        return this.mapFunction.apply(label, cob);
    }

    @Override
    public void accept(CodeBuilder cob, CodeElement coe) {
        Objects.requireNonNull(coe);
        if (coe instanceof BranchInstruction) {
            BranchInstruction bi = (BranchInstruction)coe;
            cob.branchInstruction(bi.opcode(), this.relabel(bi.target(), cob));
        } else if (coe instanceof LookupSwitchInstruction) {
            LookupSwitchInstruction lsi = (LookupSwitchInstruction)coe;
            cob.lookupSwitchInstruction(this.relabel(lsi.defaultTarget(), cob), lsi.cases().stream().map(c -> SwitchCase.of(c.caseValue(), this.relabel(c.target(), cob))).toList());
        } else if (coe instanceof TableSwitchInstruction) {
            TableSwitchInstruction tsi = (TableSwitchInstruction)coe;
            cob.tableSwitchInstruction(tsi.lowValue(), tsi.highValue(), this.relabel(tsi.defaultTarget(), cob), tsi.cases().stream().map(c -> SwitchCase.of(c.caseValue(), this.relabel(c.target(), cob))).toList());
        } else if (coe instanceof LabelTarget) {
            LabelTarget lt = (LabelTarget)coe;
            cob.labelBinding(this.relabel(lt.label(), cob));
        } else if (coe instanceof ExceptionCatch) {
            ExceptionCatch ec = (ExceptionCatch)coe;
            cob.exceptionCatch(this.relabel(ec.tryStart(), cob), this.relabel(ec.tryEnd(), cob), this.relabel(ec.handler(), cob), ec.catchType());
        } else if (coe instanceof LocalVariable) {
            LocalVariable lv = (LocalVariable)coe;
            cob.localVariable(lv.slot(), lv.name().stringValue(), lv.typeSymbol(), this.relabel(lv.startScope(), cob), this.relabel(lv.endScope(), cob));
        } else if (coe instanceof LocalVariableType) {
            LocalVariableType lvt = (LocalVariableType)coe;
            cob.localVariableType(lvt.slot(), lvt.name().stringValue(), lvt.signatureSymbol(), this.relabel(lvt.startScope(), cob), this.relabel(lvt.endScope(), cob));
        } else if (coe instanceof CharacterRange) {
            CharacterRange chr = (CharacterRange)coe;
            cob.characterRange(this.relabel(chr.startScope(), cob), this.relabel(chr.endScope(), cob), chr.characterRangeStart(), chr.characterRangeEnd(), chr.flags());
        } else {
            cob.with(coe);
        }
    }
}

